# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_admin_state_pac import TapiCommonAdminStatePac  # noqa: F401,E501
from tapi_server.models.tapi_common_administrative_state import TapiCommonAdministrativeState  # noqa: F401,E501
from tapi_server.models.tapi_common_capacity import TapiCommonCapacity  # noqa: F401,E501
from tapi_server.models.tapi_common_capacity_pac import TapiCommonCapacityPac  # noqa: F401,E501
from tapi_server.models.tapi_common_global_class import TapiCommonGlobalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_lifecycle_state import TapiCommonLifecycleState  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_common_operational_state import TapiCommonOperationalState  # noqa: F401,E501
from tapi_server.models.tapi_common_port_direction import TapiCommonPortDirection  # noqa: F401,E501
from tapi_server import util


class TapiCommonServiceInterfacePoint(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, available_capacity: TapiCommonCapacity=None, total_potential_capacity: TapiCommonCapacity=None, name: List[TapiCommonNameAndValue]=None, uuid: str=None, operational_state: TapiCommonOperationalState=None, lifecycle_state: TapiCommonLifecycleState=None, administrative_state: TapiCommonAdministrativeState=None, supported_layer_protocol_qualifier: List[str]=None, layer_protocol_name: TapiCommonLayerProtocolName=None, direction: TapiCommonPortDirection=None):  # noqa: E501
        """TapiCommonServiceInterfacePoint - a model defined in Swagger

        :param available_capacity: The available_capacity of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :type available_capacity: TapiCommonCapacity
        :param total_potential_capacity: The total_potential_capacity of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :type total_potential_capacity: TapiCommonCapacity
        :param name: The name of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :type uuid: str
        :param operational_state: The operational_state of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :type operational_state: TapiCommonOperationalState
        :param lifecycle_state: The lifecycle_state of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :type lifecycle_state: TapiCommonLifecycleState
        :param administrative_state: The administrative_state of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :type administrative_state: TapiCommonAdministrativeState
        :param supported_layer_protocol_qualifier: The supported_layer_protocol_qualifier of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :type supported_layer_protocol_qualifier: List[str]
        :param layer_protocol_name: The layer_protocol_name of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :type layer_protocol_name: TapiCommonLayerProtocolName
        :param direction: The direction of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :type direction: TapiCommonPortDirection
        """
        self.swagger_types = {
            'available_capacity': TapiCommonCapacity,
            'total_potential_capacity': TapiCommonCapacity,
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'operational_state': TapiCommonOperationalState,
            'lifecycle_state': TapiCommonLifecycleState,
            'administrative_state': TapiCommonAdministrativeState,
            'supported_layer_protocol_qualifier': List[str],
            'layer_protocol_name': TapiCommonLayerProtocolName,
            'direction': TapiCommonPortDirection
        }

        self.attribute_map = {
            'available_capacity': 'available-capacity',
            'total_potential_capacity': 'total-potential-capacity',
            'name': 'name',
            'uuid': 'uuid',
            'operational_state': 'operational-state',
            'lifecycle_state': 'lifecycle-state',
            'administrative_state': 'administrative-state',
            'supported_layer_protocol_qualifier': 'supported-layer-protocol-qualifier',
            'layer_protocol_name': 'layer-protocol-name',
            'direction': 'direction'
        }
        self._available_capacity = available_capacity
        self._total_potential_capacity = total_potential_capacity
        self._name = name
        self._uuid = uuid
        self._operational_state = operational_state
        self._lifecycle_state = lifecycle_state
        self._administrative_state = administrative_state
        self._supported_layer_protocol_qualifier = supported_layer_protocol_qualifier
        self._layer_protocol_name = layer_protocol_name
        self._direction = direction

    @classmethod
    def from_dict(cls, dikt) -> 'TapiCommonServiceInterfacePoint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.common.ServiceInterfacePoint of this TapiCommonServiceInterfacePoint.  # noqa: E501
        :rtype: TapiCommonServiceInterfacePoint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def available_capacity(self) -> TapiCommonCapacity:
        """Gets the available_capacity of this TapiCommonServiceInterfacePoint.


        :return: The available_capacity of this TapiCommonServiceInterfacePoint.
        :rtype: TapiCommonCapacity
        """
        return self._available_capacity

    @available_capacity.setter
    def available_capacity(self, available_capacity: TapiCommonCapacity):
        """Sets the available_capacity of this TapiCommonServiceInterfacePoint.


        :param available_capacity: The available_capacity of this TapiCommonServiceInterfacePoint.
        :type available_capacity: TapiCommonCapacity
        """

        self._available_capacity = available_capacity

    @property
    def total_potential_capacity(self) -> TapiCommonCapacity:
        """Gets the total_potential_capacity of this TapiCommonServiceInterfacePoint.


        :return: The total_potential_capacity of this TapiCommonServiceInterfacePoint.
        :rtype: TapiCommonCapacity
        """
        return self._total_potential_capacity

    @total_potential_capacity.setter
    def total_potential_capacity(self, total_potential_capacity: TapiCommonCapacity):
        """Sets the total_potential_capacity of this TapiCommonServiceInterfacePoint.


        :param total_potential_capacity: The total_potential_capacity of this TapiCommonServiceInterfacePoint.
        :type total_potential_capacity: TapiCommonCapacity
        """

        self._total_potential_capacity = total_potential_capacity

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiCommonServiceInterfacePoint.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiCommonServiceInterfacePoint.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiCommonServiceInterfacePoint.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiCommonServiceInterfacePoint.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiCommonServiceInterfacePoint.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiCommonServiceInterfacePoint.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiCommonServiceInterfacePoint.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiCommonServiceInterfacePoint.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def operational_state(self) -> TapiCommonOperationalState:
        """Gets the operational_state of this TapiCommonServiceInterfacePoint.


        :return: The operational_state of this TapiCommonServiceInterfacePoint.
        :rtype: TapiCommonOperationalState
        """
        return self._operational_state

    @operational_state.setter
    def operational_state(self, operational_state: TapiCommonOperationalState):
        """Sets the operational_state of this TapiCommonServiceInterfacePoint.


        :param operational_state: The operational_state of this TapiCommonServiceInterfacePoint.
        :type operational_state: TapiCommonOperationalState
        """

        self._operational_state = operational_state

    @property
    def lifecycle_state(self) -> TapiCommonLifecycleState:
        """Gets the lifecycle_state of this TapiCommonServiceInterfacePoint.


        :return: The lifecycle_state of this TapiCommonServiceInterfacePoint.
        :rtype: TapiCommonLifecycleState
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state: TapiCommonLifecycleState):
        """Sets the lifecycle_state of this TapiCommonServiceInterfacePoint.


        :param lifecycle_state: The lifecycle_state of this TapiCommonServiceInterfacePoint.
        :type lifecycle_state: TapiCommonLifecycleState
        """

        self._lifecycle_state = lifecycle_state

    @property
    def administrative_state(self) -> TapiCommonAdministrativeState:
        """Gets the administrative_state of this TapiCommonServiceInterfacePoint.


        :return: The administrative_state of this TapiCommonServiceInterfacePoint.
        :rtype: TapiCommonAdministrativeState
        """
        return self._administrative_state

    @administrative_state.setter
    def administrative_state(self, administrative_state: TapiCommonAdministrativeState):
        """Sets the administrative_state of this TapiCommonServiceInterfacePoint.


        :param administrative_state: The administrative_state of this TapiCommonServiceInterfacePoint.
        :type administrative_state: TapiCommonAdministrativeState
        """

        self._administrative_state = administrative_state

    @property
    def supported_layer_protocol_qualifier(self) -> List[str]:
        """Gets the supported_layer_protocol_qualifier of this TapiCommonServiceInterfacePoint.

        none  # noqa: E501

        :return: The supported_layer_protocol_qualifier of this TapiCommonServiceInterfacePoint.
        :rtype: List[str]
        """
        return self._supported_layer_protocol_qualifier

    @supported_layer_protocol_qualifier.setter
    def supported_layer_protocol_qualifier(self, supported_layer_protocol_qualifier: List[str]):
        """Sets the supported_layer_protocol_qualifier of this TapiCommonServiceInterfacePoint.

        none  # noqa: E501

        :param supported_layer_protocol_qualifier: The supported_layer_protocol_qualifier of this TapiCommonServiceInterfacePoint.
        :type supported_layer_protocol_qualifier: List[str]
        """

        self._supported_layer_protocol_qualifier = supported_layer_protocol_qualifier

    @property
    def layer_protocol_name(self) -> TapiCommonLayerProtocolName:
        """Gets the layer_protocol_name of this TapiCommonServiceInterfacePoint.


        :return: The layer_protocol_name of this TapiCommonServiceInterfacePoint.
        :rtype: TapiCommonLayerProtocolName
        """
        return self._layer_protocol_name

    @layer_protocol_name.setter
    def layer_protocol_name(self, layer_protocol_name: TapiCommonLayerProtocolName):
        """Sets the layer_protocol_name of this TapiCommonServiceInterfacePoint.


        :param layer_protocol_name: The layer_protocol_name of this TapiCommonServiceInterfacePoint.
        :type layer_protocol_name: TapiCommonLayerProtocolName
        """

        self._layer_protocol_name = layer_protocol_name

    @property
    def direction(self) -> TapiCommonPortDirection:
        """Gets the direction of this TapiCommonServiceInterfacePoint.


        :return: The direction of this TapiCommonServiceInterfacePoint.
        :rtype: TapiCommonPortDirection
        """
        return self._direction

    @direction.setter
    def direction(self, direction: TapiCommonPortDirection):
        """Sets the direction of this TapiCommonServiceInterfacePoint.


        :param direction: The direction of this TapiCommonServiceInterfacePoint.
        :type direction: TapiCommonPortDirection
        """

        self._direction = direction
