# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class vlan_pop(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point/eth-svc/supported-vlan-operations/vlan-pop. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Indicates VLAN pop or swap operations capabilities.
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_pop_operations','__max_pop_tags',)

  _yang_name = 'vlan-pop'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_pop_operations = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="vlan-pop-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    self.__max_pop_tags = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..2']}), is_leaf=True, yang_name="max-pop-tags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point', 'eth-svc', 'supported-vlan-operations', 'vlan-pop']

  def _get_vlan_pop_operations(self):
    """
    Getter method for vlan_pop_operations, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_pop/vlan_pop_operations (boolean)

    YANG Description: Indicates that the ETH LTP supports VLAN pop or
swap operations.
    """
    return self.__vlan_pop_operations
      
  def _set_vlan_pop_operations(self, v, load=False):
    """
    Setter method for vlan_pop_operations, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_pop/vlan_pop_operations (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_pop_operations is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_pop_operations() directly.

    YANG Description: Indicates that the ETH LTP supports VLAN pop or
swap operations.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="vlan-pop-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_pop_operations must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="vlan-pop-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)""",
        })

    self.__vlan_pop_operations = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_pop_operations(self):
    self.__vlan_pop_operations = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="vlan-pop-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)


  def _get_max_pop_tags(self):
    """
    Getter method for max_pop_tags, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_pop/max_pop_tags (uint8)

    YANG Description: Indicates the maximum number of tags that can be
popped/swapped.
    """
    return self.__max_pop_tags
      
  def _set_max_pop_tags(self, v, load=False):
    """
    Setter method for max_pop_tags, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_pop/max_pop_tags (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_pop_tags is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_pop_tags() directly.

    YANG Description: Indicates the maximum number of tags that can be
popped/swapped.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..2']}), is_leaf=True, yang_name="max-pop-tags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_pop_tags must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..2']}), is_leaf=True, yang_name="max-pop-tags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint8', is_config=True)""",
        })

    self.__max_pop_tags = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_pop_tags(self):
    self.__max_pop_tags = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..2']}), is_leaf=True, yang_name="max-pop-tags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint8', is_config=True)

  vlan_pop_operations = __builtin__.property(_get_vlan_pop_operations, _set_vlan_pop_operations)
  max_pop_tags = __builtin__.property(_get_max_pop_tags, _set_max_pop_tags)


  _pyangbind_elements = OrderedDict([('vlan_pop_operations', vlan_pop_operations), ('max_pop_tags', max_pop_tags), ])


