# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import explicit_route_exclude_objects
from . import explicit_route_include_objects
class optimization_metric(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/local-link-connectivities/optimizations/optimization-metric. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: TE path metric type.
  """
  __slots__ = ('_path_helper', '_extmethods', '__metric_type','__weight','__explicit_route_exclude_objects','__explicit_route_include_objects',)

  _yang_name = 'optimization-metric'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__metric_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="metric-type", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    self.__weight = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(1), is_leaf=True, yang_name="weight", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)
    self.__explicit_route_exclude_objects = YANGDynClass(base=explicit_route_exclude_objects.explicit_route_exclude_objects, is_container='container', yang_name="explicit-route-exclude-objects", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__explicit_route_include_objects = YANGDynClass(base=explicit_route_include_objects.explicit_route_include_objects, is_container='container', yang_name="explicit-route-include-objects", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'local-link-connectivities', 'optimizations', 'optimization-metric']

  def _get_metric_type(self):
    """
    Getter method for metric_type, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations/optimization_metric/metric_type (identityref)

    YANG Description: Identifies the 'metric-type' that the path computation
process uses for optimization.
    """
    return self.__metric_type
      
  def _set_metric_type(self, v, load=False):
    """
    Setter method for metric_type, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations/optimization_metric/metric_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_metric_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_metric_type() directly.

    YANG Description: Identifies the 'metric-type' that the path computation
process uses for optimization.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="metric-type", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """metric_type must be of a type compatible with identityref""",
          'defined-type': "ietf-te-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="metric-type", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)""",
        })

    self.__metric_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_metric_type(self):
    self.__metric_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="metric-type", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)


  def _get_weight(self):
    """
    Getter method for weight, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations/optimization_metric/weight (uint8)

    YANG Description: TE path metric normalization weight.
    """
    return self.__weight
      
  def _set_weight(self, v, load=False):
    """
    Setter method for weight, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations/optimization_metric/weight (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_weight is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_weight() directly.

    YANG Description: TE path metric normalization weight.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(1), is_leaf=True, yang_name="weight", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """weight must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(1), is_leaf=True, yang_name="weight", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)""",
        })

    self.__weight = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_weight(self):
    self.__weight = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(1), is_leaf=True, yang_name="weight", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)


  def _get_explicit_route_exclude_objects(self):
    """
    Getter method for explicit_route_exclude_objects, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations/optimization_metric/explicit_route_exclude_objects (container)

    YANG Description: Container for the 'exclude route' object list.
    """
    return self.__explicit_route_exclude_objects
      
  def _set_explicit_route_exclude_objects(self, v, load=False):
    """
    Setter method for explicit_route_exclude_objects, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations/optimization_metric/explicit_route_exclude_objects (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_explicit_route_exclude_objects is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_explicit_route_exclude_objects() directly.

    YANG Description: Container for the 'exclude route' object list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=explicit_route_exclude_objects.explicit_route_exclude_objects, is_container='container', yang_name="explicit-route-exclude-objects", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """explicit_route_exclude_objects must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=explicit_route_exclude_objects.explicit_route_exclude_objects, is_container='container', yang_name="explicit-route-exclude-objects", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__explicit_route_exclude_objects = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_explicit_route_exclude_objects(self):
    self.__explicit_route_exclude_objects = YANGDynClass(base=explicit_route_exclude_objects.explicit_route_exclude_objects, is_container='container', yang_name="explicit-route-exclude-objects", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_explicit_route_include_objects(self):
    """
    Getter method for explicit_route_include_objects, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations/optimization_metric/explicit_route_include_objects (container)

    YANG Description: Container for the 'include route' object list.
    """
    return self.__explicit_route_include_objects
      
  def _set_explicit_route_include_objects(self, v, load=False):
    """
    Setter method for explicit_route_include_objects, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations/optimization_metric/explicit_route_include_objects (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_explicit_route_include_objects is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_explicit_route_include_objects() directly.

    YANG Description: Container for the 'include route' object list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=explicit_route_include_objects.explicit_route_include_objects, is_container='container', yang_name="explicit-route-include-objects", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """explicit_route_include_objects must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=explicit_route_include_objects.explicit_route_include_objects, is_container='container', yang_name="explicit-route-include-objects", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__explicit_route_include_objects = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_explicit_route_include_objects(self):
    self.__explicit_route_include_objects = YANGDynClass(base=explicit_route_include_objects.explicit_route_include_objects, is_container='container', yang_name="explicit-route-include-objects", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

  metric_type = __builtin__.property(_get_metric_type, _set_metric_type)
  weight = __builtin__.property(_get_weight, _set_weight)
  explicit_route_exclude_objects = __builtin__.property(_get_explicit_route_exclude_objects, _set_explicit_route_exclude_objects)
  explicit_route_include_objects = __builtin__.property(_get_explicit_route_include_objects, _set_explicit_route_include_objects)

  __choices__ = {'algorithm': {'metric': ['metric_type', 'weight', 'explicit_route_exclude_objects', 'explicit_route_include_objects']}}
  _pyangbind_elements = OrderedDict([('metric_type', metric_type), ('weight', weight), ('explicit_route_exclude_objects', explicit_route_exclude_objects), ('explicit_route_include_objects', explicit_route_include_objects), ])


