# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import te_bandwidth
from . import path_metric_bounds
from . import path_affinities_values
from . import path_affinity_names
from . import path_srlgs_lists
from . import path_srlgs_names
class path_constraints(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/te-node-attributes/connectivity-matrices/path-constraints. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: TE named path constraints container.
  """
  __slots__ = ('_path_helper', '_extmethods', '__te_bandwidth','__link_protection','__setup_priority','__hold_priority','__signaling_type','__path_metric_bounds','__path_affinities_values','__path_affinity_names','__path_srlgs_lists','__path_srlgs_names','__disjointness',)

  _yang_name = 'path-constraints'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__te_bandwidth = YANGDynClass(base=te_bandwidth.te_bandwidth, is_container='container', yang_name="te-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__link_protection = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), default=six.text_type("te-types:link-protection-unprotected"), is_leaf=True, yang_name="link-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    self.__setup_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(7), is_leaf=True, yang_name="setup-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)
    self.__hold_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(7), is_leaf=True, yang_name="hold-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)
    self.__signaling_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), default=six.text_type("te-types:path-setup-rsvp"), is_leaf=True, yang_name="signaling-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    self.__path_metric_bounds = YANGDynClass(base=path_metric_bounds.path_metric_bounds, is_container='container', yang_name="path-metric-bounds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__path_affinities_values = YANGDynClass(base=path_affinities_values.path_affinities_values, is_container='container', yang_name="path-affinities-values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__path_affinity_names = YANGDynClass(base=path_affinity_names.path_affinity_names, is_container='container', yang_name="path-affinity-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__path_srlgs_lists = YANGDynClass(base=path_srlgs_lists.path_srlgs_lists, is_container='container', yang_name="path-srlgs-lists", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__path_srlgs_names = YANGDynClass(base=path_srlgs_names.path_srlgs_names, is_container='container', yang_name="path-srlgs-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__disjointness = YANGDynClass(base=YANGBitsType(allowed_bits={'node': '0', 'link': '1', 'srlg': '2'}), is_leaf=True, yang_name="disjointness", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-path-disjointness', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'te-node-attributes', 'connectivity-matrices', 'path-constraints']

  def _get_te_bandwidth(self):
    """
    Getter method for te_bandwidth, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/te_bandwidth (container)

    YANG Description: Container that specifies TE bandwidth.  The choices
can be augmented for specific data-plane technologies.
    """
    return self.__te_bandwidth
      
  def _set_te_bandwidth(self, v, load=False):
    """
    Setter method for te_bandwidth, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/te_bandwidth (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_bandwidth is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_bandwidth() directly.

    YANG Description: Container that specifies TE bandwidth.  The choices
can be augmented for specific data-plane technologies.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te_bandwidth.te_bandwidth, is_container='container', yang_name="te-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_bandwidth must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te_bandwidth.te_bandwidth, is_container='container', yang_name="te-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te_bandwidth = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_bandwidth(self):
    self.__te_bandwidth = YANGDynClass(base=te_bandwidth.te_bandwidth, is_container='container', yang_name="te-bandwidth", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_link_protection(self):
    """
    Getter method for link_protection, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/link_protection (identityref)

    YANG Description: Link protection type required for the links included
in the computed path.
    """
    return self.__link_protection
      
  def _set_link_protection(self, v, load=False):
    """
    Setter method for link_protection, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/link_protection (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link_protection is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link_protection() directly.

    YANG Description: Link protection type required for the links included
in the computed path.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), default=six.text_type("te-types:link-protection-unprotected"), is_leaf=True, yang_name="link-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link_protection must be of a type compatible with identityref""",
          'defined-type': "ietf-te-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), default=six.text_type("te-types:link-protection-unprotected"), is_leaf=True, yang_name="link-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)""",
        })

    self.__link_protection = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link_protection(self):
    self.__link_protection = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-unprotected': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-extra-traffic': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-shared': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-for-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-1-plus-1': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:link-protection-enhanced': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), default=six.text_type("te-types:link-protection-unprotected"), is_leaf=True, yang_name="link-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)


  def _get_setup_priority(self):
    """
    Getter method for setup_priority, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/setup_priority (uint8)

    YANG Description: TE LSP requested setup priority.
    """
    return self.__setup_priority
      
  def _set_setup_priority(self, v, load=False):
    """
    Setter method for setup_priority, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/setup_priority (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_setup_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_setup_priority() directly.

    YANG Description: TE LSP requested setup priority.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(7), is_leaf=True, yang_name="setup-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """setup_priority must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(7), is_leaf=True, yang_name="setup-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)""",
        })

    self.__setup_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_setup_priority(self):
    self.__setup_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(7), is_leaf=True, yang_name="setup-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)


  def _get_hold_priority(self):
    """
    Getter method for hold_priority, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/hold_priority (uint8)

    YANG Description: TE LSP requested hold priority.
    """
    return self.__hold_priority
      
  def _set_hold_priority(self, v, load=False):
    """
    Setter method for hold_priority, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/hold_priority (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_priority() directly.

    YANG Description: TE LSP requested hold priority.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(7), is_leaf=True, yang_name="hold-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_priority must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(7), is_leaf=True, yang_name="hold-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)""",
        })

    self.__hold_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_priority(self):
    self.__hold_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(7), is_leaf=True, yang_name="hold-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint8', is_config=True)


  def _get_signaling_type(self):
    """
    Getter method for signaling_type, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/signaling_type (identityref)

    YANG Description: TE tunnel path signaling type.
    """
    return self.__signaling_type
      
  def _set_signaling_type(self, v, load=False):
    """
    Setter method for signaling_type, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/signaling_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_signaling_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_signaling_type() directly.

    YANG Description: TE tunnel path signaling type.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), default=six.text_type("te-types:path-setup-rsvp"), is_leaf=True, yang_name="signaling-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """signaling_type must be of a type compatible with identityref""",
          'defined-type': "ietf-te-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), default=six.text_type("te-types:path-setup-rsvp"), is_leaf=True, yang_name="signaling-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)""",
        })

    self.__signaling_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_signaling_type(self):
    self.__signaling_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-static': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-rsvp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-setup-sr': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), default=six.text_type("te-types:path-setup-rsvp"), is_leaf=True, yang_name="signaling-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)


  def _get_path_metric_bounds(self):
    """
    Getter method for path_metric_bounds, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/path_metric_bounds (container)

    YANG Description: TE path metric bounds container.
    """
    return self.__path_metric_bounds
      
  def _set_path_metric_bounds(self, v, load=False):
    """
    Setter method for path_metric_bounds, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/path_metric_bounds (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_metric_bounds is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_metric_bounds() directly.

    YANG Description: TE path metric bounds container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_metric_bounds.path_metric_bounds, is_container='container', yang_name="path-metric-bounds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_metric_bounds must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_metric_bounds.path_metric_bounds, is_container='container', yang_name="path-metric-bounds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__path_metric_bounds = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_metric_bounds(self):
    self.__path_metric_bounds = YANGDynClass(base=path_metric_bounds.path_metric_bounds, is_container='container', yang_name="path-metric-bounds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_path_affinities_values(self):
    """
    Getter method for path_affinities_values, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/path_affinities_values (container)

    YANG Description: Path affinities represented as values.
    """
    return self.__path_affinities_values
      
  def _set_path_affinities_values(self, v, load=False):
    """
    Setter method for path_affinities_values, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/path_affinities_values (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_affinities_values is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_affinities_values() directly.

    YANG Description: Path affinities represented as values.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_affinities_values.path_affinities_values, is_container='container', yang_name="path-affinities-values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_affinities_values must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_affinities_values.path_affinities_values, is_container='container', yang_name="path-affinities-values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__path_affinities_values = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_affinities_values(self):
    self.__path_affinities_values = YANGDynClass(base=path_affinities_values.path_affinities_values, is_container='container', yang_name="path-affinities-values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_path_affinity_names(self):
    """
    Getter method for path_affinity_names, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/path_affinity_names (container)

    YANG Description: Path affinities represented as names.
    """
    return self.__path_affinity_names
      
  def _set_path_affinity_names(self, v, load=False):
    """
    Setter method for path_affinity_names, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/path_affinity_names (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_affinity_names is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_affinity_names() directly.

    YANG Description: Path affinities represented as names.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_affinity_names.path_affinity_names, is_container='container', yang_name="path-affinity-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_affinity_names must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_affinity_names.path_affinity_names, is_container='container', yang_name="path-affinity-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__path_affinity_names = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_affinity_names(self):
    self.__path_affinity_names = YANGDynClass(base=path_affinity_names.path_affinity_names, is_container='container', yang_name="path-affinity-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_path_srlgs_lists(self):
    """
    Getter method for path_srlgs_lists, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/path_srlgs_lists (container)

    YANG Description: Path SRLG properties container.
    """
    return self.__path_srlgs_lists
      
  def _set_path_srlgs_lists(self, v, load=False):
    """
    Setter method for path_srlgs_lists, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/path_srlgs_lists (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_srlgs_lists is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_srlgs_lists() directly.

    YANG Description: Path SRLG properties container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_srlgs_lists.path_srlgs_lists, is_container='container', yang_name="path-srlgs-lists", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_srlgs_lists must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_srlgs_lists.path_srlgs_lists, is_container='container', yang_name="path-srlgs-lists", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__path_srlgs_lists = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_srlgs_lists(self):
    self.__path_srlgs_lists = YANGDynClass(base=path_srlgs_lists.path_srlgs_lists, is_container='container', yang_name="path-srlgs-lists", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_path_srlgs_names(self):
    """
    Getter method for path_srlgs_names, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/path_srlgs_names (container)

    YANG Description: Container for the list of named SRLGs.
    """
    return self.__path_srlgs_names
      
  def _set_path_srlgs_names(self, v, load=False):
    """
    Setter method for path_srlgs_names, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/path_srlgs_names (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_srlgs_names is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_srlgs_names() directly.

    YANG Description: Container for the list of named SRLGs.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_srlgs_names.path_srlgs_names, is_container='container', yang_name="path-srlgs-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_srlgs_names must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_srlgs_names.path_srlgs_names, is_container='container', yang_name="path-srlgs-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__path_srlgs_names = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_srlgs_names(self):
    self.__path_srlgs_names = YANGDynClass(base=path_srlgs_names.path_srlgs_names, is_container='container', yang_name="path-srlgs-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_disjointness(self):
    """
    Getter method for disjointness, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/disjointness (te-path-disjointness)

    YANG Description: The type of resource disjointness.
When configured for a primary path, the disjointness level
applies to all secondary LSPs.  When configured for a
secondary path, the disjointness level overrides the level
configured for the primary path.
    """
    return self.__disjointness
      
  def _set_disjointness(self, v, load=False):
    """
    Setter method for disjointness, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_constraints/disjointness (te-path-disjointness)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_disjointness is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_disjointness() directly.

    YANG Description: The type of resource disjointness.
When configured for a primary path, the disjointness level
applies to all secondary LSPs.  When configured for a
secondary path, the disjointness level overrides the level
configured for the primary path.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBitsType(allowed_bits={'node': '0', 'link': '1', 'srlg': '2'}), is_leaf=True, yang_name="disjointness", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-path-disjointness', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """disjointness must be of a type compatible with te-path-disjointness""",
          'defined-type': "ietf-te-topology:te-path-disjointness",
          'generated-type': """YANGDynClass(base=YANGBitsType(allowed_bits={'node': '0', 'link': '1', 'srlg': '2'}), is_leaf=True, yang_name="disjointness", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-path-disjointness', is_config=True)""",
        })

    self.__disjointness = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_disjointness(self):
    self.__disjointness = YANGDynClass(base=YANGBitsType(allowed_bits={'node': '0', 'link': '1', 'srlg': '2'}), is_leaf=True, yang_name="disjointness", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-path-disjointness', is_config=True)

  te_bandwidth = __builtin__.property(_get_te_bandwidth, _set_te_bandwidth)
  link_protection = __builtin__.property(_get_link_protection, _set_link_protection)
  setup_priority = __builtin__.property(_get_setup_priority, _set_setup_priority)
  hold_priority = __builtin__.property(_get_hold_priority, _set_hold_priority)
  signaling_type = __builtin__.property(_get_signaling_type, _set_signaling_type)
  path_metric_bounds = __builtin__.property(_get_path_metric_bounds, _set_path_metric_bounds)
  path_affinities_values = __builtin__.property(_get_path_affinities_values, _set_path_affinities_values)
  path_affinity_names = __builtin__.property(_get_path_affinity_names, _set_path_affinity_names)
  path_srlgs_lists = __builtin__.property(_get_path_srlgs_lists, _set_path_srlgs_lists)
  path_srlgs_names = __builtin__.property(_get_path_srlgs_names, _set_path_srlgs_names)
  disjointness = __builtin__.property(_get_disjointness, _set_disjointness)


  _pyangbind_elements = OrderedDict([('te_bandwidth', te_bandwidth), ('link_protection', link_protection), ('setup_priority', setup_priority), ('hold_priority', hold_priority), ('signaling_type', signaling_type), ('path_metric_bounds', path_metric_bounds), ('path_affinities_values', path_affinities_values), ('path_affinity_names', path_affinity_names), ('path_srlgs_lists', path_srlgs_lists), ('path_srlgs_names', path_srlgs_names), ('disjointness', disjointness), ])


