# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class otn_label_range(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/te-node-attributes/connectivity-matrices/connectivity-matrix/to/label-restrictions/label-restriction/otn-label-range. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Label range information for OTN.
  """
  __slots__ = ('_path_helper', '_extmethods', '__range_type','__tsg','__odu_type_list','__priority',)

  _yang_name = 'otn-label-range'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__range_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'trib-slot': {}, 'trib-port': {}},), is_leaf=True, yang_name="range-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-label-range-type', is_config=True)
    self.__tsg = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    self.__odu_type_list = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},)), is_leaf=False, yang_name="odu-type-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'te-node-attributes', 'connectivity-matrices', 'connectivity-matrix', 'to', 'label-restrictions', 'label-restriction', 'otn-label-range']

  def _get_range_type(self):
    """
    Getter method for range_type, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/otn_label_range/range_type (otn-label-range-type)

    YANG Description: The type of range (e.g., TPN or TS)
to which the label range applies
    """
    return self.__range_type
      
  def _set_range_type(self, v, load=False):
    """
    Setter method for range_type, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/otn_label_range/range_type (otn-label-range-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_range_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_range_type() directly.

    YANG Description: The type of range (e.g., TPN or TS)
to which the label range applies
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'trib-slot': {}, 'trib-port': {}},), is_leaf=True, yang_name="range-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-label-range-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """range_type must be of a type compatible with otn-label-range-type""",
          'defined-type': "ietf-otn-topology:otn-label-range-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'trib-slot': {}, 'trib-port': {}},), is_leaf=True, yang_name="range-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-label-range-type', is_config=True)""",
        })

    self.__range_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_range_type(self):
    self.__range_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'trib-slot': {}, 'trib-port': {}},), is_leaf=True, yang_name="range-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-label-range-type', is_config=True)


  def _get_tsg(self):
    """
    Getter method for tsg, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/otn_label_range/tsg (identityref)

    YANG Description: Tributary slot granularity (TSG) to which the label range
applies.

This leaf MUST be present when the range-type is TS.

This leaf MAY be omitted when mapping an ODUk over an OTUk
Link. In this case the range-type is tpn, with only one
entry (ODUk), and the tpn range has only one value (1).
    """
    return self.__tsg
      
  def _set_tsg(self, v, load=False):
    """
    Setter method for tsg, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/otn_label_range/tsg (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tsg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tsg() directly.

    YANG Description: Tributary slot granularity (TSG) to which the label range
applies.

This leaf MUST be present when the range-type is TS.

This leaf MAY be omitted when mapping an ODUk over an OTUk
Link. In this case the range-type is tpn, with only one
entry (ODUk), and the tpn range has only one value (1).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tsg must be of a type compatible with identityref""",
          'defined-type': "ietf-otn-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)""",
        })

    self.__tsg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tsg(self):
    self.__tsg = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)


  def _get_odu_type_list(self):
    """
    Getter method for odu_type_list, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/otn_label_range/odu_type_list (identityref)

    YANG Description: List of ODU types to which the label range applies.

An Empty odu-type-list means that the label range
applies to all the supported ODU types.
    """
    return self.__odu_type_list
      
  def _set_odu_type_list(self, v, load=False):
    """
    Setter method for odu_type_list, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/otn_label_range/odu_type_list (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_odu_type_list is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_odu_type_list() directly.

    YANG Description: List of ODU types to which the label range applies.

An Empty odu-type-list means that the label range
applies to all the supported ODU types.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},)), is_leaf=False, yang_name="odu-type-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """odu_type_list must be of a type compatible with identityref""",
          'defined-type': "ietf-otn-topology:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},)), is_leaf=False, yang_name="odu-type-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)""",
        })

    self.__odu_type_list = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_odu_type_list(self):
    self.__odu_type_list = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},)), is_leaf=False, yang_name="odu-type-list", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)


  def _get_priority(self):
    """
    Getter method for priority, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/otn_label_range/priority (uint8)

    YANG Description: Priority in Interface Switching Capability
Descriptor (ISCD).
    """
    return self.__priority
      
  def _set_priority(self, v, load=False):
    """
    Setter method for priority, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/to/label_restrictions/label_restriction/otn_label_range/priority (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_priority() directly.

    YANG Description: Priority in Interface Switching Capability
Descriptor (ISCD).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """priority must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint8', is_config=True)""",
        })

    self.__priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_priority(self):
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint8', is_config=True)

  range_type = __builtin__.property(_get_range_type, _set_range_type)
  tsg = __builtin__.property(_get_tsg, _set_tsg)
  odu_type_list = __builtin__.property(_get_odu_type_list, _set_odu_type_list)
  priority = __builtin__.property(_get_priority, _set_priority)


  _pyangbind_elements = OrderedDict([('range_type', range_type), ('tsg', tsg), ('odu_type_list', odu_type_list), ('priority', priority), ])


