# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import node
from . import connectivity_matrix_entry
class statistics(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/statistics. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Statistics data.
  """
  __slots__ = ('_path_helper', '_extmethods', '__discontinuity_time','__node','__connectivity_matrix_entry',)

  _yang_name = 'statistics'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__discontinuity_time = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)
    self.__node = YANGDynClass(base=node.node, is_container='container', yang_name="node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__connectivity_matrix_entry = YANGDynClass(base=connectivity_matrix_entry.connectivity_matrix_entry, is_container='container', yang_name="connectivity-matrix-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'statistics']

  def _get_discontinuity_time(self):
    """
    Getter method for discontinuity_time, mapped from YANG variable /networks/network/node/te/statistics/discontinuity_time (yang:date-and-time)

    YANG Description: The time of the most recent occasion at which any one or
more of this interface's counters suffered a
discontinuity.  If no such discontinuities have occurred
since the last re-initialization of the local management
subsystem, then this node contains the time the local
management subsystem re-initialized itself.
    """
    return self.__discontinuity_time
      
  def _set_discontinuity_time(self, v, load=False):
    """
    Setter method for discontinuity_time, mapped from YANG variable /networks/network/node/te/statistics/discontinuity_time (yang:date-and-time)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_discontinuity_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_discontinuity_time() directly.

    YANG Description: The time of the most recent occasion at which any one or
more of this interface's counters suffered a
discontinuity.  If no such discontinuities have occurred
since the last re-initialization of the local management
subsystem, then this node contains the time the local
management subsystem re-initialized itself.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """discontinuity_time must be of a type compatible with yang:date-and-time""",
          'defined-type': "yang:date-and-time",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)""",
        })

    self.__discontinuity_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_discontinuity_time(self):
    self.__discontinuity_time = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)


  def _get_node(self):
    """
    Getter method for node, mapped from YANG variable /networks/network/node/te/statistics/node (container)

    YANG Description: Contains statistics attributes at the TE node level.
    """
    return self.__node
      
  def _set_node(self, v, load=False):
    """
    Setter method for node, mapped from YANG variable /networks/network/node/te/statistics/node (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_node is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_node() directly.

    YANG Description: Contains statistics attributes at the TE node level.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=node.node, is_container='container', yang_name="node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """node must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=node.node, is_container='container', yang_name="node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__node = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_node(self):
    self.__node = YANGDynClass(base=node.node, is_container='container', yang_name="node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_connectivity_matrix_entry(self):
    """
    Getter method for connectivity_matrix_entry, mapped from YANG variable /networks/network/node/te/statistics/connectivity_matrix_entry (container)

    YANG Description: Contains statistics attributes at the level of a
connectivity matrix entry.
    """
    return self.__connectivity_matrix_entry
      
  def _set_connectivity_matrix_entry(self, v, load=False):
    """
    Setter method for connectivity_matrix_entry, mapped from YANG variable /networks/network/node/te/statistics/connectivity_matrix_entry (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_connectivity_matrix_entry is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_connectivity_matrix_entry() directly.

    YANG Description: Contains statistics attributes at the level of a
connectivity matrix entry.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=connectivity_matrix_entry.connectivity_matrix_entry, is_container='container', yang_name="connectivity-matrix-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """connectivity_matrix_entry must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=connectivity_matrix_entry.connectivity_matrix_entry, is_container='container', yang_name="connectivity-matrix-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__connectivity_matrix_entry = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_connectivity_matrix_entry(self):
    self.__connectivity_matrix_entry = YANGDynClass(base=connectivity_matrix_entry.connectivity_matrix_entry, is_container='container', yang_name="connectivity-matrix-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

  discontinuity_time = __builtin__.property(_get_discontinuity_time)
  node = __builtin__.property(_get_node)
  connectivity_matrix_entry = __builtin__.property(_get_connectivity_matrix_entry)


  _pyangbind_elements = OrderedDict([('discontinuity_time', discontinuity_time), ('node', node), ('connectivity_matrix_entry', connectivity_matrix_entry), ])


