# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import label_start
from . import label_end
from . import label_step
from . import otn_label_range
from . import ethernet_label_range
class label_restriction(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/information-source-entry/label-restrictions/label-restriction. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The absence of the label restrictions container implies
that all labels are acceptable; otherwise, only restricted
labels are available.
  """
  __slots__ = ('_path_helper', '_extmethods', '__restriction','__index','__label_start','__label_end','__label_step','__range_bitmap','__otn_label_range','__ethernet_label_range',)

  _yang_name = 'label-restriction'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__restriction = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'inclusive': {}, 'exclusive': {}},), default=six.text_type("inclusive"), is_leaf=True, yang_name="restriction", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='enumeration', is_config=False)
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=False)
    self.__label_start = YANGDynClass(base=label_start.label_start, is_container='container', yang_name="label-start", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__label_end = YANGDynClass(base=label_end.label_end, is_container='container', yang_name="label-end", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__label_step = YANGDynClass(base=label_step.label_step, is_container='container', yang_name="label-step", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__range_bitmap = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}), is_leaf=True, yang_name="range-bitmap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:hex-string', is_config=False)
    self.__otn_label_range = YANGDynClass(base=otn_label_range.otn_label_range, is_container='container', yang_name="otn-label-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)
    self.__ethernet_label_range = YANGDynClass(base=ethernet_label_range.ethernet_label_range, is_container='container', yang_name="ethernet-label-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'information-source-entry', 'label-restrictions', 'label-restriction']

  def _get_restriction(self):
    """
    Getter method for restriction, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/restriction (enumeration)

    YANG Description: Indicates whether the list item is inclusive or exclusive.
    """
    return self.__restriction
      
  def _set_restriction(self, v, load=False):
    """
    Setter method for restriction, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/restriction (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_restriction is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_restriction() directly.

    YANG Description: Indicates whether the list item is inclusive or exclusive.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'inclusive': {}, 'exclusive': {}},), default=six.text_type("inclusive"), is_leaf=True, yang_name="restriction", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """restriction must be of a type compatible with enumeration""",
          'defined-type': "ietf-te-topology:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'inclusive': {}, 'exclusive': {}},), default=six.text_type("inclusive"), is_leaf=True, yang_name="restriction", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='enumeration', is_config=False)""",
        })

    self.__restriction = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_restriction(self):
    self.__restriction = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'inclusive': {}, 'exclusive': {}},), default=six.text_type("inclusive"), is_leaf=True, yang_name="restriction", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='enumeration', is_config=False)


  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/index (uint32)

    YANG Description: The index of the label restriction list entry.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: The index of the label restriction list entry.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=False)


  def _get_label_start(self):
    """
    Getter method for label_start, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/label_start (container)

    YANG Description: This is the starting label if a label range is specified.
This is the label value if a single label is specified,
in which case the 'label-end' attribute is not set.
    """
    return self.__label_start
      
  def _set_label_start(self, v, load=False):
    """
    Setter method for label_start, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/label_start (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label_start is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label_start() directly.

    YANG Description: This is the starting label if a label range is specified.
This is the label value if a single label is specified,
in which case the 'label-end' attribute is not set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=label_start.label_start, is_container='container', yang_name="label-start", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label_start must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=label_start.label_start, is_container='container', yang_name="label-start", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__label_start = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label_start(self):
    self.__label_start = YANGDynClass(base=label_start.label_start, is_container='container', yang_name="label-start", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_label_end(self):
    """
    Getter method for label_end, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/label_end (container)

    YANG Description: This is the ending label if a label range is specified.
This attribute is not set if a single label is specified.
    """
    return self.__label_end
      
  def _set_label_end(self, v, load=False):
    """
    Setter method for label_end, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/label_end (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label_end is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label_end() directly.

    YANG Description: This is the ending label if a label range is specified.
This attribute is not set if a single label is specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=label_end.label_end, is_container='container', yang_name="label-end", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label_end must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=label_end.label_end, is_container='container', yang_name="label-end", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__label_end = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label_end(self):
    self.__label_end = YANGDynClass(base=label_end.label_end, is_container='container', yang_name="label-end", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_label_step(self):
    """
    Getter method for label_step, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/label_step (container)

    YANG Description: The step increment between labels in the label range.
The label start/end values will have to be consistent
with the sign of label step.  For example,
'label-start' < 'label-end' enforces 'label-step' > 0
'label-start' > 'label-end' enforces 'label-step' < 0.
    """
    return self.__label_step
      
  def _set_label_step(self, v, load=False):
    """
    Setter method for label_step, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/label_step (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label_step is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label_step() directly.

    YANG Description: The step increment between labels in the label range.
The label start/end values will have to be consistent
with the sign of label step.  For example,
'label-start' < 'label-end' enforces 'label-step' > 0
'label-start' > 'label-end' enforces 'label-step' < 0.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=label_step.label_step, is_container='container', yang_name="label-step", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label_step must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=label_step.label_step, is_container='container', yang_name="label-step", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__label_step = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label_step(self):
    self.__label_step = YANGDynClass(base=label_step.label_step, is_container='container', yang_name="label-step", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_range_bitmap(self):
    """
    Getter method for range_bitmap, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/range_bitmap (yang:hex-string)

    YANG Description: When there are gaps between 'label-start' and 'label-end',
this attribute is used to specify the positions
of the used labels.  This is represented in big endian as
'hex-string'.
The most significant byte in the hex-string is the farthest
to the left in the byte sequence.  Leading zero bytes in the
configured value may be omitted for brevity.
Each bit position in the 'range-bitmap' 'hex-string' maps
to a label in the range derived from 'label-start'.

For example, assuming that 'label-start' = 16000 and
'range-bitmap' = 0x01000001, then:

- bit position (0) is set, and the corresponding mapped
  label from the range is 16000 + (0 * 'label-step') or
  16000 for default 'label-step' = 1.
- bit position (24) is set, and the corresponding mapped
  label from the range is 16000 + (24 * 'label-step') or
  16024 for default 'label-step' = 1.
    """
    return self.__range_bitmap
      
  def _set_range_bitmap(self, v, load=False):
    """
    Setter method for range_bitmap, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/range_bitmap (yang:hex-string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_range_bitmap is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_range_bitmap() directly.

    YANG Description: When there are gaps between 'label-start' and 'label-end',
this attribute is used to specify the positions
of the used labels.  This is represented in big endian as
'hex-string'.
The most significant byte in the hex-string is the farthest
to the left in the byte sequence.  Leading zero bytes in the
configured value may be omitted for brevity.
Each bit position in the 'range-bitmap' 'hex-string' maps
to a label in the range derived from 'label-start'.

For example, assuming that 'label-start' = 16000 and
'range-bitmap' = 0x01000001, then:

- bit position (0) is set, and the corresponding mapped
  label from the range is 16000 + (0 * 'label-step') or
  16000 for default 'label-step' = 1.
- bit position (24) is set, and the corresponding mapped
  label from the range is 16000 + (24 * 'label-step') or
  16024 for default 'label-step' = 1.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}), is_leaf=True, yang_name="range-bitmap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:hex-string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """range_bitmap must be of a type compatible with yang:hex-string""",
          'defined-type': "yang:hex-string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}), is_leaf=True, yang_name="range-bitmap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:hex-string', is_config=False)""",
        })

    self.__range_bitmap = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_range_bitmap(self):
    self.__range_bitmap = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?'}), is_leaf=True, yang_name="range-bitmap", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:hex-string', is_config=False)


  def _get_otn_label_range(self):
    """
    Getter method for otn_label_range, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/otn_label_range (container)

    YANG Description: Label range information for OTN.
    """
    return self.__otn_label_range
      
  def _set_otn_label_range(self, v, load=False):
    """
    Setter method for otn_label_range, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/otn_label_range (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_otn_label_range is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_otn_label_range() directly.

    YANG Description: Label range information for OTN.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=otn_label_range.otn_label_range, is_container='container', yang_name="otn-label-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """otn_label_range must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=otn_label_range.otn_label_range, is_container='container', yang_name="otn-label-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)""",
        })

    self.__otn_label_range = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_otn_label_range(self):
    self.__otn_label_range = YANGDynClass(base=otn_label_range.otn_label_range, is_container='container', yang_name="otn-label-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=False)


  def _get_ethernet_label_range(self):
    """
    Getter method for ethernet_label_range, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/ethernet_label_range (container)

    YANG Description: Ethernet-specific label range related information.
    """
    return self.__ethernet_label_range
      
  def _set_ethernet_label_range(self, v, load=False):
    """
    Setter method for ethernet_label_range, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction/ethernet_label_range (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ethernet_label_range is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ethernet_label_range() directly.

    YANG Description: Ethernet-specific label range related information.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=ethernet_label_range.ethernet_label_range, is_container='container', yang_name="ethernet-label-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ethernet_label_range must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=ethernet_label_range.ethernet_label_range, is_container='container', yang_name="ethernet-label-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=False)""",
        })

    self.__ethernet_label_range = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ethernet_label_range(self):
    self.__ethernet_label_range = YANGDynClass(base=ethernet_label_range.ethernet_label_range, is_container='container', yang_name="ethernet-label-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=False)

  restriction = __builtin__.property(_get_restriction)
  index = __builtin__.property(_get_index)
  label_start = __builtin__.property(_get_label_start)
  label_end = __builtin__.property(_get_label_end)
  label_step = __builtin__.property(_get_label_step)
  range_bitmap = __builtin__.property(_get_range_bitmap)
  otn_label_range = __builtin__.property(_get_otn_label_range)
  ethernet_label_range = __builtin__.property(_get_ethernet_label_range)


  _pyangbind_elements = OrderedDict([('restriction', restriction), ('index', index), ('label_start', label_start), ('label_end', label_end), ('label_step', label_step), ('range_bitmap', range_bitmap), ('otn_label_range', otn_label_range), ('ethernet_label_range', ethernet_label_range), ])


