# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import label_restriction
class label_restrictions(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/information-source-entry/label-restrictions. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The label restrictions container.
  """
  __slots__ = ('_path_helper', '_extmethods', '__label_restriction',)

  _yang_name = 'label-restrictions'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__label_restriction = YANGDynClass(base=YANGListType("index",label_restriction.label_restriction, yang_name="label-restriction", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="label-restriction", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'information-source-entry', 'label-restrictions']

  def _get_label_restriction(self):
    """
    Getter method for label_restriction, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction (list)

    YANG Description: The absence of the label restrictions container implies
that all labels are acceptable; otherwise, only restricted
labels are available.
    """
    return self.__label_restriction
      
  def _set_label_restriction(self, v, load=False):
    """
    Setter method for label_restriction, mapped from YANG variable /networks/network/link/te/information_source_entry/label_restrictions/label_restriction (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label_restriction is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label_restriction() directly.

    YANG Description: The absence of the label restrictions container implies
that all labels are acceptable; otherwise, only restricted
labels are available.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("index",label_restriction.label_restriction, yang_name="label-restriction", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="label-restriction", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label_restriction must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("index",label_restriction.label_restriction, yang_name="label-restriction", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="label-restriction", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)""",
        })

    self.__label_restriction = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label_restriction(self):
    self.__label_restriction = YANGDynClass(base=YANGListType("index",label_restriction.label_restriction, yang_name="label-restriction", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="label-restriction", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)

  label_restriction = __builtin__.property(_get_label_restriction)


  _pyangbind_elements = OrderedDict([('label_restriction', label_restriction), ])


