from flask.json import jsonify
from flask_restful import Resource
from google.protobuf.json_format import MessageToDict
from common.orm.Database import Database
from context.proto.context_pb2 import Empty
from context.service.grpc_server.ContextServiceServicerImpl import ContextServiceServicerImpl

class Context(Resource):
    def __init__(self, database : Database) -> None:
        super().__init__()
        self.database = database

    def get(self):
        servicer = ContextServiceServicerImpl(self.database, None)
        return jsonify(MessageToDict(servicer.ListContexts(Empty(), None)))
