import logging, pytest
from common.Constants import DEFAULT_CONTEXT_UUID, DEFAULT_TOPOLOGY_UUID
from common.orm.Database import Database
from common.orm.Factory import get_database_backend, BackendEnum
from context.service.database.Models import ContextModel, DeviceModel, LinkModel, TopologyDeviceModel, TopologyLinkModel, TopologyModel

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)

@pytest.fixture(scope='session')
def database():
    database_backend = get_database_backend(engine=BackendEnum.INMEMORY)
    _database = Database(database_backend)
    return _database

def test_create_context_topology(database : Database):
    context = ContextModel(database, DEFAULT_CONTEXT_UUID)
    context.save()

    topology = TopologyModel(database, DEFAULT_TOPOLOGY_UUID)
    topology.context_fk = context
    topology.save()

def test_create_devices(database : Database):
    topology = TopologyModel(database, DEFAULT_TOPOLOGY_UUID)

    device_01 = DeviceModel(database, 'dev-01')
    device_01.save()

    relation_topology_device_01 = TopologyDeviceModel(database, 'admin--dev-01')
    relation_topology_device_01.topology_fk = topology
    relation_topology_device_01.device_fk = device_01
    relation_topology_device_01.save()

    device_02 = DeviceModel(database, 'dev-02')
    device_02.save()

    relation_topology_device_02 = TopologyDeviceModel(database, 'admin--dev-02')
    relation_topology_device_02.topology_fk = topology
    relation_topology_device_02.device_fk = device_02
    relation_topology_device_02.save()

    device_03 = DeviceModel(database, 'dev-03')
    device_03.save()

    relation_topology_device_03 = TopologyDeviceModel(database, 'admin--dev-03')
    relation_topology_device_03.topology_fk = topology
    relation_topology_device_03.device_fk = device_03
    relation_topology_device_03.save()

def test_create_links(database : Database):
    topology = TopologyModel(database, DEFAULT_TOPOLOGY_UUID)

    link_01 = LinkModel(database, 'dev-01')
    link_01.save()

    relation_topology_link_01 = TopologyLinkModel(database, 'admin--dev-01')
    relation_topology_link_01.topology_fk = topology
    relation_topology_link_01.link_fk = link_01
    relation_topology_link_01.save()

    link_02 = LinkModel(database, 'dev-02')
    link_02.save()

    relation_topology_link_02 = TopologyLinkModel(database, 'admin--dev-02')
    relation_topology_link_02.topology_fk = topology
    relation_topology_link_02.link_fk = link_02
    relation_topology_link_02.save()

    link_03 = LinkModel(database, 'dev-03')
    link_03.save()

    relation_topology_link_03 = TopologyLinkModel(database, 'admin--dev-03')
    relation_topology_link_03.topology_fk = topology
    relation_topology_link_03.link_fk = link_03
    relation_topology_link_03.save()

def test_dump(database : Database):
    db_entries = database.dump()
    LOGGER.info('----- Database Dump [{:3d} entries] -------------------------'.format(len(db_entries)))
    for db_entry in db_entries:
        LOGGER.info('  [{:>4s}] {:40s} :: {:s}'.format(*db_entry))
    LOGGER.info('-----------------------------------------------------------')
    raise Exception()

#    assert len(database_dump) == 9
#    assert database_dump[ 0] == ('dict', 'Member[brad]',
#                                 "{'name': 'Brad', 'pk': 'brad', 'team': 'Team[admin]'}")
#    assert database_dump[ 1] == ('dict', 'Member[john]',
#                                 "{'name': 'John', 'pk': 'john', 'place': 'Workplace[bcn]', 'team': 'Team[dev-ops]'}")
#    assert database_dump[ 2] == ('dict', 'Team[admin]',
#                                 "{'name': 'Admin', 'pk': 'admin'}")
#    assert database_dump[ 3] == ('set',  'Team[admin]/references',
#                                 "{'Member[brad]:team'}")
#    assert database_dump[ 4] == ('dict', 'Team[dev-ops]',
#                                 "{'name': 'Dev Ops', 'pk': 'dev-ops'}")
#    assert database_dump[ 5] == ('set',  'Team[dev-ops]/references',
#                                 "{'Member[john]:team'}")
#    assert database_dump[ 6] == ('dict', 'Workplace[bcn]',
#                                 "{'name': 'Barcelona', 'pk': 'bcn'}")
#    assert database_dump[ 7] == ('set',  'Workplace[bcn]/references',
#                                 "{'Member[john]:place'}")
#    assert database_dump[ 8] == ('dict', 'Workplace[mad]',
#                                 "{'name': 'Madrid', 'pk': 'mad'}")
