from __future__ import annotations
from typing import TYPE_CHECKING, Dict, List
from .._engine.object._Object import _Object
from .._engine.object.Attributes import Attributes
from .._engine.object.Collection import Collection
from ._Keys import KEY_LINK #, KEY_LINK_ENDPOINTS

if TYPE_CHECKING:
    from .Context import Context
    from .Topology import Topology

VALIDATORS = {}  # no attributes accepted
TRANSCODERS = {} # no transcoding applied to attributes

class Link(_Object):
    def __init__(self, link_uuid : str, parent : 'Topology'):
        super().__init__(parent, link_uuid)
        self._attributes = Attributes(parent, KEY_LINK, VALIDATORS, TRANSCODERS)
        self._endpoints = Collection(self, KEY_LINK_ENDPOINTS)

    @property
    def parent(self) -> 'Topology': return self._parent

    @property
    def context(self) -> 'Context': return self.parent.context

    @property
    def context_uuid(self) -> str: return self.parent.context_uuid

    @property
    def topology(self) -> 'Topology': return self.parent

    @property
    def topology_uuid(self) -> str: return self.parent.topology_uuid

    @property
    def link_uuid(self) -> str: return self._object_uuid

    @property
    def attributes(self) -> Attributes: return self._attributes

    @property
    def endpoints(self) -> Collection: return self._endpoints

    def endpoint(self, link_endpoint_uuid : str) -> Endpoint: return Endpoint(link_endpoint_uuid, self)

    def create(self) -> 'Link':
        self.parent.links.add(self.link_uuid)
        return self

    def update(self, update_attributes={}, remove_attributes=[]) -> 'Link':
        self.attributes.update(update_attributes=update_attributes, remove_attributes=remove_attributes)
        return self

    def delete(self) -> None:
        for endpoint_uuid in self.endpoints.get(): self.endpoint(endpoint_uuid).delete()
        self.attributes.delete()
        self.parent.links.delete(self.link_uuid)

    def dump_id(self) -> Dict:
        return {'link_uuid': {'uuid': self.link_uuid}}

    def dump_endpoints(self) -> List[Dict]:
        return [self.endpoint(endpoint_uuid).dump() for endpoint_uuid in self.endpoints.get()]

    def dump(self, include_endpoints=True) -> Dict:
        result = {'link_id': self.dump_id()}
        if include_endpoints: result['endpoints'] = self.dump_endpoints()
        return result
