# SLICE GROUPING details

## Description
- Similar slice requests can share underlying services.
- Clustering algorithm for slice grouping.
- Consider both paths and SLA constraints.
- SLA monitored by slice group.

## TFS Target Objective
- Objective 3.2: Provisioning of multi-tenant transport network slices.
- Improve network resource usage by 30% by adopting multi-tenancy resource allocation algorithms.
- Optimal slice grouping: trade-offs between economies of scale and limitations as to which SLAs can be grouped together need to be considered.
- Optimal grouping of slices is required to maximise KPIs, such as resource utilisation, utility of the connectivity, and energy efficiency.
- In this context, trade-offs between the resulting control plane complexity and differential treatment of SLA classes should be considered.

## New Requirements
- User can select if slice grouping is performed per-slice request.
- Slice grouping introduces a clustering algorithm for finding service optimisation while preserving slice SLA.
- Service (re-)optimisation is provided.

## TFS Architecture Update
- Update Slice service RPC to include Slice Grouping.
- Use novel Slice model with SLA constraints.
- Use Policy Component with action to update services to apply slice grouping.
- Describe Slice service operation modes: per-request or user-triggered.

    OSS/BSS --> Slice   : Create Slice with SLA (slice)
    Slice   --> Slice   : Slice Grouping (slice)
alt [slice can be grouped to other slice services]
    // do nothing and return existing slice
else [slice needs new services]
    Slice   --> ... : normal logic
end alt
    Slice   --> OSS/BSS : slice

slice.proto:
  rpc OrderSliceWithSLA(context.Slice) returns (context.SliceId) {} // If slice with SLA already exists, returns slice. If not, it creates it.
  rpc RunSliceGrouping (context.Empty) returns (context.Empty) {} // Optimizes the underlying services and re-maps them to the requested slices.
