
# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from typing import Any
from telemetry.database.TelemetryDBmanager import TelemetryDBmanager
from telemetry.database.TelemetryEngine import TelemetryEngine
from telemetry.database.tests import temp_DB
from .messages import create_kpi_request, create_collector_request, \
                        create_kpi_id_request, create_kpi_filter_request

logging.basicConfig(level=logging.INFO)
LOGGER = logging.getLogger(__name__)

# def test_temp_DB():
#     temp_DB.main()

def test_telemetry_object_creation():
    LOGGER.info('--- test_telemetry_object_creation: START')
    LOGGER.info('>>> Creating TelemetryDBmanager Object: ')
    TelemetryDBmanagerObj = TelemetryDBmanager()
    # LOGGER.info('>>> Creating Tables: ')
    # TelemetryDBmanagerObj.create_tables()
    # LOGGER.info('>>> Verifing Table creation: ')
    # TelemetryDBmanagerObj.verify_tables()
    LOGGER.info('>>> Row Insertion Operation: kpi Table')
    kpi_obj = create_kpi_request()
    TelemetryDBmanagerObj.inser_kpi(kpi_obj)
    LOGGER.info('>>> Row Insertion Operation: collector Table')
    collector_obj = create_collector_request()
    TelemetryDBmanagerObj.insert_collector(collector_obj)
    LOGGER.info('>>> Get KpiDescriptor ')
    kpi_id_obj = create_kpi_id_request()
    TelemetryDBmanagerObj.get_kpi_descriptor(kpi_id_obj)
    kpi_filter : dict[str, Any] = create_kpi_filter_request()
    TelemetryDBmanagerObj.select_kpi_descriptor(**kpi_filter)

    