// Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*
Package gostruct is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was false
in this case).

This package was generated by /usr/share/gocode/src/github.com/openconfig/ygot/ygen/commongen.go
using the following YANG input files:
	- /root/public/release/models/optical-transport/openconfig-terminal-device.yang
	- /root/public/release/models/types/openconfig-types.yang
	- /root/public/release/models/openconfig-extensions.yang
	- /root/public/release/models/platform/openconfig-platform-types.yang
	- /root/public/release/models/system/openconfig-alarm-types.yang
	- /root/public/release/models/lldp/openconfig-lldp.yang
	- /root/public/release/models/interfaces/openconfig-interfaces.yang
Imported modules were sourced from:
*/
package gostruct

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ytypes"
)

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

var (
	SchemaTree map[string]*yang.Entry
)

func init() {
	var err error
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " +  err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root: &Device{},
		SchemaTree: uzp,
		Unmarshal: Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn )
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}

// Device represents the /device YANG schema element.
type Device struct {
	Components	*OpenconfigPlatform_Components	`path:"components" module:"openconfig-platform"`
	Interfaces	*OpenconfigInterfaces_Interfaces	`path:"interfaces" module:"openconfig-interfaces"`
	InterfacesState	*IETFInterfaces_InterfacesState	`path:"interfaces-state" module:"ietf-interfaces"`
	Lldp	*OpenconfigLldp_Lldp	`path:"lldp" module:"openconfig-lldp"`
	TerminalDevice	*OpenconfigTerminalDevice_TerminalDevice	`path:"terminal-device" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// IETFInterfaces_InterfacesState represents the /ietf-interfaces/interfaces-state YANG schema element.
type IETFInterfaces_InterfacesState struct {
	Interface	map[string]*IETFInterfaces_InterfacesState_Interface	`path:"interface" module:"ietf-interfaces"`
}

// IsYANGGoStruct ensures that IETFInterfaces_InterfacesState implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*IETFInterfaces_InterfacesState) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// IETFInterfaces_InterfacesState struct. The keys of the list are populated from the input
// arguments.
func (t *IETFInterfaces_InterfacesState) NewInterface(Name string) (*IETFInterfaces_InterfacesState_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*IETFInterfaces_InterfacesState_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &IETFInterfaces_InterfacesState_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *IETFInterfaces_InterfacesState) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["IETFInterfaces_InterfacesState"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *IETFInterfaces_InterfacesState) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// IETFInterfaces_InterfacesState_Interface represents the /ietf-interfaces/interfaces-state/interface YANG schema element.
type IETFInterfaces_InterfacesState_Interface struct {
	AdminStatus	E_IETFInterfaces_InterfacesState_Interface_AdminStatus	`path:"admin-status" module:"ietf-interfaces"`
	HigherLayerIf	[]string	`path:"higher-layer-if" module:"ietf-interfaces"`
	IfIndex	*int32	`path:"if-index" module:"ietf-interfaces"`
	LastChange	*string	`path:"last-change" module:"ietf-interfaces"`
	LowerLayerIf	[]string	`path:"lower-layer-if" module:"ietf-interfaces"`
	Name	*string	`path:"name" module:"ietf-interfaces"`
	OperStatus	E_IETFInterfaces_InterfacesState_Interface_OperStatus	`path:"oper-status" module:"ietf-interfaces"`
	PhysAddress	*string	`path:"phys-address" module:"ietf-interfaces"`
	Speed	*uint64	`path:"speed" module:"ietf-interfaces"`
	Statistics	*IETFInterfaces_InterfacesState_Interface_Statistics	`path:"statistics" module:"ietf-interfaces"`
	Type	E_IETFInterfaces_InterfaceType	`path:"type" module:"ietf-interfaces"`
}

// IsYANGGoStruct ensures that IETFInterfaces_InterfacesState_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*IETFInterfaces_InterfacesState_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the IETFInterfaces_InterfacesState_Interface struct, which is a YANG list entry.
func (t *IETFInterfaces_InterfacesState_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *IETFInterfaces_InterfacesState_Interface) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["IETFInterfaces_InterfacesState_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *IETFInterfaces_InterfacesState_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// IETFInterfaces_InterfacesState_Interface_Statistics represents the /ietf-interfaces/interfaces-state/interface/statistics YANG schema element.
type IETFInterfaces_InterfacesState_Interface_Statistics struct {
	DiscontinuityTime	*string	`path:"discontinuity-time" module:"ietf-interfaces"`
	InBroadcastPkts	*uint64	`path:"in-broadcast-pkts" module:"ietf-interfaces"`
	InDiscards	*uint32	`path:"in-discards" module:"ietf-interfaces"`
	InErrors	*uint32	`path:"in-errors" module:"ietf-interfaces"`
	InMulticastPkts	*uint64	`path:"in-multicast-pkts" module:"ietf-interfaces"`
	InOctets	*uint64	`path:"in-octets" module:"ietf-interfaces"`
	InUnicastPkts	*uint64	`path:"in-unicast-pkts" module:"ietf-interfaces"`
	InUnknownProtos	*uint32	`path:"in-unknown-protos" module:"ietf-interfaces"`
	OutBroadcastPkts	*uint64	`path:"out-broadcast-pkts" module:"ietf-interfaces"`
	OutDiscards	*uint32	`path:"out-discards" module:"ietf-interfaces"`
	OutErrors	*uint32	`path:"out-errors" module:"ietf-interfaces"`
	OutMulticastPkts	*uint64	`path:"out-multicast-pkts" module:"ietf-interfaces"`
	OutOctets	*uint64	`path:"out-octets" module:"ietf-interfaces"`
	OutUnicastPkts	*uint64	`path:"out-unicast-pkts" module:"ietf-interfaces"`
}

// IsYANGGoStruct ensures that IETFInterfaces_InterfacesState_Interface_Statistics implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*IETFInterfaces_InterfacesState_Interface_Statistics) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *IETFInterfaces_InterfacesState_Interface_Statistics) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["IETFInterfaces_InterfacesState_Interface_Statistics"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *IETFInterfaces_InterfacesState_Interface_Statistics) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces represents the /openconfig-interfaces/interfaces YANG schema element.
type OpenconfigInterfaces_Interfaces struct {
	Interface	map[string]*OpenconfigInterfaces_Interfaces_Interface	`path:"interface" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigInterfaces_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces) NewInterface(Name string) (*OpenconfigInterfaces_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigInterfaces_Interfaces_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface represents the /openconfig-interfaces/interfaces/interface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Config	`path:"config" module:"openconfig-interfaces"`
	Ethernet	*OpenconfigInterfaces_Interfaces_Interface_Ethernet	`path:"ethernet" module:"openconfig-if-ethernet"`
	HoldTime	*OpenconfigInterfaces_Interfaces_Interface_HoldTime	`path:"hold-time" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	State	*OpenconfigInterfaces_Interfaces_Interface_State	`path:"state" module:"openconfig-interfaces"`
	Subinterfaces	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces	`path:"subinterfaces" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_Config represents the /openconfig-interfaces/interfaces/interface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Config struct {
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	LoopbackMode	*bool	`path:"loopback-mode" module:"openconfig-interfaces"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	Type	E_IETFInterfaces_InterfaceType	`path:"type" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_Ethernet represents the /openconfig-interfaces/interfaces/interface/ethernet YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config	`path:"config" module:"openconfig-if-ethernet"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State	`path:"state" module:"openconfig-if-ethernet"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config represents the /openconfig-interfaces/interfaces/interface/ethernet/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config struct {
	AutoNegotiate	*bool	`path:"auto-negotiate" module:"openconfig-if-ethernet"`
	DuplexMode	E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode	`path:"duplex-mode" module:"openconfig-if-ethernet"`
	EnableFlowControl	*bool	`path:"enable-flow-control" module:"openconfig-if-ethernet"`
	MacAddress	*string	`path:"mac-address" module:"openconfig-if-ethernet"`
	PortSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"port-speed" module:"openconfig-if-ethernet"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State represents the /openconfig-interfaces/interfaces/interface/ethernet/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_State struct {
	AutoNegotiate	*bool	`path:"auto-negotiate" module:"openconfig-if-ethernet"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters	`path:"counters" module:"openconfig-if-ethernet"`
	DuplexMode	E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode	`path:"duplex-mode" module:"openconfig-if-ethernet"`
	EnableFlowControl	*bool	`path:"enable-flow-control" module:"openconfig-if-ethernet"`
	HwMacAddress	*string	`path:"hw-mac-address" module:"openconfig-if-ethernet"`
	MacAddress	*string	`path:"mac-address" module:"openconfig-if-ethernet"`
	NegotiatedDuplexMode	E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode	`path:"negotiated-duplex-mode" module:"openconfig-if-ethernet"`
	NegotiatedPortSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"negotiated-port-speed" module:"openconfig-if-ethernet"`
	PortSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"port-speed" module:"openconfig-if-ethernet"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters represents the /openconfig-interfaces/interfaces/interface/ethernet/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters struct {
	In_8021QFrames	*uint64	`path:"in-8021q-frames" module:"openconfig-if-ethernet"`
	InBlockErrors	*uint64	`path:"in-block-errors" module:"openconfig-if-ethernet"`
	InCrcErrors	*uint64	`path:"in-crc-errors" module:"openconfig-if-ethernet"`
	InFragmentFrames	*uint64	`path:"in-fragment-frames" module:"openconfig-if-ethernet"`
	InJabberFrames	*uint64	`path:"in-jabber-frames" module:"openconfig-if-ethernet"`
	InMacControlFrames	*uint64	`path:"in-mac-control-frames" module:"openconfig-if-ethernet"`
	InMacPauseFrames	*uint64	`path:"in-mac-pause-frames" module:"openconfig-if-ethernet"`
	InOversizeFrames	*uint64	`path:"in-oversize-frames" module:"openconfig-if-ethernet"`
	InUndersizeFrames	*uint64	`path:"in-undersize-frames" module:"openconfig-if-ethernet"`
	Out_8021QFrames	*uint64	`path:"out-8021q-frames" module:"openconfig-if-ethernet"`
	OutMacControlFrames	*uint64	`path:"out-mac-control-frames" module:"openconfig-if-ethernet"`
	OutMacPauseFrames	*uint64	`path:"out-mac-pause-frames" module:"openconfig-if-ethernet"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_HoldTime represents the /openconfig-interfaces/interfaces/interface/hold-time YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config	`path:"config" module:"openconfig-interfaces"`
	State	*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State	`path:"state" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config represents the /openconfig-interfaces/interfaces/interface/hold-time/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config struct {
	Down	*uint32	`path:"down" module:"openconfig-interfaces"`
	Up	*uint32	`path:"up" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_HoldTime_State represents the /openconfig-interfaces/interfaces/interface/hold-time/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime_State struct {
	Down	*uint32	`path:"down" module:"openconfig-interfaces"`
	Up	*uint32	`path:"up" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_State represents the /openconfig-interfaces/interfaces/interface/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_State struct {
	AdminStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus	`path:"admin-status" module:"openconfig-interfaces"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_State_Counters	`path:"counters" module:"openconfig-interfaces"`
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	HardwarePort	*string	`path:"hardware-port" module:"openconfig-platform-port"`
	Ifindex	*uint32	`path:"ifindex" module:"openconfig-interfaces"`
	LastChange	*uint64	`path:"last-change" module:"openconfig-interfaces"`
	Logical	*bool	`path:"logical" module:"openconfig-interfaces"`
	LoopbackMode	*bool	`path:"loopback-mode" module:"openconfig-interfaces"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	OperStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus	`path:"oper-status" module:"openconfig-interfaces"`
	PhysicalChannel	[]uint16	`path:"physical-channel" module:"openconfig-platform-transceiver"`
	Transceiver	*string	`path:"transceiver" module:"openconfig-platform-transceiver"`
	Type	E_IETFInterfaces_InterfaceType	`path:"type" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_State_Counters represents the /openconfig-interfaces/interfaces/interface/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_State_Counters struct {
	CarrierTransitions	*uint64	`path:"carrier-transitions" module:"openconfig-interfaces"`
	InBroadcastPkts	*uint64	`path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	InDiscards	*uint64	`path:"in-discards" module:"openconfig-interfaces"`
	InErrors	*uint64	`path:"in-errors" module:"openconfig-interfaces"`
	InFcsErrors	*uint64	`path:"in-fcs-errors" module:"openconfig-interfaces"`
	InMulticastPkts	*uint64	`path:"in-multicast-pkts" module:"openconfig-interfaces"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-interfaces"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-interfaces"`
	InUnicastPkts	*uint64	`path:"in-unicast-pkts" module:"openconfig-interfaces"`
	InUnknownProtos	*uint64	`path:"in-unknown-protos" module:"openconfig-interfaces"`
	LastClear	*uint64	`path:"last-clear" module:"openconfig-interfaces"`
	OutBroadcastPkts	*uint64	`path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	OutDiscards	*uint64	`path:"out-discards" module:"openconfig-interfaces"`
	OutErrors	*uint64	`path:"out-errors" module:"openconfig-interfaces"`
	OutMulticastPkts	*uint64	`path:"out-multicast-pkts" module:"openconfig-interfaces"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-interfaces"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-interfaces"`
	OutUnicastPkts	*uint64	`path:"out-unicast-pkts" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces represents the /openconfig-interfaces/interfaces/interface/subinterfaces YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct {
	Subinterface	map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface	`path:"subinterface" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) IsYANGGoStruct() {}

// NewSubinterface creates a new entry in the Subinterface list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) NewSubinterface(Index uint32) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subinterface == nil {
		t.Subinterface = make(map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Subinterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Subinterface", key)
	}

	t.Subinterface[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface{
		Index: &Index,
	}

	return t.Subinterface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config	`path:"config" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State	`path:"state" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config struct {
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State struct {
	AdminStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus	`path:"admin-status" module:"openconfig-interfaces"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters	`path:"counters" module:"openconfig-interfaces"`
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Ifindex	*uint32	`path:"ifindex" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
	LastChange	*uint64	`path:"last-change" module:"openconfig-interfaces"`
	Logical	*bool	`path:"logical" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	OperStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus	`path:"oper-status" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters struct {
	CarrierTransitions	*uint64	`path:"carrier-transitions" module:"openconfig-interfaces"`
	InBroadcastPkts	*uint64	`path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	InDiscards	*uint64	`path:"in-discards" module:"openconfig-interfaces"`
	InErrors	*uint64	`path:"in-errors" module:"openconfig-interfaces"`
	InFcsErrors	*uint64	`path:"in-fcs-errors" module:"openconfig-interfaces"`
	InMulticastPkts	*uint64	`path:"in-multicast-pkts" module:"openconfig-interfaces"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-interfaces"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-interfaces"`
	InUnicastPkts	*uint64	`path:"in-unicast-pkts" module:"openconfig-interfaces"`
	InUnknownProtos	*uint64	`path:"in-unknown-protos" module:"openconfig-interfaces"`
	LastClear	*uint64	`path:"last-clear" module:"openconfig-interfaces"`
	OutBroadcastPkts	*uint64	`path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	OutDiscards	*uint64	`path:"out-discards" module:"openconfig-interfaces"`
	OutErrors	*uint64	`path:"out-errors" module:"openconfig-interfaces"`
	OutMulticastPkts	*uint64	`path:"out-multicast-pkts" module:"openconfig-interfaces"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-interfaces"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-interfaces"`
	OutUnicastPkts	*uint64	`path:"out-unicast-pkts" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp represents the /openconfig-lldp/lldp YANG schema element.
type OpenconfigLldp_Lldp struct {
	Config	*OpenconfigLldp_Lldp_Config	`path:"config" module:"openconfig-lldp"`
	Interfaces	*OpenconfigLldp_Lldp_Interfaces	`path:"interfaces" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Config represents the /openconfig-lldp/lldp/config YANG schema element.
type OpenconfigLldp_Lldp_Config struct {
	ChassisId	*string	`path:"chassis-id" module:"openconfig-lldp"`
	ChassisIdType	E_OpenconfigLldp_ChassisIdType	`path:"chassis-id-type" module:"openconfig-lldp"`
	Enabled	*bool	`path:"enabled" module:"openconfig-lldp"`
	HelloTimer	*uint64	`path:"hello-timer" module:"openconfig-lldp"`
	SuppressTlvAdvertisement	[]E_OpenconfigLldpTypes_LLDP_TLV	`path:"suppress-tlv-advertisement" module:"openconfig-lldp"`
	SystemDescription	*string	`path:"system-description" module:"openconfig-lldp"`
	SystemName	*string	`path:"system-name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces represents the /openconfig-lldp/lldp/interfaces YANG schema element.
type OpenconfigLldp_Lldp_Interfaces struct {
	Interface	map[string]*OpenconfigLldp_Lldp_Interfaces_Interface	`path:"interface" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigLldp_Lldp_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces) NewInterface(Name string) (*OpenconfigLldp_Lldp_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigLldp_Lldp_Interfaces_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigLldp_Lldp_Interfaces_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface represents the /openconfig-lldp/lldp/interfaces/interface YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface struct {
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Config	`path:"config" module:"openconfig-lldp"`
	Name	*string	`path:"name" module:"openconfig-lldp"`
	Neighbors	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors	`path:"neighbors" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Config represents the /openconfig-lldp/lldp/interfaces/interface/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-lldp"`
	Name	*string	`path:"name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors represents the /openconfig-lldp/lldp/interfaces/interface/neighbors YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors struct {
	Neighbor	map[string]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) NewNeighbor(Id string) (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor{
		Id: &Id,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor struct {
	Capabilities	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities	`path:"capabilities" module:"openconfig-lldp"`
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-lldp"`
	CustomTlvs	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs	`path:"custom-tlvs" module:"openconfig-lldp"`
	Id	*string	`path:"id" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities struct {
	Capability	map[E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability	`path:"capability" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) IsYANGGoStruct() {}

// NewCapability creates a new entry in the Capability list of the
// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) NewCapability(Name E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY) (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Capability == nil {
		t.Capability = make(map[E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Capability[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Capability", key)
	}

	t.Capability[key] = &OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability{
		Name: Name,
	}

	return t.Capability[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability struct {
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config	`path:"config" module:"openconfig-lldp"`
	Name	E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY	`path:"name" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"name": t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-lldp"`
	Name	E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY	`path:"name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs struct {
	Tlv	map[OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv	`path:"tlv" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) IsYANGGoStruct() {}

// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key represents the key for list Tlv of element /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key struct {
	Type	int32	`path:"type"`
	Oui	string	`path:"oui"`
	OuiSubtype	string	`path:"oui-subtype"`
}

// NewTlv creates a new entry in the Tlv list of the
// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) NewTlv(Type int32, Oui string, OuiSubtype string) (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Tlv == nil {
		t.Tlv = make(map[OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv)
	}

	key := OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key{
		Type: Type,
		Oui: Oui,
		OuiSubtype: OuiSubtype,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Tlv[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Tlv", key)
	}

	t.Tlv[key] = &OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv{
		Type: &Type,
		Oui: &Oui,
		OuiSubtype: &OuiSubtype,
	}

	return t.Tlv[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv struct {
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config	`path:"config" module:"openconfig-lldp"`
	Oui	*string	`path:"oui" module:"openconfig-lldp"`
	OuiSubtype	*string	`path:"oui-subtype" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State	`path:"state" module:"openconfig-lldp"`
	Type	*int32	`path:"type" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Oui == nil {
		return nil, fmt.Errorf("nil value for key Oui")
	}

	if t.OuiSubtype == nil {
		return nil, fmt.Errorf("nil value for key OuiSubtype")
	}

	if t.Type == nil {
		return nil, fmt.Errorf("nil value for key Type")
	}

	return map[string]interface{}{
		"oui": *t.Oui,
		"oui-subtype": *t.OuiSubtype,
		"type": *t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State struct {
	Oui	*string	`path:"oui" module:"openconfig-lldp"`
	OuiSubtype	*string	`path:"oui-subtype" module:"openconfig-lldp"`
	Type	*int32	`path:"type" module:"openconfig-lldp"`
	Value	Binary	`path:"value" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State struct {
	Age	*uint64	`path:"age" module:"openconfig-lldp"`
	ChassisId	*string	`path:"chassis-id" module:"openconfig-lldp"`
	ChassisIdType	E_OpenconfigLldp_ChassisIdType	`path:"chassis-id-type" module:"openconfig-lldp"`
	Id	*string	`path:"id" module:"openconfig-lldp"`
	LastUpdate	*int64	`path:"last-update" module:"openconfig-lldp"`
	ManagementAddress	*string	`path:"management-address" module:"openconfig-lldp"`
	ManagementAddressType	*string	`path:"management-address-type" module:"openconfig-lldp"`
	PortDescription	*string	`path:"port-description" module:"openconfig-lldp"`
	PortId	*string	`path:"port-id" module:"openconfig-lldp"`
	PortIdType	E_OpenconfigLldp_PortIdType	`path:"port-id-type" module:"openconfig-lldp"`
	SystemDescription	*string	`path:"system-description" module:"openconfig-lldp"`
	SystemName	*string	`path:"system-name" module:"openconfig-lldp"`
	Ttl	*uint16	`path:"ttl" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_State represents the /openconfig-lldp/lldp/interfaces/interface/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_State struct {
	Counters	*OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters	`path:"counters" module:"openconfig-lldp"`
	Enabled	*bool	`path:"enabled" module:"openconfig-lldp"`
	Name	*string	`path:"name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters represents the /openconfig-lldp/lldp/interfaces/interface/state/counters YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters struct {
	FrameDiscard	*uint64	`path:"frame-discard" module:"openconfig-lldp"`
	FrameErrorIn	*uint64	`path:"frame-error-in" module:"openconfig-lldp"`
	FrameErrorOut	*uint64	`path:"frame-error-out" module:"openconfig-lldp"`
	FrameIn	*uint64	`path:"frame-in" module:"openconfig-lldp"`
	FrameOut	*uint64	`path:"frame-out" module:"openconfig-lldp"`
	LastClear	*string	`path:"last-clear" module:"openconfig-lldp"`
	TlvDiscard	*uint64	`path:"tlv-discard" module:"openconfig-lldp"`
	TlvUnknown	*uint64	`path:"tlv-unknown" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_State represents the /openconfig-lldp/lldp/state YANG schema element.
type OpenconfigLldp_Lldp_State struct {
	ChassisId	*string	`path:"chassis-id" module:"openconfig-lldp"`
	ChassisIdType	E_OpenconfigLldp_ChassisIdType	`path:"chassis-id-type" module:"openconfig-lldp"`
	Counters	*OpenconfigLldp_Lldp_State_Counters	`path:"counters" module:"openconfig-lldp"`
	Enabled	*bool	`path:"enabled" module:"openconfig-lldp"`
	HelloTimer	*uint64	`path:"hello-timer" module:"openconfig-lldp"`
	SuppressTlvAdvertisement	[]E_OpenconfigLldpTypes_LLDP_TLV	`path:"suppress-tlv-advertisement" module:"openconfig-lldp"`
	SystemDescription	*string	`path:"system-description" module:"openconfig-lldp"`
	SystemName	*string	`path:"system-name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigLldp_Lldp_State_Counters represents the /openconfig-lldp/lldp/state/counters YANG schema element.
type OpenconfigLldp_Lldp_State_Counters struct {
	EntriesAgedOut	*uint64	`path:"entries-aged-out" module:"openconfig-lldp"`
	FrameDiscard	*uint64	`path:"frame-discard" module:"openconfig-lldp"`
	FrameErrorIn	*uint64	`path:"frame-error-in" module:"openconfig-lldp"`
	FrameIn	*uint64	`path:"frame-in" module:"openconfig-lldp"`
	FrameOut	*uint64	`path:"frame-out" module:"openconfig-lldp"`
	LastClear	*string	`path:"last-clear" module:"openconfig-lldp"`
	TlvAccepted	*uint64	`path:"tlv-accepted" module:"openconfig-lldp"`
	TlvDiscard	*uint64	`path:"tlv-discard" module:"openconfig-lldp"`
	TlvUnknown	*uint64	`path:"tlv-unknown" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components represents the /openconfig-platform/components YANG schema element.
type OpenconfigPlatform_Components struct {
	Component	map[string]*OpenconfigPlatform_Components_Component	`path:"component" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components) IsYANGGoStruct() {}

// NewComponent creates a new entry in the Component list of the
// OpenconfigPlatform_Components struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigPlatform_Components) NewComponent(Name string) (*OpenconfigPlatform_Components_Component, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Component == nil {
		t.Component = make(map[string]*OpenconfigPlatform_Components_Component)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Component[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Component", key)
	}

	t.Component[key] = &OpenconfigPlatform_Components_Component{
		Name: &Name,
	}

	return t.Component[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component represents the /openconfig-platform/components/component YANG schema element.
type OpenconfigPlatform_Components_Component struct {
	Backplane	*OpenconfigPlatform_Components_Component_Backplane	`path:"backplane" module:"openconfig-platform"`
	Chassis	*OpenconfigPlatform_Components_Component_Chassis	`path:"chassis" module:"openconfig-platform"`
	Config	*OpenconfigPlatform_Components_Component_Config	`path:"config" module:"openconfig-platform"`
	Cpu	*OpenconfigPlatform_Components_Component_Cpu	`path:"cpu" module:"openconfig-platform"`
	Fabric	*OpenconfigPlatform_Components_Component_Fabric	`path:"fabric" module:"openconfig-platform"`
	Fan	*OpenconfigPlatform_Components_Component_Fan	`path:"fan" module:"openconfig-platform"`
	IntegratedCircuit	*OpenconfigPlatform_Components_Component_IntegratedCircuit	`path:"integrated-circuit" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	OpticalChannel	*OpenconfigPlatform_Components_Component_OpticalChannel	`path:"optical-channel" module:"openconfig-terminal-device"`
	Port	*OpenconfigPlatform_Components_Component_Port	`path:"port" module:"openconfig-platform"`
	PowerSupply	*OpenconfigPlatform_Components_Component_PowerSupply	`path:"power-supply" module:"openconfig-platform"`
	Properties	*OpenconfigPlatform_Components_Component_Properties	`path:"properties" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_State	`path:"state" module:"openconfig-platform"`
	Storage	*OpenconfigPlatform_Components_Component_Storage	`path:"storage" module:"openconfig-platform"`
	Subcomponents	*OpenconfigPlatform_Components_Component_Subcomponents	`path:"subcomponents" module:"openconfig-platform"`
	Transceiver	*OpenconfigPlatform_Components_Component_Transceiver	`path:"transceiver" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigPlatform_Components_Component struct, which is a YANG list entry.
func (t *OpenconfigPlatform_Components_Component) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Backplane represents the /openconfig-platform/components/component/backplane YANG schema element.
type OpenconfigPlatform_Components_Component_Backplane struct {
	Config	*OpenconfigPlatform_Components_Component_Backplane_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Backplane_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Backplane implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Backplane) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Backplane"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Backplane) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Backplane_Config represents the /openconfig-platform/components/component/backplane/config YANG schema element.
type OpenconfigPlatform_Components_Component_Backplane_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Backplane_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Backplane_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Backplane_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Backplane_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Backplane_State represents the /openconfig-platform/components/component/backplane/state YANG schema element.
type OpenconfigPlatform_Components_Component_Backplane_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Backplane_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Backplane_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Backplane_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Backplane_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Chassis represents the /openconfig-platform/components/component/chassis YANG schema element.
type OpenconfigPlatform_Components_Component_Chassis struct {
	Config	*OpenconfigPlatform_Components_Component_Chassis_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Chassis_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Chassis implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Chassis) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Chassis"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Chassis) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Chassis_Config represents the /openconfig-platform/components/component/chassis/config YANG schema element.
type OpenconfigPlatform_Components_Component_Chassis_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Chassis_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Chassis_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Chassis_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Chassis_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Chassis_State represents the /openconfig-platform/components/component/chassis/state YANG schema element.
type OpenconfigPlatform_Components_Component_Chassis_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Chassis_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Chassis_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Chassis_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Chassis_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Config represents the /openconfig-platform/components/component/config YANG schema element.
type OpenconfigPlatform_Components_Component_Config struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Cpu represents the /openconfig-platform/components/component/cpu YANG schema element.
type OpenconfigPlatform_Components_Component_Cpu struct {
	Config	*OpenconfigPlatform_Components_Component_Cpu_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Cpu_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Cpu implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Cpu) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Cpu"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Cpu) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Cpu_Config represents the /openconfig-platform/components/component/cpu/config YANG schema element.
type OpenconfigPlatform_Components_Component_Cpu_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Cpu_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Cpu_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Cpu_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Cpu_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Cpu_State represents the /openconfig-platform/components/component/cpu/state YANG schema element.
type OpenconfigPlatform_Components_Component_Cpu_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Cpu_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Cpu_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Cpu_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Cpu_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Fabric represents the /openconfig-platform/components/component/fabric YANG schema element.
type OpenconfigPlatform_Components_Component_Fabric struct {
	Config	*OpenconfigPlatform_Components_Component_Fabric_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Fabric_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fabric implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fabric) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fabric"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fabric) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Fabric_Config represents the /openconfig-platform/components/component/fabric/config YANG schema element.
type OpenconfigPlatform_Components_Component_Fabric_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fabric_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fabric_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fabric_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fabric_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Fabric_State represents the /openconfig-platform/components/component/fabric/state YANG schema element.
type OpenconfigPlatform_Components_Component_Fabric_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fabric_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fabric_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fabric_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fabric_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Fan represents the /openconfig-platform/components/component/fan YANG schema element.
type OpenconfigPlatform_Components_Component_Fan struct {
	Config	*OpenconfigPlatform_Components_Component_Fan_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Fan_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Fan_Config represents the /openconfig-platform/components/component/fan/config YANG schema element.
type OpenconfigPlatform_Components_Component_Fan_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Fan_State represents the /openconfig-platform/components/component/fan/state YANG schema element.
type OpenconfigPlatform_Components_Component_Fan_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_IntegratedCircuit represents the /openconfig-platform/components/component/integrated-circuit YANG schema element.
type OpenconfigPlatform_Components_Component_IntegratedCircuit struct {
	Config	*OpenconfigPlatform_Components_Component_IntegratedCircuit_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_IntegratedCircuit_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_IntegratedCircuit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_IntegratedCircuit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_IntegratedCircuit_Config represents the /openconfig-platform/components/component/integrated-circuit/config YANG schema element.
type OpenconfigPlatform_Components_Component_IntegratedCircuit_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_IntegratedCircuit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_IntegratedCircuit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_IntegratedCircuit_State represents the /openconfig-platform/components/component/integrated-circuit/state YANG schema element.
type OpenconfigPlatform_Components_Component_IntegratedCircuit_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_IntegratedCircuit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_IntegratedCircuit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_OpticalChannel represents the /openconfig-platform/components/component/optical-channel YANG schema element.
type OpenconfigPlatform_Components_Component_OpticalChannel struct {
	Config	*OpenconfigPlatform_Components_Component_OpticalChannel_Config	`path:"config" module:"openconfig-terminal-device"`
	State	*OpenconfigPlatform_Components_Component_OpticalChannel_State	`path:"state" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_OpticalChannel implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_OpticalChannel) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_OpticalChannel"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_OpticalChannel_Config represents the /openconfig-platform/components/component/optical-channel/config YANG schema element.
type OpenconfigPlatform_Components_Component_OpticalChannel_Config struct {
	Frequency	*uint64	`path:"frequency" module:"openconfig-terminal-device"`
	LinePort	*string	`path:"line-port" module:"openconfig-terminal-device"`
	OperationalMode	*uint16	`path:"operational-mode" module:"openconfig-terminal-device"`
	TargetOutputPower	*float64	`path:"target-output-power" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_OpticalChannel_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_OpticalChannel_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_OpticalChannel_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_OpticalChannel_State represents the /openconfig-platform/components/component/optical-channel/state YANG schema element.
type OpenconfigPlatform_Components_Component_OpticalChannel_State struct {
	ChromaticDispersion	*OpenconfigPlatform_Components_Component_OpticalChannel_State_ChromaticDispersion	`path:"chromatic-dispersion" module:"openconfig-terminal-device"`
	Frequency	*uint64	`path:"frequency" module:"openconfig-terminal-device"`
	GroupId	*uint32	`path:"group-id" module:"openconfig-terminal-device"`
	InputPower	*OpenconfigPlatform_Components_Component_OpticalChannel_State_InputPower	`path:"input-power" module:"openconfig-terminal-device"`
	LaserBiasCurrent	*OpenconfigPlatform_Components_Component_OpticalChannel_State_LaserBiasCurrent	`path:"laser-bias-current" module:"openconfig-terminal-device"`
	LinePort	*string	`path:"line-port" module:"openconfig-terminal-device"`
	OperationalMode	*uint16	`path:"operational-mode" module:"openconfig-terminal-device"`
	OutputPower	*OpenconfigPlatform_Components_Component_OpticalChannel_State_OutputPower	`path:"output-power" module:"openconfig-terminal-device"`
	PolarizationDependentLoss	*OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationDependentLoss	`path:"polarization-dependent-loss" module:"openconfig-terminal-device"`
	PolarizationModeDispersion	*OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationModeDispersion	`path:"polarization-mode-dispersion" module:"openconfig-terminal-device"`
	SecondOrderPolarizationModeDispersion	*OpenconfigPlatform_Components_Component_OpticalChannel_State_SecondOrderPolarizationModeDispersion	`path:"second-order-polarization-mode-dispersion" module:"openconfig-terminal-device"`
	TargetOutputPower	*float64	`path:"target-output-power" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_OpticalChannel_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_OpticalChannel_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_OpticalChannel_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_OpticalChannel_State_ChromaticDispersion represents the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion YANG schema element.
type OpenconfigPlatform_Components_Component_OpticalChannel_State_ChromaticDispersion struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_OpticalChannel_State_ChromaticDispersion implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_OpticalChannel_State_ChromaticDispersion) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_ChromaticDispersion) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_OpticalChannel_State_ChromaticDispersion"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_ChromaticDispersion) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_OpticalChannel_State_InputPower represents the /openconfig-platform/components/component/optical-channel/state/input-power YANG schema element.
type OpenconfigPlatform_Components_Component_OpticalChannel_State_InputPower struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_OpticalChannel_State_InputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_OpticalChannel_State_InputPower) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_InputPower) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_OpticalChannel_State_InputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_InputPower) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_OpticalChannel_State_LaserBiasCurrent represents the /openconfig-platform/components/component/optical-channel/state/laser-bias-current YANG schema element.
type OpenconfigPlatform_Components_Component_OpticalChannel_State_LaserBiasCurrent struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_OpticalChannel_State_LaserBiasCurrent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_OpticalChannel_State_LaserBiasCurrent) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_LaserBiasCurrent) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_OpticalChannel_State_LaserBiasCurrent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_LaserBiasCurrent) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_OpticalChannel_State_OutputPower represents the /openconfig-platform/components/component/optical-channel/state/output-power YANG schema element.
type OpenconfigPlatform_Components_Component_OpticalChannel_State_OutputPower struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_OpticalChannel_State_OutputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_OpticalChannel_State_OutputPower) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_OutputPower) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_OpticalChannel_State_OutputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_OutputPower) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationDependentLoss represents the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss YANG schema element.
type OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationDependentLoss struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationDependentLoss implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationDependentLoss) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationDependentLoss) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationDependentLoss"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationDependentLoss) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationModeDispersion represents the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion YANG schema element.
type OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationModeDispersion struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationModeDispersion implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationModeDispersion) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationModeDispersion) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationModeDispersion"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_PolarizationModeDispersion) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_OpticalChannel_State_SecondOrderPolarizationModeDispersion represents the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion YANG schema element.
type OpenconfigPlatform_Components_Component_OpticalChannel_State_SecondOrderPolarizationModeDispersion struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_OpticalChannel_State_SecondOrderPolarizationModeDispersion implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_OpticalChannel_State_SecondOrderPolarizationModeDispersion) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_SecondOrderPolarizationModeDispersion) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_OpticalChannel_State_SecondOrderPolarizationModeDispersion"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_OpticalChannel_State_SecondOrderPolarizationModeDispersion) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Port represents the /openconfig-platform/components/component/port YANG schema element.
type OpenconfigPlatform_Components_Component_Port struct {
	BreakoutMode	*OpenconfigPlatform_Components_Component_Port_BreakoutMode	`path:"breakout-mode" module:"openconfig-platform-port"`
	Config	*OpenconfigPlatform_Components_Component_Port_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Port_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Port_BreakoutMode represents the /openconfig-platform/components/component/port/breakout-mode YANG schema element.
type OpenconfigPlatform_Components_Component_Port_BreakoutMode struct {
	Config	*OpenconfigPlatform_Components_Component_Port_BreakoutMode_Config	`path:"config" module:"openconfig-platform-port"`
	State	*OpenconfigPlatform_Components_Component_Port_BreakoutMode_State	`path:"state" module:"openconfig-platform-port"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port_BreakoutMode implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port_BreakoutMode) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_BreakoutMode) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port_BreakoutMode"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port_BreakoutMode) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Port_BreakoutMode_Config represents the /openconfig-platform/components/component/port/breakout-mode/config YANG schema element.
type OpenconfigPlatform_Components_Component_Port_BreakoutMode_Config struct {
	ChannelSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"channel-speed" module:"openconfig-platform-port"`
	NumChannels	*uint8	`path:"num-channels" module:"openconfig-platform-port"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port_BreakoutMode_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port_BreakoutMode_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_BreakoutMode_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port_BreakoutMode_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port_BreakoutMode_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Port_BreakoutMode_State represents the /openconfig-platform/components/component/port/breakout-mode/state YANG schema element.
type OpenconfigPlatform_Components_Component_Port_BreakoutMode_State struct {
	ChannelSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"channel-speed" module:"openconfig-platform-port"`
	NumChannels	*uint8	`path:"num-channels" module:"openconfig-platform-port"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port_BreakoutMode_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port_BreakoutMode_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_BreakoutMode_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port_BreakoutMode_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port_BreakoutMode_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Port_Config represents the /openconfig-platform/components/component/port/config YANG schema element.
type OpenconfigPlatform_Components_Component_Port_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Port_State represents the /openconfig-platform/components/component/port/state YANG schema element.
type OpenconfigPlatform_Components_Component_Port_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_PowerSupply represents the /openconfig-platform/components/component/power-supply YANG schema element.
type OpenconfigPlatform_Components_Component_PowerSupply struct {
	Config	*OpenconfigPlatform_Components_Component_PowerSupply_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_PowerSupply_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_PowerSupply implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_PowerSupply) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_PowerSupply"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_PowerSupply) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_PowerSupply_Config represents the /openconfig-platform/components/component/power-supply/config YANG schema element.
type OpenconfigPlatform_Components_Component_PowerSupply_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_PowerSupply_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_PowerSupply_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_PowerSupply_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_PowerSupply_State represents the /openconfig-platform/components/component/power-supply/state YANG schema element.
type OpenconfigPlatform_Components_Component_PowerSupply_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_PowerSupply_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_PowerSupply_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_PowerSupply_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Properties represents the /openconfig-platform/components/component/properties YANG schema element.
type OpenconfigPlatform_Components_Component_Properties struct {
	Property	map[string]*OpenconfigPlatform_Components_Component_Properties_Property	`path:"property" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties) IsYANGGoStruct() {}

// NewProperty creates a new entry in the Property list of the
// OpenconfigPlatform_Components_Component_Properties struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigPlatform_Components_Component_Properties) NewProperty(Name string) (*OpenconfigPlatform_Components_Component_Properties_Property, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Property == nil {
		t.Property = make(map[string]*OpenconfigPlatform_Components_Component_Properties_Property)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Property[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Property", key)
	}

	t.Property[key] = &OpenconfigPlatform_Components_Component_Properties_Property{
		Name: &Name,
	}

	return t.Property[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Properties_Property represents the /openconfig-platform/components/component/properties/property YANG schema element.
type OpenconfigPlatform_Components_Component_Properties_Property struct {
	Config	*OpenconfigPlatform_Components_Component_Properties_Property_Config	`path:"config" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Properties_Property_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties_Property implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties_Property) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigPlatform_Components_Component_Properties_Property struct, which is a YANG list entry.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties_Property"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Properties_Property_Config represents the /openconfig-platform/components/component/properties/property/config YANG schema element.
type OpenconfigPlatform_Components_Component_Properties_Property_Config struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
	Value	OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union	`path:"value" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties_Property_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/properties/property/config/value within the YANG schema.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface {
	Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union()
}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a bool value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool struct {
	Bool	bool
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a float64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64 struct {
	Float64	float64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a int64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64 struct {
	Int64	int64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a string value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String struct {
	String	string
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a uint64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64 struct {
	Uint64	uint64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// To_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) To_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union(i interface{}) (OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union, error) {
	switch v := i.(type) {
	case bool:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool{v}, nil
	case float64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64{v}, nil
	case int64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64{v}, nil
	case string:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String{v}, nil
	case uint64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union, unknown union type, got: %T, want any of [bool, float64, int64, string, uint64]", i, i)
	}
}


// OpenconfigPlatform_Components_Component_Properties_Property_State represents the /openconfig-platform/components/component/properties/property/state YANG schema element.
type OpenconfigPlatform_Components_Component_Properties_Property_State struct {
	Configurable	*bool	`path:"configurable" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	Value	OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union	`path:"value" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties_Property_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties_Property_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/properties/property/state/value within the YANG schema.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface {
	Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union()
}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a bool value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool struct {
	Bool	bool
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64 is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a float64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64 struct {
	Float64	float64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64 is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a int64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64 struct {
	Int64	int64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a string value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String struct {
	String	string
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64 is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a uint64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64 struct {
	Uint64	uint64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// To_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) To_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union(i interface{}) (OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union, error) {
	switch v := i.(type) {
	case bool:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool{v}, nil
	case float64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64{v}, nil
	case int64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64{v}, nil
	case string:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String{v}, nil
	case uint64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union, unknown union type, got: %T, want any of [bool, float64, int64, string, uint64]", i, i)
	}
}


// OpenconfigPlatform_Components_Component_State represents the /openconfig-platform/components/component/state YANG schema element.
type OpenconfigPlatform_Components_Component_State struct {
	AllocatedPower	*uint32	`path:"allocated-power" module:"openconfig-platform"`
	Description	*string	`path:"description" module:"openconfig-platform"`
	Empty	*bool	`path:"empty" module:"openconfig-platform"`
	FirmwareVersion	*string	`path:"firmware-version" module:"openconfig-platform"`
	HardwareVersion	*string	`path:"hardware-version" module:"openconfig-platform"`
	Id	*string	`path:"id" module:"openconfig-platform"`
	Location	*string	`path:"location" module:"openconfig-platform"`
	Memory	*OpenconfigPlatform_Components_Component_State_Memory	`path:"memory" module:"openconfig-platform"`
	MfgDate	*string	`path:"mfg-date" module:"openconfig-platform"`
	MfgName	*string	`path:"mfg-name" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	OperStatus	E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS	`path:"oper-status" module:"openconfig-platform"`
	Parent	*string	`path:"parent" module:"openconfig-platform"`
	PartNo	*string	`path:"part-no" module:"openconfig-platform"`
	Removable	*bool	`path:"removable" module:"openconfig-platform"`
	SerialNo	*string	`path:"serial-no" module:"openconfig-platform"`
	SoftwareVersion	*string	`path:"software-version" module:"openconfig-platform"`
	Temperature	*OpenconfigPlatform_Components_Component_State_Temperature	`path:"temperature" module:"openconfig-platform"`
	Type	OpenconfigPlatform_Components_Component_State_Type_Union	`path:"type" module:"openconfig-platform"`
	UsedPower	*uint32	`path:"used-power" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigPlatform_Components_Component_State_Type_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/state/type within the YANG schema.
type OpenconfigPlatform_Components_Component_State_Type_Union interface {
	Is_OpenconfigPlatform_Components_Component_State_Type_Union()
}

// OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT is used when /openconfig-platform/components/component/state/type
// is to be set to a E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT value.
type OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT struct {
	E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT	E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
}

// Is_OpenconfigPlatform_Components_Component_State_Type_Union ensures that OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
// implements the OpenconfigPlatform_Components_Component_State_Type_Union interface.
func (*OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) Is_OpenconfigPlatform_Components_Component_State_Type_Union() {}

// OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT is used when /openconfig-platform/components/component/state/type
// is to be set to a E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT value.
type OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT struct {
	E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT	E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
}

// Is_OpenconfigPlatform_Components_Component_State_Type_Union ensures that OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
// implements the OpenconfigPlatform_Components_Component_State_Type_Union interface.
func (*OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) Is_OpenconfigPlatform_Components_Component_State_Type_Union() {}

// To_OpenconfigPlatform_Components_Component_State_Type_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigPlatform_Components_Component_State_Type_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigPlatform_Components_Component_State) To_OpenconfigPlatform_Components_Component_State_Type_Union(i interface{}) (OpenconfigPlatform_Components_Component_State_Type_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT:
		return &OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT{v}, nil
	case E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT:
		return &OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigPlatform_Components_Component_State_Type_Union, unknown union type, got: %T, want any of [E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT, E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT]", i, i)
	}
}


// OpenconfigPlatform_Components_Component_State_Memory represents the /openconfig-platform/components/component/state/memory YANG schema element.
type OpenconfigPlatform_Components_Component_State_Memory struct {
	Available	*uint64	`path:"available" module:"openconfig-platform"`
	Utilized	*uint64	`path:"utilized" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Memory implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Memory) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Memory) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Memory"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Memory) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_State_Temperature represents the /openconfig-platform/components/component/state/temperature YANG schema element.
type OpenconfigPlatform_Components_Component_State_Temperature struct {
	AlarmSeverity	E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY	`path:"alarm-severity" module:"openconfig-platform"`
	AlarmStatus	*bool	`path:"alarm-status" module:"openconfig-platform"`
	AlarmThreshold	*uint32	`path:"alarm-threshold" module:"openconfig-platform"`
	Avg	*float64	`path:"avg" module:"openconfig-platform"`
	Instant	*float64	`path:"instant" module:"openconfig-platform"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform"`
	Max	*float64	`path:"max" module:"openconfig-platform"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform"`
	Min	*float64	`path:"min" module:"openconfig-platform"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Temperature implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Temperature) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Temperature) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Temperature"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Temperature) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Storage represents the /openconfig-platform/components/component/storage YANG schema element.
type OpenconfigPlatform_Components_Component_Storage struct {
	Config	*OpenconfigPlatform_Components_Component_Storage_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Storage_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Storage implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Storage) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Storage"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Storage) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Storage_Config represents the /openconfig-platform/components/component/storage/config YANG schema element.
type OpenconfigPlatform_Components_Component_Storage_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Storage_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Storage_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Storage_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Storage_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Storage_State represents the /openconfig-platform/components/component/storage/state YANG schema element.
type OpenconfigPlatform_Components_Component_Storage_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Storage_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Storage_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Storage_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Storage_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Subcomponents represents the /openconfig-platform/components/component/subcomponents YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents struct {
	Subcomponent	map[string]*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent	`path:"subcomponent" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents) IsYANGGoStruct() {}

// NewSubcomponent creates a new entry in the Subcomponent list of the
// OpenconfigPlatform_Components_Component_Subcomponents struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) NewSubcomponent(Name string) (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subcomponent == nil {
		t.Subcomponent = make(map[string]*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Subcomponent[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Subcomponent", key)
	}

	t.Subcomponent[key] = &OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent{
		Name: &Name,
	}

	return t.Subcomponent[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent represents the /openconfig-platform/components/component/subcomponents/subcomponent YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent struct {
	Config	*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config	`path:"config" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent struct, which is a YANG list entry.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config represents the /openconfig-platform/components/component/subcomponents/subcomponent/config YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State represents the /openconfig-platform/components/component/subcomponents/subcomponent/state YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver represents the /openconfig-platform/components/component/transceiver YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver struct {
	Config	*OpenconfigPlatform_Components_Component_Transceiver_Config	`path:"config" module:"openconfig-platform-transceiver"`
	PhysicalChannels	*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels	`path:"physical-channels" module:"openconfig-platform-transceiver"`
	State	*OpenconfigPlatform_Components_Component_Transceiver_State	`path:"state" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_Config represents the /openconfig-platform/components/component/transceiver/config YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-platform-transceiver"`
	EthernetPmdPreconf	E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE	`path:"ethernet-pmd-preconf" module:"openconfig-platform-transceiver"`
	FecMode	E_OpenconfigPlatformTypes_FEC_MODE_TYPE	`path:"fec-mode" module:"openconfig-platform-transceiver"`
	FormFactorPreconf	E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE	`path:"form-factor-preconf" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels represents the /openconfig-platform/components/component/transceiver/physical-channels YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels struct {
	Channel	map[uint16]*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel	`path:"channel" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels) IsYANGGoStruct() {}

// NewChannel creates a new entry in the Channel list of the
// OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels) NewChannel(Index uint16) (*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Channel == nil {
		t.Channel = make(map[uint16]*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Channel[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Channel", key)
	}

	t.Channel[key] = &OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel{
		Index: &Index,
	}

	return t.Channel[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel represents the /openconfig-platform/components/component/transceiver/physical-channels/channel YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel struct {
	Config	*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_Config	`path:"config" module:"openconfig-platform-transceiver"`
	Index	*uint16	`path:"index" module:"openconfig-platform-transceiver"`
	State	*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State	`path:"state" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel struct, which is a YANG list entry.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_Config represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/config YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_Config struct {
	Description	*string	`path:"description" module:"openconfig-platform-transceiver"`
	Index	*uint16	`path:"index" module:"openconfig-platform-transceiver"`
	TargetOutputPower	*float64	`path:"target-output-power" module:"openconfig-platform-transceiver"`
	TxLaser	*bool	`path:"tx-laser" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/state YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State struct {
	Description	*string	`path:"description" module:"openconfig-platform-transceiver"`
	Index	*uint16	`path:"index" module:"openconfig-platform-transceiver"`
	InputPower	*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_InputPower	`path:"input-power" module:"openconfig-platform-transceiver"`
	LaserBiasCurrent	*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_LaserBiasCurrent	`path:"laser-bias-current" module:"openconfig-platform-transceiver"`
	OutputFrequency	*uint64	`path:"output-frequency" module:"openconfig-platform-transceiver"`
	OutputPower	*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_OutputPower	`path:"output-power" module:"openconfig-platform-transceiver"`
	TargetOutputPower	*float64	`path:"target-output-power" module:"openconfig-platform-transceiver"`
	TxLaser	*bool	`path:"tx-laser" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_InputPower represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/state/input-power YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_InputPower struct {
	Avg	*float64	`path:"avg" module:"openconfig-platform-transceiver"`
	Instant	*float64	`path:"instant" module:"openconfig-platform-transceiver"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform-transceiver"`
	Max	*float64	`path:"max" module:"openconfig-platform-transceiver"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform-transceiver"`
	Min	*float64	`path:"min" module:"openconfig-platform-transceiver"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_InputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_InputPower) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_InputPower) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_InputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_InputPower) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_LaserBiasCurrent represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/state/laser-bias-current YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_LaserBiasCurrent struct {
	Avg	*float64	`path:"avg" module:"openconfig-platform-transceiver"`
	Instant	*float64	`path:"instant" module:"openconfig-platform-transceiver"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform-transceiver"`
	Max	*float64	`path:"max" module:"openconfig-platform-transceiver"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform-transceiver"`
	Min	*float64	`path:"min" module:"openconfig-platform-transceiver"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_LaserBiasCurrent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_LaserBiasCurrent) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_LaserBiasCurrent) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_LaserBiasCurrent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_LaserBiasCurrent) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_OutputPower represents the /openconfig-platform/components/component/transceiver/physical-channels/channel/state/output-power YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_OutputPower struct {
	Avg	*float64	`path:"avg" module:"openconfig-platform-transceiver"`
	Instant	*float64	`path:"instant" module:"openconfig-platform-transceiver"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform-transceiver"`
	Max	*float64	`path:"max" module:"openconfig-platform-transceiver"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform-transceiver"`
	Min	*float64	`path:"min" module:"openconfig-platform-transceiver"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_OutputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_OutputPower) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_OutputPower) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_OutputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_PhysicalChannels_Channel_State_OutputPower) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_State represents the /openconfig-platform/components/component/transceiver/state YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_State struct {
	ConnectorType	E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE	`path:"connector-type" module:"openconfig-platform-transceiver"`
	DateCode	*string	`path:"date-code" module:"openconfig-platform-transceiver"`
	Enabled	*bool	`path:"enabled" module:"openconfig-platform-transceiver"`
	EthernetPmd	E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE	`path:"ethernet-pmd" module:"openconfig-platform-transceiver"`
	EthernetPmdPreconf	E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE	`path:"ethernet-pmd-preconf" module:"openconfig-platform-transceiver"`
	FaultCondition	*bool	`path:"fault-condition" module:"openconfig-platform-transceiver"`
	FecCorrectedBits	*uint64	`path:"fec-corrected-bits" module:"openconfig-platform-transceiver"`
	FecCorrectedBytes	*uint64	`path:"fec-corrected-bytes" module:"openconfig-platform-transceiver"`
	FecMode	E_OpenconfigPlatformTypes_FEC_MODE_TYPE	`path:"fec-mode" module:"openconfig-platform-transceiver"`
	FecStatus	E_OpenconfigPlatformTypes_FEC_STATUS_TYPE	`path:"fec-status" module:"openconfig-platform-transceiver"`
	FecUncorrectableBlocks	*uint64	`path:"fec-uncorrectable-blocks" module:"openconfig-platform-transceiver"`
	FecUncorrectableWords	*uint64	`path:"fec-uncorrectable-words" module:"openconfig-platform-transceiver"`
	FormFactor	E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE	`path:"form-factor" module:"openconfig-platform-transceiver"`
	FormFactorPreconf	E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE	`path:"form-factor-preconf" module:"openconfig-platform-transceiver"`
	InputPower	*OpenconfigPlatform_Components_Component_Transceiver_State_InputPower	`path:"input-power" module:"openconfig-platform-transceiver"`
	LaserBiasCurrent	*OpenconfigPlatform_Components_Component_Transceiver_State_LaserBiasCurrent	`path:"laser-bias-current" module:"openconfig-platform-transceiver"`
	OtnComplianceCode	E_OpenconfigTransportTypes_OTN_APPLICATION_CODE	`path:"otn-compliance-code" module:"openconfig-platform-transceiver"`
	OutputPower	*OpenconfigPlatform_Components_Component_Transceiver_State_OutputPower	`path:"output-power" module:"openconfig-platform-transceiver"`
	PostFecBer	*OpenconfigPlatform_Components_Component_Transceiver_State_PostFecBer	`path:"post-fec-ber" module:"openconfig-platform-transceiver"`
	PreFecBer	*OpenconfigPlatform_Components_Component_Transceiver_State_PreFecBer	`path:"pre-fec-ber" module:"openconfig-platform-transceiver"`
	Present	E_OpenconfigPlatform_Components_Component_Transceiver_State_Present	`path:"present" module:"openconfig-platform-transceiver"`
	SerialNo	*string	`path:"serial-no" module:"openconfig-platform-transceiver"`
	SonetSdhComplianceCode	E_OpenconfigTransportTypes_SONET_APPLICATION_CODE	`path:"sonet-sdh-compliance-code" module:"openconfig-platform-transceiver"`
	Vendor	*string	`path:"vendor" module:"openconfig-platform-transceiver"`
	VendorPart	*string	`path:"vendor-part" module:"openconfig-platform-transceiver"`
	VendorRev	*string	`path:"vendor-rev" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_State_InputPower represents the /openconfig-platform/components/component/transceiver/state/input-power YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_State_InputPower struct {
	Avg	*float64	`path:"avg" module:"openconfig-platform-transceiver"`
	Instant	*float64	`path:"instant" module:"openconfig-platform-transceiver"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform-transceiver"`
	Max	*float64	`path:"max" module:"openconfig-platform-transceiver"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform-transceiver"`
	Min	*float64	`path:"min" module:"openconfig-platform-transceiver"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_State_InputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_State_InputPower) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State_InputPower) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_State_InputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State_InputPower) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_State_LaserBiasCurrent represents the /openconfig-platform/components/component/transceiver/state/laser-bias-current YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_State_LaserBiasCurrent struct {
	Avg	*float64	`path:"avg" module:"openconfig-platform-transceiver"`
	Instant	*float64	`path:"instant" module:"openconfig-platform-transceiver"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform-transceiver"`
	Max	*float64	`path:"max" module:"openconfig-platform-transceiver"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform-transceiver"`
	Min	*float64	`path:"min" module:"openconfig-platform-transceiver"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_State_LaserBiasCurrent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_State_LaserBiasCurrent) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State_LaserBiasCurrent) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_State_LaserBiasCurrent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State_LaserBiasCurrent) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_State_OutputPower represents the /openconfig-platform/components/component/transceiver/state/output-power YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_State_OutputPower struct {
	Avg	*float64	`path:"avg" module:"openconfig-platform-transceiver"`
	Instant	*float64	`path:"instant" module:"openconfig-platform-transceiver"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform-transceiver"`
	Max	*float64	`path:"max" module:"openconfig-platform-transceiver"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform-transceiver"`
	Min	*float64	`path:"min" module:"openconfig-platform-transceiver"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_State_OutputPower implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_State_OutputPower) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State_OutputPower) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_State_OutputPower"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State_OutputPower) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_State_PostFecBer represents the /openconfig-platform/components/component/transceiver/state/post-fec-ber YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_State_PostFecBer struct {
	Avg	*float64	`path:"avg" module:"openconfig-platform-transceiver"`
	Instant	*float64	`path:"instant" module:"openconfig-platform-transceiver"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform-transceiver"`
	Max	*float64	`path:"max" module:"openconfig-platform-transceiver"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform-transceiver"`
	Min	*float64	`path:"min" module:"openconfig-platform-transceiver"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_State_PostFecBer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_State_PostFecBer) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State_PostFecBer) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_State_PostFecBer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State_PostFecBer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigPlatform_Components_Component_Transceiver_State_PreFecBer represents the /openconfig-platform/components/component/transceiver/state/pre-fec-ber YANG schema element.
type OpenconfigPlatform_Components_Component_Transceiver_State_PreFecBer struct {
	Avg	*float64	`path:"avg" module:"openconfig-platform-transceiver"`
	Instant	*float64	`path:"instant" module:"openconfig-platform-transceiver"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform-transceiver"`
	Max	*float64	`path:"max" module:"openconfig-platform-transceiver"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform-transceiver"`
	Min	*float64	`path:"min" module:"openconfig-platform-transceiver"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform-transceiver"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Transceiver_State_PreFecBer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Transceiver_State_PreFecBer) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State_PreFecBer) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Transceiver_State_PreFecBer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Transceiver_State_PreFecBer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice represents the /openconfig-terminal-device/terminal-device YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice struct {
	Config	*OpenconfigTerminalDevice_TerminalDevice_Config	`path:"config" module:"openconfig-terminal-device"`
	LogicalChannels	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels	`path:"logical-channels" module:"openconfig-terminal-device"`
	OperationalModes	*OpenconfigTerminalDevice_TerminalDevice_OperationalModes	`path:"operational-modes" module:"openconfig-terminal-device"`
	State	*OpenconfigTerminalDevice_TerminalDevice_State	`path:"state" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_Config represents the /openconfig-terminal-device/terminal-device/config YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels represents the /openconfig-terminal-device/terminal-device/logical-channels YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels struct {
	Channel	map[uint32]*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel	`path:"channel" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels) IsYANGGoStruct() {}

// NewChannel creates a new entry in the Channel list of the
// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels) NewChannel(Index uint32) (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Channel == nil {
		t.Channel = make(map[uint32]*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Channel[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Channel", key)
	}

	t.Channel[key] = &OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel{
		Index: &Index,
	}

	return t.Channel[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel represents the /openconfig-terminal-device/terminal-device/logical-channels/channel YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel struct {
	Config	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Config	`path:"config" module:"openconfig-terminal-device"`
	Ethernet	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet	`path:"ethernet" module:"openconfig-terminal-device"`
	Index	*uint32	`path:"index" module:"openconfig-terminal-device"`
	Ingress	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress	`path:"ingress" module:"openconfig-terminal-device"`
	LogicalChannelAssignments	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments	`path:"logical-channel-assignments" module:"openconfig-terminal-device"`
	Otn	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn	`path:"otn" module:"openconfig-terminal-device"`
	State	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State	`path:"state" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel struct, which is a YANG list entry.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Config represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/config YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Config struct {
	AdminState	E_OpenconfigTerminalDevice_AdminStateType	`path:"admin-state" module:"openconfig-terminal-device"`
	Description	*string	`path:"description" module:"openconfig-terminal-device"`
	Index	*uint32	`path:"index" module:"openconfig-terminal-device"`
	LogicalChannelType	E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE	`path:"logical-channel-type" module:"openconfig-terminal-device"`
	LoopbackMode	E_OpenconfigTerminalDevice_LoopbackModeType	`path:"loopback-mode" module:"openconfig-terminal-device"`
	RateClass	E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE	`path:"rate-class" module:"openconfig-terminal-device"`
	TestSignal	*bool	`path:"test-signal" module:"openconfig-terminal-device"`
	TribProtocol	E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE	`path:"trib-protocol" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet struct {
	Config	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config	`path:"config" module:"openconfig-terminal-device"`
	Lldp	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp	`path:"lldp" module:"openconfig-terminal-device"`
	State	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_State	`path:"state" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/config YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config struct {
	AlsDelay	*uint32	`path:"als-delay" module:"openconfig-terminal-device"`
	ClientAls	E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls	`path:"client-als" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp struct {
	Config	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Config	`path:"config" module:"openconfig-terminal-device"`
	Neighbors	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors	`path:"neighbors" module:"openconfig-terminal-device"`
	State	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State	`path:"state" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Config represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/config YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-terminal-device"`
	Snooping	*bool	`path:"snooping" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/neighbors YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors struct {
	Neighbor	map[string]*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors) NewNeighbor(Id string) (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor{
		Id: &Id,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor struct {
	Config	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-terminal-device"`
	CustomTlvs	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs	`path:"custom-tlvs" module:"openconfig-terminal-device"`
	Id	*string	`path:"id" module:"openconfig-terminal-device"`
	State	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_State	`path:"state" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_Config represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/config YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/custom-tlvs YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs struct {
	Tlv	map[OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Key]*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv	`path:"tlv" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs) IsYANGGoStruct() {}

// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Key represents the key for list Tlv of element /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/custom-tlvs.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Key struct {
	Type	int32	`path:"type"`
	Oui	string	`path:"oui"`
	OuiSubtype	string	`path:"oui-subtype"`
}

// NewTlv creates a new entry in the Tlv list of the
// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs) NewTlv(Type int32, Oui string, OuiSubtype string) (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Tlv == nil {
		t.Tlv = make(map[OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Key]*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv)
	}

	key := OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Key{
		Type: Type,
		Oui: Oui,
		OuiSubtype: OuiSubtype,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Tlv[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Tlv", key)
	}

	t.Tlv[key] = &OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv{
		Type: &Type,
		Oui: &Oui,
		OuiSubtype: &OuiSubtype,
	}

	return t.Tlv[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/custom-tlvs/tlv YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv struct {
	Config	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Config	`path:"config" module:"openconfig-terminal-device"`
	Oui	*string	`path:"oui" module:"openconfig-terminal-device"`
	OuiSubtype	*string	`path:"oui-subtype" module:"openconfig-terminal-device"`
	State	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_State	`path:"state" module:"openconfig-terminal-device"`
	Type	*int32	`path:"type" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv struct, which is a YANG list entry.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Oui == nil {
		return nil, fmt.Errorf("nil value for key Oui")
	}

	if t.OuiSubtype == nil {
		return nil, fmt.Errorf("nil value for key OuiSubtype")
	}

	if t.Type == nil {
		return nil, fmt.Errorf("nil value for key Type")
	}

	return map[string]interface{}{
		"oui": *t.Oui,
		"oui-subtype": *t.OuiSubtype,
		"type": *t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Config represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/custom-tlvs/tlv/config YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_State represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/custom-tlvs/tlv/state YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_State struct {
	Oui	*string	`path:"oui" module:"openconfig-terminal-device"`
	OuiSubtype	*string	`path:"oui-subtype" module:"openconfig-terminal-device"`
	Type	*int32	`path:"type" module:"openconfig-terminal-device"`
	Value	Binary	`path:"value" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_CustomTlvs_Tlv_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_State represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/state YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_State struct {
	Age	*uint64	`path:"age" module:"openconfig-terminal-device"`
	ChassisId	*string	`path:"chassis-id" module:"openconfig-terminal-device"`
	ChassisIdType	E_OpenconfigLldp_ChassisIdType	`path:"chassis-id-type" module:"openconfig-terminal-device"`
	Id	*string	`path:"id" module:"openconfig-terminal-device"`
	LastUpdate	*int64	`path:"last-update" module:"openconfig-terminal-device"`
	ManagementAddress	*string	`path:"management-address" module:"openconfig-terminal-device"`
	ManagementAddressType	*string	`path:"management-address-type" module:"openconfig-terminal-device"`
	PortDescription	*string	`path:"port-description" module:"openconfig-terminal-device"`
	PortId	*string	`path:"port-id" module:"openconfig-terminal-device"`
	PortIdType	E_OpenconfigLldp_PortIdType	`path:"port-id-type" module:"openconfig-terminal-device"`
	SystemDescription	*string	`path:"system-description" module:"openconfig-terminal-device"`
	SystemName	*string	`path:"system-name" module:"openconfig-terminal-device"`
	Ttl	*uint16	`path:"ttl" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/state YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State struct {
	Counters	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State_Counters	`path:"counters" module:"openconfig-terminal-device"`
	Enabled	*bool	`path:"enabled" module:"openconfig-terminal-device"`
	Snooping	*bool	`path:"snooping" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State_Counters represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/lldp/state/counters YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State_Counters struct {
	FrameDiscard	*uint64	`path:"frame-discard" module:"openconfig-terminal-device"`
	FrameErrorIn	*uint64	`path:"frame-error-in" module:"openconfig-terminal-device"`
	FrameErrorOut	*uint64	`path:"frame-error-out" module:"openconfig-terminal-device"`
	FrameIn	*uint64	`path:"frame-in" module:"openconfig-terminal-device"`
	FrameOut	*uint64	`path:"frame-out" module:"openconfig-terminal-device"`
	LastClear	*string	`path:"last-clear" module:"openconfig-terminal-device"`
	TlvDiscard	*uint64	`path:"tlv-discard" module:"openconfig-terminal-device"`
	TlvUnknown	*uint64	`path:"tlv-unknown" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Lldp_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_State represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ethernet/state YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_State struct {
	AlsDelay	*uint32	`path:"als-delay" module:"openconfig-terminal-device"`
	ClientAls	E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls	`path:"client-als" module:"openconfig-terminal-device"`
	In_8021QFrames	*uint64	`path:"in-8021q-frames" module:"openconfig-terminal-device"`
	InBlockErrors	*uint64	`path:"in-block-errors" module:"openconfig-terminal-device"`
	InCrcErrors	*uint64	`path:"in-crc-errors" module:"openconfig-terminal-device"`
	InFragmentFrames	*uint64	`path:"in-fragment-frames" module:"openconfig-terminal-device"`
	InJabberFrames	*uint64	`path:"in-jabber-frames" module:"openconfig-terminal-device"`
	InMacControlFrames	*uint64	`path:"in-mac-control-frames" module:"openconfig-terminal-device"`
	InMacPauseFrames	*uint64	`path:"in-mac-pause-frames" module:"openconfig-terminal-device"`
	InOversizeFrames	*uint64	`path:"in-oversize-frames" module:"openconfig-terminal-device"`
	InPcsBipErrors	*uint64	`path:"in-pcs-bip-errors" module:"openconfig-terminal-device"`
	InPcsErroredSeconds	*uint64	`path:"in-pcs-errored-seconds" module:"openconfig-terminal-device"`
	InPcsSeverelyErroredSeconds	*uint64	`path:"in-pcs-severely-errored-seconds" module:"openconfig-terminal-device"`
	InPcsUnavailableSeconds	*uint64	`path:"in-pcs-unavailable-seconds" module:"openconfig-terminal-device"`
	InUndersizeFrames	*uint64	`path:"in-undersize-frames" module:"openconfig-terminal-device"`
	Out_8021QFrames	*uint64	`path:"out-8021q-frames" module:"openconfig-terminal-device"`
	OutBlockErrors	*uint64	`path:"out-block-errors" module:"openconfig-terminal-device"`
	OutCrcErrors	*uint64	`path:"out-crc-errors" module:"openconfig-terminal-device"`
	OutMacControlFrames	*uint64	`path:"out-mac-control-frames" module:"openconfig-terminal-device"`
	OutMacPauseFrames	*uint64	`path:"out-mac-pause-frames" module:"openconfig-terminal-device"`
	OutPcsBipErrors	*uint64	`path:"out-pcs-bip-errors" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ingress YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress struct {
	Config	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_Config	`path:"config" module:"openconfig-terminal-device"`
	State	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_State	`path:"state" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_Config represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ingress/config YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_Config struct {
	PhysicalChannel	[]uint16	`path:"physical-channel" module:"openconfig-terminal-device"`
	Transceiver	*string	`path:"transceiver" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_State represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/ingress/state YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_State struct {
	PhysicalChannel	[]uint16	`path:"physical-channel" module:"openconfig-terminal-device"`
	Transceiver	*string	`path:"transceiver" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ingress_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/logical-channel-assignments YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments struct {
	Assignment	map[uint32]*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment	`path:"assignment" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments) IsYANGGoStruct() {}

// NewAssignment creates a new entry in the Assignment list of the
// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments) NewAssignment(Index uint32) (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Assignment == nil {
		t.Assignment = make(map[uint32]*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Assignment[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Assignment", key)
	}

	t.Assignment[key] = &OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment{
		Index: &Index,
	}

	return t.Assignment[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/logical-channel-assignments/assignment YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment struct {
	Config	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config	`path:"config" module:"openconfig-terminal-device"`
	Index	*uint32	`path:"index" module:"openconfig-terminal-device"`
	State	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_State	`path:"state" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment struct, which is a YANG list entry.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/logical-channel-assignments/assignment/config YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config struct {
	Allocation	*float64	`path:"allocation" module:"openconfig-terminal-device"`
	AssignmentType	E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType	`path:"assignment-type" module:"openconfig-terminal-device"`
	Description	*string	`path:"description" module:"openconfig-terminal-device"`
	Index	*uint32	`path:"index" module:"openconfig-terminal-device"`
	LogicalChannel	*uint32	`path:"logical-channel" module:"openconfig-terminal-device"`
	Mapping	E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL	`path:"mapping" module:"openconfig-terminal-device"`
	OpticalChannel	*string	`path:"optical-channel" module:"openconfig-terminal-device"`
	TributarySlotIndex	*int32	`path:"tributary-slot-index" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_State represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/logical-channel-assignments/assignment/state YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_State struct {
	Allocation	*float64	`path:"allocation" module:"openconfig-terminal-device"`
	AssignmentType	E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType	`path:"assignment-type" module:"openconfig-terminal-device"`
	Description	*string	`path:"description" module:"openconfig-terminal-device"`
	Index	*uint32	`path:"index" module:"openconfig-terminal-device"`
	LogicalChannel	*uint32	`path:"logical-channel" module:"openconfig-terminal-device"`
	Mapping	E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL	`path:"mapping" module:"openconfig-terminal-device"`
	OpticalChannel	*string	`path:"optical-channel" module:"openconfig-terminal-device"`
	TributarySlotIndex	*int32	`path:"tributary-slot-index" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/otn YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn struct {
	Config	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_Config	`path:"config" module:"openconfig-terminal-device"`
	State	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State	`path:"state" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_Config represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/otn/config YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_Config struct {
	TributarySlotGranularity	E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY	`path:"tributary-slot-granularity" module:"openconfig-terminal-device"`
	TtiMsgAuto	*bool	`path:"tti-msg-auto" module:"openconfig-terminal-device"`
	TtiMsgExpected	*string	`path:"tti-msg-expected" module:"openconfig-terminal-device"`
	TtiMsgTransmit	*string	`path:"tti-msg-transmit" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/otn/state YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State struct {
	BackgroundBlockErrors	*uint64	`path:"background-block-errors" module:"openconfig-terminal-device"`
	CodeViolations	*uint64	`path:"code-violations" module:"openconfig-terminal-device"`
	ErroredBlocks	*uint64	`path:"errored-blocks" module:"openconfig-terminal-device"`
	ErroredSeconds	*uint64	`path:"errored-seconds" module:"openconfig-terminal-device"`
	Esnr	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_Esnr	`path:"esnr" module:"openconfig-terminal-device"`
	FecCorrectedBits	*uint64	`path:"fec-corrected-bits" module:"openconfig-terminal-device"`
	FecCorrectedBytes	*uint64	`path:"fec-corrected-bytes" module:"openconfig-terminal-device"`
	FecUncorrectableBlocks	*uint64	`path:"fec-uncorrectable-blocks" module:"openconfig-terminal-device"`
	FecUncorrectableWords	*uint64	`path:"fec-uncorrectable-words" module:"openconfig-terminal-device"`
	PostFecBer	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PostFecBer	`path:"post-fec-ber" module:"openconfig-terminal-device"`
	PreFecBer	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PreFecBer	`path:"pre-fec-ber" module:"openconfig-terminal-device"`
	QValue	*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_QValue	`path:"q-value" module:"openconfig-terminal-device"`
	RdiMsg	*string	`path:"rdi-msg" module:"openconfig-terminal-device"`
	SeverelyErroredSeconds	*uint64	`path:"severely-errored-seconds" module:"openconfig-terminal-device"`
	TributarySlotGranularity	E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY	`path:"tributary-slot-granularity" module:"openconfig-terminal-device"`
	TtiMsgAuto	*bool	`path:"tti-msg-auto" module:"openconfig-terminal-device"`
	TtiMsgExpected	*string	`path:"tti-msg-expected" module:"openconfig-terminal-device"`
	TtiMsgRecv	*string	`path:"tti-msg-recv" module:"openconfig-terminal-device"`
	TtiMsgTransmit	*string	`path:"tti-msg-transmit" module:"openconfig-terminal-device"`
	UnavailableSeconds	*uint64	`path:"unavailable-seconds" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_Esnr represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/otn/state/esnr YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_Esnr struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_Esnr implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_Esnr) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_Esnr) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_Esnr"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_Esnr) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PostFecBer represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/otn/state/post-fec-ber YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PostFecBer struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PostFecBer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PostFecBer) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PostFecBer) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PostFecBer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PostFecBer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PreFecBer represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/otn/state/pre-fec-ber YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PreFecBer struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PreFecBer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PreFecBer) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PreFecBer) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PreFecBer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_PreFecBer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_QValue represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/otn/state/q-value YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_QValue struct {
	Avg	*float64	`path:"avg" module:"openconfig-terminal-device"`
	Instant	*float64	`path:"instant" module:"openconfig-terminal-device"`
	Interval	*uint64	`path:"interval" module:"openconfig-terminal-device"`
	Max	*float64	`path:"max" module:"openconfig-terminal-device"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-terminal-device"`
	Min	*float64	`path:"min" module:"openconfig-terminal-device"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_QValue implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_QValue) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_QValue) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_QValue"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Otn_State_QValue) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State represents the /openconfig-terminal-device/terminal-device/logical-channels/channel/state YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State struct {
	AdminState	E_OpenconfigTerminalDevice_AdminStateType	`path:"admin-state" module:"openconfig-terminal-device"`
	Description	*string	`path:"description" module:"openconfig-terminal-device"`
	Index	*uint32	`path:"index" module:"openconfig-terminal-device"`
	LinkState	E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState	`path:"link-state" module:"openconfig-terminal-device"`
	LogicalChannelType	E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE	`path:"logical-channel-type" module:"openconfig-terminal-device"`
	LoopbackMode	E_OpenconfigTerminalDevice_LoopbackModeType	`path:"loopback-mode" module:"openconfig-terminal-device"`
	RateClass	E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE	`path:"rate-class" module:"openconfig-terminal-device"`
	TestSignal	*bool	`path:"test-signal" module:"openconfig-terminal-device"`
	TribProtocol	E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE	`path:"trib-protocol" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_OperationalModes represents the /openconfig-terminal-device/terminal-device/operational-modes YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_OperationalModes struct {
	Mode	map[uint16]*OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode	`path:"mode" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_OperationalModes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_OperationalModes) IsYANGGoStruct() {}

// NewMode creates a new entry in the Mode list of the
// OpenconfigTerminalDevice_TerminalDevice_OperationalModes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigTerminalDevice_TerminalDevice_OperationalModes) NewMode(ModeId uint16) (*OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Mode == nil {
		t.Mode = make(map[uint16]*OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode)
	}

	key := ModeId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Mode[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Mode", key)
	}

	t.Mode[key] = &OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode{
		ModeId: &ModeId,
	}

	return t.Mode[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_OperationalModes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_OperationalModes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_OperationalModes) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode represents the /openconfig-terminal-device/terminal-device/operational-modes/mode YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode struct {
	Config	*OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_Config	`path:"config" module:"openconfig-terminal-device"`
	ModeId	*uint16	`path:"mode-id" module:"openconfig-terminal-device"`
	State	*OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_State	`path:"state" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode struct, which is a YANG list entry.
func (t *OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode) ΛListKeyMap() (map[string]interface{}, error) {
	if t.ModeId == nil {
		return nil, fmt.Errorf("nil value for key ModeId")
	}

	return map[string]interface{}{
		"mode-id": *t.ModeId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_Config represents the /openconfig-terminal-device/terminal-device/operational-modes/mode/config YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_State represents the /openconfig-terminal-device/terminal-device/operational-modes/mode/state YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_State struct {
	Description	*string	`path:"description" module:"openconfig-terminal-device"`
	ModeId	*uint16	`path:"mode-id" module:"openconfig-terminal-device"`
	VendorId	*string	`path:"vendor-id" module:"openconfig-terminal-device"`
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_OperationalModes_Mode_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// OpenconfigTerminalDevice_TerminalDevice_State represents the /openconfig-terminal-device/terminal-device/state YANG schema element.
type OpenconfigTerminalDevice_TerminalDevice_State struct {
}

// IsYANGGoStruct ensures that OpenconfigTerminalDevice_TerminalDevice_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigTerminalDevice_TerminalDevice_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigTerminalDevice_TerminalDevice_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigTerminalDevice_TerminalDevice_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigTerminalDevice_TerminalDevice_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }


// E_IETFInterfaces_InterfaceType is a derived int64 type which is used to represent
// the enumerated node IETFInterfaces_InterfaceType. An additional value named
// IETFInterfaces_InterfaceType_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_IETFInterfaces_InterfaceType int64

// IsYANGGoEnum ensures that IETFInterfaces_InterfaceType implements the yang.GoEnum
// interface. This ensures that IETFInterfaces_InterfaceType can be identified as a
// mapped type for a YANG enumeration.
func (E_IETFInterfaces_InterfaceType) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  IETFInterfaces_InterfaceType.
func (E_IETFInterfaces_InterfaceType) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// IETFInterfaces_InterfaceType_UNSET corresponds to the value UNSET of IETFInterfaces_InterfaceType
	IETFInterfaces_InterfaceType_UNSET E_IETFInterfaces_InterfaceType = 0
)


// E_IETFInterfaces_InterfacesState_Interface_AdminStatus is a derived int64 type which is used to represent
// the enumerated node IETFInterfaces_InterfacesState_Interface_AdminStatus. An additional value named
// IETFInterfaces_InterfacesState_Interface_AdminStatus_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_IETFInterfaces_InterfacesState_Interface_AdminStatus int64

// IsYANGGoEnum ensures that IETFInterfaces_InterfacesState_Interface_AdminStatus implements the yang.GoEnum
// interface. This ensures that IETFInterfaces_InterfacesState_Interface_AdminStatus can be identified as a
// mapped type for a YANG enumeration.
func (E_IETFInterfaces_InterfacesState_Interface_AdminStatus) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  IETFInterfaces_InterfacesState_Interface_AdminStatus.
func (E_IETFInterfaces_InterfacesState_Interface_AdminStatus) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// IETFInterfaces_InterfacesState_Interface_AdminStatus_UNSET corresponds to the value UNSET of IETFInterfaces_InterfacesState_Interface_AdminStatus
	IETFInterfaces_InterfacesState_Interface_AdminStatus_UNSET E_IETFInterfaces_InterfacesState_Interface_AdminStatus = 0
	// IETFInterfaces_InterfacesState_Interface_AdminStatus_up corresponds to the value up of IETFInterfaces_InterfacesState_Interface_AdminStatus
	IETFInterfaces_InterfacesState_Interface_AdminStatus_up E_IETFInterfaces_InterfacesState_Interface_AdminStatus = 2
	// IETFInterfaces_InterfacesState_Interface_AdminStatus_down corresponds to the value down of IETFInterfaces_InterfacesState_Interface_AdminStatus
	IETFInterfaces_InterfacesState_Interface_AdminStatus_down E_IETFInterfaces_InterfacesState_Interface_AdminStatus = 3
	// IETFInterfaces_InterfacesState_Interface_AdminStatus_testing corresponds to the value testing of IETFInterfaces_InterfacesState_Interface_AdminStatus
	IETFInterfaces_InterfacesState_Interface_AdminStatus_testing E_IETFInterfaces_InterfacesState_Interface_AdminStatus = 4
)


// E_IETFInterfaces_InterfacesState_Interface_OperStatus is a derived int64 type which is used to represent
// the enumerated node IETFInterfaces_InterfacesState_Interface_OperStatus. An additional value named
// IETFInterfaces_InterfacesState_Interface_OperStatus_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_IETFInterfaces_InterfacesState_Interface_OperStatus int64

// IsYANGGoEnum ensures that IETFInterfaces_InterfacesState_Interface_OperStatus implements the yang.GoEnum
// interface. This ensures that IETFInterfaces_InterfacesState_Interface_OperStatus can be identified as a
// mapped type for a YANG enumeration.
func (E_IETFInterfaces_InterfacesState_Interface_OperStatus) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  IETFInterfaces_InterfacesState_Interface_OperStatus.
func (E_IETFInterfaces_InterfacesState_Interface_OperStatus) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// IETFInterfaces_InterfacesState_Interface_OperStatus_UNSET corresponds to the value UNSET of IETFInterfaces_InterfacesState_Interface_OperStatus
	IETFInterfaces_InterfacesState_Interface_OperStatus_UNSET E_IETFInterfaces_InterfacesState_Interface_OperStatus = 0
	// IETFInterfaces_InterfacesState_Interface_OperStatus_up corresponds to the value up of IETFInterfaces_InterfacesState_Interface_OperStatus
	IETFInterfaces_InterfacesState_Interface_OperStatus_up E_IETFInterfaces_InterfacesState_Interface_OperStatus = 2
	// IETFInterfaces_InterfacesState_Interface_OperStatus_down corresponds to the value down of IETFInterfaces_InterfacesState_Interface_OperStatus
	IETFInterfaces_InterfacesState_Interface_OperStatus_down E_IETFInterfaces_InterfacesState_Interface_OperStatus = 3
	// IETFInterfaces_InterfacesState_Interface_OperStatus_testing corresponds to the value testing of IETFInterfaces_InterfacesState_Interface_OperStatus
	IETFInterfaces_InterfacesState_Interface_OperStatus_testing E_IETFInterfaces_InterfacesState_Interface_OperStatus = 4
	// IETFInterfaces_InterfacesState_Interface_OperStatus_unknown corresponds to the value unknown of IETFInterfaces_InterfacesState_Interface_OperStatus
	IETFInterfaces_InterfacesState_Interface_OperStatus_unknown E_IETFInterfaces_InterfacesState_Interface_OperStatus = 5
	// IETFInterfaces_InterfacesState_Interface_OperStatus_dormant corresponds to the value dormant of IETFInterfaces_InterfacesState_Interface_OperStatus
	IETFInterfaces_InterfacesState_Interface_OperStatus_dormant E_IETFInterfaces_InterfacesState_Interface_OperStatus = 6
	// IETFInterfaces_InterfacesState_Interface_OperStatus_not_present corresponds to the value not_present of IETFInterfaces_InterfacesState_Interface_OperStatus
	IETFInterfaces_InterfacesState_Interface_OperStatus_not_present E_IETFInterfaces_InterfacesState_Interface_OperStatus = 7
	// IETFInterfaces_InterfacesState_Interface_OperStatus_lower_layer_down corresponds to the value lower_layer_down of IETFInterfaces_InterfacesState_Interface_OperStatus
	IETFInterfaces_InterfacesState_Interface_OperStatus_lower_layer_down E_IETFInterfaces_InterfacesState_Interface_OperStatus = 8
)


// E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY is a derived int64 type which is used to represent
// the enumerated node OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY. An additional value named
// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY int64

// IsYANGGoEnum ensures that OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY implements the yang.GoEnum
// interface. This ensures that OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY.
func (E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNSET corresponds to the value UNSET of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNSET E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 0
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_CRITICAL corresponds to the value CRITICAL of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_CRITICAL E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 1
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MAJOR corresponds to the value MAJOR of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MAJOR E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 2
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MINOR corresponds to the value MINOR of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MINOR E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 3
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNKNOWN corresponds to the value UNKNOWN of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNKNOWN E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 4
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_WARNING corresponds to the value WARNING of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_WARNING E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 5
)


// E_OpenconfigIfEthernet_ETHERNET_SPEED is a derived int64 type which is used to represent
// the enumerated node OpenconfigIfEthernet_ETHERNET_SPEED. An additional value named
// OpenconfigIfEthernet_ETHERNET_SPEED_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigIfEthernet_ETHERNET_SPEED int64

// IsYANGGoEnum ensures that OpenconfigIfEthernet_ETHERNET_SPEED implements the yang.GoEnum
// interface. This ensures that OpenconfigIfEthernet_ETHERNET_SPEED can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigIfEthernet_ETHERNET_SPEED) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigIfEthernet_ETHERNET_SPEED.
func (E_OpenconfigIfEthernet_ETHERNET_SPEED) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigIfEthernet_ETHERNET_SPEED_UNSET corresponds to the value UNSET of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_UNSET E_OpenconfigIfEthernet_ETHERNET_SPEED = 0
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_100GB corresponds to the value SPEED_100GB of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_100GB E_OpenconfigIfEthernet_ETHERNET_SPEED = 1
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_100MB corresponds to the value SPEED_100MB of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_100MB E_OpenconfigIfEthernet_ETHERNET_SPEED = 2
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_10GB corresponds to the value SPEED_10GB of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_10GB E_OpenconfigIfEthernet_ETHERNET_SPEED = 3
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_10MB corresponds to the value SPEED_10MB of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_10MB E_OpenconfigIfEthernet_ETHERNET_SPEED = 4
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_1GB corresponds to the value SPEED_1GB of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_1GB E_OpenconfigIfEthernet_ETHERNET_SPEED = 5
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_2500MB corresponds to the value SPEED_2500MB of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_2500MB E_OpenconfigIfEthernet_ETHERNET_SPEED = 6
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_25GB corresponds to the value SPEED_25GB of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_25GB E_OpenconfigIfEthernet_ETHERNET_SPEED = 7
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_40GB corresponds to the value SPEED_40GB of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_40GB E_OpenconfigIfEthernet_ETHERNET_SPEED = 8
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_50GB corresponds to the value SPEED_50GB of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_50GB E_OpenconfigIfEthernet_ETHERNET_SPEED = 9
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_5GB corresponds to the value SPEED_5GB of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_5GB E_OpenconfigIfEthernet_ETHERNET_SPEED = 10
	// OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_UNKNOWN corresponds to the value SPEED_UNKNOWN of OpenconfigIfEthernet_ETHERNET_SPEED
	OpenconfigIfEthernet_ETHERNET_SPEED_SPEED_UNKNOWN E_OpenconfigIfEthernet_ETHERNET_SPEED = 11
)


// E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode is a derived int64 type which is used to represent
// the enumerated node OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode. An additional value named
// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode int64

// IsYANGGoEnum ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode implements the yang.GoEnum
// interface. This ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode.
func (E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode_UNSET corresponds to the value UNSET of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode
	OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode_UNSET E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode = 0
	// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode_FULL corresponds to the value FULL of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode
	OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode_FULL E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode = 1
	// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode_HALF corresponds to the value HALF of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode
	OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode_HALF E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode = 2
)


// E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode is a derived int64 type which is used to represent
// the enumerated node OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode. An additional value named
// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode int64

// IsYANGGoEnum ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode implements the yang.GoEnum
// interface. This ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode.
func (E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode_UNSET corresponds to the value UNSET of OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode
	OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode_UNSET E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode = 0
	// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode_FULL corresponds to the value FULL of OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode
	OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode_FULL E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode = 1
	// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode_HALF corresponds to the value HALF of OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode
	OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode_HALF E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode = 2
)


// E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus is a derived int64 type which is used to represent
// the enumerated node OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus. An additional value named
// OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus int64

// IsYANGGoEnum ensures that OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus implements the yang.GoEnum
// interface. This ensures that OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus.
func (E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_UNSET corresponds to the value UNSET of OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus
	OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_UNSET E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus = 0
	// OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_UP corresponds to the value UP of OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus
	OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_UP E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus = 1
	// OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_DOWN corresponds to the value DOWN of OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus
	OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_DOWN E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus = 2
	// OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_TESTING corresponds to the value TESTING of OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus
	OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_TESTING E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus = 3
)


// E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus is a derived int64 type which is used to represent
// the enumerated node OpenconfigInterfaces_Interfaces_Interface_State_OperStatus. An additional value named
// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus int64

// IsYANGGoEnum ensures that OpenconfigInterfaces_Interfaces_Interface_State_OperStatus implements the yang.GoEnum
// interface. This ensures that OpenconfigInterfaces_Interfaces_Interface_State_OperStatus can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigInterfaces_Interfaces_Interface_State_OperStatus.
func (E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UNSET corresponds to the value UNSET of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UNSET E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 0
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UP corresponds to the value UP of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UP E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 2
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_DOWN corresponds to the value DOWN of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_DOWN E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 3
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_TESTING corresponds to the value TESTING of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_TESTING E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 4
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UNKNOWN corresponds to the value UNKNOWN of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UNKNOWN E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 5
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_DORMANT corresponds to the value DORMANT of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_DORMANT E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 6
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_NOT_PRESENT corresponds to the value NOT_PRESENT of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_NOT_PRESENT E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 7
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_LOWER_LAYER_DOWN corresponds to the value LOWER_LAYER_DOWN of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_LOWER_LAYER_DOWN E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 8
)


// E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY is a derived int64 type which is used to represent
// the enumerated node OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY. An additional value named
// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY int64

// IsYANGGoEnum ensures that OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY implements the yang.GoEnum
// interface. This ensures that OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY.
func (E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_UNSET corresponds to the value UNSET of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_UNSET E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 0
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_C_VLAN corresponds to the value C_VLAN of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_C_VLAN E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 1
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_DOCSIS_CABLE_DEVICE corresponds to the value DOCSIS_CABLE_DEVICE of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_DOCSIS_CABLE_DEVICE E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 2
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_MAC_BRIDGE corresponds to the value MAC_BRIDGE of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_MAC_BRIDGE E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 3
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_OTHER corresponds to the value OTHER of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_OTHER E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 4
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_REPEATER corresponds to the value REPEATER of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_REPEATER E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 5
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_ROUTER corresponds to the value ROUTER of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_ROUTER E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 6
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_STATION_ONLY corresponds to the value STATION_ONLY of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_STATION_ONLY E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 7
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_S_VLAN corresponds to the value S_VLAN of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_S_VLAN E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 8
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_TELEPHONE corresponds to the value TELEPHONE of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_TELEPHONE E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 9
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_TWO_PORT_MAC_RELAY corresponds to the value TWO_PORT_MAC_RELAY of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_TWO_PORT_MAC_RELAY E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 10
	// OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_WLAN_ACCESS_POINT corresponds to the value WLAN_ACCESS_POINT of OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY
	OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY_WLAN_ACCESS_POINT E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY = 11
)


// E_OpenconfigLldpTypes_LLDP_TLV is a derived int64 type which is used to represent
// the enumerated node OpenconfigLldpTypes_LLDP_TLV. An additional value named
// OpenconfigLldpTypes_LLDP_TLV_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigLldpTypes_LLDP_TLV int64

// IsYANGGoEnum ensures that OpenconfigLldpTypes_LLDP_TLV implements the yang.GoEnum
// interface. This ensures that OpenconfigLldpTypes_LLDP_TLV can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigLldpTypes_LLDP_TLV) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigLldpTypes_LLDP_TLV.
func (E_OpenconfigLldpTypes_LLDP_TLV) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigLldpTypes_LLDP_TLV_UNSET corresponds to the value UNSET of OpenconfigLldpTypes_LLDP_TLV
	OpenconfigLldpTypes_LLDP_TLV_UNSET E_OpenconfigLldpTypes_LLDP_TLV = 0
	// OpenconfigLldpTypes_LLDP_TLV_CHASSIS_ID corresponds to the value CHASSIS_ID of OpenconfigLldpTypes_LLDP_TLV
	OpenconfigLldpTypes_LLDP_TLV_CHASSIS_ID E_OpenconfigLldpTypes_LLDP_TLV = 1
	// OpenconfigLldpTypes_LLDP_TLV_MANAGEMENT_ADDRESS corresponds to the value MANAGEMENT_ADDRESS of OpenconfigLldpTypes_LLDP_TLV
	OpenconfigLldpTypes_LLDP_TLV_MANAGEMENT_ADDRESS E_OpenconfigLldpTypes_LLDP_TLV = 2
	// OpenconfigLldpTypes_LLDP_TLV_PORT_DESCRIPTION corresponds to the value PORT_DESCRIPTION of OpenconfigLldpTypes_LLDP_TLV
	OpenconfigLldpTypes_LLDP_TLV_PORT_DESCRIPTION E_OpenconfigLldpTypes_LLDP_TLV = 3
	// OpenconfigLldpTypes_LLDP_TLV_PORT_ID corresponds to the value PORT_ID of OpenconfigLldpTypes_LLDP_TLV
	OpenconfigLldpTypes_LLDP_TLV_PORT_ID E_OpenconfigLldpTypes_LLDP_TLV = 4
	// OpenconfigLldpTypes_LLDP_TLV_SYSTEM_CAPABILITIES corresponds to the value SYSTEM_CAPABILITIES of OpenconfigLldpTypes_LLDP_TLV
	OpenconfigLldpTypes_LLDP_TLV_SYSTEM_CAPABILITIES E_OpenconfigLldpTypes_LLDP_TLV = 5
	// OpenconfigLldpTypes_LLDP_TLV_SYSTEM_DESCRIPTION corresponds to the value SYSTEM_DESCRIPTION of OpenconfigLldpTypes_LLDP_TLV
	OpenconfigLldpTypes_LLDP_TLV_SYSTEM_DESCRIPTION E_OpenconfigLldpTypes_LLDP_TLV = 6
	// OpenconfigLldpTypes_LLDP_TLV_SYSTEM_NAME corresponds to the value SYSTEM_NAME of OpenconfigLldpTypes_LLDP_TLV
	OpenconfigLldpTypes_LLDP_TLV_SYSTEM_NAME E_OpenconfigLldpTypes_LLDP_TLV = 7
)


// E_OpenconfigLldp_ChassisIdType is a derived int64 type which is used to represent
// the enumerated node OpenconfigLldp_ChassisIdType. An additional value named
// OpenconfigLldp_ChassisIdType_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigLldp_ChassisIdType int64

// IsYANGGoEnum ensures that OpenconfigLldp_ChassisIdType implements the yang.GoEnum
// interface. This ensures that OpenconfigLldp_ChassisIdType can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigLldp_ChassisIdType) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigLldp_ChassisIdType.
func (E_OpenconfigLldp_ChassisIdType) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigLldp_ChassisIdType_UNSET corresponds to the value UNSET of OpenconfigLldp_ChassisIdType
	OpenconfigLldp_ChassisIdType_UNSET E_OpenconfigLldp_ChassisIdType = 0
	// OpenconfigLldp_ChassisIdType_CHASSIS_COMPONENT corresponds to the value CHASSIS_COMPONENT of OpenconfigLldp_ChassisIdType
	OpenconfigLldp_ChassisIdType_CHASSIS_COMPONENT E_OpenconfigLldp_ChassisIdType = 1
	// OpenconfigLldp_ChassisIdType_INTERFACE_ALIAS corresponds to the value INTERFACE_ALIAS of OpenconfigLldp_ChassisIdType
	OpenconfigLldp_ChassisIdType_INTERFACE_ALIAS E_OpenconfigLldp_ChassisIdType = 2
	// OpenconfigLldp_ChassisIdType_PORT_COMPONENT corresponds to the value PORT_COMPONENT of OpenconfigLldp_ChassisIdType
	OpenconfigLldp_ChassisIdType_PORT_COMPONENT E_OpenconfigLldp_ChassisIdType = 3
	// OpenconfigLldp_ChassisIdType_MAC_ADDRESS corresponds to the value MAC_ADDRESS of OpenconfigLldp_ChassisIdType
	OpenconfigLldp_ChassisIdType_MAC_ADDRESS E_OpenconfigLldp_ChassisIdType = 4
	// OpenconfigLldp_ChassisIdType_NETWORK_ADDRESS corresponds to the value NETWORK_ADDRESS of OpenconfigLldp_ChassisIdType
	OpenconfigLldp_ChassisIdType_NETWORK_ADDRESS E_OpenconfigLldp_ChassisIdType = 5
	// OpenconfigLldp_ChassisIdType_INTERFACE_NAME corresponds to the value INTERFACE_NAME of OpenconfigLldp_ChassisIdType
	OpenconfigLldp_ChassisIdType_INTERFACE_NAME E_OpenconfigLldp_ChassisIdType = 6
	// OpenconfigLldp_ChassisIdType_LOCAL corresponds to the value LOCAL of OpenconfigLldp_ChassisIdType
	OpenconfigLldp_ChassisIdType_LOCAL E_OpenconfigLldp_ChassisIdType = 7
)


// E_OpenconfigLldp_PortIdType is a derived int64 type which is used to represent
// the enumerated node OpenconfigLldp_PortIdType. An additional value named
// OpenconfigLldp_PortIdType_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigLldp_PortIdType int64

// IsYANGGoEnum ensures that OpenconfigLldp_PortIdType implements the yang.GoEnum
// interface. This ensures that OpenconfigLldp_PortIdType can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigLldp_PortIdType) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigLldp_PortIdType.
func (E_OpenconfigLldp_PortIdType) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigLldp_PortIdType_UNSET corresponds to the value UNSET of OpenconfigLldp_PortIdType
	OpenconfigLldp_PortIdType_UNSET E_OpenconfigLldp_PortIdType = 0
	// OpenconfigLldp_PortIdType_INTERFACE_ALIAS corresponds to the value INTERFACE_ALIAS of OpenconfigLldp_PortIdType
	OpenconfigLldp_PortIdType_INTERFACE_ALIAS E_OpenconfigLldp_PortIdType = 1
	// OpenconfigLldp_PortIdType_PORT_COMPONENT corresponds to the value PORT_COMPONENT of OpenconfigLldp_PortIdType
	OpenconfigLldp_PortIdType_PORT_COMPONENT E_OpenconfigLldp_PortIdType = 2
	// OpenconfigLldp_PortIdType_MAC_ADDRESS corresponds to the value MAC_ADDRESS of OpenconfigLldp_PortIdType
	OpenconfigLldp_PortIdType_MAC_ADDRESS E_OpenconfigLldp_PortIdType = 3
	// OpenconfigLldp_PortIdType_NETWORK_ADDRESS corresponds to the value NETWORK_ADDRESS of OpenconfigLldp_PortIdType
	OpenconfigLldp_PortIdType_NETWORK_ADDRESS E_OpenconfigLldp_PortIdType = 4
	// OpenconfigLldp_PortIdType_INTERFACE_NAME corresponds to the value INTERFACE_NAME of OpenconfigLldp_PortIdType
	OpenconfigLldp_PortIdType_INTERFACE_NAME E_OpenconfigLldp_PortIdType = 5
	// OpenconfigLldp_PortIdType_AGENT_CIRCUIT_ID corresponds to the value AGENT_CIRCUIT_ID of OpenconfigLldp_PortIdType
	OpenconfigLldp_PortIdType_AGENT_CIRCUIT_ID E_OpenconfigLldp_PortIdType = 6
	// OpenconfigLldp_PortIdType_LOCAL corresponds to the value LOCAL of OpenconfigLldp_PortIdType
	OpenconfigLldp_PortIdType_LOCAL E_OpenconfigLldp_PortIdType = 7
)


// E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_COMPONENT_OPER_STATUS. An additional value named
// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_COMPONENT_OPER_STATUS implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_COMPONENT_OPER_STATUS can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_COMPONENT_OPER_STATUS.
func (E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_UNSET E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 0
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_ACTIVE corresponds to the value ACTIVE of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_ACTIVE E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 1
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_DISABLED corresponds to the value DISABLED of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_DISABLED E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 2
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_INACTIVE corresponds to the value INACTIVE of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_INACTIVE E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 3
)


// E_OpenconfigPlatformTypes_FEC_MODE_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_FEC_MODE_TYPE. An additional value named
// OpenconfigPlatformTypes_FEC_MODE_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_FEC_MODE_TYPE int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_FEC_MODE_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_FEC_MODE_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_FEC_MODE_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_FEC_MODE_TYPE.
func (E_OpenconfigPlatformTypes_FEC_MODE_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigPlatformTypes_FEC_MODE_TYPE_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_FEC_MODE_TYPE
	OpenconfigPlatformTypes_FEC_MODE_TYPE_UNSET E_OpenconfigPlatformTypes_FEC_MODE_TYPE = 0
	// OpenconfigPlatformTypes_FEC_MODE_TYPE_FEC_AUTO corresponds to the value FEC_AUTO of OpenconfigPlatformTypes_FEC_MODE_TYPE
	OpenconfigPlatformTypes_FEC_MODE_TYPE_FEC_AUTO E_OpenconfigPlatformTypes_FEC_MODE_TYPE = 1
	// OpenconfigPlatformTypes_FEC_MODE_TYPE_FEC_DISABLED corresponds to the value FEC_DISABLED of OpenconfigPlatformTypes_FEC_MODE_TYPE
	OpenconfigPlatformTypes_FEC_MODE_TYPE_FEC_DISABLED E_OpenconfigPlatformTypes_FEC_MODE_TYPE = 2
	// OpenconfigPlatformTypes_FEC_MODE_TYPE_FEC_ENABLED corresponds to the value FEC_ENABLED of OpenconfigPlatformTypes_FEC_MODE_TYPE
	OpenconfigPlatformTypes_FEC_MODE_TYPE_FEC_ENABLED E_OpenconfigPlatformTypes_FEC_MODE_TYPE = 3
)


// E_OpenconfigPlatformTypes_FEC_STATUS_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_FEC_STATUS_TYPE. An additional value named
// OpenconfigPlatformTypes_FEC_STATUS_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_FEC_STATUS_TYPE int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_FEC_STATUS_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_FEC_STATUS_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_FEC_STATUS_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_FEC_STATUS_TYPE.
func (E_OpenconfigPlatformTypes_FEC_STATUS_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigPlatformTypes_FEC_STATUS_TYPE_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_FEC_STATUS_TYPE
	OpenconfigPlatformTypes_FEC_STATUS_TYPE_UNSET E_OpenconfigPlatformTypes_FEC_STATUS_TYPE = 0
	// OpenconfigPlatformTypes_FEC_STATUS_TYPE_FEC_STATUS_LOCKED corresponds to the value FEC_STATUS_LOCKED of OpenconfigPlatformTypes_FEC_STATUS_TYPE
	OpenconfigPlatformTypes_FEC_STATUS_TYPE_FEC_STATUS_LOCKED E_OpenconfigPlatformTypes_FEC_STATUS_TYPE = 1
	// OpenconfigPlatformTypes_FEC_STATUS_TYPE_FEC_STATUS_UNLOCKED corresponds to the value FEC_STATUS_UNLOCKED of OpenconfigPlatformTypes_FEC_STATUS_TYPE
	OpenconfigPlatformTypes_FEC_STATUS_TYPE_FEC_STATUS_UNLOCKED E_OpenconfigPlatformTypes_FEC_STATUS_TYPE = 2
)


// E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT. An additional value named
// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT.
func (E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_UNSET E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 0
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_BACKPLANE corresponds to the value BACKPLANE of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_BACKPLANE E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 1
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CHASSIS corresponds to the value CHASSIS of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CHASSIS E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 2
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CONTROLLER_CARD corresponds to the value CONTROLLER_CARD of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CONTROLLER_CARD E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 3
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CPU corresponds to the value CPU of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CPU E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 4
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FABRIC corresponds to the value FABRIC of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FABRIC E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 5
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FAN corresponds to the value FAN of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FAN E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 6
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FRU corresponds to the value FRU of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FRU E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 7
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_INTEGRATED_CIRCUIT corresponds to the value INTEGRATED_CIRCUIT of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_INTEGRATED_CIRCUIT E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 8
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_LINECARD corresponds to the value LINECARD of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_LINECARD E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 9
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_OPTICAL_CHANNEL corresponds to the value OPTICAL_CHANNEL of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_OPTICAL_CHANNEL E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 10
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_PORT corresponds to the value PORT of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_PORT E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 11
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_POWER_SUPPLY corresponds to the value POWER_SUPPLY of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_POWER_SUPPLY E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 12
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_SENSOR corresponds to the value SENSOR of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_SENSOR E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 13
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_STORAGE corresponds to the value STORAGE of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_STORAGE E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 14
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_TRANSCEIVER corresponds to the value TRANSCEIVER of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_TRANSCEIVER E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 15
)


// E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT. An additional value named
// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT.
func (E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_UNSET E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 0
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM corresponds to the value OPERATING_SYSTEM of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 1
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM_UPDATE corresponds to the value OPERATING_SYSTEM_UPDATE of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM_UPDATE E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 2
)


// E_OpenconfigPlatform_Components_Component_Transceiver_State_Present is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatform_Components_Component_Transceiver_State_Present. An additional value named
// OpenconfigPlatform_Components_Component_Transceiver_State_Present_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatform_Components_Component_Transceiver_State_Present int64

// IsYANGGoEnum ensures that OpenconfigPlatform_Components_Component_Transceiver_State_Present implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatform_Components_Component_Transceiver_State_Present can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatform_Components_Component_Transceiver_State_Present) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatform_Components_Component_Transceiver_State_Present.
func (E_OpenconfigPlatform_Components_Component_Transceiver_State_Present) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigPlatform_Components_Component_Transceiver_State_Present_UNSET corresponds to the value UNSET of OpenconfigPlatform_Components_Component_Transceiver_State_Present
	OpenconfigPlatform_Components_Component_Transceiver_State_Present_UNSET E_OpenconfigPlatform_Components_Component_Transceiver_State_Present = 0
	// OpenconfigPlatform_Components_Component_Transceiver_State_Present_PRESENT corresponds to the value PRESENT of OpenconfigPlatform_Components_Component_Transceiver_State_Present
	OpenconfigPlatform_Components_Component_Transceiver_State_Present_PRESENT E_OpenconfigPlatform_Components_Component_Transceiver_State_Present = 1
	// OpenconfigPlatform_Components_Component_Transceiver_State_Present_NOT_PRESENT corresponds to the value NOT_PRESENT of OpenconfigPlatform_Components_Component_Transceiver_State_Present
	OpenconfigPlatform_Components_Component_Transceiver_State_Present_NOT_PRESENT E_OpenconfigPlatform_Components_Component_Transceiver_State_Present = 2
)


// E_OpenconfigTerminalDevice_AdminStateType is a derived int64 type which is used to represent
// the enumerated node OpenconfigTerminalDevice_AdminStateType. An additional value named
// OpenconfigTerminalDevice_AdminStateType_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTerminalDevice_AdminStateType int64

// IsYANGGoEnum ensures that OpenconfigTerminalDevice_AdminStateType implements the yang.GoEnum
// interface. This ensures that OpenconfigTerminalDevice_AdminStateType can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTerminalDevice_AdminStateType) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTerminalDevice_AdminStateType.
func (E_OpenconfigTerminalDevice_AdminStateType) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTerminalDevice_AdminStateType_UNSET corresponds to the value UNSET of OpenconfigTerminalDevice_AdminStateType
	OpenconfigTerminalDevice_AdminStateType_UNSET E_OpenconfigTerminalDevice_AdminStateType = 0
	// OpenconfigTerminalDevice_AdminStateType_ENABLED corresponds to the value ENABLED of OpenconfigTerminalDevice_AdminStateType
	OpenconfigTerminalDevice_AdminStateType_ENABLED E_OpenconfigTerminalDevice_AdminStateType = 1
	// OpenconfigTerminalDevice_AdminStateType_DISABLED corresponds to the value DISABLED of OpenconfigTerminalDevice_AdminStateType
	OpenconfigTerminalDevice_AdminStateType_DISABLED E_OpenconfigTerminalDevice_AdminStateType = 2
	// OpenconfigTerminalDevice_AdminStateType_MAINT corresponds to the value MAINT of OpenconfigTerminalDevice_AdminStateType
	OpenconfigTerminalDevice_AdminStateType_MAINT E_OpenconfigTerminalDevice_AdminStateType = 3
)


// E_OpenconfigTerminalDevice_LoopbackModeType is a derived int64 type which is used to represent
// the enumerated node OpenconfigTerminalDevice_LoopbackModeType. An additional value named
// OpenconfigTerminalDevice_LoopbackModeType_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTerminalDevice_LoopbackModeType int64

// IsYANGGoEnum ensures that OpenconfigTerminalDevice_LoopbackModeType implements the yang.GoEnum
// interface. This ensures that OpenconfigTerminalDevice_LoopbackModeType can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTerminalDevice_LoopbackModeType) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTerminalDevice_LoopbackModeType.
func (E_OpenconfigTerminalDevice_LoopbackModeType) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTerminalDevice_LoopbackModeType_UNSET corresponds to the value UNSET of OpenconfigTerminalDevice_LoopbackModeType
	OpenconfigTerminalDevice_LoopbackModeType_UNSET E_OpenconfigTerminalDevice_LoopbackModeType = 0
	// OpenconfigTerminalDevice_LoopbackModeType_NONE corresponds to the value NONE of OpenconfigTerminalDevice_LoopbackModeType
	OpenconfigTerminalDevice_LoopbackModeType_NONE E_OpenconfigTerminalDevice_LoopbackModeType = 1
	// OpenconfigTerminalDevice_LoopbackModeType_FACILITY corresponds to the value FACILITY of OpenconfigTerminalDevice_LoopbackModeType
	OpenconfigTerminalDevice_LoopbackModeType_FACILITY E_OpenconfigTerminalDevice_LoopbackModeType = 2
	// OpenconfigTerminalDevice_LoopbackModeType_TERMINAL corresponds to the value TERMINAL of OpenconfigTerminalDevice_LoopbackModeType
	OpenconfigTerminalDevice_LoopbackModeType_TERMINAL E_OpenconfigTerminalDevice_LoopbackModeType = 3
)


// E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls is a derived int64 type which is used to represent
// the enumerated node OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls. An additional value named
// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls int64

// IsYANGGoEnum ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls implements the yang.GoEnum
// interface. This ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls.
func (E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls_UNSET corresponds to the value UNSET of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls_UNSET E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls = 0
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls_NONE corresponds to the value NONE of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls_NONE E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls = 1
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls_LASER_SHUTDOWN corresponds to the value LASER_SHUTDOWN of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls_LASER_SHUTDOWN E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls = 2
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls_ETHERNET corresponds to the value ETHERNET of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls_ETHERNET E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls = 3
)


// E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType is a derived int64 type which is used to represent
// the enumerated node OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType. An additional value named
// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType int64

// IsYANGGoEnum ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType implements the yang.GoEnum
// interface. This ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType.
func (E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType_UNSET corresponds to the value UNSET of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType_UNSET E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType = 0
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType_LOGICAL_CHANNEL corresponds to the value LOGICAL_CHANNEL of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType_LOGICAL_CHANNEL E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType = 1
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType_OPTICAL_CHANNEL corresponds to the value OPTICAL_CHANNEL of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType_OPTICAL_CHANNEL E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType = 2
)


// E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState is a derived int64 type which is used to represent
// the enumerated node OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState. An additional value named
// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState int64

// IsYANGGoEnum ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState implements the yang.GoEnum
// interface. This ensures that OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState.
func (E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState_UNSET corresponds to the value UNSET of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState_UNSET E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState = 0
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState_UP corresponds to the value UP of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState_UP E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState = 1
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState_DOWN corresponds to the value DOWN of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState_DOWN E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState = 2
	// OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState_TESTING corresponds to the value TESTING of OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState
	OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState_TESTING E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState = 3
)


// E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigTransportTypes_ETHERNET_PMD_TYPE. An additional value named
// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE int64

// IsYANGGoEnum ensures that OpenconfigTransportTypes_ETHERNET_PMD_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigTransportTypes_ETHERNET_PMD_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTransportTypes_ETHERNET_PMD_TYPE.
func (E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_UNSET corresponds to the value UNSET of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_UNSET E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 0
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_CLR4 corresponds to the value ETH_100GBASE_CLR4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_CLR4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 1
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_CR4 corresponds to the value ETH_100GBASE_CR4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_CR4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 2
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_CWDM4 corresponds to the value ETH_100GBASE_CWDM4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_CWDM4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 3
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_ER4 corresponds to the value ETH_100GBASE_ER4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_ER4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 4
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_LR4 corresponds to the value ETH_100GBASE_LR4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_LR4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 5
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_PSM4 corresponds to the value ETH_100GBASE_PSM4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_PSM4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 6
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_SR10 corresponds to the value ETH_100GBASE_SR10 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_SR10 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 7
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_SR4 corresponds to the value ETH_100GBASE_SR4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100GBASE_SR4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 8
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100G_ACC corresponds to the value ETH_100G_ACC of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100G_ACC E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 9
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100G_AOC corresponds to the value ETH_100G_AOC of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_100G_AOC E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 10
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_10GBASE_ER corresponds to the value ETH_10GBASE_ER of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_10GBASE_ER E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 11
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_10GBASE_LR corresponds to the value ETH_10GBASE_LR of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_10GBASE_LR E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 12
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_10GBASE_LRM corresponds to the value ETH_10GBASE_LRM of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_10GBASE_LRM E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 13
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_10GBASE_SR corresponds to the value ETH_10GBASE_SR of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_10GBASE_SR E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 14
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_10GBASE_ZR corresponds to the value ETH_10GBASE_ZR of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_10GBASE_ZR E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 15
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_40GBASE_CR4 corresponds to the value ETH_40GBASE_CR4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_40GBASE_CR4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 16
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_40GBASE_ER4 corresponds to the value ETH_40GBASE_ER4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_40GBASE_ER4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 17
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_40GBASE_LR4 corresponds to the value ETH_40GBASE_LR4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_40GBASE_LR4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 18
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_40GBASE_PSM4 corresponds to the value ETH_40GBASE_PSM4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_40GBASE_PSM4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 19
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_40GBASE_SR4 corresponds to the value ETH_40GBASE_SR4 of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_40GBASE_SR4 E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 20
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_4X10GBASE_LR corresponds to the value ETH_4X10GBASE_LR of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_4X10GBASE_LR E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 21
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_4X10GBASE_SR corresponds to the value ETH_4X10GBASE_SR of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_4X10GBASE_SR E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 22
	// OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_UNDEFINED corresponds to the value ETH_UNDEFINED of OpenconfigTransportTypes_ETHERNET_PMD_TYPE
	OpenconfigTransportTypes_ETHERNET_PMD_TYPE_ETH_UNDEFINED E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE = 23
)


// E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE. An additional value named
// OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE int64

// IsYANGGoEnum ensures that OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE.
func (E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE_UNSET corresponds to the value UNSET of OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE
	OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE_UNSET E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE = 0
	// OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE_LC_CONNECTOR corresponds to the value LC_CONNECTOR of OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE
	OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE_LC_CONNECTOR E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE = 1
	// OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE_MPO_CONNECTOR corresponds to the value MPO_CONNECTOR of OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE
	OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE_MPO_CONNECTOR E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE = 2
	// OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE_SC_CONNECTOR corresponds to the value SC_CONNECTOR of OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE
	OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE_SC_CONNECTOR E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE = 3
)


// E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL is a derived int64 type which is used to represent
// the enumerated node OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL. An additional value named
// OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL int64

// IsYANGGoEnum ensures that OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL implements the yang.GoEnum
// interface. This ensures that OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL.
func (E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_UNSET corresponds to the value UNSET of OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL
	OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_UNSET E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL = 0
	// OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_AMP corresponds to the value AMP of OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL
	OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_AMP E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL = 1
	// OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_BMP corresponds to the value BMP of OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL
	OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_BMP E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL = 2
	// OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_CBR corresponds to the value CBR of OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL
	OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_CBR E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL = 3
	// OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_GFP_F corresponds to the value GFP_F of OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL
	OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_GFP_F E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL = 4
	// OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_GFP_T corresponds to the value GFP_T of OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL
	OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_GFP_T E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL = 5
	// OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_GMP corresponds to the value GMP of OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL
	OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL_GMP E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL = 6
)


// E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE. An additional value named
// OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE int64

// IsYANGGoEnum ensures that OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE.
func (E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE_UNSET corresponds to the value UNSET of OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE
	OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE_UNSET E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE = 0
	// OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE_PROT_ETHERNET corresponds to the value PROT_ETHERNET of OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE
	OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE_PROT_ETHERNET E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE = 1
	// OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE_PROT_OTN corresponds to the value PROT_OTN of OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE
	OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE_PROT_OTN E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE = 2
)


// E_OpenconfigTransportTypes_OTN_APPLICATION_CODE is a derived int64 type which is used to represent
// the enumerated node OpenconfigTransportTypes_OTN_APPLICATION_CODE. An additional value named
// OpenconfigTransportTypes_OTN_APPLICATION_CODE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTransportTypes_OTN_APPLICATION_CODE int64

// IsYANGGoEnum ensures that OpenconfigTransportTypes_OTN_APPLICATION_CODE implements the yang.GoEnum
// interface. This ensures that OpenconfigTransportTypes_OTN_APPLICATION_CODE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTransportTypes_OTN_APPLICATION_CODE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTransportTypes_OTN_APPLICATION_CODE.
func (E_OpenconfigTransportTypes_OTN_APPLICATION_CODE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTransportTypes_OTN_APPLICATION_CODE_UNSET corresponds to the value UNSET of OpenconfigTransportTypes_OTN_APPLICATION_CODE
	OpenconfigTransportTypes_OTN_APPLICATION_CODE_UNSET E_OpenconfigTransportTypes_OTN_APPLICATION_CODE = 0
	// OpenconfigTransportTypes_OTN_APPLICATION_CODE_OTN_UNDEFINED corresponds to the value OTN_UNDEFINED of OpenconfigTransportTypes_OTN_APPLICATION_CODE
	OpenconfigTransportTypes_OTN_APPLICATION_CODE_OTN_UNDEFINED E_OpenconfigTransportTypes_OTN_APPLICATION_CODE = 1
	// OpenconfigTransportTypes_OTN_APPLICATION_CODE_P1L1_2D1 corresponds to the value P1L1_2D1 of OpenconfigTransportTypes_OTN_APPLICATION_CODE
	OpenconfigTransportTypes_OTN_APPLICATION_CODE_P1L1_2D1 E_OpenconfigTransportTypes_OTN_APPLICATION_CODE = 2
	// OpenconfigTransportTypes_OTN_APPLICATION_CODE_P1L1_2D2 corresponds to the value P1L1_2D2 of OpenconfigTransportTypes_OTN_APPLICATION_CODE
	OpenconfigTransportTypes_OTN_APPLICATION_CODE_P1L1_2D2 E_OpenconfigTransportTypes_OTN_APPLICATION_CODE = 3
	// OpenconfigTransportTypes_OTN_APPLICATION_CODE_P1S1_2D2 corresponds to the value P1S1_2D2 of OpenconfigTransportTypes_OTN_APPLICATION_CODE
	OpenconfigTransportTypes_OTN_APPLICATION_CODE_P1S1_2D2 E_OpenconfigTransportTypes_OTN_APPLICATION_CODE = 4
)


// E_OpenconfigTransportTypes_SONET_APPLICATION_CODE is a derived int64 type which is used to represent
// the enumerated node OpenconfigTransportTypes_SONET_APPLICATION_CODE. An additional value named
// OpenconfigTransportTypes_SONET_APPLICATION_CODE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTransportTypes_SONET_APPLICATION_CODE int64

// IsYANGGoEnum ensures that OpenconfigTransportTypes_SONET_APPLICATION_CODE implements the yang.GoEnum
// interface. This ensures that OpenconfigTransportTypes_SONET_APPLICATION_CODE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTransportTypes_SONET_APPLICATION_CODE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTransportTypes_SONET_APPLICATION_CODE.
func (E_OpenconfigTransportTypes_SONET_APPLICATION_CODE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTransportTypes_SONET_APPLICATION_CODE_UNSET corresponds to the value UNSET of OpenconfigTransportTypes_SONET_APPLICATION_CODE
	OpenconfigTransportTypes_SONET_APPLICATION_CODE_UNSET E_OpenconfigTransportTypes_SONET_APPLICATION_CODE = 0
	// OpenconfigTransportTypes_SONET_APPLICATION_CODE_SONET_UNDEFINED corresponds to the value SONET_UNDEFINED of OpenconfigTransportTypes_SONET_APPLICATION_CODE
	OpenconfigTransportTypes_SONET_APPLICATION_CODE_SONET_UNDEFINED E_OpenconfigTransportTypes_SONET_APPLICATION_CODE = 1
	// OpenconfigTransportTypes_SONET_APPLICATION_CODE_VSR2000_3R2 corresponds to the value VSR2000_3R2 of OpenconfigTransportTypes_SONET_APPLICATION_CODE
	OpenconfigTransportTypes_SONET_APPLICATION_CODE_VSR2000_3R2 E_OpenconfigTransportTypes_SONET_APPLICATION_CODE = 2
	// OpenconfigTransportTypes_SONET_APPLICATION_CODE_VSR2000_3R3 corresponds to the value VSR2000_3R3 of OpenconfigTransportTypes_SONET_APPLICATION_CODE
	OpenconfigTransportTypes_SONET_APPLICATION_CODE_VSR2000_3R3 E_OpenconfigTransportTypes_SONET_APPLICATION_CODE = 3
	// OpenconfigTransportTypes_SONET_APPLICATION_CODE_VSR2000_3R5 corresponds to the value VSR2000_3R5 of OpenconfigTransportTypes_SONET_APPLICATION_CODE
	OpenconfigTransportTypes_SONET_APPLICATION_CODE_VSR2000_3R5 E_OpenconfigTransportTypes_SONET_APPLICATION_CODE = 4
)


// E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE. An additional value named
// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE int64

// IsYANGGoEnum ensures that OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE.
func (E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_UNSET corresponds to the value UNSET of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_UNSET E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 0
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_CFP corresponds to the value CFP of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_CFP E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 1
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_CFP2 corresponds to the value CFP2 of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_CFP2 E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 2
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_CFP2_ACO corresponds to the value CFP2_ACO of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_CFP2_ACO E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 3
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_CFP4 corresponds to the value CFP4 of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_CFP4 E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 4
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_CPAK corresponds to the value CPAK of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_CPAK E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 5
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_NON_PLUGGABLE corresponds to the value NON_PLUGGABLE of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_NON_PLUGGABLE E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 6
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_OTHER corresponds to the value OTHER of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_OTHER E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 7
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_QSFP corresponds to the value QSFP of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_QSFP E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 8
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_QSFP28 corresponds to the value QSFP28 of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_QSFP28 E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 9
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_QSFP_PLUS corresponds to the value QSFP_PLUS of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_QSFP_PLUS E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 10
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_SFP corresponds to the value SFP of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_SFP E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 11
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_SFP_PLUS corresponds to the value SFP_PLUS of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_SFP_PLUS E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 12
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_X2 corresponds to the value X2 of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_X2 E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 13
	// OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_XFP corresponds to the value XFP of OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE
	OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE_XFP E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE = 14
)


// E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE. An additional value named
// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE int64

// IsYANGGoEnum ensures that OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE.
func (E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_UNSET corresponds to the value UNSET of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_UNSET E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 0
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_100GE corresponds to the value PROT_100GE of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_100GE E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 1
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_100G_MLG corresponds to the value PROT_100G_MLG of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_100G_MLG E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 2
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_10GE_LAN corresponds to the value PROT_10GE_LAN of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_10GE_LAN E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 3
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_10GE_WAN corresponds to the value PROT_10GE_WAN of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_10GE_WAN E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 4
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_1GE corresponds to the value PROT_1GE of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_1GE E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 5
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_40GE corresponds to the value PROT_40GE of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_40GE E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 6
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OC192 corresponds to the value PROT_OC192 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OC192 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 7
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OC48 corresponds to the value PROT_OC48 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OC48 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 8
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OC768 corresponds to the value PROT_OC768 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OC768 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 9
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_ODU2 corresponds to the value PROT_ODU2 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_ODU2 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 10
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_ODU2E corresponds to the value PROT_ODU2E of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_ODU2E E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 11
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_ODU3 corresponds to the value PROT_ODU3 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_ODU3 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 12
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_ODU4 corresponds to the value PROT_ODU4 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_ODU4 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 13
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_ODUCN corresponds to the value PROT_ODUCN of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_ODUCN E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 14
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTU1E corresponds to the value PROT_OTU1E of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTU1E E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 15
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTU2 corresponds to the value PROT_OTU2 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTU2 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 16
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTU2E corresponds to the value PROT_OTU2E of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTU2E E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 17
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTU3 corresponds to the value PROT_OTU3 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTU3 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 18
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTU4 corresponds to the value PROT_OTU4 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTU4 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 19
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTUCN corresponds to the value PROT_OTUCN of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_OTUCN E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 20
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_STM16 corresponds to the value PROT_STM16 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_STM16 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 21
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_STM256 corresponds to the value PROT_STM256 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_STM256 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 22
	// OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_STM64 corresponds to the value PROT_STM64 of OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE
	OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE_PROT_STM64 E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE = 23
)


// E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE. An additional value named
// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE int64

// IsYANGGoEnum ensures that OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE.
func (E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_UNSET corresponds to the value UNSET of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_UNSET E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 0
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_1000G corresponds to the value TRIB_RATE_1000G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_1000G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 1
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_100G corresponds to the value TRIB_RATE_100G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_100G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 2
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_10G corresponds to the value TRIB_RATE_10G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_10G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 3
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_1100G corresponds to the value TRIB_RATE_1100G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_1100G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 4
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_150G corresponds to the value TRIB_RATE_150G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_150G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 5
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_1G corresponds to the value TRIB_RATE_1G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_1G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 6
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_2_5G corresponds to the value TRIB_RATE_2_5G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_2_5G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 7
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_200G corresponds to the value TRIB_RATE_200G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_200G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 8
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_250G corresponds to the value TRIB_RATE_250G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_250G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 9
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_300G corresponds to the value TRIB_RATE_300G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_300G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 10
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_400G corresponds to the value TRIB_RATE_400G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_400G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 11
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_40G corresponds to the value TRIB_RATE_40G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_40G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 12
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_500G corresponds to the value TRIB_RATE_500G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_500G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 13
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_600G corresponds to the value TRIB_RATE_600G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_600G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 14
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_700G corresponds to the value TRIB_RATE_700G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_700G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 15
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_800G corresponds to the value TRIB_RATE_800G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_800G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 16
	// OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_900G corresponds to the value TRIB_RATE_900G of OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE
	OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE_TRIB_RATE_900G E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE = 17
)


// E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY is a derived int64 type which is used to represent
// the enumerated node OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY. An additional value named
// OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY int64

// IsYANGGoEnum ensures that OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY implements the yang.GoEnum
// interface. This ensures that OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY.
func (E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

const (
	// OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY_UNSET corresponds to the value UNSET of OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY
	OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY_UNSET E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY = 0
	// OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY_TRIB_SLOT_1_25G corresponds to the value TRIB_SLOT_1_25G of OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY
	OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY_TRIB_SLOT_1_25G E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY = 1
	// OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY_TRIB_SLOT_2_5G corresponds to the value TRIB_SLOT_2_5G of OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY
	OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY_TRIB_SLOT_2_5G E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY = 2
	// OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY_TRIB_SLOT_5G corresponds to the value TRIB_SLOT_5G of OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY
	OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY_TRIB_SLOT_5G E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY = 3
)


// ΛEnum is a map, keyed by the name of the type defined for each enum in the
// generated Go code, which provides a mapping between the constant int64 value
// of each value of the enumeration, and the string that is used to represent it
// in the YANG schema. The map is named ΛEnum in order to avoid clash with any
// valid YANG identifier.
var ΛEnum = map[string]map[int64]ygot.EnumDefinition{
	"E_IETFInterfaces_InterfaceType": {
	},
	"E_IETFInterfaces_InterfacesState_Interface_AdminStatus": {
		2: {Name: "up"},
		3: {Name: "down"},
		4: {Name: "testing"},
	},
	"E_IETFInterfaces_InterfacesState_Interface_OperStatus": {
		2: {Name: "up"},
		3: {Name: "down"},
		4: {Name: "testing"},
		5: {Name: "unknown"},
		6: {Name: "dormant"},
		7: {Name: "not-present"},
		8: {Name: "lower-layer-down"},
	},
	"E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY": {
		1: {Name: "CRITICAL", DefiningModule: "openconfig-alarm-types"},
		2: {Name: "MAJOR", DefiningModule: "openconfig-alarm-types"},
		3: {Name: "MINOR", DefiningModule: "openconfig-alarm-types"},
		4: {Name: "UNKNOWN", DefiningModule: "openconfig-alarm-types"},
		5: {Name: "WARNING", DefiningModule: "openconfig-alarm-types"},
	},
	"E_OpenconfigIfEthernet_ETHERNET_SPEED": {
		1: {Name: "SPEED_100GB", DefiningModule: "openconfig-if-ethernet"},
		2: {Name: "SPEED_100MB", DefiningModule: "openconfig-if-ethernet"},
		3: {Name: "SPEED_10GB", DefiningModule: "openconfig-if-ethernet"},
		4: {Name: "SPEED_10MB", DefiningModule: "openconfig-if-ethernet"},
		5: {Name: "SPEED_1GB", DefiningModule: "openconfig-if-ethernet"},
		6: {Name: "SPEED_2500MB", DefiningModule: "openconfig-if-ethernet"},
		7: {Name: "SPEED_25GB", DefiningModule: "openconfig-if-ethernet"},
		8: {Name: "SPEED_40GB", DefiningModule: "openconfig-if-ethernet"},
		9: {Name: "SPEED_50GB", DefiningModule: "openconfig-if-ethernet"},
		10: {Name: "SPEED_5GB", DefiningModule: "openconfig-if-ethernet"},
		11: {Name: "SPEED_UNKNOWN", DefiningModule: "openconfig-if-ethernet"},
	},
	"E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode": {
		1: {Name: "FULL"},
		2: {Name: "HALF"},
	},
	"E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode": {
		1: {Name: "FULL"},
		2: {Name: "HALF"},
	},
	"E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus": {
		1: {Name: "UP"},
		2: {Name: "DOWN"},
		3: {Name: "TESTING"},
	},
	"E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus": {
		2: {Name: "UP"},
		3: {Name: "DOWN"},
		4: {Name: "TESTING"},
		5: {Name: "UNKNOWN"},
		6: {Name: "DORMANT"},
		7: {Name: "NOT_PRESENT"},
		8: {Name: "LOWER_LAYER_DOWN"},
	},
	"E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY": {
		1: {Name: "C_VLAN", DefiningModule: "openconfig-lldp-types"},
		2: {Name: "DOCSIS_CABLE_DEVICE", DefiningModule: "openconfig-lldp-types"},
		3: {Name: "MAC_BRIDGE", DefiningModule: "openconfig-lldp-types"},
		4: {Name: "OTHER", DefiningModule: "openconfig-lldp-types"},
		5: {Name: "REPEATER", DefiningModule: "openconfig-lldp-types"},
		6: {Name: "ROUTER", DefiningModule: "openconfig-lldp-types"},
		7: {Name: "STATION_ONLY", DefiningModule: "openconfig-lldp-types"},
		8: {Name: "S_VLAN", DefiningModule: "openconfig-lldp-types"},
		9: {Name: "TELEPHONE", DefiningModule: "openconfig-lldp-types"},
		10: {Name: "TWO_PORT_MAC_RELAY", DefiningModule: "openconfig-lldp-types"},
		11: {Name: "WLAN_ACCESS_POINT", DefiningModule: "openconfig-lldp-types"},
	},
	"E_OpenconfigLldpTypes_LLDP_TLV": {
		1: {Name: "CHASSIS_ID", DefiningModule: "openconfig-lldp-types"},
		2: {Name: "MANAGEMENT_ADDRESS", DefiningModule: "openconfig-lldp-types"},
		3: {Name: "PORT_DESCRIPTION", DefiningModule: "openconfig-lldp-types"},
		4: {Name: "PORT_ID", DefiningModule: "openconfig-lldp-types"},
		5: {Name: "SYSTEM_CAPABILITIES", DefiningModule: "openconfig-lldp-types"},
		6: {Name: "SYSTEM_DESCRIPTION", DefiningModule: "openconfig-lldp-types"},
		7: {Name: "SYSTEM_NAME", DefiningModule: "openconfig-lldp-types"},
	},
	"E_OpenconfigLldp_ChassisIdType": {
		1: {Name: "CHASSIS_COMPONENT"},
		2: {Name: "INTERFACE_ALIAS"},
		3: {Name: "PORT_COMPONENT"},
		4: {Name: "MAC_ADDRESS"},
		5: {Name: "NETWORK_ADDRESS"},
		6: {Name: "INTERFACE_NAME"},
		7: {Name: "LOCAL"},
	},
	"E_OpenconfigLldp_PortIdType": {
		1: {Name: "INTERFACE_ALIAS"},
		2: {Name: "PORT_COMPONENT"},
		3: {Name: "MAC_ADDRESS"},
		4: {Name: "NETWORK_ADDRESS"},
		5: {Name: "INTERFACE_NAME"},
		6: {Name: "AGENT_CIRCUIT_ID"},
		7: {Name: "LOCAL"},
	},
	"E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS": {
		1: {Name: "ACTIVE", DefiningModule: "openconfig-platform-types"},
		2: {Name: "DISABLED", DefiningModule: "openconfig-platform-types"},
		3: {Name: "INACTIVE", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatformTypes_FEC_MODE_TYPE": {
		1: {Name: "FEC_AUTO", DefiningModule: "openconfig-platform-types"},
		2: {Name: "FEC_DISABLED", DefiningModule: "openconfig-platform-types"},
		3: {Name: "FEC_ENABLED", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatformTypes_FEC_STATUS_TYPE": {
		1: {Name: "FEC_STATUS_LOCKED", DefiningModule: "openconfig-platform-types"},
		2: {Name: "FEC_STATUS_UNLOCKED", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT": {
		1: {Name: "BACKPLANE", DefiningModule: "openconfig-platform-types"},
		2: {Name: "CHASSIS", DefiningModule: "openconfig-platform-types"},
		3: {Name: "CONTROLLER_CARD", DefiningModule: "openconfig-platform-types"},
		4: {Name: "CPU", DefiningModule: "openconfig-platform-types"},
		5: {Name: "FABRIC", DefiningModule: "openconfig-platform-types"},
		6: {Name: "FAN", DefiningModule: "openconfig-platform-types"},
		7: {Name: "FRU", DefiningModule: "openconfig-platform-types"},
		8: {Name: "INTEGRATED_CIRCUIT", DefiningModule: "openconfig-platform-types"},
		9: {Name: "LINECARD", DefiningModule: "openconfig-platform-types"},
		10: {Name: "OPTICAL_CHANNEL", DefiningModule: "openconfig-transport-types"},
		11: {Name: "PORT", DefiningModule: "openconfig-platform-types"},
		12: {Name: "POWER_SUPPLY", DefiningModule: "openconfig-platform-types"},
		13: {Name: "SENSOR", DefiningModule: "openconfig-platform-types"},
		14: {Name: "STORAGE", DefiningModule: "openconfig-platform-types"},
		15: {Name: "TRANSCEIVER", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT": {
		1: {Name: "OPERATING_SYSTEM", DefiningModule: "openconfig-platform-types"},
		2: {Name: "OPERATING_SYSTEM_UPDATE", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatform_Components_Component_Transceiver_State_Present": {
		1: {Name: "PRESENT"},
		2: {Name: "NOT_PRESENT"},
	},
	"E_OpenconfigTerminalDevice_AdminStateType": {
		1: {Name: "ENABLED"},
		2: {Name: "DISABLED"},
		3: {Name: "MAINT"},
	},
	"E_OpenconfigTerminalDevice_LoopbackModeType": {
		1: {Name: "NONE"},
		2: {Name: "FACILITY"},
		3: {Name: "TERMINAL"},
	},
	"E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls": {
		1: {Name: "NONE"},
		2: {Name: "LASER_SHUTDOWN"},
		3: {Name: "ETHERNET"},
	},
	"E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType": {
		1: {Name: "LOGICAL_CHANNEL"},
		2: {Name: "OPTICAL_CHANNEL"},
	},
	"E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState": {
		1: {Name: "UP"},
		2: {Name: "DOWN"},
		3: {Name: "TESTING"},
	},
	"E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE": {
		1: {Name: "ETH_100GBASE_CLR4", DefiningModule: "openconfig-transport-types"},
		2: {Name: "ETH_100GBASE_CR4", DefiningModule: "openconfig-transport-types"},
		3: {Name: "ETH_100GBASE_CWDM4", DefiningModule: "openconfig-transport-types"},
		4: {Name: "ETH_100GBASE_ER4", DefiningModule: "openconfig-transport-types"},
		5: {Name: "ETH_100GBASE_LR4", DefiningModule: "openconfig-transport-types"},
		6: {Name: "ETH_100GBASE_PSM4", DefiningModule: "openconfig-transport-types"},
		7: {Name: "ETH_100GBASE_SR10", DefiningModule: "openconfig-transport-types"},
		8: {Name: "ETH_100GBASE_SR4", DefiningModule: "openconfig-transport-types"},
		9: {Name: "ETH_100G_ACC", DefiningModule: "openconfig-transport-types"},
		10: {Name: "ETH_100G_AOC", DefiningModule: "openconfig-transport-types"},
		11: {Name: "ETH_10GBASE_ER", DefiningModule: "openconfig-transport-types"},
		12: {Name: "ETH_10GBASE_LR", DefiningModule: "openconfig-transport-types"},
		13: {Name: "ETH_10GBASE_LRM", DefiningModule: "openconfig-transport-types"},
		14: {Name: "ETH_10GBASE_SR", DefiningModule: "openconfig-transport-types"},
		15: {Name: "ETH_10GBASE_ZR", DefiningModule: "openconfig-transport-types"},
		16: {Name: "ETH_40GBASE_CR4", DefiningModule: "openconfig-transport-types"},
		17: {Name: "ETH_40GBASE_ER4", DefiningModule: "openconfig-transport-types"},
		18: {Name: "ETH_40GBASE_LR4", DefiningModule: "openconfig-transport-types"},
		19: {Name: "ETH_40GBASE_PSM4", DefiningModule: "openconfig-transport-types"},
		20: {Name: "ETH_40GBASE_SR4", DefiningModule: "openconfig-transport-types"},
		21: {Name: "ETH_4X10GBASE_LR", DefiningModule: "openconfig-transport-types"},
		22: {Name: "ETH_4X10GBASE_SR", DefiningModule: "openconfig-transport-types"},
		23: {Name: "ETH_UNDEFINED", DefiningModule: "openconfig-transport-types"},
	},
	"E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE": {
		1: {Name: "LC_CONNECTOR", DefiningModule: "openconfig-transport-types"},
		2: {Name: "MPO_CONNECTOR", DefiningModule: "openconfig-transport-types"},
		3: {Name: "SC_CONNECTOR", DefiningModule: "openconfig-transport-types"},
	},
	"E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL": {
		1: {Name: "AMP", DefiningModule: "openconfig-transport-types"},
		2: {Name: "BMP", DefiningModule: "openconfig-transport-types"},
		3: {Name: "CBR", DefiningModule: "openconfig-transport-types"},
		4: {Name: "GFP_F", DefiningModule: "openconfig-transport-types"},
		5: {Name: "GFP_T", DefiningModule: "openconfig-transport-types"},
		6: {Name: "GMP", DefiningModule: "openconfig-transport-types"},
	},
	"E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE": {
		1: {Name: "PROT_ETHERNET", DefiningModule: "openconfig-transport-types"},
		2: {Name: "PROT_OTN", DefiningModule: "openconfig-transport-types"},
	},
	"E_OpenconfigTransportTypes_OTN_APPLICATION_CODE": {
		1: {Name: "OTN_UNDEFINED", DefiningModule: "openconfig-transport-types"},
		2: {Name: "P1L1_2D1", DefiningModule: "openconfig-transport-types"},
		3: {Name: "P1L1_2D2", DefiningModule: "openconfig-transport-types"},
		4: {Name: "P1S1_2D2", DefiningModule: "openconfig-transport-types"},
	},
	"E_OpenconfigTransportTypes_SONET_APPLICATION_CODE": {
		1: {Name: "SONET_UNDEFINED", DefiningModule: "openconfig-transport-types"},
		2: {Name: "VSR2000_3R2", DefiningModule: "openconfig-transport-types"},
		3: {Name: "VSR2000_3R3", DefiningModule: "openconfig-transport-types"},
		4: {Name: "VSR2000_3R5", DefiningModule: "openconfig-transport-types"},
	},
	"E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE": {
		1: {Name: "CFP", DefiningModule: "openconfig-transport-types"},
		2: {Name: "CFP2", DefiningModule: "openconfig-transport-types"},
		3: {Name: "CFP2_ACO", DefiningModule: "openconfig-transport-types"},
		4: {Name: "CFP4", DefiningModule: "openconfig-transport-types"},
		5: {Name: "CPAK", DefiningModule: "openconfig-transport-types"},
		6: {Name: "NON_PLUGGABLE", DefiningModule: "openconfig-transport-types"},
		7: {Name: "OTHER", DefiningModule: "openconfig-transport-types"},
		8: {Name: "QSFP", DefiningModule: "openconfig-transport-types"},
		9: {Name: "QSFP28", DefiningModule: "openconfig-transport-types"},
		10: {Name: "QSFP_PLUS", DefiningModule: "openconfig-transport-types"},
		11: {Name: "SFP", DefiningModule: "openconfig-transport-types"},
		12: {Name: "SFP_PLUS", DefiningModule: "openconfig-transport-types"},
		13: {Name: "X2", DefiningModule: "openconfig-transport-types"},
		14: {Name: "XFP", DefiningModule: "openconfig-transport-types"},
	},
	"E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE": {
		1: {Name: "PROT_100GE", DefiningModule: "openconfig-transport-types"},
		2: {Name: "PROT_100G_MLG", DefiningModule: "openconfig-transport-types"},
		3: {Name: "PROT_10GE_LAN", DefiningModule: "openconfig-transport-types"},
		4: {Name: "PROT_10GE_WAN", DefiningModule: "openconfig-transport-types"},
		5: {Name: "PROT_1GE", DefiningModule: "openconfig-transport-types"},
		6: {Name: "PROT_40GE", DefiningModule: "openconfig-transport-types"},
		7: {Name: "PROT_OC192", DefiningModule: "openconfig-transport-types"},
		8: {Name: "PROT_OC48", DefiningModule: "openconfig-transport-types"},
		9: {Name: "PROT_OC768", DefiningModule: "openconfig-transport-types"},
		10: {Name: "PROT_ODU2", DefiningModule: "openconfig-transport-types"},
		11: {Name: "PROT_ODU2E", DefiningModule: "openconfig-transport-types"},
		12: {Name: "PROT_ODU3", DefiningModule: "openconfig-transport-types"},
		13: {Name: "PROT_ODU4", DefiningModule: "openconfig-transport-types"},
		14: {Name: "PROT_ODUCN", DefiningModule: "openconfig-transport-types"},
		15: {Name: "PROT_OTU1E", DefiningModule: "openconfig-transport-types"},
		16: {Name: "PROT_OTU2", DefiningModule: "openconfig-transport-types"},
		17: {Name: "PROT_OTU2E", DefiningModule: "openconfig-transport-types"},
		18: {Name: "PROT_OTU3", DefiningModule: "openconfig-transport-types"},
		19: {Name: "PROT_OTU4", DefiningModule: "openconfig-transport-types"},
		20: {Name: "PROT_OTUCN", DefiningModule: "openconfig-transport-types"},
		21: {Name: "PROT_STM16", DefiningModule: "openconfig-transport-types"},
		22: {Name: "PROT_STM256", DefiningModule: "openconfig-transport-types"},
		23: {Name: "PROT_STM64", DefiningModule: "openconfig-transport-types"},
	},
	"E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE": {
		1: {Name: "TRIB_RATE_1000G", DefiningModule: "openconfig-transport-types"},
		2: {Name: "TRIB_RATE_100G", DefiningModule: "openconfig-transport-types"},
		3: {Name: "TRIB_RATE_10G", DefiningModule: "openconfig-transport-types"},
		4: {Name: "TRIB_RATE_1100G", DefiningModule: "openconfig-transport-types"},
		5: {Name: "TRIB_RATE_150G", DefiningModule: "openconfig-transport-types"},
		6: {Name: "TRIB_RATE_1G", DefiningModule: "openconfig-transport-types"},
		7: {Name: "TRIB_RATE_2.5G", DefiningModule: "openconfig-transport-types"},
		8: {Name: "TRIB_RATE_200G", DefiningModule: "openconfig-transport-types"},
		9: {Name: "TRIB_RATE_250G", DefiningModule: "openconfig-transport-types"},
		10: {Name: "TRIB_RATE_300G", DefiningModule: "openconfig-transport-types"},
		11: {Name: "TRIB_RATE_400G", DefiningModule: "openconfig-transport-types"},
		12: {Name: "TRIB_RATE_40G", DefiningModule: "openconfig-transport-types"},
		13: {Name: "TRIB_RATE_500G", DefiningModule: "openconfig-transport-types"},
		14: {Name: "TRIB_RATE_600G", DefiningModule: "openconfig-transport-types"},
		15: {Name: "TRIB_RATE_700G", DefiningModule: "openconfig-transport-types"},
		16: {Name: "TRIB_RATE_800G", DefiningModule: "openconfig-transport-types"},
		17: {Name: "TRIB_RATE_900G", DefiningModule: "openconfig-transport-types"},
	},
	"E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY": {
		1: {Name: "TRIB_SLOT_1.25G", DefiningModule: "openconfig-transport-types"},
		2: {Name: "TRIB_SLOT_2.5G", DefiningModule: "openconfig-transport-types"},
		3: {Name: "TRIB_SLOT_5G", DefiningModule: "openconfig-transport-types"},
	},
}


var (
	// ySchema is a byte slice contain a gzip compressed representation of the
	// YANG schema from which the Go code was generated. When uncompressed the
	// contents of the byte slice is a JSON document containing an object, keyed
	// on the name of the generated struct, and containing the JSON marshalled
	// contents of a goyang yang.Entry struct, which defines the schema for the
	// fields within the struct.
	ySchema = []byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0xbd, 0x6b, 0x73, 0xdb, 0xb8,
		0x96, 0xf7, 0xfb, 0xde, 0x9f, 0x42, 0xa5, 0x9a, 0x17, 0xdd, 0x67, 0x87, 0xb1, 0x24, 0xcb, 0xb7,
		0x54, 0x9d, 0x9a, 0x92, 0x6d, 0x25, 0xf1, 0x69, 0x5f, 0xf4, 0x58, 0xca, 0xee, 0xe9, 0xdd, 0xf6,
		0xa8, 0x68, 0x12, 0xb2, 0xf9, 0x84, 0x22, 0x35, 0x24, 0xe4, 0x8e, 0x77, 0x4f, 0xbe, 0xfb, 0x29,
		0xdd, 0xa8, 0xbb, 0x44, 0x00, 0x0b, 0x14, 0x49, 0xfd, 0xbb, 0x76, 0xed, 0x38, 0x8e, 0x08, 0x91,
		0x00, 0xd6, 0x5a, 0xbf, 0xf5, 0x07, 0xb8, 0xf0, 0xf7, 0x41, 0xa1, 0x50, 0x28, 0x14, 0xef, 0xcc,
		0x2e, 0x2b, 0x7e, 0x2a, 0x14, 0x6d, 0xf6, 0xe6, 0x58, 0xac, 0xf8, 0x61, 0xf4, 0xdb, 0xdf, 0x1c,
		0xcf, 0x2e, 0x7e, 0x2a, 0x94, 0xc7, 0x7f, 0xbd, 0xf4, 0xbd, 0x8e, 0xf3, 0x52, 0xfc, 0x54, 0x28,
		0x8d, 0x7f, 0x71, 0xe5, 0x04, 0xc5, 0x4f, 0x85, 0x51, 0x13, 0xc3, 0x5f, 0x58, 0x7e, 0xb7, 0xe7,
		0x7b, 0xcc, 0xe3, 0xe1, 0xdc, 0xef, 0xe7, 0xbe, 0x62, 0xe6, 0x33, 0x1f, 0xe6, 0x3f, 0x31, 0xff,
		0x75, 0xd1, 0xaf, 0x17, 0xbf, 0x36, 0xfa, 0x87, 0x46, 0xc0, 0x3a, 0xce, 0x8f, 0xa5, 0x6f, 0x9a,
		0xfb, 0x36, 0xdf, 0x32, 0x7a, 0xae, 0xc9, 0x3b, 0x7e, 0xd0, 0x5d, 0xf8, 0xba, 0xe1, 0xc7, 0x9a,
		0x7e, 0x3f, 0xb0, 0xd8, 0xca, 0x26, 0x46, 0xb7, 0xc4, 0xde, 0xff, 0xf2, 0x83, 0xc1, 0x5d, 0x15,
		0x7b, 0xa3, 0x6f, 0xfb, 0xb0, 0xfa, 0x83, 0x5f, 0xcd, 0xb0, 0x16, 0xbc, 0xf4, 0xbb, 0xcc, 0xe3,
		0xc5, 0x4f, 0x05, 0x1e, 0xf4, 0xd9, 0x9a, 0x0f, 0xce, 0x7c, 0x6a, 0xee, 0xe6, 0x96, 0x3e, 0xfd,
		0x73, 0xee, 0x37, 0x3f, 0x17, 0x9e, 0x7d, 0xb1, 0xeb, 0x97, 0x87, 0x60, 0xfd, 0x43, 0x2d, 0x8d,
		0xc4, 0xba, 0x87, 0x5a, 0x3d, 0x20, 0x5b, 0x07, 0x26, 0xce, 0x00, 0x09, 0x0e, 0x54, 0xdc, 0x01,
		0x13, 0x1e, 0x38, 0xe1, 0x01, 0x14, 0x1f, 0xc8, 0xd5, 0x03, 0xba, 0x66, 0x60, 0xb7, 0x0e, 0x70,
		0xf4, 0x81, 0x67, 0xd3, 0xfa, 0xde, 0x73, 0x4d, 0x2f, 0x46, 0x67, 0x4c, 0xfa, 0x78, 0x7a, 0xc9,
		0x96, 0x67, 0xdb, 0x3c, 0xf0, 0xb1, 0x27, 0x80, 0xc8, 0x44, 0x90, 0x9c, 0x10, 0xa2, 0x13, 0x43,
		0x7a, 0x82, 0x48, 0x4f, 0x14, 0xf9, 0x09, 0xb3, 0x79, 0xe2, 0x6c, 0x99, 0x40, 0xb1, 0x27, 0xd2,
		0x8c, 0xe7, 0x18, 0x8f, 0x66, 0xcc, 0x1e, 0x9c, 0xba, 0x91, 0xe1, 0x75, 0x31, 0x7b, 0x21, 0xde,
		0xd4, 0x12, 0x9e, 0x62, 0x32, 0x53, 0x4d, 0x71, 0xca, 0xc9, 0x4e, 0x3d, 0xe5, 0x29, 0xa8, 0x3c,
		0x15, 0xd5, 0xa7, 0x64, 0xbc, 0xa9, 0x19, 0x73, 0x8a, 0x4e, 0x6f, 0xc7, 0xf3, 0x7c, 0x6e, 0x72,
		0xc7, 0xf7, 0xc4, 0xc6, 0x2f, 0xb4, 0x5e, 0x59, 0xd7, 0xec, 0x99, 0xfc, 0x75, 0xf0, 0x20, 0x87,
		0x7e, 0x8f, 0x79, 0xa3, 0x49, 0x19, 0x3d, 0xd1, 0xe1, 0x94, 0x3a, 0xa6, 0x3f, 0x1e, 0x46, 0xfe,
		0xf0, 0x50, 0x68, 0x0e, 0x8f, 0xbe, 0x93, 0x07, 0x7d, 0x8b, 0x7b, 0xe3, 0x99, 0x73, 0x1f, 0x7d,
		0x65, 0x63, 0xfc, 0x8d, 0xed, 0xcb, 0xe8, 0x1b, 0xa7, 0x3f, 0xb6, 0x2f, 0x26, 0xdf, 0xd8, 0x1e,
		0x4f, 0xec, 0x03, 0x9a, 0x5e, 0x8e, 0xd1, 0xc3, 0xc5, 0x90, 0x9b, 0x9c, 0x89, 0x9b, 0xf7, 0xe8,
		0x32, 0xcd, 0xd6, 0x5d, 0x81, 0x75, 0xc3, 0xba, 0xb5, 0x59, 0xb7, 0xc8, 0x14, 0x26, 0x31, 0xee,
		0xe6, 0xf0, 0x0b, 0xa9, 0x6c, 0x5b, 0x29, 0xfc, 0x0b, 0xf6, 0xba, 0x7a, 0x6f, 0x17, 0x63, 0xb9,
		0x22, 0xa5, 0xfe, 0xdd, 0xdc, 0xb3, 0xeb, 0xfb, 0x6b, 0x43, 0x5f, 0x15, 0xad, 0x57, 0x33, 0x0c,
		0x9d, 0x30, 0x3e, 0x4c, 0x4f, 0x2e, 0x00, 0x4a, 0x03, 0xa5, 0x81, 0xd2, 0x08, 0xb6, 0xfb, 0x1d,
		0x6c, 0xc7, 0xde, 0x30, 0x31, 0x90, 0xbe, 0x1c, 0x7d, 0x1f, 0x30, 0x1a, 0x18, 0x0d, 0xcb, 0x4e,
		0xc4, 0xb2, 0x13, 0x82, 0xe8, 0x89, 0x61, 0xef, 0x21, 0x42, 0xc7, 0x23, 0x4a, 0xf5, 0xbe, 0xd5,
		0x82, 0xcf, 0xf1, 0x88, 0x47, 0x8c, 0x74, 0x00, 0xcf, 0xfb, 0x08, 0xcf, 0xe3, 0x59, 0x2d, 0x18,
		0x5f, 0x87, 0x57, 0x89, 0x85, 0xd7, 0x12, 0xc0, 0x19, 0xe1, 0x75, 0xf1, 0x76, 0x5a, 0xef, 0x3d,
		0x26, 0x37, 0x72, 0x21, 0x0f, 0x1c, 0x4f, 0x08, 0x7d, 0x27, 0xee, 0xed, 0x6c, 0xbf, 0xc2, 0x5c,
		0xdc, 0x14, 0x41, 0x36, 0xca, 0xc5, 0x48, 0x09, 0x24, 0x83, 0x5c, 0xaf, 0x2f, 0x10, 0xe1, 0x7a,
		0x7d, 0x84, 0x37, 0x84, 0x37, 0x68, 0x43, 0x08, 0x71, 0xfb, 0x9e, 0x41, 0xf6, 0xfa, 0xc9, 0xe9,
		0x42, 0xbd, 0x3e, 0x34, 0x21, 0x68, 0x42, 0xb0, 0x68, 0xed, 0x16, 0x9d, 0x94, 0x1e, 0xd4, 0xeb,
		0xef, 0xa5, 0x16, 0xb4, 0x95, 0x1e, 0xd5, 0xfa, 0x54, 0x07, 0x1e, 0x77, 0xcc, 0xe7, 0xc0, 0xb1,
		0xe2, 0x13, 0xf2, 0xf8, 0xf3, 0x80, 0x64, 0x40, 0x32, 0x20, 0x19, 0x21, 0x75, 0xbf, 0x43, 0xea,
		0xc8, 0x19, 0x26, 0xc6, 0xc9, 0x9f, 0x87, 0x5f, 0x07, 0x54, 0x06, 0x2a, 0xc3, 0xae, 0x93, 0xb0,
		0xeb, 0x84, 0x68, 0x79, 0x6c, 0xd6, 0x7b, 0x08, 0xcc, 0xb1, 0x60, 0x52, 0xb9, 0x67, 0xf5, 0x60,
		0xb3, 0x27, 0xc2, 0xcc, 0x1e, 0x80, 0x19, 0xc0, 0x0c, 0x60, 0x46, 0x60, 0xdd, 0xfb, 0xc0, 0xea,
		0x25, 0x48, 0xcb, 0x1e, 0x50, 0x19, 0xa8, 0x0c, 0x8b, 0xd6, 0x6e, 0xd1, 0x89, 0x71, 0xb2, 0xb7,
		0x9f, 0x90, 0xec, 0xe9, 0x24, 0x64, 0x4f, 0x07, 0x1e, 0x3b, 0x1e, 0x67, 0x2f, 0x81, 0xc9, 0x99,
		0x6d, 0x58, 0x4e, 0x60, 0xf5, 0x1d, 0x1e, 0x9f, 0x96, 0x57, 0x5c, 0x0b, 0x78, 0x06, 0x3c, 0x03,
		0x9e, 0x11, 0x6a, 0xf7, 0x3b, 0xd4, 0x2e, 0x3b, 0xc6, 0xc4, 0x58, 0xfa, 0x3a, 0xfa, 0xea, 0xcb,
		0xd1, 0x37, 0x83, 0xac, 0x41, 0xd6, 0x30, 0xf7, 0xa4, 0xcd, 0x3d, 0x21, 0xd0, 0x5e, 0xb6, 0xf6,
		0x3d, 0xc4, 0x6e, 0x61, 0x0c, 0xa5, 0xec, 0x70, 0x1d, 0x4c, 0x1e, 0xeb, 0x15, 0x0d, 0x91, 0x57,
		0x33, 0x62, 0xbe, 0x92, 0x01, 0xee, 0xce, 0x02, 0x77, 0xc7, 0x7e, 0x85, 0x22, 0xea, 0x79, 0x97,
		0x99, 0x9d, 0x80, 0x75, 0xe2, 0xf4, 0xfa, 0x24, 0xac, 0x9e, 0xc6, 0xf8, 0x6c, 0x63, 0x6c, 0xa9,
		0x1f, 0x3f, 0x8e, 0xe9, 0xe6, 0x70, 0x38, 0x15, 0x35, 0x18, 0x84, 0xdf, 0xe3, 0x8e, 0x65, 0xba,
		0x86, 0xf5, 0x6a, 0x7a, 0x1e, 0x73, 0xe3, 0xdb, 0xc6, 0xe2, 0x85, 0xd9, 0x48, 0x4f, 0xfd, 0x1e,
		0x37, 0x38, 0xcb, 0xa9, 0x99, 0x44, 0x0f, 0x87, 0xf4, 0x34, 0x45, 0xe9, 0xa9, 0xc0, 0x94, 0xcb,
		0x1f, 0xaf, 0xc6, 0x9f, 0x92, 0x7a, 0x78, 0x35, 0xee, 0x54, 0x8d, 0x2e, 0xe8, 0x04, 0xec, 0x7f,
		0xfa, 0xcc, 0xb3, 0xde, 0xc5, 0x3b, 0x3f, 0x5a, 0xe9, 0x8e, 0x9a, 0x10, 0xec, 0x3b, 0xb1, 0xb7,
		0x3b, 0xa5, 0x27, 0xb4, 0xca, 0xc4, 0x26, 0x9a, 0xe0, 0xaa, 0x13, 0x9d, 0x6c, 0xc2, 0x93, 0x4d,
		0x7c, 0x3a, 0x03, 0x10, 0x33, 0x04, 0x41, 0x83, 0x10, 0x47, 0x9d, 0xed, 0xd3, 0xdc, 0xe0, 0x83,
		0xb6, 0x24, 0x06, 0x7f, 0x3c, 0xdf, 0xcf, 0x24, 0x2e, 0xfd, 0xe6, 0x39, 0xc3, 0x52, 0xcd, 0xc5,
		0xdb, 0xaf, 0xff, 0x96, 0xf9, 0xea, 0x07, 0xd3, 0x7b, 0x19, 0x3c, 0xc5, 0x9f, 0x52, 0x83, 0x2c,
		0x37, 0x59, 0x87, 0x5f, 0x7c, 0xeb, 0x78, 0xd2, 0xb3, 0x5d, 0xd1, 0x51, 0x2c, 0x35, 0xf3, 0x4f,
		0xd3, 0xed, 0x33, 0x82, 0x76, 0x3e, 0x07, 0xa6, 0x35, 0xc8, 0x45, 0xaf, 0x9c, 0x97, 0xd1, 0xa8,
		0x94, 0xa4, 0xdb, 0xfb, 0xf9, 0x41, 0xa1, 0x6b, 0xcd, 0x1f, 0xa9, 0xeb, 0xda, 0xf2, 0x59, 0xb5,
		0x7a, 0x72, 0x5a, 0xad, 0x96, 0x4e, 0x8f, 0x4e, 0x4b, 0xe7, 0xc7, 0xc7, 0xe5, 0x93, 0xf2, 0x71,
		0x8a, 0x7a, 0xfb, 0x20, 0x99, 0xab, 0x9e, 0x0e, 0xf4, 0xb4, 0x2f, 0x30, 0x5b, 0x8a, 0xae, 0xe3,
		0x31, 0xa3, 0xe7, 0x07, 0x5c, 0x3e, 0xb0, 0x4f, 0x9b, 0x40, 0x60, 0x47, 0x60, 0xcf, 0x6d, 0x60,
		0x8f, 0xaf, 0x69, 0xa8, 0x68, 0x1c, 0x6b, 0x35, 0x8f, 0xc3, 0x19, 0xc1, 0xe7, 0xd3, 0x8c, 0x2a,
		0xb9, 0xf2, 0xd7, 0x73, 0xbf, 0xdd, 0xae, 0x91, 0x24, 0xe3, 0x6a, 0xfc, 0x1e, 0x0b, 0x86, 0xe2,
		0xac, 0xe9, 0x1a, 0x5d, 0xdf, 0x66, 0xf2, 0x1e, 0x67, 0xa9, 0x25, 0x38, 0x1e, 0x38, 0x9e, 0xdc,
		0x3a, 0x9e, 0xbe, 0xe3, 0xf1, 0xf2, 0x89, 0x82, 0xdf, 0x39, 0x41, 0x26, 0x80, 0x4c, 0x20, 0xa5,
		0x99, 0xc0, 0xc9, 0xf1, 0xf1, 0x11, 0xd0, 0x7f, 0x27, 0xf1, 0x98, 0x9b, 0xc1, 0x0b, 0xe3, 0x86,
		0xdf, 0xe7, 0xbd, 0x3e, 0x37, 0x7a, 0xfe, 0x5f, 0x2c, 0x90, 0x0f, 0xc9, 0xab, 0x1a, 0x43, 0x54,
		0x46, 0x54, 0xce, 0x6d, 0x54, 0xb6, 0x99, 0xe5, 0x74, 0x4d, 0xf7, 0xa4, 0xaa, 0x92, 0x10, 0x54,
		0x24, 0xae, 0x5d, 0xf2, 0x76, 0x95, 0x7d, 0x0d, 0xef, 0x15, 0x84, 0x77, 0x5d, 0xe1, 0xfd, 0x28,
		0x87, 0x5d, 0x9b, 0xf5, 0xd0, 0x9e, 0xe9, 0x1d, 0x6b, 0x0b, 0xfb, 0x22, 0x12, 0xdb, 0x9d, 0x7a,
		0x3f, 0xfa, 0xde, 0xcb, 0xd1, 0xd7, 0x62, 0x6b, 0xea, 0x2e, 0xb6, 0xa6, 0x62, 0xa9, 0x3f, 0x4b,
		0x4b, 0xfd, 0xd6, 0x6b, 0xe0, 0x77, 0x4d, 0xee, 0x58, 0x86, 0xed, 0x84, 0x3d, 0x16, 0x84, 0xa2,
		0x3e, 0xa2, 0x30, 0x7f, 0xaa, 0xce, 0x8a, 0xd6, 0xe4, 0x12, 0x83, 0x32, 0x12, 0x03, 0x24, 0x06,
		0xba, 0x13, 0x03, 0x51, 0x73, 0x89, 0x2e, 0x34, 0xdf, 0x5e, 0xe4, 0x87, 0x6b, 0x32, 0x6b, 0x06,
		0x8d, 0x48, 0xf6, 0xaf, 0x9a, 0x2e, 0x23, 0x6d, 0x2c, 0x14, 0x46, 0xb3, 0xd6, 0x78, 0xde, 0x7b,
		0x2c, 0x2c, 0x2a, 0x10, 0xb1, 0xa2, 0x15, 0x91, 0x5b, 0x13, 0xb9, 0x55, 0x6d, 0xb4, 0xae, 0x61,
		0xef, 0x25, 0x8d, 0xcb, 0x92, 0xb3, 0x47, 0x3a, 0x1f, 0x27, 0xcd, 0xcb, 0x29, 0xf2, 0x73, 0xd2,
		0x3c, 0x9d, 0x28, 0x5f, 0x57, 0xcf, 0xdb, 0x49, 0xf3, 0x77, 0xe2, 0x3c, 0x9e, 0x3a, 0xe9, 0xd4,
		0x91, 0x7c, 0x12, 0xe4, 0xf7, 0xa4, 0x79, 0x3e, 0x71, 0xbe, 0x9f, 0xa9, 0x21, 0x38, 0xd8, 0xcd,
		0xd5, 0x4f, 0x09, 0xe9, 0x0f, 0x12, 0x53, 0xac, 0xe8, 0x78, 0x21, 0x37, 0x3d, 0xae, 0x0e, 0x30,
		0x93, 0x86, 0x00, 0x31, 0x80, 0x18, 0x40, 0x0c, 0x20, 0x06, 0x10, 0x03, 0x88, 0x01, 0xc4, 0x00,
		0x62, 0x92, 0x81, 0x18, 0xce, 0x82, 0x37, 0xd3, 0xa5, 0xa0, 0x98, 0x71, 0x4b, 0xc0, 0x98, 0x41,
		0x20, 0x06, 0xc2, 0xc8, 0x22, 0xcc, 0x9e, 0xe2, 0x4b, 0xc8, 0x4d, 0x6e, 0x28, 0x1a, 0x51, 0x41,
		0xed, 0x55, 0xa8, 0xa8, 0x89, 0xe8, 0x95, 0x28, 0xcf, 0xf4, 0xfc, 0x90, 0x59, 0xbe, 0x67, 0x2b,
		0xcd, 0xe5, 0x5c, 0x43, 0x4c, 0x09, 0x10, 0xb3, 0x6b, 0x88, 0xa1, 0x1e, 0x02, 0xfa, 0x57, 0xad,
		0xc0, 0x35, 0xc9, 0x72, 0x4d, 0x57, 0x61, 0x96, 0x45, 0x2e, 0x79, 0xd0, 0x08, 0x68, 0x06, 0xa2,
		0x0c, 0x44, 0x19, 0x88, 0x32, 0x10, 0x65, 0xc0, 0x33, 0x10, 0x65, 0x00, 0x2f, 0x09, 0xc1, 0x8b,
		0xc1, 0x9d, 0x2e, 0x23, 0x21, 0x98, 0x51, 0x4b, 0xc0, 0x18, 0x88, 0x32, 0x10, 0x65, 0x84, 0xe7,
		0xcc, 0xc0, 0x76, 0xb8, 0x63, 0x7d, 0x0f, 0x49, 0x00, 0x06, 0x92, 0x0c, 0x24, 0x19, 0x48, 0x32,
		0x90, 0x64, 0xf6, 0x94, 0x6a, 0x14, 0x0c, 0x7d, 0x0a, 0x34, 0x8e, 0x07, 0x96, 0x81, 0x24, 0x03,
		0x49, 0x06, 0x92, 0x0c, 0x24, 0x19, 0xf0, 0x0c, 0x24, 0x19, 0xc0, 0x4b, 0x52, 0xf0, 0x42, 0x25,
		0xc9, 0x4c, 0x5a, 0x02, 0xc6, 0x40, 0x92, 0x81, 0x24, 0x03, 0x49, 0x06, 0x92, 0x0c, 0x10, 0x06,
		0x92, 0x0c, 0xa8, 0x46, 0x95, 0x6a, 0xb4, 0xbe, 0xe2, 0x2d, 0x59, 0xfa, 0x24, 0xba, 0x9e, 0xaa,
		0x04, 0xca, 0xb0, 0xc4, 0xc7, 0x21, 0x41, 0x81, 0x84, 0x02, 0x59, 0x79, 0x94, 0xe1, 0x59, 0x5e,
		0xed, 0xcb, 0xc9, 0x2d, 0x5d, 0x4d, 0xef, 0x28, 0x05, 0xf5, 0xea, 0x70, 0x06, 0x85, 0x9c, 0xb0,
		0x86, 0x12, 0x14, 0x1b, 0x74, 0x33, 0x9c, 0x41, 0x41, 0x8c, 0x94, 0x38, 0x83, 0x02, 0x95, 0x67,
		0xb5, 0x20, 0x20, 0xce, 0xa0, 0xd0, 0x71, 0x55, 0x1a, 0x0a, 0xd1, 0xbe, 0x04, 0x7e, 0xbf, 0x67,
		0x38, 0xb6, 0x7c, 0x5c, 0x8f, 0x5a, 0x40, 0x58, 0x47, 0x58, 0xcf, 0x75, 0x21, 0xf8, 0xa3, 0x8a,
		0x42, 0x38, 0x3f, 0x45, 0x38, 0x46, 0x38, 0x4e, 0x69, 0x38, 0xae, 0x56, 0xce, 0xab, 0xe7, 0x27,
		0xa7, 0x95, 0x73, 0x04, 0xe1, 0x9d, 0x04, 0x61, 0xc7, 0x23, 0xa8, 0x02, 0x3f, 0xdb, 0xc8, 0x7e,
		0x14, 0x79, 0xe4, 0x81, 0xe9, 0x85, 0x16, 0x73, 0xde, 0x84, 0x9f, 0x78, 0x3f, 0xa2, 0xf1, 0x6c,
		0xff, 0xa0, 0xd4, 0x23, 0x4a, 0x3d, 0xae, 0x32, 0x21, 0x2c, 0x9b, 0xca, 0x1a, 0x17, 0x76, 0x7d,
		0xa9, 0xe2, 0x0b, 0x76, 0x7d, 0x69, 0x01, 0xef, 0xc5, 0x6e, 0xc6, 0xae, 0xaf, 0xc4, 0x01, 0x7d,
		0x71, 0x08, 0xb0, 0xeb, 0x4b, 0xfb, 0xd5, 0x28, 0xf1, 0x08, 0x78, 0x01, 0xbc, 0x00, 0x5e, 0x00,
		0x2f, 0x80, 0x17, 0xc0, 0x0b, 0xe0, 0x05, 0xf0, 0x42, 0x06, 0x2f, 0x28, 0xed, 0x08, 0x7c, 0x01,
		0xbe, 0xa0, 0xb4, 0xe3, 0x6c, 0x13, 0xd8, 0xb4, 0xae, 0xdf, 0x63, 0x01, 0x62, 0xd2, 0x3b, 0x04,
		0xd8, 0xb4, 0x9e, 0x75, 0xae, 0x41, 0x69, 0x47, 0xd0, 0x0c, 0x68, 0x06, 0x62, 0x0c, 0xc4, 0x18,
		0x88, 0x31, 0x10, 0x63, 0x00, 0x2d, 0x59, 0x81, 0x16, 0x94, 0x74, 0x04, 0xbe, 0x00, 0x5f, 0x50,
		0x3f, 0x00, 0x52, 0x0c, 0xa4, 0x18, 0x48, 0x31, 0x90, 0x62, 0xf2, 0x40, 0x35, 0x28, 0xe9, 0x08,
		0x96, 0x01, 0xcb, 0x40, 0x8a, 0x81, 0x14, 0x03, 0x29, 0x06, 0x52, 0x0c, 0xa0, 0x25, 0x23, 0xd0,
		0x82, 0x52, 0x8e, 0xc0, 0x17, 0xe0, 0x0b, 0xa4, 0x18, 0x48, 0x31, 0x90, 0x62, 0x20, 0xc5, 0x40,
		0x8a, 0x49, 0x1b, 0xd5, 0xec, 0x51, 0x29, 0x47, 0xf9, 0xea, 0x07, 0x05, 0xe2, 0x0a, 0x8e, 0xd7,
		0x83, 0x3b, 0x69, 0x0c, 0x6f, 0x24, 0x05, 0xa5, 0x25, 0x5c, 0x33, 0x64, 0x81, 0xf1, 0xec, 0x98,
		0xa1, 0x61, 0xf5, 0x83, 0x80, 0x49, 0xbc, 0x85, 0x16, 0xc5, 0xd9, 0x15, 0x6d, 0xa1, 0xd0, 0x84,
		0x7e, 0x1e, 0x45, 0xa1, 0x09, 0x05, 0x2f, 0x85, 0x42, 0x13, 0x48, 0xea, 0x90, 0xd4, 0x65, 0x30,
		0xa9, 0x83, 0x26, 0x9d, 0xb9, 0x84, 0x0e, 0x9a, 0xf4, 0xce, 0x13, 0x3a, 0x68, 0xd2, 0xf9, 0xc9,
		0xde, 0x50, 0x68, 0x02, 0xf0, 0x02, 0x78, 0x01, 0xbc, 0x00, 0x5e, 0x00, 0x2f, 0x80, 0x17, 0xc0,
		0x4b, 0xfe, 0xe1, 0x05, 0x85, 0x26, 0x80, 0x2f, 0xc0, 0x17, 0x14, 0x9a, 0x98, 0x6d, 0x02, 0x4b,
		0xea, 0xfa, 0x3d, 0x16, 0x20, 0x26, 0xbd, 0x43, 0x80, 0x25, 0xf5, 0xac, 0x73, 0x0d, 0x0a, 0x4d,
		0x80, 0x66, 0x40, 0x33, 0x10, 0x63, 0x20, 0xc6, 0x40, 0x8c, 0x81, 0x18, 0x03, 0x68, 0xc9, 0x0a,
		0xb4, 0xa0, 0xd0, 0x04, 0xf0, 0x05, 0xf8, 0x82, 0xb7, 0x1b, 0x20, 0xc5, 0x40, 0x8a, 0x81, 0x14,
		0x03, 0x29, 0x26, 0x0f, 0x54, 0x83, 0x42, 0x13, 0x60, 0x19, 0xb0, 0x0c, 0xa4, 0x18, 0x48, 0x31,
		0x90, 0x62, 0x20, 0xc5, 0x00, 0x5a, 0x32, 0x02, 0x2d, 0x28, 0x34, 0x01, 0x7c, 0x01, 0xbe, 0x40,
		0x8a, 0x81, 0x14, 0x03, 0x29, 0x06, 0x52, 0x0c, 0xa4, 0x98, 0xb4, 0x51, 0xcd, 0x1e, 0x15, 0x9a,
		0x50, 0x2e, 0x82, 0x50, 0x20, 0xae, 0x37, 0x71, 0x33, 0xb8, 0xa1, 0x0b, 0xc7, 0x0c, 0x2f, 0xc7,
		0xb7, 0x93, 0x86, 0xaa, 0x13, 0x8e, 0xc7, 0x8c, 0x9e, 0x1f, 0xa8, 0x14, 0x9b, 0x88, 0x9a, 0x90,
		0xab, 0x31, 0x51, 0xca, 0x58, 0x8d, 0x09, 0xbf, 0xc7, 0x0d, 0xce, 0x82, 0x2e, 0x0a, 0x4c, 0xac,
		0xe0, 0xcd, 0xa8, 0x73, 0x52, 0xe6, 0x9a, 0xa4, 0xd1, 0x72, 0x3a, 0xcd, 0x99, 0xd9, 0x09, 0x58,
		0x47, 0x66, 0xd4, 0x27, 0x3a, 0xd8, 0xa9, 0xc4, 0xb5, 0x8d, 0xc8, 0x1b, 0x5a, 0x91, 0x17, 0xfc,
		0x34, 0xe3, 0x05, 0x57, 0xfe, 0x7a, 0xee, 0xb7, 0x43, 0xdf, 0x95, 0x02, 0x57, 0xe3, 0xf7, 0x58,
		0x30, 0x0c, 0x0e, 0xa6, 0x6b, 0x74, 0x7d, 0x9b, 0xc9, 0x7b, 0x9c, 0xa5, 0x96, 0xe0, 0x78, 0xe0,
		0x78, 0x72, 0xeb, 0x78, 0xfa, 0x8e, 0xc7, 0xcb, 0x27, 0x0a, 0x7e, 0xe7, 0x44, 0xe2, 0x52, 0xb5,
		0x34, 0x53, 0x21, 0x83, 0xa7, 0x48, 0x2b, 0x89, 0x72, 0x19, 0xaa, 0x34, 0x92, 0x32, 0x51, 0x51,
		0x48, 0x1b, 0x49, 0xd2, 0x45, 0xea, 0xae, 0x3d, 0x39, 0x3e, 0x3e, 0x3a, 0x4e, 0x51, 0xf7, 0x26,
		0x94, 0x87, 0x3d, 0xa5, 0x21, 0x1e, 0xf7, 0xf9, 0xb4, 0x12, 0x9f, 0x7c, 0x2c, 0x9e, 0x6d, 0x05,
		0x45, 0xe6, 0x10, 0x8a, 0x51, 0x64, 0x6e, 0xed, 0xdc, 0x41, 0x91, 0x39, 0x2c, 0xe8, 0x28, 0x1b,
		0x17, 0xf6, 0xa3, 0xa8, 0xb2, 0x0b, 0xf6, 0xa3, 0x68, 0xa1, 0xee, 0xc5, 0x6e, 0xc6, 0x7e, 0x94,
		0xc4, 0xe9, 0x7c, 0x71, 0x08, 0xb0, 0x1f, 0x45, 0xfb, 0xd5, 0x28, 0x32, 0x07, 0x78, 0x01, 0xbc,
		0x00, 0x5e, 0x00, 0x2f, 0x80, 0x17, 0xc0, 0x0b, 0xe0, 0x05, 0xf0, 0x42, 0x06, 0x2f, 0x28, 0x32,
		0x07, 0x7c, 0x01, 0xbe, 0xa0, 0xc8, 0xdc, 0x6c, 0x13, 0xd8, 0x4e, 0xab, 0xdf, 0x63, 0x01, 0x62,
		0xd2, 0x3b, 0x04, 0xd8, 0x4e, 0x9b, 0x75, 0xae, 0x41, 0x91, 0x39, 0xd0, 0x0c, 0x68, 0x06, 0x62,
		0x0c, 0xc4, 0x18, 0x88, 0x31, 0x10, 0x63, 0x00, 0x2d, 0x59, 0x81, 0x16, 0x14, 0x99, 0x03, 0xbe,
		0x00, 0x5f, 0xf0, 0x66, 0x33, 0xa4, 0x18, 0x48, 0x31, 0x90, 0x62, 0x20, 0xc5, 0xe4, 0x81, 0x6a,
		0x50, 0x64, 0x0e, 0x2c, 0x03, 0x96, 0x81, 0x14, 0x03, 0x29, 0x06, 0x52, 0x0c, 0xa4, 0x18, 0x40,
		0x4b, 0x46, 0xa0, 0x05, 0x45, 0xe6, 0x80, 0x2f, 0xc0, 0x17, 0x48, 0x31, 0x90, 0x62, 0x20, 0xc5,
		0x40, 0x8a, 0x81, 0x14, 0x93, 0x36, 0xaa, 0xd9, 0xa3, 0x22, 0x73, 0x0a, 0xe5, 0x0f, 0x0a, 0xc4,
		0xe5, 0xe5, 0xee, 0x87, 0xb7, 0xd2, 0x18, 0xde, 0x49, 0x0a, 0xca, 0x4b, 0xf4, 0x7c, 0xd7, 0x0c,
		0x9c, 0x7f, 0x0f, 0x47, 0xca, 0xb0, 0x59, 0x8f, 0x79, 0x36, 0xf3, 0xb8, 0xe1, 0xfa, 0x61, 0x28,
		0x5f, 0x6d, 0x62, 0x53, 0xa3, 0xfb, 0x51, 0x7c, 0x02, 0x45, 0xa0, 0x36, 0x80, 0x68, 0x5a, 0x8b,
		0x40, 0xa1, 0xec, 0x04, 0x52, 0x3c, 0xa4, 0x78, 0x19, 0x4c, 0xf1, 0xa0, 0x50, 0x67, 0x2e, 0xbd,
		0x83, 0x42, 0xbd, 0xf3, 0xf4, 0x0e, 0x0a, 0x75, 0x7e, 0x72, 0x39, 0x94, 0x9d, 0x00, 0xbc, 0x00,
		0x5e, 0x00, 0x2f, 0x80, 0x17, 0xc0, 0x0b, 0xe0, 0x05, 0xf0, 0x92, 0x7f, 0x78, 0x41, 0xd9, 0x09,
		0xe0, 0x0b, 0xf0, 0x05, 0x65, 0x27, 0x66, 0x9b, 0xc0, 0x02, 0xbb, 0x7e, 0x8f, 0x05, 0x88, 0x49,
		0xef, 0x10, 0x60, 0x81, 0x3d, 0xeb, 0x5c, 0x83, 0xb2, 0x13, 0xa0, 0x19, 0xd0, 0x0c, 0xc4, 0x18,
		0x88, 0x31, 0x10, 0x63, 0x20, 0xc6, 0x00, 0x5a, 0xb2, 0x02, 0x2d, 0x28, 0x3b, 0x01, 0x7c, 0x01,
		0xbe, 0xe0, 0x5d, 0x07, 0x48, 0x31, 0x90, 0x62, 0x20, 0xc5, 0x40, 0x8a, 0xc9, 0x03, 0xd5, 0xa0,
		0xec, 0x04, 0x58, 0x06, 0x2c, 0x03, 0x29, 0x06, 0x52, 0x0c, 0xa4, 0x18, 0x48, 0x31, 0x80, 0x96,
		0x8c, 0x40, 0x0b, 0xca, 0x4e, 0x00, 0x5f, 0x80, 0x2f, 0x90, 0x62, 0x20, 0xc5, 0x40, 0x8a, 0x81,
		0x14, 0x03, 0x29, 0x26, 0x6d, 0x54, 0xb3, 0x47, 0x65, 0x27, 0xe8, 0xea, 0x20, 0x14, 0x88, 0xab,
		0x50, 0x34, 0x66, 0xee, 0xec, 0x6a, 0x72, 0x63, 0x37, 0x83, 0xfb, 0x4a, 0x5b, 0x4d, 0x8a, 0xae,
		0x6f, 0x33, 0xc3, 0x76, 0xc2, 0x1e, 0x0b, 0x42, 0x99, 0x61, 0x5d, 0x5d, 0x94, 0x62, 0xb1, 0x55,
		0x54, 0xa5, 0xd0, 0xcc, 0xaf, 0xa8, 0x4a, 0x21, 0xeb, 0xd2, 0x50, 0x95, 0x22, 0x1d, 0x19, 0xe0,
		0x70, 0x7e, 0x20, 0x0b, 0x54, 0xb1, 0x2e, 0x08, 0xd9, 0xaa, 0x6c, 0x0c, 0x21, 0x3b, 0x91, 0x2c,
		0x10, 0x42, 0xf6, 0xce, 0xb3, 0x40, 0x08, 0xd9, 0xf9, 0x49, 0xf9, 0x50, 0x9d, 0x02, 0x10, 0x03,
		0x88, 0x01, 0xc4, 0x00, 0x62, 0x00, 0x31, 0x80, 0x18, 0x40, 0xcc, 0xfe, 0x40, 0x0c, 0xaa, 0x54,
		0x68, 0xc1, 0x18, 0x20, 0x8c, 0x2c, 0xc2, 0xa0, 0x4a, 0x05, 0xaa, 0x54, 0x64, 0x09, 0x62, 0xb0,
		0x1e, 0xbf, 0x73, 0x88, 0xc1, 0x7a, 0x3c, 0xb8, 0x66, 0xbe, 0x9b, 0x51, 0xa5, 0x02, 0xa2, 0x0c,
		0x44, 0x19, 0x88, 0x32, 0x10, 0x65, 0x20, 0xca, 0x40, 0x94, 0x81, 0x28, 0x93, 0x35, 0x78, 0x41,
		0xb5, 0x0a, 0x88, 0x32, 0x10, 0x65, 0xf0, 0x8a, 0x04, 0x24, 0x19, 0x48, 0x32, 0x90, 0x64, 0x20,
		0xc9, 0xe4, 0x81, 0x6a, 0x50, 0xad, 0x02, 0x92, 0x0c, 0x24, 0x19, 0x48, 0x32, 0x90, 0x64, 0x20,
		0xc9, 0x40, 0x92, 0x01, 0xbc, 0x64, 0x0c, 0x5e, 0x50, 0xb5, 0x02, 0x92, 0x0c, 0x24, 0x19, 0x48,
		0x32, 0x90, 0x64, 0x20, 0xc9, 0x40, 0x92, 0x81, 0x24, 0x93, 0x36, 0xaa, 0xd9, 0xd7, 0xaa, 0x15,
		0x6a, 0x85, 0x12, 0x0a, 0x1a, 0xcb, 0x56, 0xdc, 0xfa, 0x36, 0xbb, 0x9a, 0xde, 0x58, 0x0a, 0xea,
		0x56, 0x8c, 0xa2, 0x94, 0xe1, 0x07, 0x36, 0x0b, 0x0c, 0x3d, 0x45, 0x2c, 0xe2, 0x7f, 0x05, 0x2a,
		0x5a, 0x68, 0x66, 0x5b, 0x54, 0xb4, 0x90, 0x75, 0x77, 0xa8, 0x68, 0x01, 0x91, 0x3b, 0xfb, 0x19,
		0x22, 0x44, 0x6e, 0x88, 0xdc, 0xd9, 0xc9, 0x10, 0x21, 0x72, 0xef, 0x3c, 0x43, 0x84, 0xc8, 0x9d,
		0x9f, 0x74, 0x10, 0x15, 0x2d, 0x00, 0x31, 0x80, 0x18, 0x40, 0x0c, 0x20, 0x06, 0x10, 0x03, 0x88,
		0x01, 0xc4, 0xec, 0x0f, 0xc4, 0xa0, 0xa2, 0x85, 0x16, 0x8c, 0x01, 0xc2, 0xc8, 0x22, 0x0c, 0x2a,
		0x5a, 0xa0, 0xa2, 0x45, 0x96, 0x20, 0x06, 0x6b, 0xf5, 0x3b, 0x87, 0x18, 0xac, 0xd5, 0x83, 0x6b,
		0xe6, 0xbb, 0x19, 0x15, 0x2d, 0x20, 0xca, 0x40, 0x94, 0x81, 0x28, 0x03, 0x51, 0x06, 0xa2, 0x0c,
		0x44, 0x19, 0x88, 0x32, 0x59, 0x83, 0x17, 0x54, 0xb4, 0x80, 0x28, 0x03, 0x51, 0x06, 0xaf, 0x4f,
		0x40, 0x92, 0x81, 0x24, 0x03, 0x49, 0x06, 0x92, 0x4c, 0x1e, 0xa8, 0x06, 0x15, 0x2d, 0x20, 0xc9,
		0x40, 0x92, 0x81, 0x24, 0x03, 0x49, 0x06, 0x92, 0x0c, 0x24, 0x19, 0xc0, 0x4b, 0xc6, 0xe0, 0x05,
		0x15, 0x2d, 0x20, 0xc9, 0x40, 0x92, 0x81, 0x24, 0x03, 0x49, 0x06, 0x92, 0x0c, 0x24, 0x19, 0x48,
		0x32, 0x69, 0xa3, 0x9a, 0x3d, 0xaa, 0x68, 0xa1, 0xab, 0x6a, 0x42, 0x81, 0xb8, 0xbc, 0x45, 0x73,
		0x78, 0x9f, 0xf7, 0x83, 0xdb, 0x4c, 0x77, 0xa5, 0x0b, 0x6e, 0x06, 0x2f, 0x8c, 0x1b, 0x7e, 0x9f,
		0xf7, 0xfa, 0xdc, 0xe8, 0xf9, 0x7f, 0xb1, 0x40, 0xbe, 0xa6, 0xc5, 0xaa, 0xc6, 0xe4, 0xaa, 0x57,
		0x94, 0x50, 0xbd, 0x22, 0x71, 0x7e, 0xdd, 0xbb, 0xea, 0x15, 0xd2, 0x68, 0x4a, 0xa2, 0xa8, 0xa9,
		0x28, 0x69, 0x24, 0x0a, 0x9a, 0x22, 0x76, 0x2a, 0x10, 0x3d, 0x05, 0x66, 0x12, 0x29, 0x64, 0x54,
		0x58, 0x49, 0x09, 0x2e, 0x0a, 0x18, 0x49, 0x82, 0x8f, 0x44, 0xca, 0x57, 0x2a, 0xbb, 0x36, 0x21,
		0x26, 0x7b, 0xd2, 0x15, 0xda, 0x0f, 0x08, 0x27, 0x90, 0x2c, 0xdb, 0xd1, 0x32, 0x5d, 0x51, 0xa4,
		0x2e, 0x17, 0x19, 0xa1, 0xc5, 0x8b, 0x45, 0xdb, 0xbb, 0x7b, 0xf3, 0x27, 0xb6, 0x0c, 0x84, 0xe8,
		0x00, 0x50, 0x75, 0x7c, 0x8c, 0x2e, 0x27, 0xe9, 0xea, 0xcd, 0x9d, 0xbc, 0xbe, 0xeb, 0x36, 0x74,
		0x5b, 0xb1, 0xe7, 0x07, 0xdb, 0x2b, 0x2f, 0x44, 0x01, 0x7a, 0xf8, 0xe9, 0x2d, 0x83, 0x10, 0xaf,
		0x60, 0x5a, 0x6c, 0xc4, 0x14, 0x41, 0xca, 0x59, 0x84, 0x9c, 0x8c, 0x60, 0x9c, 0xc1, 0x11, 0x44,
		0x46, 0x69, 0x44, 0x94, 0x46, 0xc2, 0x45, 0x04, 0x8c, 0x1e, 0x4e, 0xb3, 0x41, 0xc5, 0x2d, 0x48,
		0x56, 0x7c, 0x0e, 0x98, 0xf9, 0xdd, 0xef, 0xf3, 0x61, 0xde, 0x18, 0xbf, 0x23, 0x27, 0xe3, 0x35,
		0x7f, 0x79, 0xcc, 0x3e, 0x11, 0xab, 0xcc, 0x27, 0x9c, 0xd3, 0xc8, 0xe4, 0x32, 0x73, 0x13, 0x70,
		0xbb, 0xad, 0x50, 0xe4, 0x2d, 0xca, 0xf9, 0x8a, 0x72, 0x9e, 0xb2, 0x34, 0x39, 0x07, 0x0f, 0xbe,
		0xa3, 0x10, 0x2c, 0x5a, 0x41, 0xaf, 0x68, 0x4d, 0x66, 0x85, 0x64, 0x8e, 0x3e, 0xbe, 0x7e, 0x3f,
		0x8a, 0x4a, 0x0a, 0x4e, 0xe9, 0xfd, 0x49, 0xc9, 0xc5, 0xa6, 0x7c, 0x32, 0xe9, 0xb8, 0x74, 0x31,
		0xc9, 0x31, 0xd5, 0x18, 0x61, 0x8f, 0x31, 0x5b, 0x7d, 0x9d, 0x76, 0xbe, 0x39, 0x2c, 0xd6, 0x2a,
		0x18, 0x12, 0x95, 0x41, 0x91, 0x1b, 0x16, 0xb9, 0x81, 0xd1, 0x1a, 0x9a, 0x62, 0xba, 0xba, 0xf3,
		0xa5, 0x5a, 0xc7, 0x66, 0x1e, 0x77, 0xf8, 0x7b, 0xc0, 0x3a, 0x14, 0x7b, 0xcd, 0x14, 0x16, 0x97,
		0x8a, 0xd7, 0xe3, 0x5b, 0xb9, 0x30, 0x43, 0x82, 0xf9, 0x37, 0x79, 0xc0, 0x7a, 0xeb, 0x6b, 0xfd,
		0xe1, 0xae, 0xde, 0x6a, 0x37, 0x1b, 0xf5, 0xfa, 0x55, 0x91, 0x42, 0x28, 0x09, 0x95, 0x17, 0x80,
		0x0b, 0x24, 0x8b, 0xc0, 0x73, 0xcf, 0x39, 0x7c, 0xbc, 0x76, 0xb9, 0x54, 0xfa, 0x72, 0x51, 0x4c,
		0xc3, 0xf2, 0xa8, 0x96, 0xc7, 0x3b, 0xce, 0xf5, 0xd3, 0x95, 0x4b, 0xa5, 0xdb, 0x3c, 0x3f, 0x5e,
		0x9e, 0xc7, 0xae, 0x72, 0x9c, 0xef, 0x99, 0x99, 0xeb, 0x89, 0x99, 0x6b, 0xaf, 0xf2, 0xed, 0xee,
		0xb7, 0xbb, 0xfb, 0xdf, 0xef, 0x72, 0x1c, 0x14, 0xf2, 0xed, 0x57, 0xf2, 0x1d, 0x14, 0xaa, 0x34,
		0xb6, 0xa7, 0xd4, 0xc2, 0x53, 0xea, 0x17, 0xa9, 0x64, 0xb6, 0x43, 0x7b, 0xfd, 0xee, 0x64, 0x15,
		0x21, 0x54, 0x4f, 0xb5, 0xe7, 0x5a, 0x43, 0xa6, 0x8d, 0x4c, 0x1b, 0x99, 0xb6, 0xe0, 0x8c, 0xe9,
		0x3b, 0x1e, 0x3f, 0x23, 0xc8, 0xb1, 0x8f, 0xb1, 0x7d, 0x99, 0xd4, 0xaf, 0xac, 0xce, 0xf1, 0xb1,
		0x7d, 0x39, 0x0d, 0x43, 0x50, 0x39, 0xc6, 0x6e, 0x65, 0x22, 0x5c, 0xc1, 0x6e, 0xe5, 0xd1, 0x06,
		0x8b, 0x41, 0xf0, 0x39, 0x9c, 0x5b, 0x14, 0x3e, 0x94, 0x5a, 0x68, 0x2b, 0xc8, 0x6f, 0xbd, 0x68,
		0xf8, 0x01, 0x6f, 0x5f, 0x8c, 0x6f, 0xe1, 0xd6, 0xb7, 0x59, 0x7b, 0x8c, 0x36, 0x69, 0x38, 0x4f,
		0x6f, 0xb8, 0xe5, 0x46, 0xfe, 0xac, 0x3c, 0xc1, 0x7d, 0x42, 0x05, 0x8a, 0x25, 0xcb, 0x0a, 0x96,
		0x2c, 0x77, 0xca, 0x79, 0x58, 0xb2, 0x8c, 0x3f, 0x6f, 0xb0, 0x64, 0x89, 0x44, 0x0a, 0x89, 0x94,
		0xd2, 0x8c, 0xc1, 0x92, 0xa5, 0x38, 0x4b, 0x63, 0xc9, 0x72, 0x57, 0x8f, 0x87, 0x25, 0xcb, 0x2c,
		0x3f, 0x1e, 0x96, 0x2c, 0xb3, 0x3b, 0x33, 0xb1, 0x64, 0x99, 0xd5, 0xa7, 0xc3, 0x92, 0x65, 0xb6,
		0xfd, 0x0a, 0x96, 0x2c, 0x75, 0xab, 0x87, 0x58, 0xb2, 0xdc, 0x3e, 0x5a, 0x58, 0xb2, 0x44, 0xa6,
		0x8d, 0x4c, 0x5b, 0x65, 0xc6, 0x60, 0xc9, 0x72, 0xe6, 0x46, 0xb0, 0x64, 0xb9, 0xeb, 0x68, 0x8e,
		0x25, 0xcb, 0xdd, 0x42, 0x07, 0x96, 0x2c, 0x53, 0xb3, 0x64, 0x29, 0xb3, 0xce, 0x56, 0xa0, 0x5c,
		0xb1, 0x14, 0x78, 0x35, 0x5f, 0x7c, 0x70, 0xb2, 0x5d, 0x3b, 0x61, 0x79, 0xb8, 0xf4, 0x17, 0x4e,
		0x58, 0x1a, 0x20, 0xb2, 0xaa, 0x09, 0x31, 0xde, 0x71, 0x17, 0x7c, 0xd1, 0x55, 0xee, 0x05, 0xd7,
		0xd4, 0xbf, 0x93, 0x1d, 0xbf, 0x28, 0x80, 0x2a, 0x4e, 0xa7, 0xf0, 0xbd, 0xec, 0xd8, 0x45, 0x03,
		0x72, 0x64, 0xe2, 0xc2, 0xdb, 0x46, 0x54, 0x6c, 0x5b, 0x64, 0x87, 0x08, 0x8d, 0x55, 0x8b, 0xed,
		0x04, 0x91, 0xda, 0x01, 0x22, 0x6d, 0xd3, 0x15, 0xd8, 0x34, 0x6c, 0x5a, 0x87, 0x4d, 0x27, 0x54,
		0xe7, 0x68, 0x68, 0xd2, 0x69, 0xaa, 0x6e, 0xd4, 0x7f, 0x19, 0x8c, 0xfc, 0x70, 0x83, 0xcb, 0xf6,
		0x44, 0x5b, 0xd0, 0x23, 0x1c, 0xce, 0x4c, 0xa6, 0x4f, 0x33, 0x5d, 0xbf, 0xf2, 0xd7, 0x73, 0xbf,
		0x15, 0x90, 0xab, 0x8a, 0x57, 0x2c, 0xb4, 0x02, 0xa7, 0x37, 0x9e, 0x2f, 0xc5, 0x9a, 0x6d, 0x3b,
		0xde, 0x4b, 0x61, 0xd0, 0x42, 0x61, 0xc2, 0x62, 0x05, 0xdb, 0xe4, 0x66, 0x81, 0xfb, 0x85, 0xde,
		0xeb, 0x7b, 0xe8, 0x58, 0xa6, 0x5b, 0x98, 0x7c, 0xd3, 0xf0, 0x5f, 0x50, 0x1c, 0x26, 0xe3, 0x0e,
		0x2b, 0x4b, 0xc5, 0x61, 0xe4, 0xaa, 0x1a, 0x2d, 0x8d, 0xb7, 0x6c, 0x9a, 0xb1, 0xca, 0x64, 0x5a,
		0x7e, 0xcf, 0x70, 0xd9, 0x1b, 0x73, 0x0b, 0x96, 0xef, 0x71, 0xd3, 0xf1, 0x58, 0x50, 0xe8, 0xf8,
		0xc1, 0x0a, 0x1b, 0x42, 0x4d, 0x1a, 0x9d, 0x2a, 0x39, 0x36, 0x78, 0x6a, 0x51, 0x0b, 0x14, 0x43,
		0xe8, 0x53, 0x4a, 0x0a, 0x04, 0xc6, 0x9c, 0x94, 0x0a, 0x60, 0xa2, 0xa7, 0x16, 0xe0, 0x5f, 0x2c,
		0x30, 0xc2, 0x7e, 0xaf, 0xe7, 0xbe, 0x8b, 0xd4, 0x04, 0x9c, 0xb9, 0x0a, 0xb5, 0x01, 0x51, 0x1b,
		0x10, 0xca, 0x13, 0xb2, 0xd4, 0x7d, 0xcf, 0x52, 0xa7, 0x2e, 0x31, 0x41, 0x05, 0xea, 0x2f, 0x16,
		0x34, 0x87, 0xdf, 0x09, 0x21, 0x0a, 0x42, 0x14, 0x4c, 0x3c, 0x39, 0x13, 0x4f, 0x4c, 0x90, 0x9a,
		0x5a, 0xf8, 0x1e, 0x56, 0xdd, 0x16, 0x00, 0x4d, 0x9a, 0x4e, 0xd6, 0xc2, 0xd8, 0x81, 0xdf, 0x63,
		0x01, 0x77, 0x58, 0x28, 0x40, 0xd8, 0xd3, 0x6b, 0xc0, 0xd7, 0xe0, 0xeb, 0x35, 0x53, 0xea, 0x5d,
		0x3c, 0xfa, 0x46, 0x57, 0x82, 0xb1, 0x11, 0x80, 0x93, 0x16, 0x57, 0x51, 0x79, 0x5b, 0xef, 0xd4,
		0xde, 0x23, 0xa5, 0x53, 0x78, 0xea, 0x4b, 0xaa, 0x9d, 0x49, 0xbd, 0xce, 0x3e, 0x66, 0x16, 0xd5,
		0xad, 0xf5, 0x26, 0x0e, 0x47, 0x56, 0x37, 0x1f, 0x2a, 0x33, 0x22, 0x37, 0x27, 0x72, 0xb3, 0xa2,
		0x37, 0x2f, 0x39, 0x33, 0x93, 0x34, 0xb7, 0xe8, 0xf6, 0xe9, 0xb6, 0xd6, 0x87, 0x3c, 0x70, 0xbc,
		0x17, 0x8a, 0xf7, 0xd7, 0xcf, 0x52, 0xfc, 0x42, 0xcf, 0xdb, 0x78, 0x53, 0xb4, 0xa2, 0xbb, 0x19,
		0x35, 0x03, 0x7f, 0x03, 0x7f, 0x03, 0x7f, 0x23, 0x39, 0x73, 0xfa, 0x9e, 0xdc, 0x51, 0xbb, 0x4b,
		0xee, 0xe6, 0x5c, 0xa1, 0x8d, 0xf1, 0xe3, 0xec, 0xfc, 0x55, 0x1e, 0x32, 0x27, 0x4c, 0xe4, 0x8c,
		0x15, 0xa7, 0x89, 0x86, 0x9e, 0x79, 0xf6, 0x7d, 0x97, 0x99, 0x1e, 0x65, 0xd7, 0x94, 0x73, 0xd2,
		0x35, 0x8e, 0xc7, 0xa5, 0x4e, 0x91, 0x5d, 0xd7, 0x31, 0x55, 0x82, 0xa6, 0x68, 0x5e, 0x92, 0xa3,
		0xeb, 0xac, 0xe8, 0xc6, 0x28, 0x5f, 0x9a, 0x53, 0x4c, 0xb4, 0xb7, 0x36, 0x3b, 0x79, 0x83, 0xeb,
		0xbc, 0x52, 0x39, 0x3a, 0x3a, 0xad, 0x94, 0x8e, 0x4e, 0xce, 0x8e, 0xab, 0xa7, 0xa7, 0xc7, 0x67,
		0xa5, 0x33, 0xe2, 0x6f, 0xd2, 0xf0, 0x66, 0x17, 0x91, 0x9d, 0xcc, 0x0f, 0x1e, 0xe1, 0xeb, 0x76,
		0x44, 0x38, 0x26, 0x31, 0x78, 0xa7, 0x19, 0x1a, 0xbc, 0x83, 0x74, 0xb4, 0xf2, 0x94, 0x13, 0x57,
		0xdd, 0xa7, 0xf6, 0xd5, 0x67, 0xf0, 0xd5, 0xe9, 0x32, 0xf7, 0x12, 0x3c, 0x73, 0x56, 0x86, 0xaa,
		0x7c, 0x56, 0xad, 0x9e, 0x9c, 0x56, 0xab, 0xa5, 0xd3, 0xa3, 0xd3, 0xd2, 0xf9, 0xf1, 0x71, 0xf9,
		0xa4, 0x7c, 0x0c, 0xd7, 0xbc, 0xaf, 0xae, 0xd9, 0x66, 0x96, 0xd3, 0x35, 0x5d, 0x52, 0xef, 0x5c,
		0xae, 0x10, 0xb4, 0xb5, 0x34, 0x87, 0x2a, 0xf0, 0xf9, 0x72, 0xc3, 0x51, 0x81, 0xcf, 0xcf, 0x8a,
		0xcf, 0x3f, 0xc2, 0x50, 0xe5, 0xc4, 0xc1, 0xa3, 0x44, 0xc7, 0x6e, 0x4a, 0x74, 0x44, 0xfb, 0xa8,
		0x26, 0x3f, 0xbe, 0x27, 0x7f, 0xac, 0x40, 0x74, 0x0f, 0x93, 0x1f, 0xdf, 0x53, 0x74, 0xb0, 0x80,
		0xd4, 0xc2, 0xb3, 0xca, 0x82, 0xb3, 0x24, 0xcf, 0x62, 0x3f, 0x06, 0xf6, 0x63, 0x88, 0xfb, 0x1d,
		0xe9, 0x85, 0x9a, 0x68, 0xe4, 0x5d, 0x66, 0x76, 0xe4, 0x2a, 0x9a, 0x47, 0xf8, 0x2b, 0xa1, 0x74,
		0x15, 0x1b, 0x63, 0x57, 0xf7, 0xf1, 0xe3, 0xd8, 0x5f, 0x1d, 0x0e, 0x4d, 0x0d, 0x27, 0x91, 0x48,
		0xb9, 0x8c, 0x0a, 0x5c, 0x06, 0x5c, 0x46, 0xcc, 0xdb, 0x94, 0x3f, 0x91, 0x64, 0x38, 0xdb, 0xfa,
		0x81, 0xf9, 0xec, 0x12, 0xec, 0xad, 0x98, 0x6b, 0x0d, 0x5b, 0x2c, 0xb0, 0xc5, 0x62, 0x67, 0xe6,
		0xa6, 0x96, 0xc3, 0xec, 0x7e, 0x8b, 0x85, 0xfa, 0x9a, 0xb9, 0xe2, 0x5a, 0x79, 0x42, 0x45, 0x9a,
		0xb1, 0x83, 0x14, 0xee, 0x06, 0xee, 0x06, 0x3b, 0x48, 0xb1, 0x83, 0x14, 0xfe, 0x06, 0xfe, 0x66,
		0x6f, 0xfc, 0x0d, 0x76, 0x90, 0xea, 0x70, 0xc2, 0x44, 0xce, 0x58, 0x71, 0x9a, 0x68, 0xe8, 0x19,
		0xec, 0x20, 0x5d, 0xdb, 0x35, 0xd8, 0x41, 0x2a, 0x70, 0x63, 0xd8, 0x41, 0xba, 0xea, 0x9b, 0xb0,
		0x66, 0x8d, 0x1d, 0xa4, 0x74, 0x70, 0x41, 0xdf, 0x0a, 0x76, 0x90, 0xae, 0x99, 0xb5, 0xd8, 0x41,
		0x9a, 0x32, 0x73, 0xc7, 0x6e, 0xa2, 0xcc, 0x0c, 0x15, 0x76, 0x90, 0xc2, 0x35, 0x63, 0x07, 0xe9,
		0x1e, 0xf9, 0x7c, 0xec, 0x20, 0xc5, 0x0e, 0x52, 0x38, 0xf8, 0x84, 0x1d, 0x3c, 0x76, 0x90, 0xa6,
		0x66, 0x07, 0x69, 0xd2, 0xa7, 0xbc, 0xad, 0xd8, 0x40, 0x9a, 0xa1, 0x73, 0xde, 0x7e, 0x63, 0xef,
		0x82, 0x2b, 0xcb, 0xc5, 0x1b, 0x27, 0xe4, 0x35, 0xce, 0x05, 0xcb, 0x8b, 0xdd, 0x3a, 0x5e, 0xdd,
		0x65, 0xdd, 0x41, 0xef, 0x15, 0x3f, 0x15, 0xbc, 0xbe, 0xeb, 0x0a, 0x6c, 0x6b, 0xbb, 0x35, 0x7f,
		0xc8, 0x5f, 0x7c, 0x1f, 0xd8, 0x2c, 0x60, 0xf6, 0xc5, 0xfb, 0xf8, 0xd2, 0x6c, 0xd7, 0x39, 0x5d,
		0x9e, 0xf1, 0x09, 0x14, 0x3a, 0x5d, 0x9e, 0xe3, 0x7b, 0x56, 0xea, 0x34, 0x6e, 0xc5, 0x4f, 0x92,
		0x4e, 0xd6, 0x51, 0xe7, 0x34, 0xde, 0xc6, 0x50, 0xa1, 0x8d, 0xa0, 0xc2, 0xd5, 0x4d, 0x2b, 0xa8,
		0x6e, 0x1a, 0xc3, 0xa1, 0xa4, 0xbc, 0xba, 0xa9, 0xe9, 0xba, 0xbe, 0x65, 0x72, 0x66, 0x1b, 0xc3,
		0xfa, 0xbf, 0xe2, 0x45, 0x4e, 0x17, 0x1b, 0x10, 0xab, 0x75, 0x5a, 0x42, 0xad, 0x53, 0xd4, 0x3a,
		0x5d, 0xbc, 0x1d, 0xe1, 0xf5, 0xfa, 0x39, 0xa9, 0xfa, 0xa8, 0x22, 0x32, 0x68, 0xe3, 0x79, 0x28,
		0xb0, 0xbc, 0x21, 0x29, 0x43, 0x48, 0x60, 0xb4, 0x8a, 0xac, 0xa0, 0xba, 0x61, 0x47, 0x31, 0xf7,
		0xa4, 0xc8, 0x31, 0x65, 0xb6, 0x4a, 0xa9, 0xa4, 0xf7, 0x54, 0x5d, 0x56, 0xad, 0x9c, 0x57, 0xcf,
		0x4f, 0x4e, 0x2b, 0xe7, 0xc7, 0x3b, 0xec, 0x3b, 0x4d, 0xd9, 0xca, 0x53, 0x82, 0x67, 0x5e, 0xd8,
		0x73, 0x47, 0xb3, 0x09, 0x86, 0xa5, 0xd9, 0x8b, 0x11, 0x92, 0x10, 0x92, 0x76, 0x16, 0x92, 0x84,
		0x77, 0x47, 0x09, 0xee, 0x82, 0xa2, 0xb1, 0x35, 0xd6, 0xed, 0xc9, 0x54, 0xb8, 0x1f, 0x5d, 0x16,
		0xfb, 0x74, 0xd2, 0x8e, 0xd9, 0x77, 0x87, 0x23, 0xda, 0x31, 0xdd, 0x90, 0xc1, 0x2e, 0x61, 0x97,
		0xbb, 0xb3, 0x4b, 0xf1, 0xbd, 0x79, 0x82, 0x7b, 0xf0, 0x68, 0x0c, 0xb3, 0xe3, 0x04, 0xdd, 0xbf,
		0xcc, 0x80, 0x19, 0x6f, 0x2c, 0x08, 0xa5, 0x22, 0xe1, 0x52, 0x0b, 0x30, 0x3b, 0x98, 0x1d, 0xc2,
		0xe1, 0xc6, 0xef, 0x7c, 0x35, 0x03, 0x5b, 0xcd, 0xea, 0x96, 0x5a, 0x80, 0xd5, 0xc1, 0xea, 0x60,
		0x75, 0x1b, 0xbf, 0xd3, 0xb1, 0xc5, 0xed, 0xcc, 0xb1, 0x61, 0x59, 0xb0, 0x2c, 0x58, 0xd6, 0xe6,
		0xef, 0x1c, 0x4a, 0xf4, 0x52, 0x71, 0x2c, 0xba, 0x12, 0x56, 0x06, 0x2b, 0x83, 0x95, 0x6d, 0xfc,
		0xce, 0x2e, 0xeb, 0xfa, 0x81, 0x84, 0x8a, 0x32, 0xbe, 0x0e, 0xa7, 0x04, 0xc2, 0xc2, 0x14, 0x2d,
		0x4c, 0xf8, 0x94, 0x40, 0xf3, 0xcd, 0x74, 0x5c, 0xa9, 0x22, 0x3a, 0xd3, 0x05, 0xe0, 0xa8, 0x09,
		0xd4, 0xa6, 0xd3, 0x34, 0xd1, 0xc9, 0x26, 0x3c, 0xd9, 0xc4, 0xa7, 0x33, 0x00, 0x31, 0x43, 0x10,
		0x34, 0x08, 0xf9, 0xd0, 0xb3, 0x34, 0xf2, 0xd2, 0x6f, 0x41, 0x29, 0xbc, 0xf5, 0xa4, 0xb8, 0xe3,
		0x5d, 0xe1, 0x85, 0x77, 0x8a, 0x1d, 0xed, 0x44, 0xaf, 0xc2, 0x50, 0x6d, 0x83, 0xa6, 0xdc, 0xf6,
		0xac, 0xb0, 0x23, 0x9d, 0x64, 0x07, 0x3a, 0x75, 0xd7, 0xd2, 0xbf, 0x55, 0x44, 0xda, 0xdb, 0x09,
		0x6d, 0xaa, 0x7e, 0x4a, 0x41, 0xc5, 0xc7, 0x3e, 0x77, 0x5c, 0xe7, 0xdf, 0xcc, 0x96, 0x8f, 0xc7,
		0x51, 0x0b, 0x08, 0xc7, 0x08, 0xc7, 0x08, 0xc7, 0x08, 0xc7, 0x08, 0xc7, 0x08, 0xc7, 0x08, 0xc7,
		0xba, 0x52, 0xee, 0xa4, 0xdf, 0x18, 0x19, 0x6e, 0xe5, 0x3f, 0x14, 0x92, 0x8c, 0x0a, 0xf2, 0x6f,
		0x31, 0x0c, 0x5f, 0x7d, 0x6a, 0xdf, 0x8e, 0xbe, 0x2d, 0x49, 0x29, 0xad, 0xf3, 0x62, 0xd8, 0x22,
		0xb5, 0xaf, 0xa7, 0x62, 0xda, 0xe4, 0x4a, 0x08, 0xd6, 0x90, 0xd3, 0x14, 0x6d, 0x5b, 0x5e, 0xb0,
		0xb6, 0xc5, 0x5e, 0x5a, 0x9c, 0xca, 0xd5, 0x02, 0xd7, 0x34, 0x4c, 0xce, 0x59, 0xe0, 0x09, 0xf3,
		0x48, 0xf1, 0xbf, 0xff, 0x2c, 0x19, 0xe7, 0x4f, 0x7f, 0x57, 0x7f, 0x3e, 0x3e, 0x1a, 0xa3, 0x1f,
		0x2b, 0xb3, 0x3f, 0xfe, 0x47, 0x31, 0x95, 0xdb, 0x81, 0x07, 0x86, 0x2d, 0x54, 0x77, 0x77, 0xce,
		0x25, 0x88, 0xbc, 0x11, 0x09, 0x97, 0x00, 0x97, 0x40, 0xef, 0x12, 0xb2, 0xb1, 0x86, 0x25, 0x67,
		0x61, 0xb0, 0x2e, 0x58, 0x17, 0xac, 0x6b, 0xbb, 0x75, 0xf9, 0x3d, 0x16, 0x18, 0x03, 0x82, 0xef,
		0x87, 0xe2, 0x46, 0x36, 0x7b, 0x31, 0x6c, 0x0d, 0xb6, 0xb6, 0x33, 0x5b, 0x73, 0x6c, 0xe6, 0x71,
		0x87, 0xbf, 0x8b, 0x1d, 0xd5, 0x14, 0x19, 0x9c, 0x80, 0x94, 0x51, 0xbc, 0x1e, 0x7f, 0xd5, 0x85,
		0x19, 0x2a, 0x2c, 0x51, 0x5f, 0xde, 0xdf, 0x36, 0xee, 0xef, 0xea, 0x77, 0xad, 0xf6, 0x7d, 0xa3,
		0xfe, 0xd0, 0x6e, 0xb6, 0x6a, 0xad, 0x6f, 0x4d, 0xd1, 0xf1, 0x1f, 0x8a, 0x33, 0xa1, 0x94, 0xfa,
		0xa7, 0x58, 0xb8, 0xbd, 0x76, 0xd9, 0xba, 0xfe, 0x67, 0xbd, 0x98, 0xc4, 0x0b, 0x94, 0x8a, 0x77,
		0x7a, 0x7d, 0x97, 0x9d, 0x7b, 0xbd, 0xba, 0x6e, 0xd6, 0x2e, 0x6e, 0xea, 0x57, 0xba, 0xb5, 0xf1,
		0x27, 0x6a, 0xfb, 0x26, 0x89, 0x44, 0x3d, 0x33, 0x18, 0xb9, 0x22, 0xc1, 0x20, 0x34, 0xbe, 0x0e,
		0xf1, 0x07, 0xf1, 0x67, 0x67, 0xf1, 0x47, 0xfc, 0x98, 0x40, 0x99, 0xe3, 0x01, 0x67, 0x8f, 0x05,
		0x1c, 0xfd, 0x6f, 0x2a, 0xc2, 0x0a, 0x1f, 0x13, 0x48, 0x66, 0xb4, 0xdc, 0xf0, 0x7c, 0x29, 0xab,
		0x1d, 0x5e, 0x08, 0xb3, 0x85, 0xd9, 0x22, 0x45, 0xdb, 0xf8, 0x9d, 0x01, 0xeb, 0xfa, 0x6f, 0x42,
		0x3b, 0x22, 0xa3, 0x07, 0x9c, 0x5e, 0x0a, 0x3b, 0x83, 0x9d, 0xed, 0xcc, 0xce, 0x32, 0xf2, 0x66,
		0x73, 0xc8, 0x02, 0xc7, 0x74, 0xa5, 0xc2, 0xd9, 0xf4, 0x52, 0x18, 0x1a, 0x0c, 0x0d, 0x01, 0x6d,
		0xb3, 0x9d, 0xf9, 0x1d, 0xae, 0xf6, 0x2e, 0xf3, 0x52, 0x0b, 0xb0, 0x3a, 0x58, 0x1d, 0xac, 0x6e,
		0xe3, 0x77, 0x72, 0xd6, 0xed, 0xb1, 0xc0, 0xe4, 0xfd, 0x40, 0x02, 0x24, 0x67, 0x2f, 0xc6, 0x5b,
		0x61, 0xb0, 0x35, 0x45, 0x5b, 0x13, 0x7f, 0x2b, 0xcc, 0x35, 0x83, 0xae, 0x11, 0xb2, 0x37, 0x16,
		0x38, 0x02, 0x65, 0xa1, 0x96, 0x06, 0x7e, 0xa1, 0x1d, 0x6c, 0x48, 0xd7, 0x34, 0xe5, 0xc9, 0xa6,
		0x3e, 0x99, 0x09, 0xd0, 0x99, 0x82, 0x98, 0x49, 0x08, 0x9a, 0x86, 0x7c, 0x38, 0x5a, 0x1a, 0x79,
		0xb9, 0x45, 0xb1, 0x25, 0xff, 0x2d, 0xb1, 0xcf, 0x57, 0x6d, 0x91, 0x6c, 0xe9, 0x41, 0xee, 0x1b,
		0xf5, 0xbb, 0xcb, 0xfb, 0xbb, 0xcf, 0xd7, 0x5f, 0xda, 0xb5, 0x9b, 0xda, 0xc3, 0x6d, 0xbb, 0x59,
		0xff, 0x67, 0xfd, 0xe1, 0xba, 0xf5, 0x47, 0x51, 0xa5, 0x2e, 0x66, 0xa8, 0x74, 0x6e, 0x8b, 0xe2,
		0xf6, 0xec, 0xc9, 0xa3, 0x7d, 0xbb, 0xfb, 0xed, 0xee, 0xfe, 0xf7, 0xbb, 0xe2, 0x2e, 0x36, 0x9a,
		0x13, 0x3d, 0xc2, 0xed, 0xf5, 0xdd, 0xfd, 0x43, 0x96, 0x1f, 0xe0, 0xf2, 0xe1, 0xba, 0x75, 0x7d,
		0x59, 0xbb, 0xc9, 0xf2, 0x33, 0xfc, 0x5e, 0x7b, 0xb8, 0xbb, 0xbe, 0xfb, 0x92, 0xe9, 0x79, 0x54,
		0xfb, 0xff, 0x94, 0xe6, 0x91, 0xd4, 0x95, 0x4f, 0xa9, 0xa9, 0x63, 0x2b, 0xf2, 0x4a, 0xde, 0x98,
		0x62, 0xc4, 0x76, 0xed, 0xac, 0x63, 0x21, 0x91, 0xed, 0x3b, 0x20, 0x21, 0x90, 0x50, 0x06, 0x49,
		0x48, 0xfe, 0xd4, 0x6b, 0xc9, 0x53, 0xae, 0x75, 0x9a, 0x3d, 0x7f, 0x0d, 0x58, 0xf8, 0xea, 0xbb,
		0xb6, 0xaa, 0xe5, 0x4f, 0x1b, 0x82, 0xf1, 0xc3, 0xf8, 0x73, 0xfd, 0x5e, 0xae, 0xd0, 0x09, 0x0c,
		0x8b, 0xf3, 0xfc, 0x14, 0xef, 0xe5, 0x16, 0xe4, 0xd3, 0x2c, 0xbc, 0x97, 0xab, 0xb3, 0x6b, 0x55,
		0x4f, 0x76, 0xd0, 0xd2, 0xc7, 0x7b, 0x54, 0x1c, 0xc3, 0x7c, 0x7b, 0x51, 0xa9, 0x53, 0xf5, 0xb2,
		0x67, 0xa1, 0xd7, 0xe0, 0xef, 0x3d, 0x16, 0x22, 0x00, 0x6f, 0x08, 0xc0, 0xe3, 0x2e, 0xca, 0x5d,
		0x18, 0x56, 0x39, 0x18, 0x5a, 0xe5, 0x20, 0xe8, 0x65, 0xcf, 0x56, 0xde, 0xd7, 0x78, 0x5e, 0x41,
		0x3c, 0xd7, 0x15, 0xcf, 0x8f, 0x72, 0xd8, 0xb5, 0x7b, 0x14, 0xc6, 0x1d, 0x2f, 0xe4, 0xa6, 0xc0,
		0xcb, 0x07, 0x4b, 0xde, 0x6d, 0xd2, 0x00, 0xc2, 0x39, 0xc2, 0x39, 0xc2, 0x39, 0xc2, 0x39, 0xc2,
		0x39, 0xc2, 0x39, 0xc2, 0xf9, 0xee, 0xc2, 0x39, 0x67, 0xc1, 0x9b, 0xe9, 0xaa, 0xc4, 0xf3, 0x71,
		0x0b, 0xfb, 0x11, 0xd0, 0x11, 0xc7, 0xd7, 0xc5, 0xf1, 0x9c, 0x86, 0xef, 0x90, 0x9b, 0xdc, 0x90,
		0x9c, 0xe4, 0x05, 0xc5, 0x9a, 0x95, 0xdf, 0xbc, 0x91, 0x2f, 0x2b, 0x7a, 0xa6, 0xe7, 0x87, 0xcc,
		0xf2, 0x3d, 0x5b, 0x6a, 0xee, 0x41, 0x63, 0x47, 0x10, 0x4f, 0xa2, 0x6b, 0x51, 0xfb, 0x32, 0x2d,
		0x71, 0xbd, 0x2b, 0x31, 0x3b, 0xa6, 0x35, 0xd7, 0xcc, 0x1f, 0x48, 0xcf, 0x11, 0xd6, 0x91, 0x9e,
		0x23, 0x3d, 0x47, 0x7a, 0x8e, 0xf4, 0x1c, 0xe9, 0xf9, 0x2e, 0xc3, 0xb8, 0xc1, 0x9d, 0x2e, 0x53,
		0x8a, 0xe5, 0xa3, 0x16, 0x90, 0x9e, 0x23, 0x3d, 0xcf, 0x61, 0xf8, 0x1e, 0xcc, 0x6d, 0xee, 0x58,
		0xdf, 0xc3, 0xc4, 0x0f, 0x94, 0x40, 0x72, 0x8e, 0xe4, 0x1c, 0xc9, 0x39, 0xa2, 0xba, 0x44, 0x54,
		0x97, 0x30, 0xbc, 0x69, 0x40, 0x77, 0x3c, 0x24, 0xe7, 0x08, 0xea, 0x48, 0xce, 0x91, 0x9c, 0x23,
		0x39, 0x47, 0x72, 0x8e, 0xe4, 0x7c, 0x97, 0x61, 0x5c, 0x35, 0x39, 0x9f, 0xb4, 0x80, 0xe4, 0x1c,
		0xc9, 0x39, 0x92, 0x73, 0x24, 0xe7, 0x48, 0xce, 0x91, 0x9c, 0x23, 0x39, 0xa7, 0x8f, 0xea, 0x39,
		0x38, 0x35, 0x52, 0xbc, 0xae, 0x5c, 0x41, 0xf5, 0xe8, 0xc8, 0xd6, 0xcc, 0x57, 0x26, 0x59, 0x7e,
		0x4f, 0x24, 0xee, 0x4c, 0x63, 0xcd, 0xe0, 0x2a, 0x14, 0xb7, 0x44, 0xc1, 0x3d, 0x45, 0xeb, 0x96,
		0x2f, 0x6e, 0xd9, 0xf7, 0xe2, 0xd7, 0x57, 0x9d, 0x13, 0x28, 0xce, 0x05, 0xae, 0x19, 0xdf, 0x9e,
		0x18, 0x8f, 0xa0, 0x34, 0xda, 0x5c, 0x69, 0xb4, 0xaf, 0xb5, 0x87, 0xab, 0xdf, 0x6b, 0x0f, 0xf5,
		0x76, 0x74, 0xb6, 0x50, 0xf6, 0xcb, 0xa3, 0xdd, 0x5c, 0xdf, 0xd5, 0x2f, 0x6b, 0x0f, 0x57, 0x59,
		0xae, 0x6b, 0xd5, 0xb8, 0xff, 0xbd, 0xfe, 0xd0, 0x6e, 0x7e, 0x6b, 0x34, 0x6e, 0xfe, 0xc8, 0xf2,
		0x73, 0x7c, 0xae, 0x5d, 0x3c, 0x5c, 0x5f, 0x66, 0xba, 0xd0, 0x5b, 0xe3, 0x5b, 0x96, 0x6f, 0xff,
		0xfa, 0xae, 0x55, 0xff, 0xf2, 0x50, 0x6b, 0xd5, 0xaf, 0xda, 0x97, 0xd7, 0x0f, 0x97, 0xdf, 0xae,
		0x5b, 0x59, 0x7e, 0x9a, 0xfb, 0xc6, 0xb0, 0xe8, 0x5e, 0xfb, 0xf2, 0x6b, 0xed, 0xee, 0xae, 0x9e,
		0xe9, 0xe2, 0x7b, 0x17, 0xb5, 0xcb, 0xdf, 0x1a, 0x37, 0xb5, 0xbb, 0x7a, 0x96, 0x1f, 0xa2, 0xf5,
		0x50, 0xbb, 0x6b, 0x5e, 0xd6, 0xaf, 0xff, 0x59, 0x7f, 0xc8, 0xb6, 0x97, 0xca, 0x74, 0x31, 0xcd,
		0xcb, 0xaf, 0xb5, 0x66, 0xf3, 0xba, 0x99, 0xe5, 0x47, 0x68, 0xd6, 0xef, 0x9a, 0xd9, 0x2e, 0x08,
		0xfa, 0xf9, 0x21, 0xd3, 0x71, 0xe2, 0xf2, 0xfe, 0xae, 0xf5, 0x70, 0x7f, 0x73, 0x53, 0x7f, 0x68,
		0x67, 0x9f, 0x9d, 0x1e, 0x32, 0x1d, 0xe4, 0x9a, 0xad, 0xfb, 0x87, 0xda, 0x97, 0x7a, 0xee, 0xaa,
		0x9a, 0x7e, 0x40, 0xa2, 0x26, 0x9f, 0xa8, 0x35, 0xef, 0x3f, 0xb7, 0xf2, 0x96, 0xa8, 0xdd, 0x37,
		0xea, 0x0f, 0xb5, 0xd6, 0xf5, 0xdd, 0x97, 0x76, 0xf3, 0x8f, 0x66, 0xab, 0x7e, 0x9b, 0x6d, 0x32,
		0x9d, 0x7f, 0x96, 0xf6, 0xb7, 0xc6, 0x55, 0xad, 0x55, 0xdf, 0xdf, 0xd2, 0xc4, 0x4f, 0x09, 0xca,
		0xa4, 0xfd, 0x90, 0xd9, 0x46, 0xcf, 0xff, 0x8b, 0x05, 0xe2, 0x62, 0xe9, 0xcc, 0xb5, 0x90, 0x4c,
		0x21, 0x99, 0xaa, 0x39, 0x18, 0x15, 0xc9, 0x54, 0xb4, 0xe2, 0xa8, 0x44, 0xa5, 0x51, 0xc9, 0x35,
		0x5c, 0x89, 0x50, 0xac, 0xb2, 0x66, 0xab, 0xb8, 0xa0, 0xa8, 0xba, 0x46, 0x4b, 0xb1, 0x5a, 0x28,
		0x11, 0x8f, 0x94, 0xd6, 0x62, 0xa9, 0xba, 0x4c, 0xb5, 0x32, 0x28, 0x49, 0xdf, 0xa5, 0x3d, 0x20,
		0x1d, 0x28, 0x8c, 0xbc, 0xe8, 0x8a, 0xa9, 0xda, 0x4a, 0x69, 0x31, 0xce, 0xb9, 0x7a, 0xf2, 0xab,
		0xa2, 0x9b, 0x9d, 0xec, 0xfa, 0x7e, 0xda, 0xd0, 0x47, 0xc5, 0x90, 0xfb, 0x81, 0xf9, 0xb2, 0xdd,
		0x87, 0xce, 0x14, 0xa5, 0x18, 0x5d, 0xb0, 0xa5, 0xdf, 0xe3, 0x1d, 0x2c, 0x16, 0x3b, 0x58, 0x8b,
		0x04, 0x69, 0xc9, 0xe0, 0x2c, 0x1a, 0x94, 0xa5, 0x83, 0xb1, 0x74, 0x10, 0x96, 0x0f, 0xbe, 0x6a,
		0x36, 0x14, 0xf7, 0x20, 0xb0, 0xa2, 0x35, 0x19, 0x4d, 0x41, 0x26, 0x1c, 0x5f, 0x87, 0x33, 0xeb,
		0xc0, 0x83, 0x8a, 0x3c, 0x98, 0xfc, 0x06, 0x99, 0xa1, 0x37, 0x3c, 0x14, 0x9a, 0xc1, 0x4a, 0x71,
		0x60, 0xf8, 0x7d, 0xed, 0xf1, 0xa4, 0x4e, 0xf2, 0x3c, 0xd8, 0x61, 0x04, 0x12, 0x3f, 0x04, 0x36,
		0x66, 0x5c, 0x54, 0xb2, 0xec, 0x0a, 0x2c, 0x1b, 0x96, 0xad, 0xc9, 0xb2, 0x45, 0x26, 0x30, 0x81,
		0x61, 0xc7, 0x00, 0xbd, 0xfc, 0xa1, 0x73, 0x1c, 0xa2, 0x54, 0xef, 0x5b, 0x2d, 0xf8, 0xdc, 0x7f,
		0x9e, 0x3e, 0x93, 0x00, 0x44, 0xcf, 0x5d, 0x06, 0x94, 0x06, 0x4a, 0x6f, 0x9a, 0x58, 0x12, 0x51,
		0x77, 0xf6, 0x6a, 0x60, 0x35, 0x82, 0xaf, 0x62, 0xf0, 0x15, 0x3e, 0x0a, 0x5a, 0x30, 0x13, 0x54,
		0xcb, 0x08, 0x25, 0xa7, 0xb0, 0xf4, 0x54, 0x56, 0x99, 0xd2, 0x44, 0x53, 0x5b, 0x75, 0x8a, 0x93,
		0x4d, 0x75, 0xb2, 0x29, 0x4f, 0x37, 0xf5, 0x25, 0x85, 0x4d, 0xc1, 0xb1, 0x17, 0x35, 0x89, 0xe8,
		0xc2, 0x31, 0xbd, 0x28, 0x2e, 0x55, 0x0f, 0x5b, 0xf9, 0xb0, 0x13, 0xf1, 0x5a, 0xd6, 0x5c, 0x28,
		0xcc, 0x86, 0xd8, 0x7c, 0xa8, 0xcc, 0x88, 0xdc, 0x9c, 0xc8, 0xcd, 0x8a, 0xde, 0xbc, 0xe4, 0xcc,
		0x4c, 0xd2, 0xdc, 0xa2, 0xdb, 0x97, 0x7e, 0x33, 0x74, 0x69, 0xe6, 0xb8, 0xcc, 0xec, 0xc8, 0xed,
		0x58, 0x59, 0x8a, 0x37, 0xa7, 0x0a, 0x6d, 0x34, 0xc6, 0xf9, 0xd2, 0xc7, 0x8f, 0x87, 0xb3, 0xff,
		0x9b, 0xa6, 0x47, 0xa3, 0x50, 0x78, 0x38, 0x34, 0xf8, 0x84, 0x5e, 0x86, 0xd3, 0xeb, 0x39, 0x25,
		0x33, 0x79, 0xf5, 0x3c, 0x73, 0x36, 0xe9, 0x9a, 0xfb, 0xdb, 0xa1, 0x14, 0x6e, 0xa8, 0x64, 0xa4,
		0xb3, 0xb7, 0x32, 0xf7, 0x37, 0x21, 0x65, 0x4f, 0x7c, 0xbc, 0x44, 0x8a, 0x0c, 0x48, 0x05, 0x2a,
		0x95, 0x00, 0x85, 0x33, 0x6b, 0xc1, 0x6f, 0x89, 0x79, 0x21, 0xf5, 0x12, 0x03, 0xf2, 0x01, 0x44,
		0x25, 0x70, 0xcc, 0x06, 0x0c, 0xe9, 0xd0, 0xa0, 0xc7, 0x61, 0x88, 0x2d, 0x11, 0x2c, 0x8b, 0x16,
		0x82, 0x4a, 0x2b, 0x49, 0xca, 0x57, 0x81, 0xcb, 0x80, 0xcb, 0x40, 0xca, 0x87, 0x94, 0x0f, 0x29,
		0x1f, 0x52, 0x3e, 0xa4, 0x7c, 0xfb, 0x93, 0xf2, 0xc9, 0xd0, 0x86, 0x9e, 0x8c, 0x4f, 0x60, 0xc9,
		0x57, 0x82, 0xdf, 0x48, 0xd7, 0x01, 0x7e, 0x63, 0xef, 0x82, 0x91, 0xa8, 0x78, 0xe3, 0x84, 0xbc,
		0xc6, 0xb9, 0xe0, 0xfa, 0xc1, 0xad, 0xe3, 0xd5, 0x5d, 0xd6, 0x1d, 0xaf, 0xaa, 0x7a, 0x7d, 0xd7,
		0x15, 0xe0, 0xd0, 0x5b, 0xf3, 0x87, 0xfc, 0xc5, 0xf7, 0x81, 0xcd, 0x02, 0x66, 0x5f, 0xbc, 0x8f,
		0x2f, 0xcd, 0xf6, 0x26, 0x86, 0xb5, 0xf3, 0x3f, 0x81, 0x1d, 0x0d, 0x6b, 0x67, 0xfc, 0x9e, 0x6d,
		0x6f, 0x10, 0x58, 0xeb, 0xa7, 0xea, 0x6e, 0x1d, 0x5b, 0x1d, 0x78, 0x60, 0x7a, 0xa1, 0xc5, 0x9c,
		0xb7, 0x18, 0x6f, 0xfd, 0x4c, 0x4b, 0x23, 0xcd, 0x5c, 0x94, 0x8d, 0x6d, 0x0e, 0xf1, 0xef, 0xb8,
		0x90, 0xc9, 0x9d, 0x0e, 0xb3, 0xcf, 0x87, 0x7d, 0xc3, 0x84, 0x39, 0x8f, 0xea, 0x06, 0x07, 0xb1,
		0x89, 0xa7, 0x9a, 0xc6, 0xa4, 0x6f, 0x8f, 0x83, 0xd0, 0xc4, 0xd4, 0x83, 0x37, 0xc2, 0xdb, 0x1c,
		0x98, 0x67, 0x3e, 0xbb, 0xcc, 0x96, 0xd7, 0xbc, 0x26, 0x0d, 0xec, 0x49, 0x15, 0x5e, 0xa9, 0x29,
		0xbe, 0x3f, 0xc2, 0x97, 0x94, 0x09, 0x64, 0x45, 0x2e, 0x7f, 0xf6, 0x7d, 0x97, 0x99, 0x9e, 0x8a,
		0x5c, 0x5e, 0x4e, 0x81, 0xc8, 0xcd, 0xf8, 0x2b, 0x0b, 0x3c, 0xc6, 0x8d, 0x5e, 0xd7, 0x36, 0x7a,
		0x01, 0x1b, 0xc4, 0x20, 0x05, 0xfb, 0x5f, 0xd5, 0x1a, 0x9c, 0x01, 0x9c, 0x41, 0xce, 0x9d, 0x41,
		0x6e, 0x4a, 0x86, 0xd4, 0x5b, 0x5f, 0xeb, 0x0f, 0x77, 0xf5, 0x56, 0xbb, 0x71, 0x7b, 0xd5, 0x6e,
		0xfd, 0xd1, 0xa8, 0x67, 0xbf, 0x4c, 0x48, 0xbd, 0xf5, 0xb5, 0x5d, 0x2e, 0x95, 0xbe, 0x5c, 0xd4,
		0x9a, 0xf5, 0x76, 0xf3, 0xa1, 0x9a, 0xe5, 0x32, 0x21, 0xa3, 0x67, 0x19, 0x3d, 0xca, 0xcd, 0x43,
		0xd6, 0x9f, 0xa4, 0x3a, 0x7e, 0x92, 0x46, 0xf3, 0x36, 0x07, 0xa3, 0x12, 0x0d, 0x4b, 0xe6, 0x9f,
		0xe5, 0xdb, 0xdd, 0x55, 0xfd, 0xf3, 0xf5, 0x5d, 0xfd, 0x2a, 0x0f, 0x83, 0xd2, 0xae, 0xdd, 0x5f,
		0x66, 0xde, 0x50, 0xfe, 0x2b, 0x3f, 0x46, 0x3f, 0xe3, 0x8a, 0xcb, 0xa5, 0xbc, 0xf8, 0xe2, 0x7f,
		0x3d, 0xe4, 0xe5, 0x49, 0x9a, 0x0f, 0xf9, 0x31, 0x96, 0x66, 0x7e, 0x8c, 0xe5, 0xf2, 0xf7, 0xab,
		0xec, 0xc7, 0xc8, 0x6a, 0x9e, 0x20, 0x6c, 0xfc, 0x2c, 0xf5, 0x3c, 0x01, 0xe5, 0x6d, 0x6e, 0x86,
		0x25, 0x57, 0x48, 0x79, 0x79, 0x93, 0x0f, 0x83, 0x69, 0xd7, 0x2e, 0x2f, 0xf3, 0x33, 0x28, 0x0f,
		0xb9, 0xf1, 0xc7, 0x39, 0xf2, 0x61, 0xf5, 0xdc, 0x24, 0xc5, 0x37, 0xf9, 0x99, 0x5f, 0x6a, 0xa6,
		0x92, 0xf1, 0x42, 0xa6, 0x22, 0x62, 0x7c, 0x87, 0x59, 0x46, 0xd7, 0xb7, 0x15, 0x36, 0x9d, 0x47,
		0x2d, 0x40, 0x74, 0x8f, 0xd1, 0x12, 0x44, 0x77, 0x42, 0x8b, 0x80, 0xe8, 0x2e, 0xfb, 0x20, 0x9f,
		0xeb, 0x97, 0xed, 0xdb, 0xfb, 0xab, 0x7a, 0x4e, 0x04, 0xf7, 0xc1, 0xe3, 0xd4, 0xbe, 0xb5, 0xee,
		0x33, 0x7d, 0x1c, 0x43, 0xfd, 0xb2, 0x5d, 0xbf, 0xab, 0x5d, 0xdc, 0x64, 0x5b, 0x04, 0x1d, 0x3c,
		0xc6, 0xd5, 0x75, 0x53, 0xf5, 0x39, 0xf6, 0x29, 0x04, 0xfb, 0x41, 0xd7, 0xe8, 0x98, 0x16, 0xf7,
		0x03, 0xf5, 0xe5, 0xf0, 0x55, 0x8d, 0x21, 0x30, 0x23, 0x30, 0x23, 0x30, 0x67, 0x23, 0x30, 0xcf,
		0x9c, 0x4f, 0xd5, 0xfe, 0x7c, 0xff, 0x70, 0xdb, 0xfe, 0x5c, 0xbb, 0x6c, 0xdd, 0x3f, 0xe4, 0x24,
		0x4e, 0xff, 0x9f, 0xe6, 0xe7, 0x46, 0xbb, 0x71, 0xf3, 0x2d, 0xd3, 0x27, 0x3f, 0x0d, 0x1e, 0xa2,
		0x72, 0x96, 0xe9, 0xa3, 0x93, 0x3e, 0x37, 0xb2, 0x7c, 0xfb, 0xff, 0x55, 0xc9, 0x78, 0xe7, 0x67,
		0x5a, 0x66, 0xf9, 0xaf, 0x6c, 0x4f, 0x9e, 0xcb, 0xcf, 0x8d, 0x4a, 0xbb, 0x76, 0x99, 0xe9, 0x54,
		0xe1, 0xbe, 0xf5, 0x35, 0xdb, 0xaa, 0x63, 0x33, 0xdb, 0x73, 0xe8, 0xee, 0xfe, 0x6e, 0x10, 0xc5,
		0xbe, 0x7c, 0x19, 0x64, 0x39, 0xd9, 0x3e, 0x2a, 0xb6, 0xf6, 0x5b, 0xd6, 0x8d, 0x39, 0xeb, 0x28,
		0x91, 0x71, 0x3b, 0x56, 0xc5, 0xb9, 0xac, 0x27, 0xfa, 0x99, 0x7e, 0xbb, 0x75, 0x26, 0x27, 0x4c,
		0xac, 0x00, 0x7f, 0x6b, 0xfa, 0x9d, 0x3b, 0x28, 0xc2, 0xdf, 0x7b, 0x7d, 0x0f, 0x1d, 0xcb, 0x74,
		0x0d, 0xeb, 0xd5, 0xf4, 0x3c, 0xe6, 0x86, 0xe2, 0xef, 0xcc, 0x2d, 0x37, 0x81, 0xd7, 0xe7, 0xf0,
		0xfa, 0x1c, 0x89, 0xfd, 0x8b, 0x57, 0x09, 0x1e, 0x4d, 0x41, 0x85, 0x32, 0xc1, 0xe3, 0x06, 0xf6,
		0xa3, 0x4e, 0x30, 0x34, 0xc2, 0xcc, 0x6a, 0x84, 0xd2, 0xa5, 0xa3, 0x24, 0x0b, 0x69, 0x2f, 0x5b,
		0x8a, 0x6c, 0x85, 0x4b, 0x05, 0x83, 0x51, 0x36, 0x1c, 0x0a, 0x03, 0xa2, 0x37, 0x24, 0x2a, 0x83,
		0x22, 0x37, 0x2c, 0x72, 0x03, 0xd3, 0x62, 0x68, 0x6a, 0xec, 0x2c, 0x5b, 0x44, 0x4a, 0xd6, 0x00,
		0xa3, 0x06, 0x6c, 0x16, 0x5a, 0x81, 0xd3, 0x93, 0xae, 0x61, 0xb4, 0x72, 0x2e, 0xce, 0x36, 0xaa,
		0x38, 0x44, 0x6a, 0x15, 0xde, 0xc8, 0x4c, 0x95, 0xd2, 0x64, 0xf5, 0x99, 0x2e, 0xb5, 0x09, 0x6b,
		0x33, 0x65, 0x6d, 0x26, 0xad, 0xd5, 0xb4, 0xd5, 0x4c, 0x9c, 0x40, 0x20, 0x28, 0x90, 0xd4, 0x8d,
		0x5b, 0x9a, 0x7f, 0x21, 0x0f, 0x1c, 0xef, 0x85, 0x62, 0xde, 0x4d, 0x02, 0xea, 0xd9, 0xc1, 0x6e,
		0xfa, 0x57, 0xa1, 0x6f, 0x8b, 0x8e, 0x67, 0xb3, 0x1f, 0x74, 0x3e, 0x70, 0xd4, 0x1c, 0xbc, 0x1f,
		0xbc, 0x1f, 0xbc, 0x5f, 0xaa, 0xbd, 0x5f, 0xdf, 0xf1, 0x78, 0xf9, 0x84, 0xd0, 0xfb, 0x9d, 0x10,
		0x34, 0x25, 0x77, 0xc2, 0xfa, 0xba, 0xff, 0x68, 0xec, 0xa0, 0xa0, 0x7a, 0x22, 0xbb, 0x66, 0x37,
		0xb7, 0xd4, 0xac, 0xe2, 0x09, 0xee, 0x6b, 0xdb, 0x25, 0x38, 0x9d, 0x5c, 0x93, 0x79, 0xcc, 0x0f,
		0x95, 0xf9, 0x43, 0xdb, 0x50, 0x1d, 0x61, 0xa8, 0x7e, 0x1e, 0xa4, 0xa3, 0x95, 0xa7, 0x0c, 0xb2,
		0x16, 0x37, 0x83, 0x17, 0xc6, 0x0d, 0xbf, 0xcf, 0x7b, 0x7d, 0x6e, 0xf4, 0xfc, 0xbf, 0x58, 0x40,
		0x47, 0x5e, 0xab, 0x1a, 0x07, 0x87, 0x81, 0xc3, 0xc0, 0x61, 0xa9, 0xe6, 0x30, 0x9b, 0x59, 0x4e,
		0xd7, 0x74, 0x4f, 0xaa, 0x94, 0x89, 0x68, 0x85, 0xa0, 0xad, 0xa5, 0x18, 0x52, 0x01, 0xe0, 0xc9,
		0x0d, 0x47, 0x05, 0xd4, 0x00, 0xc0, 0x03, 0xe0, 0xed, 0x03, 0xe0, 0xfd, 0x30, 0x5c, 0x33, 0x24,
		0xa5, 0xba, 0x49, 0x8b, 0x40, 0x39, 0xa0, 0x1c, 0x50, 0x2e, 0xd5, 0x28, 0x27, 0x5f, 0x13, 0x77,
		0x2d, 0xc8, 0x95, 0x77, 0xe5, 0x04, 0x13, 0x5d, 0xce, 0x55, 0x3c, 0x50, 0x26, 0x6a, 0x87, 0x62,
		0xeb, 0xe1, 0xd2, 0x8e, 0xba, 0xc3, 0xf1, 0x0f, 0x87, 0x4a, 0x9b, 0x2e, 0x0a, 0x34, 0x9b, 0x14,
		0x1b, 0xe3, 0xbb, 0xbb, 0x1c, 0xdf, 0x5c, 0x7b, 0xfc, 0x83, 0xd4, 0x41, 0xa3, 0xf2, 0x83, 0x2d,
		0x31, 0xd0, 0x8a, 0x0b, 0x4d, 0x24, 0x0b, 0x4c, 0x79, 0x3b, 0x38, 0x0d, 0x3b, 0x5f, 0x52, 0x10,
		0xcd, 0x70, 0x7c, 0x1a, 0xd5, 0xf1, 0x69, 0xe3, 0x83, 0xd2, 0x46, 0x16, 0x9e, 0x62, 0x4f, 0x26,
		0x77, 0x32, 0xea, 0xd2, 0x00, 0xc8, 0x9e, 0x59, 0x56, 0xa0, 0xdc, 0xc3, 0x57, 0x81, 0x27, 0x83,
		0x27, 0xdb, 0x89, 0x27, 0xc3, 0x1e, 0x3e, 0xa4, 0xdc, 0x48, 0xb9, 0x91, 0x72, 0x2b, 0xc6, 0x50,
		0xec, 0xe1, 0xc3, 0x1e, 0x3e, 0x78, 0x3f, 0x78, 0xbf, 0x7d, 0xf4, 0x7e, 0xd8, 0xc3, 0x27, 0x72,
		0x63, 0xd8, 0xc3, 0x87, 0x25, 0x5e, 0x2c, 0xf1, 0x16, 0xb0, 0xc4, 0xab, 0xc8, 0x5a, 0x1a, 0xf6,
		0xee, 0xcd, 0x36, 0x4a, 0xc3, 0x5d, 0x65, 0x70, 0x17, 0xb8, 0x0b, 0xdc, 0x45, 0x21, 0x34, 0x45,
		0x0d, 0x99, 0x6f, 0x2f, 0x74, 0x33, 0x64, 0x32, 0x97, 0x07, 0x8d, 0x12, 0x0d, 0x21, 0x2d, 0x8b,
		0x90, 0xb9, 0x00, 0x1d, 0xae, 0x60, 0xa5, 0x4b, 0x78, 0xef, 0xb1, 0xb0, 0x48, 0x48, 0x21, 0xc4,
		0x4e, 0x41, 0xbb, 0x73, 0xd0, 0xee, 0x24, 0xd6, 0x3a, 0x8b, 0x61, 0xcf, 0xa7, 0x0d, 0x4f, 0x88,
		0x66, 0x2d, 0x59, 0xda, 0xb6, 0x34, 0x67, 0x29, 0xb7, 0xfe, 0x2e, 0xc5, 0x7f, 0xc2, 0x4d, 0xa7,
		0x5a, 0xb6, 0x02, 0x6b, 0xca, 0x17, 0xe9, 0xf3, 0x46, 0xad, 0xf9, 0xe3, 0xe2, 0xb0, 0x11, 0x6f,
		0x15, 0xd6, 0x9d, 0xa4, 0x24, 0x91, 0xac, 0x68, 0xc8, 0x2f, 0xb5, 0xe6, 0x99, 0x9a, 0xf3, 0xcd,
		0x5c, 0x0d, 0xe9, 0x41, 0x3a, 0x5b, 0x7b, 0x4a, 0x49, 0x7e, 0x4c, 0x30, 0xe5, 0x8b, 0x8e, 0x17,
		0x72, 0x73, 0x18, 0xa9, 0x89, 0xc1, 0x75, 0xd2, 0x30, 0xe0, 0x15, 0xf0, 0x0a, 0x78, 0x05, 0xbc,
		0x02, 0x5e, 0x01, 0xaf, 0x20, 0x1d, 0xc0, 0x2b, 0xe0, 0x15, 0xf0, 0x4a, 0x07, 0xaf, 0x9c, 0x05,
		0x6f, 0xa6, 0xab, 0x83, 0x5e, 0xc7, 0x2d, 0x03, 0x5f, 0x81, 0xaf, 0xc0, 0xd7, 0xbd, 0xc3, 0xd7,
		0x90, 0x9b, 0xdc, 0x20, 0x76, 0x02, 0xb3, 0x8e, 0xe0, 0x8c, 0xb0, 0xc9, 0x6f, 0xde, 0x28, 0x86,
		0x15, 0x3d, 0xd3, 0xf3, 0x43, 0x66, 0xf9, 0x9e, 0x4d, 0x6a, 0x6b, 0x80, 0x58, 0x7d, 0x3b, 0x79,
		0x00, 0xb1, 0xbb, 0x87, 0x58, 0xdd, 0x43, 0x5a, 0x3e, 0xab, 0x56, 0x4f, 0x4e, 0xab, 0xd5, 0xd2,
		0xe9, 0xd1, 0x69, 0xe9, 0xfc, 0xf8, 0xb8, 0x7c, 0x22, 0x73, 0x78, 0x1f, 0xb8, 0x76, 0x7f, 0xb8,
		0xb6, 0x4b, 0x38, 0xeb, 0xa3, 0x90, 0x36, 0x68, 0x14, 0x34, 0x0b, 0x9a, 0x05, 0xcd, 0xee, 0x1d,
		0xcd, 0x42, 0x8c, 0x05, 0xc7, 0x2e, 0x0c, 0x1b, 0xc4, 0xd8, 0xdc, 0x71, 0x2c, 0xc4, 0x58, 0x40,
		0xeb, 0x6e, 0xa1, 0xd5, 0xe0, 0x4e, 0x97, 0x69, 0x21, 0xd7, 0x51, 0xcb, 0xc0, 0x57, 0xe0, 0x2b,
		0xf0, 0x75, 0xef, 0xf0, 0x75, 0x60, 0xfb, 0xdc, 0xb1, 0xbe, 0x87, 0x5a, 0x00, 0x16, 0x52, 0x2c,
		0xa4, 0x58, 0x20, 0x6c, 0x3a, 0x10, 0x16, 0x52, 0x2c, 0xa8, 0x36, 0x65, 0x54, 0x4b, 0xe8, 0xc8,
		0xa6, 0x40, 0xeb, 0x78, 0x60, 0x59, 0xb0, 0x2c, 0x58, 0x76, 0xff, 0x58, 0x16, 0x52, 0x2c, 0x38,
		0x76, 0x61, 0xd8, 0x20, 0xc5, 0xe6, 0x8e, 0x63, 0x21, 0xc5, 0x02, 0x5a, 0x77, 0x0b, 0xad, 0xba,
		0xa4, 0xd8, 0x49, 0xcb, 0xc0, 0x57, 0xe0, 0x2b, 0xf0, 0x75, 0xef, 0xf0, 0x15, 0x52, 0x2c, 0x10,
		0x56, 0x9f, 0xff, 0x06, 0xc2, 0xa6, 0x07, 0x61, 0x21, 0xc5, 0x82, 0x6a, 0x09, 0xa9, 0x76, 0xa7,
		0x25, 0xbe, 0x88, 0x0e, 0x10, 0x8a, 0xda, 0xd3, 0x7b, 0x90, 0xd0, 0xf0, 0xe0, 0x87, 0x43, 0xba,
		0x9a, 0x7f, 0x05, 0xcd, 0x67, 0x0b, 0x35, 0x07, 0xf7, 0xdb, 0xbe, 0x1e, 0xdc, 0x6f, 0x63, 0x78,
		0xbb, 0x19, 0x2c, 0xdb, 0x38, 0x3c, 0x44, 0xcf, 0x78, 0x76, 0xcc, 0xd0, 0xb0, 0xfa, 0x41, 0xc0,
		0x08, 0x2a, 0x62, 0x4c, 0x4f, 0x52, 0x59, 0x6e, 0x1b, 0x45, 0x1c, 0x63, 0x65, 0x47, 0x28, 0xe2,
		0x88, 0x22, 0x8e, 0xf1, 0x9e, 0x0c, 0x45, 0x1c, 0x21, 0x98, 0x40, 0x30, 0x81, 0x60, 0x92, 0x3a,
		0xc1, 0x04, 0xeb, 0x7d, 0x10, 0x4b, 0x16, 0x86, 0x0d, 0xeb, 0x7d, 0xb9, 0x13, 0x4b, 0xb0, 0xde,
		0x07, 0x65, 0x64, 0x77, 0x53, 0x1e, 0x45, 0x1c, 0x01, 0xaf, 0x80, 0x57, 0xc0, 0x2b, 0xe0, 0x15,
		0xf0, 0x0a, 0x78, 0x05, 0xbc, 0x02, 0x5e, 0x01, 0xaf, 0x59, 0x82, 0x57, 0x14, 0x71, 0x04, 0xbe,
		0x02, 0x5f, 0x81, 0xaf, 0xd4, 0x73, 0x16, 0x45, 0x1c, 0x01, 0xb1, 0x3a, 0x3d, 0x38, 0x20, 0x36,
		0x3d, 0x10, 0x8b, 0xed, 0x6a, 0xe0, 0xda, 0x74, 0x71, 0x2d, 0x8a, 0x38, 0x82, 0x66, 0x41, 0xb3,
		0xa0, 0x59, 0xaa, 0x39, 0x0b, 0x31, 0x16, 0x1c, 0xbb, 0x30, 0x6c, 0x10, 0x63, 0x73, 0xc7, 0xb1,
		0x10, 0x63, 0x01, 0xad, 0xbb, 0x85, 0x56, 0x14, 0x71, 0x04, 0xbe, 0x02, 0x5f, 0x81, 0xaf, 0xc4,
		0x73, 0x16, 0x6f, 0x0e, 0x03, 0x61, 0xf5, 0xf9, 0x6f, 0x20, 0x6c, 0x7a, 0x10, 0x16, 0x52, 0x2c,
		0xa8, 0x36, 0x65, 0x54, 0x8b, 0x22, 0x8e, 0x60, 0x59, 0xb0, 0x2c, 0x58, 0x96, 0x68, 0xce, 0x42,
		0x8a, 0x05, 0xc7, 0x2e, 0x0c, 0x1b, 0xa4, 0xd8, 0xdc, 0x71, 0x2c, 0xa4, 0x58, 0x40, 0xeb, 0x6e,
		0xa1, 0x15, 0x45, 0x1c, 0x81, 0xaf, 0xc0, 0x57, 0xe0, 0x2b, 0xf1, 0x9c, 0x85, 0x14, 0x0b, 0x84,
		0xd5, 0xe7, 0xbf, 0x81, 0xb0, 0xe9, 0x41, 0x58, 0x48, 0xb1, 0xa0, 0x5a, 0x42, 0xaa, 0x45, 0x11,
		0x47, 0xc1, 0x22, 0x8e, 0xe4, 0xa5, 0xff, 0x0a, 0x89, 0xd4, 0x72, 0xbc, 0x19, 0xdc, 0xf6, 0x85,
		0x63, 0x86, 0x97, 0xe3, 0x9b, 0xce, 0x60, 0x45, 0x47, 0xbf, 0xcf, 0x7b, 0x7d, 0x6e, 0x74, 0x02,
		0xf6, 0x3f, 0x7d, 0xe6, 0x59, 0xef, 0x74, 0xf5, 0x1c, 0x97, 0x5a, 0xa6, 0xa9, 0xe6, 0x58, 0x42,
		0x35, 0xc7, 0x1d, 0x26, 0x49, 0xa8, 0xe6, 0x98, 0x22, 0x57, 0x4f, 0x96, 0xfa, 0x44, 0xf3, 0x2f,
		0x32, 0xd6, 0x61, 0xce, 0x48, 0x31, 0xff, 0xe8, 0xb2, 0x9d, 0x69, 0x96, 0x73, 0xfb, 0xf5, 0xdf,
		0x14, 0xb7, 0x46, 0x9b, 0xd5, 0x10, 0x26, 0xa0, 0x3a, 0xb2, 0x18, 0x4d, 0xa8, 0xab, 0x2b, 0x6b,
		0xd1, 0xc9, 0xb1, 0x84, 0x59, 0x8a, 0x96, 0xec, 0x44, 0xf7, 0x50, 0xe9, 0xcf, 0x46, 0xb4, 0x8e,
		0x5e, 0x4a, 0x28, 0xff, 0x29, 0xbb, 0xb0, 0x37, 0xaa, 0x96, 0x4e, 0x0d, 0x7a, 0x14, 0x35, 0xd8,
		0x51, 0xb2, 0x1b, 0x90, 0x07, 0xc8, 0x9b, 0x7b, 0x32, 0x94, 0xec, 0xde, 0xad, 0x0b, 0xd0, 0xe1,
		0x0a, 0x56, 0xba, 0x04, 0x2c, 0x8f, 0x69, 0x76, 0x12, 0x6b, 0x9d, 0x05, 0x96, 0xc7, 0x64, 0xe6,
		0x2c, 0x76, 0x77, 0x61, 0x69, 0x6c, 0x61, 0xd8, 0xb0, 0xbb, 0x2b, 0x89, 0xa4, 0x53, 0x6b, 0xf2,
		0xb9, 0x38, 0xa4, 0xd8, 0xdd, 0xa5, 0xd9, 0xd1, 0xd3, 0xb7, 0x86, 0x92, 0xdd, 0x31, 0xa2, 0x17,
		0x4a, 0x76, 0x03, 0x5e, 0x01, 0xaf, 0x80, 0x57, 0xc0, 0x2b, 0xe0, 0x15, 0xf0, 0x0a, 0x78, 0x05,
		0xbc, 0x02, 0x5e, 0xe9, 0xe1, 0x15, 0x25, 0xbb, 0x81, 0xaf, 0xc0, 0x57, 0xe0, 0x2b, 0xf5, 0x9c,
		0x45, 0xc9, 0x6e, 0x40, 0xac, 0x4e, 0x0f, 0x0e, 0x88, 0x4d, 0x0f, 0xc4, 0xe2, 0xe5, 0x04, 0x70,
		0x6d, 0xba, 0xb8, 0x16, 0x25, 0xbb, 0x41, 0xb3, 0xa0, 0x59, 0xd0, 0x2c, 0xd5, 0x9c, 0x85, 0x18,
		0x0b, 0x8e, 0x5d, 0x18, 0x36, 0x88, 0xb1, 0xb9, 0xe3, 0x58, 0x88, 0xb1, 0x80, 0xd6, 0xdd, 0x42,
		0x2b, 0x4a, 0x76, 0x03, 0x5f, 0x81, 0xaf, 0xc0, 0x57, 0xe2, 0x39, 0x8b, 0x3a, 0x31, 0x40, 0x58,
		0x7d, 0xfe, 0x1b, 0x08, 0x9b, 0x1e, 0x84, 0x85, 0x14, 0x0b, 0xaa, 0x4d, 0x19, 0xd5, 0xa2, 0x64,
		0x37, 0x58, 0x16, 0x2c, 0x0b, 0x96, 0x25, 0x9a, 0xb3, 0x90, 0x62, 0xc1, 0xb1, 0x0b, 0xc3, 0x06,
		0x29, 0x36, 0x77, 0x1c, 0x0b, 0x29, 0x16, 0xd0, 0xba, 0x5b, 0x68, 0x45, 0xc9, 0x6e, 0xe0, 0x2b,
		0xf0, 0x15, 0xf8, 0x4a, 0x3c, 0x67, 0x21, 0xc5, 0x02, 0x61, 0xf5, 0xf9, 0x6f, 0x20, 0x6c, 0x7a,
		0x10, 0x16, 0x52, 0x2c, 0xa8, 0x96, 0x90, 0x6a, 0x51, 0xb2, 0x5b, 0xb0, 0x64, 0x37, 0x61, 0xd1,
		0xbf, 0x42, 0x22, 0xc5, 0xba, 0xef, 0x87, 0x37, 0xdc, 0x18, 0xde, 0x6f, 0x06, 0x4b, 0x37, 0x72,
		0x33, 0x78, 0x61, 0xdc, 0xd0, 0x53, 0xc1, 0x71, 0x55, 0xe3, 0xa8, 0xd6, 0x1d, 0x2b, 0x43, 0x42,
		0x21, 0x47, 0x14, 0x72, 0x4c, 0x38, 0xeb, 0xd1, 0x22, 0xd6, 0x53, 0x8a, 0xf4, 0x5a, 0xc4, 0xf9,
		0xfd, 0x2c, 0xd7, 0x5d, 0x41, 0xb9, 0xee, 0xac, 0x94, 0xeb, 0x3e, 0xc2, 0x50, 0xa1, 0x36, 0xb7,
		0x02, 0xe0, 0xfd, 0x30, 0x86, 0xc7, 0xe0, 0x10, 0x52, 0xdd, 0xa4, 0x45, 0xa0, 0x1c, 0x50, 0x0e,
		0x28, 0x97, 0x6a, 0x94, 0x7b, 0xf6, 0x7d, 0x97, 0x99, 0x1e, 0x25, 0xc8, 0x95, 0x77, 0xe5, 0x04,
		0x0f, 0x12, 0x1c, 0x12, 0x2a, 0xed, 0x24, 0x09, 0xcd, 0x44, 0x61, 0x70, 0xb5, 0xcb, 0x23, 0x72,
		0x16, 0x29, 0x3e, 0xd4, 0x62, 0x57, 0x08, 0x4e, 0x8a, 0x81, 0x8f, 0x1c, 0x55, 0x47, 0xb2, 0x99,
		0xa8, 0x7b, 0x2c, 0xde, 0x38, 0x21, 0xaf, 0x71, 0x2e, 0x17, 0x7f, 0x07, 0x39, 0x40, 0xdd, 0x65,
		0x03, 0x6f, 0x37, 0x20, 0x2a, 0xaf, 0xef, 0xba, 0x1f, 0x0e, 0x64, 0xe8, 0x54, 0xbd, 0x91, 0xfb,
		0xc0, 0x66, 0x01, 0xb3, 0x2f, 0xde, 0xc7, 0x4d, 0x68, 0xed, 0x70, 0x45, 0xeb, 0xd3, 0x6b, 0x75,
		0x12, 0xf6, 0xa6, 0xd1, 0xce, 0xc4, 0x2c, 0x2c, 0xbe, 0x9d, 0xc4, 0xfb, 0x64, 0xcc, 0x81, 0x95,
		0x1d, 0x50, 0x3d, 0x03, 0x29, 0x30, 0x80, 0x1a, 0x06, 0x2e, 0xde, 0x80, 0x6d, 0xef, 0xfe, 0x18,
		0x5d, 0x5f, 0x1c, 0xc5, 0x87, 0xb8, 0x3d, 0x3e, 0x57, 0x06, 0x2a, 0x6e, 0x58, 0x11, 0x3c, 0x5a,
		0x67, 0x8a, 0xeb, 0x31, 0x25, 0x08, 0x19, 0x2c, 0x57, 0xc7, 0x6f, 0x59, 0xcc, 0x56, 0xc6, 0x69,
		0x65, 0x6c, 0x26, 0xc1, 0x63, 0x5a, 0xe3, 0x17, 0x3d, 0x6a, 0xa6, 0x68, 0xf9, 0x9e, 0xc7, 0x2c,
		0xee, 0x07, 0xa3, 0xe3, 0x02, 0x85, 0x07, 0x61, 0x32, 0xfc, 0x0b, 0xed, 0x88, 0x46, 0x7d, 0xa9,
		0xfc, 0x54, 0x3a, 0x1f, 0x55, 0xc9, 0x3f, 0xe9, 0xf2, 0x4d, 0xd5, 0xfc, 0x92, 0x2c, 0x9f, 0x24,
		0xcb, 0x1f, 0x49, 0xf3, 0x45, 0xbd, 0x9c, 0x29, 0x9d, 0xff, 0x4d, 0x0b, 0x78, 0xda, 0xcc, 0xe3,
		0x0e, 0x7f, 0x0f, 0x58, 0x47, 0x66, 0xf0, 0x27, 0xbe, 0x5c, 0x62, 0x4b, 0x42, 0xf1, 0x7a, 0xfc,
		0xd5, 0x17, 0x66, 0xa8, 0x30, 0x7d, 0x26, 0x0f, 0xf2, 0xf9, 0xfa, 0xa2, 0xfe, 0xd0, 0xbe, 0xbc,
		0xbf, 0xbb, 0xab, 0x5f, 0xb6, 0xee, 0x1f, 0xda, 0xad, 0x3f, 0x1a, 0x75, 0xd9, 0x99, 0x34, 0x54,
		0x3c, 0x43, 0x25, 0x89, 0x9f, 0x48, 0x3a, 0xbb, 0xb9, 0x9c, 0x3e, 0x52, 0x71, 0x17, 0x72, 0x20,
		0xd1, 0x73, 0x34, 0x73, 0xf2, 0x1c, 0xb7, 0x8d, 0x7b, 0x92, 0x07, 0x39, 0x48, 0x46, 0x4d, 0xfe,
		0xa9, 0x8b, 0xf5, 0x05, 0xc0, 0xc8, 0x36, 0x39, 0x33, 0x2c, 0xdf, 0x56, 0x08, 0xcb, 0xd3, 0x26,
		0x10, 0x91, 0x11, 0x91, 0x73, 0x1e, 0x91, 0x87, 0x93, 0xdd, 0xf4, 0x6c, 0xd9, 0xf7, 0x07, 0xa2,
		0x98, 0x2c, 0xb1, 0x4b, 0xb8, 0xd8, 0x30, 0x39, 0x67, 0x81, 0x27, 0x1d, 0xfa, 0x8a, 0xff, 0xfd,
		0x67, 0xc9, 0x38, 0x7f, 0xfa, 0xbb, 0xfa, 0xf3, 0xf1, 0xd1, 0x18, 0xfd, 0x58, 0x99, 0xfd, 0xb1,
		0x35, 0xf9, 0xe1, 0xd3, 0xd2, 0x0f, 0xbf, 0x3c, 0x3e, 0x7e, 0x1c, 0xfe, 0xfc, 0x8f, 0x5f, 0xff,
		0xf3, 0x5f, 0x7f, 0xfe, 0xc3, 0x78, 0x5a, 0xfa, 0xc4, 0x7f, 0x88, 0x0f, 0xf6, 0x53, 0x0a, 0x1c,
		0x20, 0xf3, 0xcc, 0x67, 0x97, 0xd9, 0xf2, 0xee, 0x6f, 0xd2, 0x00, 0x9c, 0x1f, 0x9c, 0x5f, 0xce,
		0x9d, 0x9f, 0xfc, 0xf2, 0x93, 0xe4, 0x72, 0x93, 0x26, 0x93, 0xe7, 0xaf, 0x2c, 0xf0, 0x18, 0x37,
		0x7a, 0x5d, 0x15, 0xbb, 0x9f, 0x6d, 0x05, 0xc6, 0x0f, 0xe3, 0x87, 0x16, 0x91, 0x0d, 0x2d, 0xa2,
		0xde, 0xfa, 0x5a, 0x7f, 0xb8, 0xab, 0xb7, 0xda, 0x8d, 0xdb, 0xab, 0x9c, 0x08, 0x11, 0xf5, 0xd6,
		0xd7, 0x76, 0xb9, 0x54, 0xfa, 0x72, 0x51, 0x6b, 0xd6, 0xdb, 0xcd, 0x87, 0x6a, 0x96, 0x93, 0xf8,
		0xd1, 0xb3, 0x8c, 0x1e, 0xe5, 0xe6, 0x21, 0xeb, 0x4f, 0x52, 0x1d, 0x3f, 0x49, 0xa3, 0x79, 0x9b,
		0x83, 0x51, 0x89, 0x86, 0x25, 0xf3, 0xcf, 0xf2, 0xed, 0xee, 0xaa, 0xfe, 0xf9, 0xfa, 0xae, 0x7e,
		0x95, 0x87, 0x41, 0x69, 0xd7, 0xee, 0x2f, 0x33, 0x6f, 0x28, 0xff, 0x95, 0x1f, 0xa3, 0x9f, 0x71,
		0xc5, 0xe5, 0x52, 0x5e, 0x7c, 0xf1, 0xbf, 0x1e, 0xf2, 0xf2, 0x24, 0xcd, 0x87, 0xfc, 0x18, 0x4b,
		0x33, 0x3f, 0xc6, 0x72, 0xf9, 0xfb, 0x55, 0xf6, 0x63, 0x64, 0x35, 0x4f, 0x10, 0x36, 0x7e, 0x96,
		0x7a, 0x9e, 0x80, 0xf2, 0x36, 0x37, 0xc3, 0x92, 0x2b, 0xa4, 0xbc, 0xbc, 0xc9, 0x87, 0xc1, 0xb4,
		0x6b, 0x97, 0x97, 0xf9, 0x19, 0x94, 0x87, 0xdc, 0xf8, 0xe3, 0x1c, 0xf9, 0xb0, 0x7a, 0x6e, 0x92,
		0xe2, 0x9b, 0xfc, 0xcc, 0x2f, 0x35, 0x53, 0xd9, 0xa3, 0x0d, 0x07, 0xb3, 0xb2, 0xb9, 0xd1, 0x0b,
		0x98, 0xe5, 0x7b, 0x1d, 0x1a, 0x11, 0x3e, 0x6a, 0x0d, 0x62, 0x7c, 0x8c, 0x96, 0x20, 0xc6, 0x13,
		0x5a, 0x0a, 0xc4, 0x78, 0x05, 0x1f, 0x0a, 0x31, 0x3e, 0x2b, 0xb9, 0x13, 0xc4, 0xf8, 0x02, 0xc4,
		0x78, 0x0d, 0xcf, 0x02, 0x31, 0x3e, 0xb5, 0xfa, 0x22, 0xc4, 0xf8, 0x54, 0xfa, 0x62, 0x88, 0xf1,
		0x05, 0x88, 0xf1, 0x5a, 0xa5, 0x1f, 0x88, 0xf1, 0xe9, 0x1c, 0x18, 0x88, 0xf1, 0xa9, 0x1c, 0x16,
		0x88, 0xf1, 0xa9, 0x44, 0x31, 0x88, 0xf1, 0x69, 0xf4, 0xc7, 0x10, 0xe3, 0x53, 0x38, 0x28, 0x10,
		0xe3, 0x65, 0xa4, 0xbf, 0xc9, 0x7f, 0xd9, 0x14, 0xe3, 0x3b, 0x66, 0xdf, 0xe5, 0x86, 0xe5, 0x7b,
		0xb6, 0x23, 0x55, 0x9d, 0x25, 0xea, 0xfd, 0xc5, 0x86, 0x20, 0xc1, 0xc7, 0x68, 0x09, 0x12, 0x3c,
		0xa1, 0x7d, 0xe0, 0x65, 0x18, 0x49, 0x17, 0xc0, 0x2c, 0xc3, 0xf2, 0x83, 0x80, 0x59, 0x9c, 0xd9,
		0xc6, 0xf3, 0xa8, 0xd6, 0xa7, 0xac, 0x17, 0x58, 0x6e, 0x0b, 0x8e, 0x00, 0x8e, 0x20, 0xe7, 0x8e,
		0xc0, 0xf2, 0xfb, 0x1e, 0x67, 0x81, 0x54, 0x7d, 0x6d, 0x85, 0x33, 0x83, 0x14, 0x2b, 0x5d, 0x2b,
		0x14, 0x41, 0xa4, 0xa8, 0x64, 0x4d, 0x55, 0x2e, 0x96, 0xa8, 0xfc, 0x31, 0x65, 0xb9, 0x63, 0x95,
		0xf2, 0xbe, 0x14, 0x95, 0xa7, 0xa9, 0xbb, 0x96, 0xfe, 0x8c, 0x1b, 0xd2, 0xde, 0x4e, 0xa8, 0x24,
		0xe5, 0x53, 0xfa, 0x62, 0xf5, 0x3b, 0x67, 0x74, 0xc1, 0x7a, 0xd8, 0x18, 0xa2, 0x35, 0xa2, 0x35,
		0xa2, 0x35, 0xa2, 0x35, 0xa2, 0x35, 0xa2, 0x35, 0xa2, 0x35, 0x41, 0xb4, 0xee, 0x2a, 0x55, 0xd6,
		0x8a, 0x5a, 0x40, 0x5c, 0x46, 0x5c, 0xc6, 0x8e, 0xd6, 0x38, 0x92, 0x5a, 0x0a, 0x4a, 0x5d, 0xd6,
		0x2f, 0xdb, 0xb7, 0xf7, 0x57, 0xf5, 0x9c, 0xec, 0x66, 0x1d, 0x3c, 0x4e, 0xed, 0x5b, 0xeb, 0x3e,
		0xcb, 0x6b, 0x43, 0x83, 0x67, 0xa8, 0xdf, 0xd5, 0x2e, 0x6e, 0xb2, 0xbd, 0xc3, 0x70, 0xf0, 0x18,
		0x57, 0xd7, 0x4d, 0xd5, 0xe7, 0xd8, 0xa7, 0xf5, 0x2d, 0x66, 0x19, 0x21, 0x37, 0x79, 0x5f, 0x31,
		0x4f, 0x1e, 0xb7, 0x81, 0x30, 0x8c, 0x30, 0x8c, 0x30, 0x9c, 0x9d, 0x30, 0xdc, 0x6c, 0xd5, 0x5a,
		0xdf, 0x9a, 0x39, 0x0a, 0xc4, 0xe3, 0x07, 0xfa, 0x76, 0x77, 0x73, 0x7f, 0xf9, 0x5b, 0xf6, 0x83,
		0xd9, 0xf8, 0x71, 0x94, 0x1f, 0x66, 0xcf, 0x22, 0x5a, 0xdf, 0x1b, 0xeb, 0xb6, 0xe6, 0xb3, 0xcb,
		0x8c, 0x67, 0xd7, 0xb7, 0xbe, 0x2b, 0xc6, 0xb7, 0x95, 0x2d, 0x22, 0xda, 0x21, 0xda, 0x41, 0x0c,
		0xde, 0x3a, 0xe1, 0x21, 0x06, 0x2b, 0x2a, 0x96, 0x10, 0x83, 0xb5, 0x75, 0x2d, 0xc4, 0xe0, 0x42,
		0x8a, 0xc4, 0xe0, 0xf9, 0x28, 0x3b, 0x70, 0xfb, 0xa4, 0x61, 0x7b, 0xd4, 0x20, 0xa2, 0x36, 0xa2,
		0x36, 0xa2, 0x36, 0xa2, 0x36, 0xa2, 0x36, 0xa2, 0x36, 0xa2, 0xb6, 0x6a, 0xd4, 0xf6, 0x83, 0xae,
		0xd1, 0x31, 0x2d, 0xee, 0x07, 0x0a, 0x91, 0x7a, 0xa6, 0x11, 0x44, 0x67, 0x44, 0x67, 0x28, 0xc8,
		0x31, 0xa6, 0x7c, 0x0a, 0x14, 0xe4, 0xd6, 0x43, 0xed, 0xae, 0x79, 0x59, 0xbf, 0xfe, 0x67, 0xfd,
		0xa1, 0xfd, 0xf9, 0xfe, 0xe1, 0xb6, 0xfd, 0xb9, 0x96, 0xa3, 0xb3, 0x0b, 0xff, 0x4f, 0xf3, 0x73,
		0xa3, 0xdd, 0xb8, 0xf9, 0xd6, 0xcc, 0xb2, 0x88, 0x3c, 0x78, 0x88, 0xca, 0x59, 0x96, 0x9f, 0xe0,
		0xf2, 0x73, 0x23, 0xcb, 0xb7, 0xff, 0x5f, 0x95, 0x8c, 0x77, 0x7e, 0xa6, 0xdf, 0x79, 0xfd, 0xaf,
		0x6c, 0x4f, 0x9e, 0xcb, 0xcf, 0x8d, 0x4a, 0xbb, 0x76, 0x99, 0xe9, 0xad, 0x25, 0xf7, 0xad, 0xaf,
		0xd9, 0x7e, 0x05, 0xbc, 0x99, 0xed, 0x39, 0x74, 0x77, 0x7f, 0x37, 0x88, 0x62, 0x5f, 0xbe, 0xd4,
		0x2e, 0x6e, 0xea, 0x99, 0x36, 0x86, 0x46, 0xed, 0xb7, 0xac, 0x1b, 0x73, 0xd6, 0x51, 0x22, 0xe3,
		0x76, 0xac, 0x8a, 0x73, 0xfb, 0xb4, 0x8c, 0x3e, 0xcd, 0xc9, 0xd5, 0x8b, 0x10, 0xaf, 0x6a, 0x0c,
		0x89, 0x3e, 0x12, 0x7d, 0x24, 0xfa, 0x48, 0xf4, 0x91, 0xe8, 0x23, 0xd1, 0x47, 0xa2, 0x8f, 0x44,
		0x1f, 0x89, 0x3e, 0x12, 0x7d, 0x24, 0xfa, 0x48, 0xf4, 0x91, 0xe8, 0x23, 0xd1, 0x47, 0xa2, 0x9f,
		0x5c, 0xa2, 0xef, 0x78, 0xbd, 0x3e, 0x37, 0x7a, 0xfe, 0x5f, 0x4c, 0x61, 0x05, 0x7f, 0xb6, 0x11,
		0xb9, 0xc4, 0xbe, 0x8c, 0xc4, 0x1e, 0x89, 0x7d, 0x32, 0x89, 0xfd, 0x95, 0x13, 0xc8, 0x0d, 0xbf,
		0xf9, 0xf6, 0xa2, 0x9e, 0x4b, 0x0f, 0x1a, 0x91, 0xec, 0x62, 0xb5, 0x5d, 0x54, 0xd2, 0x26, 0x43,
		0x61, 0x3a, 0x2b, 0x4d, 0xe8, 0xbd, 0x27, 0x5c, 0x51, 0x89, 0xd2, 0x88, 0xc8, 0x8d, 0x89, 0xdc,
		0xa8, 0xd6, 0x1a, 0xd7, 0xb0, 0xe7, 0x92, 0xde, 0xa0, 0x26, 0x39, 0x6b, 0xa4, 0x75, 0xb4, 0xa5,
		0x39, 0x63, 0x33, 0xcb, 0xe9, 0x9a, 0xae, 0xd4, 0xb6, 0xd6, 0xa5, 0x78, 0x53, 0x51, 0x68, 0x63,
		0x69, 0xb3, 0xa0, 0x4a, 0x63, 0x6a, 0x9b, 0x66, 0x69, 0xd8, 0xa9, 0x40, 0xb5, 0x89, 0x76, 0xb1,
		0x9b, 0x2b, 0x1f, 0x68, 0x9a, 0x23, 0xda, 0x54, 0xbb, 0x7e, 0x04, 0x4b, 0xca, 0xed, 0xfe, 0xfc,
		0x40, 0x30, 0x04, 0x04, 0x9b, 0x6d, 0x17, 0x87, 0xe0, 0x68, 0x8f, 0x86, 0xe0, 0x60, 0x37, 0x57,
		0x3f, 0x25, 0xb4, 0xe3, 0x57, 0x62, 0x8a, 0x15, 0x1d, 0x2f, 0xe4, 0xe6, 0x30, 0x72, 0x28, 0x82,
		0xcb, 0xa4, 0x21, 0xc0, 0x0b, 0xe0, 0x05, 0xf0, 0x02, 0x78, 0x01, 0xbc, 0x00, 0x5e, 0x00, 0x2f,
		0x80, 0x17, 0xbd, 0xf0, 0xc2, 0x59, 0xf0, 0x66, 0xba, 0x14, 0xf4, 0x32, 0x6e, 0x09, 0xf8, 0x02,
		0x7c, 0x01, 0xbe, 0x08, 0xcf, 0x99, 0x90, 0x9b, 0xdc, 0x50, 0x34, 0xa2, 0x82, 0xda, 0xeb, 0xc5,
		0x51, 0x13, 0xdf, 0xbc, 0x91, 0xcf, 0x2d, 0x7a, 0xa6, 0xe7, 0x87, 0xcc, 0xf2, 0x3d, 0x5b, 0x69,
		0x2e, 0xe7, 0x1a, 0x62, 0x4a, 0x80, 0x98, 0x5d, 0x43, 0x0c, 0xf5, 0x10, 0xd0, 0xbf, 0xfe, 0x0c,
		0xae, 0x49, 0x96, 0x6b, 0xba, 0x0a, 0xb3, 0x2c, 0x72, 0xc9, 0x83, 0x46, 0x40, 0x33, 0xa0, 0x19,
		0xd0, 0x0c, 0xc4, 0x18, 0x88, 0x31, 0xe0, 0x18, 0x88, 0x31, 0x80, 0x16, 0xcd, 0xd0, 0x62, 0x70,
		0xa7, 0xcb, 0x48, 0xc8, 0x65, 0xd4, 0x12, 0xf0, 0x05, 0xf8, 0x02, 0x7c, 0x11, 0x9e, 0x33, 0x03,
		0xdb, 0xe1, 0x8e, 0xf5, 0x3d, 0x24, 0x01, 0x18, 0x48, 0x31, 0x90, 0x62, 0x20, 0xc5, 0x40, 0x8a,
		0xd9, 0x53, 0xaa, 0x51, 0x30, 0xf4, 0x29, 0xd0, 0x38, 0x1e, 0x58, 0x06, 0x2c, 0x03, 0x96, 0x81,
		0x14, 0x03, 0x29, 0x06, 0x1c, 0x03, 0x29, 0x06, 0xd0, 0xa2, 0x1b, 0x5a, 0xa8, 0xa4, 0x98, 0x49,
		0x4b, 0xc0, 0x17, 0xe0, 0x0b, 0xf0, 0x05, 0x52, 0x0c, 0xa4, 0x18, 0x20, 0x0c, 0xa4, 0x18, 0x50,
		0x8d, 0x2a, 0xd5, 0x68, 0x7d, 0x85, 0xbb, 0xe6, 0x79, 0x3e, 0x37, 0x07, 0x43, 0x22, 0xf7, 0x26,
		0x77, 0x68, 0xbd, 0xb2, 0xae, 0xd9, 0x33, 0xf9, 0xeb, 0xc0, 0x61, 0x1e, 0xfa, 0x3d, 0xe6, 0x59,
		0x43, 0x12, 0x31, 0x7a, 0xae, 0xc9, 0x3b, 0x7e, 0xd0, 0x3d, 0xb4, 0xfc, 0x6e, 0xcf, 0xf7, 0x98,
		0xc7, 0xc3, 0xe9, 0x8f, 0x87, 0x33, 0x6f, 0xb5, 0x1f, 0x86, 0xdc, 0xe4, 0xec, 0x50, 0xbe, 0xf2,
		0xc1, 0xe8, 0x46, 0x78, 0xd0, 0xb7, 0xb8, 0x37, 0x29, 0xa1, 0x13, 0xdd, 0x47, 0x63, 0x7c, 0x1b,
		0xed, 0xcb, 0xe8, 0x36, 0xa6, 0x3f, 0xb6, 0x5b, 0xd3, 0xdb, 0x68, 0x37, 0x07, 0xb7, 0xd1, 0xbe,
		0x1e, 0xdc, 0x46, 0x63, 0x78, 0x17, 0x29, 0xa8, 0x29, 0xe1, 0x9a, 0x21, 0x0b, 0x8c, 0x67, 0xc7,
		0x0c, 0x0d, 0xab, 0x1f, 0x04, 0x4c, 0xe2, 0xf5, 0xb3, 0x28, 0xc0, 0xae, 0x68, 0x0b, 0x15, 0x26,
		0xf4, 0x83, 0x28, 0x2a, 0x4c, 0x28, 0xb8, 0x27, 0x54, 0x98, 0x40, 0x36, 0x87, 0x6c, 0x2e, 0x83,
		0xd9, 0x1c, 0xc4, 0xe8, 0xcc, 0x65, 0x72, 0x10, 0xa3, 0x77, 0x9e, 0xc9, 0x41, 0x8c, 0xce, 0x4f,
		0xda, 0x86, 0x0a, 0x13, 0x80, 0x17, 0xc0, 0x0b, 0xe0, 0x05, 0xf0, 0x02, 0x78, 0x01, 0xbc, 0x00,
		0x5e, 0xf2, 0x0f, 0x2f, 0xa8, 0x30, 0x01, 0x7c, 0x01, 0xbe, 0xa0, 0xc2, 0xc4, 0x6c, 0x13, 0x58,
		0x4b, 0xd7, 0xef, 0xb1, 0x00, 0x31, 0xe9, 0x1d, 0x02, 0xac, 0xa5, 0x67, 0x9d, 0x6b, 0x50, 0x61,
		0x02, 0x34, 0x03, 0x9a, 0x81, 0x18, 0x03, 0x31, 0x06, 0x62, 0x0c, 0xc4, 0x18, 0x40, 0x4b, 0x56,
		0xa0, 0x05, 0x15, 0x26, 0x80, 0x2f, 0xc0, 0x17, 0xbc, 0xd6, 0x00, 0x29, 0x06, 0x52, 0x0c, 0xa4,
		0x18, 0x48, 0x31, 0x79, 0xa0, 0x1a, 0x54, 0x98, 0x00, 0xcb, 0x80, 0x65, 0x20, 0xc5, 0x40, 0x8a,
		0x81, 0x14, 0x03, 0x29, 0x06, 0xd0, 0x92, 0x11, 0x68, 0x41, 0x85, 0x09, 0xe0, 0x0b, 0xf0, 0x05,
		0x52, 0x0c, 0xa4, 0x18, 0x48, 0x31, 0x90, 0x62, 0x20, 0xc5, 0xa4, 0x8d, 0x6a, 0xf6, 0xa4, 0xc2,
		0x84, 0x72, 0x01, 0x84, 0x02, 0x65, 0xa1, 0x89, 0x9b, 0xc1, 0xdd, 0x5c, 0x38, 0x66, 0x78, 0x39,
		0xbe, 0x97, 0x14, 0x94, 0x9b, 0xf0, 0xb9, 0x67, 0x0c, 0x7a, 0xd0, 0x75, 0x4c, 0xcf, 0x62, 0x86,
		0xe5, 0xdb, 0x4c, 0xbe, 0xde, 0xc4, 0xaa, 0xc6, 0xe4, 0x0a, 0x4e, 0x94, 0x50, 0x70, 0x62, 0x17,
		0x3c, 0xba, 0x8f, 0x05, 0x27, 0xa4, 0x69, 0x73, 0xfa, 0xf6, 0x82, 0xcd, 0x3c, 0xee, 0xf0, 0xf7,
		0x80, 0x75, 0x64, 0x06, 0x7f, 0x22, 0x8f, 0x49, 0xc4, 0xc3, 0xe2, 0xf5, 0xf8, 0xab, 0x2f, 0xcc,
		0x90, 0x20, 0xdd, 0xbc, 0x6f, 0xdd, 0xb5, 0x6b, 0x8d, 0xc6, 0xcd, 0xf5, 0x65, 0xad, 0x75, 0x7d,
		0x7f, 0xd7, 0xbe, 0xbc, 0xbf, 0xaa, 0xcb, 0xce, 0xa4, 0x61, 0xe0, 0x0f, 0x95, 0x08, 0x55, 0x31,
		0x49, 0x9b, 0x3c, 0x55, 0xa3, 0x7c, 0x53, 0x6e, 0x57, 0xae, 0x2a, 0x0a, 0xe9, 0xcf, 0x87, 0x5d,
		0x3f, 0xc3, 0x60, 0x64, 0xbe, 0xdd, 0x5d, 0xd5, 0x3f, 0x5f, 0xdf, 0xd5, 0xaf, 0xb2, 0xfc, 0x20,
		0xe3, 0xc1, 0x28, 0x67, 0xfb, 0x19, 0x9a, 0xaa, 0x13, 0xea, 0x20, 0x19, 0x3a, 0xfc, 0x99, 0x06,
		0xc2, 0xe8, 0xf3, 0x69, 0x99, 0x2f, 0x79, 0xb4, 0x98, 0x6d, 0x05, 0x45, 0xac, 0xc0, 0x14, 0x28,
		0x62, 0xb5, 0x76, 0xee, 0xa0, 0x88, 0x15, 0x04, 0x63, 0x65, 0xe3, 0xc2, 0x7a, 0xb7, 0xaa, 0x84,
		0x86, 0xf5, 0xee, 0x65, 0xa5, 0x12, 0xeb, 0xdd, 0x4a, 0xc2, 0x22, 0xd6, 0xbb, 0x77, 0x3e, 0x04,
		0x58, 0xef, 0x5e, 0xea, 0x66, 0x14, 0xb1, 0x02, 0xbc, 0x00, 0x5e, 0x00, 0x2f, 0x80, 0x17, 0xc0,
		0x0b, 0xe0, 0x05, 0xf0, 0x92, 0x31, 0x78, 0x41, 0x11, 0x2b, 0xe0, 0x0b, 0xf0, 0x05, 0x45, 0xac,
		0x66, 0x9b, 0xc0, 0x76, 0x3d, 0xfd, 0x1e, 0x0b, 0x10, 0x93, 0xde, 0x21, 0xc0, 0x76, 0xbd, 0xac,
		0x73, 0x0d, 0x8a, 0x58, 0x81, 0x66, 0x40, 0x33, 0x10, 0x63, 0x20, 0xc6, 0x40, 0x8c, 0x81, 0x18,
		0x03, 0x68, 0xc9, 0x0a, 0xb4, 0xa0, 0x88, 0x15, 0xf0, 0x05, 0xf8, 0x82, 0x37, 0x27, 0x21, 0xc5,
		0x40, 0x8a, 0x81, 0x14, 0x03, 0x29, 0x26, 0x0f, 0x54, 0x83, 0x22, 0x56, 0x60, 0x19, 0xb0, 0x0c,
		0xa4, 0x18, 0x48, 0x31, 0x90, 0x62, 0x20, 0xc5, 0x00, 0x5a, 0x32, 0x02, 0x2d, 0x28, 0x62, 0x05,
		0x7c, 0x01, 0xbe, 0x40, 0x8a, 0x81, 0x14, 0x03, 0x29, 0x06, 0x52, 0x0c, 0xa4, 0x98, 0xb4, 0x51,
		0xcd, 0x9e, 0x14, 0xb1, 0x52, 0x28, 0x7d, 0x50, 0xa0, 0x2c, 0x5f, 0x75, 0x3f, 0xbc, 0x8f, 0xc6,
		0xf0, 0x36, 0x52, 0x50, 0x57, 0xa2, 0xe7, 0x87, 0xdc, 0xe8, 0x30, 0xcb, 0x78, 0x56, 0xa9, 0x2b,
		0x31, 0xd7, 0x0a, 0xea, 0x4a, 0xe8, 0xc7, 0x4f, 0xd4, 0x95, 0x50, 0x70, 0x4a, 0xa8, 0x2b, 0x91,
		0x8e, 0x1c, 0xce, 0xef, 0x71, 0xe4, 0x71, 0xd2, 0x06, 0x36, 0xed, 0x3d, 0x48, 0xd1, 0x0a, 0xc6,
		0x44, 0x2b, 0x45, 0x97, 0xcf, 0x90, 0xc8, 0xad, 0xee, 0x67, 0x68, 0xd1, 0x3b, 0x4f, 0xe4, 0xa0,
		0x45, 0xe7, 0x27, 0x6b, 0x43, 0x81, 0x09, 0x50, 0x0c, 0x28, 0x06, 0x14, 0x03, 0x8a, 0x01, 0xc5,
		0x80, 0x62, 0x40, 0x31, 0x7b, 0x44, 0x31, 0xa8, 0x34, 0xa1, 0x85, 0x63, 0xc0, 0x30, 0xb2, 0x0c,
		0x83, 0x4a, 0x13, 0xa8, 0x34, 0x91, 0x25, 0x88, 0xc1, 0x9a, 0xfa, 0xce, 0x21, 0x06, 0x6b, 0xea,
		0xe0, 0x9a, 0xf9, 0x6e, 0x46, 0xa5, 0x09, 0xa8, 0x32, 0x50, 0x65, 0xa0, 0xca, 0x40, 0x95, 0x81,
		0x2a, 0x03, 0x55, 0x06, 0xaa, 0x4c, 0xe6, 0xe8, 0x05, 0x25, 0x27, 0xa0, 0xca, 0x40, 0x95, 0xc1,
		0x7b, 0x0e, 0xd0, 0x64, 0xa0, 0xc9, 0x40, 0x93, 0x81, 0x26, 0x93, 0x07, 0xaa, 0x41, 0xc9, 0x09,
		0x68, 0x32, 0xd0, 0x64, 0xa0, 0xc9, 0x40, 0x93, 0x81, 0x26, 0x03, 0x4d, 0x06, 0x9a, 0x4c, 0xd6,
		0xe8, 0x05, 0xb5, 0x27, 0xa0, 0xc9, 0x40, 0x93, 0x81, 0x26, 0x03, 0x4d, 0x06, 0x9a, 0x0c, 0x34,
		0x19, 0x68, 0x32, 0x69, 0xa3, 0x9a, 0x3d, 0xa9, 0x3d, 0xa1, 0x50, 0x1e, 0xa1, 0x40, 0x59, 0x7b,
		0xa2, 0xe1, 0x87, 0xfc, 0x33, 0xb3, 0x2e, 0x52, 0x52, 0x7a, 0x22, 0x60, 0x04, 0x95, 0x27, 0x66,
		0x1a, 0x41, 0xe1, 0x09, 0xfd, 0xec, 0x89, 0xc2, 0x13, 0x0a, 0x1e, 0x09, 0x85, 0x27, 0x20, 0x44,
		0x67, 0x3f, 0x89, 0x83, 0x10, 0x0d, 0x21, 0x3a, 0x43, 0x59, 0x1c, 0x84, 0xe8, 0x9d, 0x67, 0x71,
		0x10, 0xa2, 0xf3, 0x93, 0xb2, 0xa1, 0xf0, 0x04, 0x28, 0x06, 0x14, 0x03, 0x8a, 0x01, 0xc5, 0x80,
		0x62, 0x40, 0x31, 0xa0, 0x98, 0x3d, 0xa2, 0x18, 0x14, 0x9e, 0xd0, 0xc2, 0x31, 0x60, 0x18, 0x59,
		0x86, 0x41, 0xe1, 0x09, 0x14, 0x9e, 0xc8, 0x12, 0xc4, 0x60, 0x41, 0x7d, 0xe7, 0x10, 0x83, 0x05,
		0x75, 0x70, 0xcd, 0x7c, 0x37, 0xa3, 0xf0, 0x04, 0x54, 0x19, 0xa8, 0x32, 0x50, 0x65, 0xa0, 0xca,
		0x40, 0x95, 0x81, 0x2a, 0x03, 0x55, 0x26, 0x73, 0xf4, 0x82, 0xc2, 0x13, 0x50, 0x65, 0xa0, 0xca,
		0xe0, 0x25, 0x07, 0x68, 0x32, 0xd0, 0x64, 0xa0, 0xc9, 0x40, 0x93, 0xc9, 0x03, 0xd5, 0xa0, 0xf0,
		0x04, 0x34, 0x19, 0x68, 0x32, 0xd0, 0x64, 0xa0, 0xc9, 0x40, 0x93, 0x81, 0x26, 0x03, 0x4d, 0x26,
		0x6b, 0xf4, 0x82, 0xc2, 0x13, 0xd0, 0x64, 0xa0, 0xc9, 0x40, 0x93, 0x81, 0x26, 0x03, 0x4d, 0x06,
		0x9a, 0x0c, 0x34, 0x99, 0xb4, 0x51, 0xcd, 0xbe, 0x14, 0x9e, 0x90, 0xae, 0x8e, 0x50, 0x20, 0xad,
		0x3b, 0x11, 0xb0, 0x54, 0x95, 0x9d, 0x08, 0x99, 0xc4, 0xdb, 0x68, 0xb3, 0x25, 0x27, 0x86, 0x0d,
		0xc8, 0x95, 0x9b, 0x28, 0xa1, 0xdc, 0xc4, 0x2e, 0x48, 0x73, 0x1f, 0xcb, 0x4d, 0x48, 0x73, 0x64,
		0x34, 0xfe, 0xcc, 0xeb, 0x77, 0x59, 0x30, 0x72, 0x65, 0x12, 0x83, 0x3f, 0x51, 0xbe, 0xaa, 0x12,
		0xd7, 0xd6, 0xbd, 0x7e, 0x77, 0x70, 0xf3, 0x3f, 0x53, 0xe0, 0x32, 0x42, 0x16, 0x38, 0xa6, 0x6b,
		0x78, 0xbe, 0xbc, 0xd3, 0x98, 0x36, 0x01, 0xb7, 0x01, 0xb7, 0x91, 0x73, 0xb7, 0x11, 0xf2, 0xc0,
		0xf1, 0x5e, 0x54, 0x3c, 0x86, 0x44, 0xaa, 0x59, 0xbc, 0x61, 0xde, 0xcb, 0x10, 0x99, 0xe4, 0x72,
		0x42, 0x85, 0x74, 0x9b, 0x22, 0x07, 0x24, 0x4a, 0x3c, 0xa6, 0x09, 0x87, 0x62, 0x3b, 0x84, 0x59,
		0x85, 0x42, 0x8e, 0x47, 0x92, 0xdb, 0x91, 0x77, 0xed, 0x49, 0x8a, 0xfa, 0x36, 0xa1, 0x8c, 0xe9,
		0x29, 0x0d, 0x61, 0xd8, 0xf7, 0x18, 0x37, 0x42, 0xfb, 0xd5, 0x18, 0xe4, 0x3c, 0xae, 0x63, 0x7a,
		0x16, 0x33, 0x2c, 0xdf, 0x66, 0x0a, 0x61, 0x79, 0x6d, 0x93, 0x08, 0xd3, 0x08, 0xd3, 0x39, 0x0f,
		0xd3, 0x8e, 0xcd, 0x3c, 0xee, 0xf0, 0xf7, 0x80, 0x75, 0x54, 0x62, 0xb5, 0x84, 0x8e, 0x55, 0xbc,
		0x1e, 0x7f, 0xf5, 0x85, 0x19, 0x12, 0x2c, 0x13, 0x35, 0xef, 0xef, 0xea, 0xad, 0x76, 0xad, 0xd1,
		0xb8, 0xb9, 0xbe, 0xac, 0xb5, 0xae, 0xef, 0xef, 0xda, 0x97, 0xf7, 0x57, 0x75, 0xd9, 0xb9, 0x34,
		0x74, 0xf3, 0xa1, 0x92, 0xb6, 0xac, 0x18, 0xaf, 0xe6, 0x9f, 0xeb, 0xdb, 0xdd, 0x55, 0xfd, 0xf3,
		0xf5, 0x5d, 0xfd, 0xaa, 0xb8, 0x8b, 0x08, 0x4c, 0xf4, 0x28, 0xff, 0x6c, 0x3e, 0x54, 0x4a, 0xa5,
		0x52, 0xfb, 0xe8, 0xe1, 0x28, 0x1f, 0x8f, 0x71, 0x9c, 0x8f, 0xc7, 0xa8, 0x24, 0xbd, 0x28, 0xf6,
		0xa4, 0xdb, 0x8d, 0x6a, 0x41, 0x8f, 0x37, 0xe6, 0xd9, 0xbe, 0x42, 0x99, 0xda, 0xf1, 0xf5, 0x80,
		0x0a, 0x40, 0x05, 0x72, 0x7f, 0xe4, 0xfe, 0xc8, 0xfd, 0x91, 0xfb, 0x23, 0xf7, 0x17, 0x0f, 0xc0,
		0x46, 0xcf, 0x0c, 0xb8, 0x6a, 0x14, 0x1e, 0x35, 0x82, 0x50, 0x8c, 0x50, 0x8c, 0x50, 0x8c, 0x50,
		0x8c, 0x50, 0x8c, 0x50, 0x8c, 0x50, 0x2c, 0x11, 0x8a, 0x03, 0xf6, 0xa6, 0x1c, 0x89, 0x07, 0x6d,
		0x20, 0x10, 0x23, 0x10, 0x23, 0x10, 0x23, 0x10, 0x23, 0x10, 0x67, 0x35, 0x10, 0x57, 0x10, 0x87,
		0xc9, 0xe2, 0xf0, 0x01, 0xe1, 0x04, 0x92, 0xdd, 0x88, 0x4c, 0xb7, 0x01, 0xb9, 0x28, 0xb2, 0xba,
		0x4f, 0xb3, 0xd9, 0x38, 0x5e, 0xf4, 0xd8, 0xde, 0xcf, 0x9b, 0x3f, 0xb1, 0x65, 0x04, 0x44, 0x7b,
		0x9e, 0xa2, 0xc7, 0x63, 0xf4, 0xb5, 0x7a, 0x1f, 0x6f, 0xee, 0xdd, 0xf5, 0x7d, 0xb6, 0xfa, 0x5f,
		0xd6, 0xf4, 0xe2, 0x80, 0x56, 0x46, 0xaf, 0x0a, 0xad, 0x7d, 0xf3, 0xaf, 0x78, 0xe3, 0x84, 0xbc,
		0xc6, 0xf9, 0xe6, 0x25, 0x99, 0x41, 0x20, 0xaa, 0xbb, 0x6c, 0x80, 0x19, 0x03, 0xb7, 0xe2, 0xf5,
		0x5d, 0xf7, 0xc3, 0xc1, 0x26, 0xd7, 0x1a, 0xff, 0xc3, 0xf7, 0x81, 0xcd, 0x02, 0x66, 0x5f, 0xbc,
		0x8f, 0x3f, 0x2a, 0xf4, 0x7c, 0xb5, 0xfe, 0xcb, 0xe0, 0x6b, 0x98, 0xbd, 0x31, 0x38, 0x6f, 0x9e,
		0x36, 0x11, 0x5c, 0x1c, 0xfa, 0x56, 0x34, 0x49, 0x3e, 0xcd, 0x4c, 0x92, 0x95, 0xbf, 0xde, 0x32,
		0x49, 0x8a, 0x57, 0x2c, 0xb4, 0x02, 0xa7, 0x37, 0x9e, 0xb8, 0xc5, 0x9a, 0x6d, 0x3b, 0xde, 0x4b,
		0xc1, 0xef, 0x71, 0xc7, 0x32, 0xdd, 0x82, 0xf5, 0x6a, 0x7a, 0x1e, 0x73, 0x0b, 0xb6, 0xc9, 0xcd,
		0x02, 0xf7, 0x0b, 0xbd, 0xd7, 0xf7, 0x70, 0xf8, 0x0f, 0x8e, 0xf7, 0xc6, 0x3c, 0xee, 0x07, 0xef,
		0xdb, 0xda, 0x8f, 0x77, 0xe6, 0x62, 0x6c, 0x5a, 0x17, 0xa1, 0xf3, 0xa5, 0x82, 0x10, 0x2c, 0xe8,
		0xc6, 0xb1, 0x19, 0x41, 0xf4, 0x96, 0x46, 0x6d, 0x69, 0xb4, 0x5e, 0x59, 0xaf, 0x61, 0xf0, 0x70,
		0x9a, 0x7d, 0x5c, 0xdc, 0xd3, 0x0c, 0x8b, 0xe3, 0xe9, 0x63, 0x8c, 0xa7, 0x4f, 0xfc, 0xae, 0x8c,
		0x46, 0x6c, 0xa1, 0x81, 0x98, 0xfd, 0xb2, 0x30, 0x99, 0xeb, 0x9e, 0xe5, 0xfa, 0xe1, 0x60, 0x3e,
		0x5b, 0xbe, 0xc7, 0x4d, 0xc7, 0x63, 0x41, 0xa1, 0xe3, 0x07, 0x05, 0xfe, 0xca, 0x0a, 0xae, 0x13,
		0xf2, 0x82, 0xdf, 0x59, 0x9c, 0xe9, 0x71, 0x5f, 0x51, 0x14, 0x3c, 0x4b, 0x54, 0x38, 0x1b, 0x95,
		0xc9, 0x42, 0x25, 0xe7, 0xbb, 0x6a, 0xca, 0xa9, 0x9c, 0x6a, 0x2a, 0xa7, 0x98, 0xf2, 0xf6, 0x20,
		0x48, 0x61, 0xaa, 0xf6, 0x75, 0x20, 0x61, 0x79, 0xe9, 0x09, 0x0a, 0x33, 0xe8, 0x91, 0xfd, 0x80,
		0x20, 0xc8, 0x51, 0x99, 0x8b, 0x09, 0x42, 0xf2, 0x4a, 0x42, 0x61, 0x61, 0xf6, 0x9e, 0x84, 0x43,
		0x82, 0xb8, 0x9e, 0xb6, 0x38, 0x8d, 0x5b, 0x7e, 0xcf, 0x70, 0xd9, 0x1b, 0x73, 0x17, 0xc2, 0x81,
		0xe5, 0x3a, 0xcc, 0xe3, 0x85, 0x9e, 0x1f, 0xf0, 0xa5, 0x39, 0x9e, 0x93, 0x70, 0x20, 0x27, 0x46,
		0xe6, 0x27, 0x22, 0x48, 0x89, 0x8d, 0x3b, 0x0f, 0x0a, 0x2b, 0xff, 0xe5, 0x69, 0x5d, 0x8a, 0x11,
		0x2f, 0x01, 0x95, 0x4d, 0x3c, 0x37, 0x8c, 0xa0, 0x5c, 0x92, 0xb9, 0x7a, 0x1c, 0x96, 0x9f, 0x79,
		0xfe, 0x37, 0x0b, 0xbe, 0x68, 0xdb, 0x53, 0x8b, 0x3d, 0xed, 0x8a, 0x67, 0x14, 0x79, 0xb6, 0xf9,
		0x27, 0x9a, 0xde, 0xf7, 0xcc, 0x3d, 0x8f, 0x4e, 0x82, 0xea, 0x98, 0xd6, 0x70, 0xbb, 0xf1, 0xfc,
		0xfd, 0xce, 0x9f, 0x16, 0x35, 0xfa, 0xcc, 0xc2, 0xd3, 0xae, 0xf6, 0x32, 0x6b, 0xbd, 0xc9, 0x26,
		0xaf, 0x31, 0xeb, 0x1d, 0x9c, 0x55, 0xbb, 0xc1, 0xb7, 0x19, 0x7f, 0x6c, 0x23, 0x8f, 0x6d, 0xcc,
		0x8b, 0x46, 0xeb, 0x74, 0x8a, 0x82, 0xb3, 0x61, 0x5d, 0x24, 0x9a, 0x76, 0xe9, 0xfa, 0xc7, 0x59,
		0xea, 0xfd, 0x75, 0x8f, 0xb3, 0xd9, 0xd5, 0x6f, 0x75, 0xed, 0x71, 0x5c, 0xf9, 0xd6, 0xc1, 0x11,
		0xf5, 0xd0, 0xc2, 0x1e, 0x59, 0xd8, 0x03, 0xc7, 0x19, 0x3c, 0x39, 0x6d, 0x68, 0x1b, 0x5e, 0x14,
		0xad, 0x49, 0x8f, 0xc7, 0x44, 0xe5, 0xf1, 0xe7, 0xb3, 0xc1, 0xa9, 0x4e, 0x27, 0x97, 0x78, 0xba,
		0x69, 0x7a, 0x24, 0x4c, 0xa5, 0xf6, 0x1c, 0x25, 0x0a, 0x52, 0xe9, 0xec, 0xc5, 0x62, 0xa8, 0x58,
		0x4a, 0x29, 0x2a, 0x3a, 0x9d, 0xbd, 0x24, 0xc4, 0x38, 0x13, 0x52, 0xcf, 0x9a, 0x8d, 0xf0, 0x6a,
		0xb3, 0xfc, 0x2a, 0xf3, 0x74, 0x75, 0x99, 0x0a, 0x6d, 0x63, 0xf8, 0x26, 0xe6, 0x99, 0xcf, 0xee,
		0x50, 0xf9, 0x16, 0xb4, 0xad, 0xc9, 0x85, 0xb1, 0xb3, 0xbd, 0x8e, 0xd9, 0x77, 0xf9, 0x28, 0x57,
		0xec, 0x33, 0x98, 0x23, 0xcc, 0x31, 0x59, 0x73, 0x7c, 0xf6, 0x7d, 0x97, 0x99, 0x9e, 0x8c, 0x3d,
		0x96, 0x13, 0xb4, 0x47, 0xd7, 0xf7, 0x7b, 0xcf, 0xa6, 0xf5, 0xdd, 0xe8, 0x8a, 0xbc, 0x48, 0x1d,
		0x3d, 0xe5, 0xfc, 0xe5, 0xe2, 0xb6, 0xd9, 0x31, 0xdd, 0x10, 0xc6, 0x09, 0xe3, 0x84, 0x71, 0xae,
		0xfa, 0xce, 0x2e, 0xef, 0x8b, 0x9b, 0xe4, 0xe0, 0x22, 0x18, 0x14, 0x0c, 0x2a, 0x51, 0x83, 0xea,
		0x3b, 0x1e, 0x2f, 0x9f, 0x48, 0xd8, 0x93, 0xc0, 0x26, 0x6e, 0xc9, 0xa2, 0xaf, 0x12, 0x1b, 0x37,
		0x55, 0x36, 0x30, 0xaa, 0x16, 0x9d, 0x56, 0x2c, 0xda, 0x4a, 0xb1, 0x9b, 0x4e, 0xa6, 0xe8, 0xb7,
		0xca, 0xc6, 0x44, 0xaa, 0x2e, 0x3b, 0x39, 0x3e, 0x3e, 0x3a, 0xde, 0x61, 0xb7, 0x69, 0xda, 0x14,
		0xf8, 0x94, 0x60, 0xc4, 0x19, 0x4b, 0xdb, 0x82, 0x21, 0x67, 0xc3, 0x4e, 0x2d, 0xc4, 0x1c, 0xc4,
		0x9c, 0xbd, 0x16, 0x3c, 0xb8, 0xc8, 0xf3, 0x4d, 0xd7, 0xb7, 0x07, 0x57, 0xc1, 0xa2, 0x60, 0x51,
		0x89, 0x5a, 0x94, 0x5c, 0x45, 0x28, 0x99, 0x4a, 0x50, 0x6a, 0x15, 0xa0, 0x96, 0x97, 0xe7, 0x86,
		0x27, 0x3c, 0xa4, 0x6e, 0x31, 0x7f, 0xcb, 0xa2, 0x44, 0xfd, 0x07, 0x8f, 0x57, 0x67, 0x4a, 0x7c,
		0x1d, 0xc7, 0xb7, 0x0c, 0xf6, 0x83, 0x7f, 0xe2, 0xcc, 0x65, 0x5d, 0xc6, 0x83, 0x77, 0xc3, 0xf7,
		0x86, 0xdb, 0x27, 0x5f, 0x98, 0xdc, 0xda, 0xce, 0x50, 0xa7, 0x91, 0x58, 0xdc, 0x51, 0x5d, 0xd7,
		0x79, 0x4a, 0x6c, 0xa3, 0xfd, 0x74, 0x9d, 0xfd, 0x70, 0xd5, 0x8f, 0x87, 0xb1, 0xd6, 0x09, 0x0b,
		0x9b, 0x36, 0x09, 0x5c, 0x47, 0xcd, 0xb6, 0x57, 0xfd, 0xd8, 0x1e, 0x3b, 0x66, 0xfa, 0x4d, 0x83,
		0x45, 0xc6, 0x5f, 0x59, 0xe0, 0x31, 0x1e, 0x7f, 0x55, 0x34, 0xba, 0x22, 0x1b, 0xeb, 0xa2, 0x8c,
		0xbf, 0xe6, 0x72, 0x61, 0x74, 0xf0, 0x5c, 0x69, 0x59, 0x19, 0x8d, 0xb9, 0xb0, 0xbe, 0x34, 0x3c,
		0xb1, 0x0d, 0xa7, 0x90, 0x81, 0xad, 0x73, 0xf1, 0x26, 0x5a, 0xfe, 0x68, 0x26, 0xd6, 0x44, 0xd4,
		0x83, 0x33, 0x71, 0x27, 0x68, 0x74, 0x81, 0xd9, 0xe7, 0xbe, 0xe1, 0xb1, 0x17, 0x9f, 0x3b, 0x26,
		0x57, 0x80, 0x8b, 0x85, 0x76, 0x04, 0x3b, 0x50, 0x6e, 0x01, 0x52, 0x51, 0x12, 0xd9, 0xf9, 0x7b,
		0xee, 0x62, 0xf6, 0xa1, 0x6a, 0x27, 0x64, 0xf6, 0x42, 0x66, 0x37, 0x24, 0xf6, 0x23, 0x29, 0x28,
		0x25, 0xfe, 0x5e, 0xbb, 0xf8, 0x2a, 0xca, 0x92, 0x9b, 0x2f, 0xa7, 0xa0, 0xa0, 0x85, 0xdd, 0xef,
		0xb9, 0xec, 0x87, 0xd8, 0x02, 0xe8, 0x52, 0x5f, 0xcc, 0x36, 0x02, 0x53, 0x87, 0xa9, 0xe7, 0xcc,
		0xd4, 0x71, 0x12, 0x4c, 0x61, 0xba, 0x7b, 0xc9, 0xe8, 0xb8, 0xfe, 0x5f, 0x86, 0xe5, 0x7b, 0x3c,
		0xf0, 0x5d, 0x79, 0x97, 0xb1, 0xaa, 0x31, 0x79, 0xc8, 0x10, 0xd9, 0x49, 0x01, 0xd7, 0x03, 0xd7,
		0x03, 0xca, 0x48, 0xd6, 0x75, 0x74, 0x4d, 0xcb, 0x30, 0x6d, 0x3b, 0x60, 0x61, 0x28, 0xef, 0x32,
		0x66, 0x1b, 0x81, 0xa9, 0xc3, 0xd4, 0x73, 0x66, 0xea, 0xf2, 0xd3, 0xbb, 0xa0, 0x5a, 0x2d, 0xab,
		0x61, 0x72, 0xce, 0x02, 0x4f, 0xba, 0x5c, 0x56, 0xf1, 0xbf, 0xff, 0x2c, 0x19, 0xe7, 0xa6, 0xd1,
		0xa9, 0x19, 0x9f, 0x9f, 0xfe, 0xae, 0xfc, 0xfc, 0xe5, 0xd3, 0xfc, 0xdf, 0x7f, 0xfd, 0xfb, 0xf8,
		0xe7, 0x7f, 0x14, 0x33, 0x59, 0xf0, 0xaf, 0xe7, 0x07, 0xdc, 0x08, 0x7b, 0x4c, 0x60, 0xd7, 0xf6,
		0xd2, 0xc8, 0xce, 0xb4, 0x01, 0xbf, 0x05, 0xbf, 0x95, 0x33, 0xbf, 0x95, 0x9b, 0x93, 0x74, 0xea,
		0xad, 0xaf, 0xf5, 0x87, 0xbb, 0x7a, 0xab, 0xdd, 0x6c, 0xd4, 0xeb, 0x57, 0x39, 0x38, 0x41, 0x67,
		0xf0, 0x18, 0xed, 0x72, 0xa9, 0xf4, 0xe5, 0x22, 0xcb, 0xe7, 0xb5, 0x8c, 0x1e, 0xe3, 0x38, 0x17,
		0x4f, 0x51, 0x2e, 0x95, 0x6e, 0xf3, 0xf0, 0x18, 0x79, 0x18, 0x8b, 0xca, 0x71, 0x3e, 0x66, 0x54,
		0x2e, 0x26, 0x54, 0x2e, 0xac, 0xfb, 0xdb, 0xdd, 0x6f, 0x77, 0xf7, 0xbf, 0xdf, 0xe5, 0xc0, 0xd9,
		0xe6, 0xc3, 0xbe, 0xf3, 0xe1, 0x6c, 0xab, 0x6a, 0xb6, 0x91, 0xf5, 0x83, 0xca, 0x52, 0x5e, 0x14,
		0x76, 0xdb, 0xce, 0xa9, 0xc9, 0x5e, 0xa2, 0x43, 0xa1, 0x9d, 0x20, 0x05, 0x95, 0xad, 0x54, 0xf5,
		0xf1, 0x57, 0xc6, 0xda, 0x53, 0x15, 0xbf, 0x9f, 0x7f, 0xc6, 0xda, 0xfd, 0x25, 0xb2, 0xe9, 0x60,
		0x66, 0x33, 0x73, 0xfc, 0x3d, 0x06, 0xd2, 0x9b, 0x64, 0x2a, 0xd8, 0x24, 0x43, 0x99, 0xe3, 0x62,
		0x93, 0x0c, 0x36, 0xc9, 0x40, 0x1b, 0x82, 0x36, 0xb4, 0x71, 0xbc, 0x73, 0xb2, 0x7c, 0x65, 0xf9,
		0xfd, 0x41, 0x74, 0x55, 0x58, 0xbb, 0x8a, 0x5a, 0x90, 0x33, 0xf2, 0x32, 0x8c, 0x1c, 0x46, 0xae,
		0xc7, 0xc8, 0x45, 0x83, 0x67, 0x74, 0xa1, 0xe3, 0x19, 0x67, 0xa5, 0x4a, 0xf9, 0x7f, 0x8c, 0x4e,
		0x60, 0x76, 0x59, 0xa8, 0xae, 0xbf, 0x2e, 0x36, 0xf8, 0x61, 0x27, 0xef, 0xd3, 0xca, 0x9a, 0x0e,
		0x85, 0x09, 0xd1, 0x99, 0x12, 0x95, 0x49, 0x91, 0x9b, 0x16, 0xb9, 0x89, 0x91, 0x9a, 0x9a, 0x5a,
		0xd6, 0x2c, 0xa9, 0x18, 0xc8, 0xc7, 0xd9, 0x75, 0x61, 0xe6, 0xa4, 0xaa, 0x32, 0x65, 0xc6, 0x06,
		0x74, 0xa6, 0xd0, 0x84, 0x5c, 0xb1, 0x02, 0x5a, 0x19, 0xa5, 0x40, 0x75, 0x1a, 0x13, 0x91, 0x67,
		0x59, 0x6a, 0x4e, 0xb1, 0xd8, 0xc1, 0x52, 0x7b, 0x84, 0x47, 0x09, 0x11, 0x68, 0x60, 0xd3, 0x21,
		0x20, 0x38, 0xb5, 0x49, 0xf7, 0x10, 0x94, 0xcf, 0xaa, 0xd5, 0x93, 0xd3, 0x6a, 0xb5, 0x74, 0x7a,
		0x74, 0x5a, 0x3a, 0x3f, 0x3e, 0x2e, 0x9f, 0x94, 0x8f, 0x53, 0x3c, 0x2a, 0x07, 0xbb, 0xb9, 0xfa,
		0x29, 0xa1, 0x03, 0xa6, 0x64, 0x4a, 0x70, 0x38, 0x9e, 0xf1, 0xec, 0xfa, 0xd6, 0x77, 0x83, 0x05,
		0x81, 0x1f, 0xd0, 0xd0, 0xc8, 0x5c, 0x83, 0xa0, 0x11, 0xd0, 0x08, 0x68, 0x04, 0x34, 0x02, 0x1a,
		0x01, 0x8d, 0x80, 0x46, 0x40, 0x23, 0xdb, 0x68, 0xc4, 0x0a, 0x2c, 0x4a, 0x16, 0x99, 0x69, 0x0e,
		0x24, 0x02, 0x12, 0x01, 0x89, 0x80, 0x44, 0x40, 0x22, 0x20, 0x11, 0x90, 0x08, 0x48, 0x64, 0x1b,
		0x89, 0x74, 0x02, 0x73, 0x78, 0xe4, 0x2e, 0xe5, 0x42, 0xcd, 0x62, 0x9b, 0x60, 0x12, 0x30, 0x09,
		0x98, 0x04, 0x4c, 0x02, 0x26, 0x01, 0x93, 0x80, 0x49, 0xc0, 0x24, 0xdb, 0x98, 0xe4, 0xff, 0x9a,
		0xcf, 0xcf, 0x2c, 0xa0, 0x24, 0x92, 0xf9, 0x16, 0xc1, 0x23, 0xe0, 0x11, 0xf0, 0x08, 0x78, 0x04,
		0x3c, 0x02, 0x1e, 0x01, 0x8f, 0x80, 0x47, 0xb6, 0xf1, 0x48, 0xd7, 0xb4, 0x26, 0x65, 0xc8, 0x28,
		0xa1, 0x64, 0x45, 0xb3, 0x20, 0x13, 0x90, 0x09, 0xc8, 0x04, 0x64, 0x02, 0x32, 0x01, 0x99, 0x80,
		0x4c, 0x40, 0x26, 0x71, 0xc8, 0xa4, 0x67, 0xf6, 0x43, 0x46, 0xcd, 0x25, 0x73, 0x8d, 0x82, 0x4a,
		0x40, 0x25, 0xa0, 0x12, 0x50, 0x09, 0xa8, 0x04, 0x54, 0x02, 0x2a, 0x01, 0x95, 0x6c, 0xa3, 0x12,
		0xff, 0x8d, 0x05, 0xa1, 0xf3, 0x6f, 0x52, 0x28, 0x59, 0x6c, 0x13, 0x4c, 0x02, 0x26, 0x01, 0x93,
		0x80, 0x49, 0xc0, 0x24, 0x60, 0x12, 0x30, 0x09, 0x98, 0x64, 0x1b, 0x93, 0xf4, 0x3d, 0x9b, 0x1e,
		0x4a, 0x96, 0x1a, 0x05, 0x95, 0x80, 0x4a, 0x40, 0x25, 0xa0, 0x12, 0x50, 0x09, 0xa8, 0x04, 0x54,
		0x02, 0x2a, 0xd9, 0xd8, 0xcd, 0x7e, 0x9f, 0x13, 0x17, 0x49, 0x5b, 0x6a, 0x11, 0x3c, 0x02, 0x1e,
		0x01, 0x8f, 0x80, 0x47, 0xc0, 0x23, 0xe0, 0x11, 0xf0, 0x08, 0x78, 0x64, 0x2b, 0x8f, 0xe8, 0xd8,
		0xea, 0xba, 0xa6, 0x5d, 0xb0, 0x09, 0xd8, 0x04, 0x6c, 0x02, 0x36, 0x01, 0x9b, 0x80, 0x4d, 0xc0,
		0x26, 0x60, 0x93, 0x58, 0x6c, 0x42, 0xbb, 0xd9, 0x75, 0x65, 0xab, 0xe0, 0x12, 0x70, 0x09, 0xb8,
		0x04, 0x5c, 0x02, 0x2e, 0x01, 0x97, 0x80, 0x4b, 0xf6, 0x89, 0x4b, 0xb4, 0x1e, 0xa5, 0x23, 0x79,
		0xba, 0x64, 0x74, 0x3d, 0xc1, 0x29, 0x93, 0xc3, 0x93, 0x14, 0x0f, 0x25, 0x4f, 0x9b, 0x2a, 0x90,
		0x9c, 0x3a, 0xd9, 0x1c, 0xdc, 0x42, 0xfb, 0x72, 0x72, 0x0b, 0x29, 0x38, 0xbe, 0xcb, 0xee, 0xf7,
		0x5c, 0xf6, 0xc3, 0xe8, 0xfa, 0xb6, 0xc2, 0x59, 0x7f, 0xb3, 0x8d, 0xe0, 0xa4, 0x3e, 0x7d, 0x5c,
		0x88, 0x43, 0xbc, 0x76, 0x72, 0x52, 0x1f, 0xf3, 0xfa, 0x5d, 0x16, 0x8c, 0x9c, 0x97, 0xc2, 0x69,
		0x7d, 0x55, 0x89, 0x6b, 0xeb, 0x5e, 0xbf, 0x3b, 0xb8, 0xf9, 0x9f, 0x29, 0x70, 0x15, 0xcc, 0x33,
		0x9f, 0x5d, 0x66, 0x74, 0x5c, 0xff, 0xaf, 0x89, 0x98, 0x2d, 0xef, 0x32, 0x56, 0x35, 0x26, 0x7f,
		0x46, 0x68, 0xc7, 0x74, 0x43, 0xb8, 0x1e, 0xb8, 0x1e, 0x1c, 0x12, 0xba, 0xec, 0x76, 0xd2, 0x70,
		0x48, 0xe8, 0xeb, 0x5f, 0x43, 0xa1, 0xc9, 0xb4, 0xed, 0x80, 0x85, 0x0a, 0x47, 0x85, 0x2e, 0xb4,
		0x03, 0x83, 0x87, 0xc1, 0xe7, 0xcc, 0xe0, 0xe5, 0xa7, 0xf7, 0x9c, 0xd1, 0x4b, 0xc8, 0x48, 0xc5,
		0x86, 0xc9, 0x39, 0x0b, 0x3c, 0x69, 0x01, 0xa9, 0xf8, 0xdf, 0x7f, 0x96, 0x8c, 0x73, 0xd3, 0xe8,
		0xd4, 0x8c, 0xcf, 0x4f, 0x7f, 0x57, 0x7e, 0xfe, 0xf2, 0x69, 0xfe, 0xef, 0xbf, 0xfe, 0x7d, 0xfc,
		0xf3, 0x3f, 0xc4, 0x47, 0xec, 0x29, 0x05, 0xfe, 0x8b, 0xc4, 0x79, 0xc1, 0x73, 0xc1, 0x73, 0xc1,
		0x73, 0xc1, 0x73, 0x25, 0xea, 0xb9, 0x3c, 0xf6, 0xe2, 0x73, 0xc7, 0xe4, 0xcc, 0x36, 0x48, 0xa4,
		0x9e, 0x35, 0xed, 0xc1, 0x9f, 0xc1, 0x9f, 0x41, 0xf5, 0xc9, 0xa3, 0xea, 0x33, 0x63, 0xf0, 0x3d,
		0x3f, 0xe0, 0x46, 0xd8, 0x63, 0xcc, 0x26, 0xf1, 0x1f, 0x33, 0xcd, 0xc1, 0x7d, 0xc0, 0x7d, 0xe4,
		0xcc, 0x7d, 0x38, 0x36, 0xf3, 0xb8, 0xc3, 0xdf, 0x03, 0xd6, 0x51, 0x71, 0x1f, 0x12, 0x0b, 0xa2,
		0xc5, 0xeb, 0xf1, 0x57, 0x5f, 0x98, 0x21, 0x53, 0xdf, 0x25, 0x54, 0x6f, 0x7d, 0xad, 0x3f, 0xdc,
		0xd5, 0x5b, 0xed, 0x66, 0xa3, 0x5e, 0xbf, 0x92, 0x9d, 0x3b, 0xc3, 0x35, 0xdf, 0x50, 0x69, 0x73,
		0x82, 0xe2, 0x5e, 0x9a, 0xc9, 0xf3, 0x0c, 0x1f, 0xa3, 0x5d, 0x2e, 0x95, 0xbe, 0x5c, 0x28, 0x6c,
		0x55, 0xf9, 0x90, 0x8e, 0xc7, 0x38, 0xce, 0xc5, 0x53, 0x94, 0x4b, 0xa5, 0xdb, 0x3c, 0x3c, 0x46,
		0x1e, 0xc6, 0xa2, 0x72, 0x9c, 0x8f, 0x19, 0x95, 0x8b, 0x09, 0x95, 0x0b, 0xeb, 0xfe, 0x76, 0xf7,
		0xdb, 0xdd, 0xfd, 0xef, 0x77, 0x39, 0x70, 0xb6, 0xf9, 0xb0, 0xef, 0x7c, 0x38, 0xdb, 0xaa, 0x9a,
		0x6d, 0x48, 0x5d, 0xf9, 0xa4, 0x9b, 0x52, 0xb5, 0x64, 0x70, 0x14, 0x69, 0x1b, 0x72, 0x35, 0xe4,
		0x6a, 0xc8, 0xd5, 0x90, 0xab, 0x21, 0x57, 0x43, 0xae, 0x86, 0x5c, 0x0d, 0xb9, 0x1a, 0x72, 0x35,
		0xe4, 0x6a, 0xc8, 0xd5, 0x90, 0xab, 0x21, 0x57, 0xa3, 0xfa, 0x64, 0xcc, 0xb1, 0x92, 0x7d, 0x91,
		0x86, 0xec, 0x05, 0x1a, 0x01, 0xa8, 0x24, 0x7a, 0x5f, 0x26, 0xde, 0xcc, 0xd9, 0xde, 0xcb, 0x9b,
		0x3f, 0xb1, 0xa5, 0xff, 0x45, 0xfb, 0x9d, 0xa0, 0xbf, 0x63, 0xf4, 0xb4, 0x72, 0x0f, 0x6f, 0xee,
		0xdb, 0xf5, 0x3d, 0xb6, 0xa1, 0xb7, 0x8a, 0xaf, 0xbe, 0x6b, 0x1b, 0xdc, 0xe9, 0x6e, 0xcf, 0x67,
		0xa6, 0xfb, 0x7a, 0xa3, 0x4b, 0xb6, 0x8c, 0xc2, 0x24, 0xd5, 0xda, 0xf2, 0xb1, 0xb8, 0xea, 0x81,
		0x88, 0x5a, 0x30, 0xab, 0x0e, 0x38, 0x71, 0xf2, 0x44, 0x51, 0x31, 0x40, 0x3a, 0xf9, 0x97, 0x4e,
		0xf6, 0x17, 0x93, 0x7b, 0xa7, 0x53, 0xd4, 0x6c, 0x45, 0x57, 0x4e, 0x10, 0xaf, 0xb3, 0xad, 0xc9,
		0x08, 0xc6, 0xec, 0xbb, 0xe9, 0xbb, 0xd8, 0xc3, 0xeb, 0x62, 0x3e, 0x7f, 0xbc, 0xe9, 0x24, 0x2d,
		0x4a, 0xc9, 0x88, 0x51, 0xc2, 0xd3, 0x4c, 0x55, 0x7b, 0x52, 0xd6, 0x9c, 0x94, 0xb5, 0x26, 0x99,
		0x69, 0xa8, 0x27, 0xb8, 0xc6, 0x9d, 0x9e, 0xd1, 0x05, 0xb6, 0xff, 0x97, 0xa7, 0xf0, 0xde, 0xe4,
		0xe0, 0x6a, 0xf9, 0xb7, 0x9e, 0x4a, 0x7b, 0xa2, 0xc5, 0x3a, 0x1d, 0x48, 0xb1, 0x8a, 0x66, 0x92,
		0x15, 0x25, 0xb6, 0xef, 0x78, 0xfc, 0xa8, 0xa2, 0x20, 0xc2, 0x9e, 0x4a, 0x5c, 0xaa, 0x56, 0x37,
		0x43, 0xa1, 0x80, 0x08, 0x45, 0x9d, 0x0c, 0xa2, 0xe2, 0x0c, 0x54, 0x75, 0x31, 0x28, 0x2b, 0x2f,
		0x28, 0xa4, 0xaf, 0x24, 0xf5, 0x2f, 0xa8, 0xbb, 0xb6, 0x5a, 0x39, 0xaf, 0x9e, 0x9f, 0x9c, 0x56,
		0xce, 0x8f, 0x53, 0xd4, 0xc7, 0x09, 0x55, 0x97, 0x48, 0xc3, 0x5e, 0xf8, 0x7e, 0x4f, 0x3e, 0x54,
		0xf7, 0x7b, 0x08, 0xd4, 0x08, 0xd4, 0x08, 0xd4, 0x08, 0xd4, 0x08, 0xd4, 0x08, 0xd4, 0x08, 0xd4,
		0xe2, 0x81, 0x9a, 0x34, 0x51, 0xaf, 0xff, 0xe0, 0x62, 0x1b, 0x14, 0xe4, 0x35, 0x11, 0xdf, 0x32,
		0xd8, 0x0f, 0xfe, 0x89, 0x33, 0x97, 0x75, 0x19, 0x0f, 0xde, 0x0d, 0xdf, 0x33, 0xac, 0xd7, 0xa1,
		0x27, 0x52, 0xd2, 0x49, 0x86, 0x35, 0x4b, 0x14, 0x84, 0x12, 0x6a, 0x8d, 0xe4, 0x29, 0xb5, 0x0b,
		0x10, 0x91, 0x3a, 0x7c, 0x28, 0xa4, 0xee, 0x15, 0x54, 0x04, 0xf2, 0xaf, 0xbe, 0x6b, 0xb7, 0x9c,
		0x2e, 0x6b, 0x8f, 0x99, 0x8a, 0x6a, 0x0d, 0x22, 0x96, 0xa6, 0x6f, 0x72, 0x26, 0xae, 0x7c, 0x8a,
		0xac, 0xce, 0x48, 0x0b, 0x9f, 0x15, 0x08, 0x9f, 0x10, 0x3e, 0x21, 0x7c, 0x22, 0x9f, 0x42, 0x3e,
		0x85, 0x7c, 0x0a, 0xf9, 0x14, 0xf2, 0x29, 0xe4, 0x53, 0x10, 0x3e, 0x11, 0xa8, 0x11, 0xa8, 0x11,
		0xa8, 0x11, 0xa8, 0x11, 0xa8, 0x11, 0xa8, 0x11, 0xa8, 0xf5, 0x26, 0xea, 0xbb, 0x54, 0xdf, 0x12,
		0xdb, 0xff, 0x1b, 0x89, 0x6f, 0x7b, 0xb9, 0xff, 0x37, 0xee, 0x66, 0x58, 0x92, 0x2e, 0xd6, 0xb1,
		0x01, 0x78, 0x7c, 0x37, 0x31, 0xf7, 0xfe, 0x0e, 0x3f, 0x1d, 0x6f, 0xdb, 0x6f, 0x09, 0xdb, 0x7e,
		0x29, 0xb0, 0x2d, 0xf9, 0x6d, 0xbf, 0xb1, 0xb1, 0x2b, 0xea, 0x6d, 0x97, 0x99, 0x9d, 0x78, 0xaf,
		0xe3, 0x46, 0x5a, 0x76, 0x0c, 0xb0, 0x2a, 0x36, 0xc6, 0xf6, 0xf8, 0xf1, 0xe3, 0x78, 0x2d, 0xe1,
		0x70, 0x38, 0xfd, 0x34, 0x18, 0x41, 0x3c, 0x15, 0x5f, 0x48, 0xbd, 0x17, 0xde, 0xfd, 0x5e, 0x81,
		0x19, 0xa4, 0xca, 0x0c, 0x62, 0xef, 0x7e, 0x37, 0xed, 0xae, 0xe3, 0x19, 0x83, 0x39, 0xd1, 0x0f,
		0xc5, 0x57, 0x82, 0xe6, 0xae, 0x16, 0x5b, 0x10, 0x2a, 0x61, 0x27, 0x3c, 0x16, 0x84, 0xa4, 0x12,
		0x65, 0xc5, 0xba, 0x99, 0x32, 0xf5, 0x32, 0x05, 0xeb, 0x64, 0x62, 0x6f, 0x41, 0xec, 0xa9, 0x47,
		0xbe, 0xb7, 0x80, 0x64, 0x61, 0x3c, 0x3a, 0xba, 0x4b, 0xe2, 0xad, 0x20, 0xa1, 0x43, 0xbf, 0xf0,
		0x5e, 0x10, 0xbc, 0xa1, 0x54, 0xe0, 0x9e, 0x4e, 0x55, 0x33, 0x08, 0x1c, 0x16, 0x18, 0x3c, 0x30,
		0xbd, 0xd0, 0x19, 0xf8, 0x42, 0x85, 0x83, 0x03, 0x56, 0x35, 0x06, 0x5d, 0x1d, 0xba, 0x7a, 0xae,
		0x74, 0x75, 0x95, 0x43, 0x74, 0x15, 0x0e, 0xcf, 0x85, 0xb4, 0x0e, 0x69, 0x3d, 0x91, 0xae, 0xa5,
		0x3f, 0xec, 0x76, 0x0f, 0x44, 0x76, 0x41, 0x2f, 0x24, 0x4c, 0xee, 0x6a, 0x66, 0xac, 0x85, 0xe4,
		0xe9, 0x88, 0x5e, 0x91, 0xec, 0xe5, 0x06, 0xf9, 0x49, 0xcb, 0x06, 0x06, 0xc7, 0x33, 0x9e, 0x03,
		0xdf, 0xb4, 0x2d, 0x33, 0xe4, 0x46, 0xef, 0x3b, 0x57, 0x80, 0xa9, 0xe5, 0xa6, 0x80, 0x52, 0x40,
		0x29, 0xa0, 0x14, 0x50, 0x0a, 0x28, 0x05, 0x94, 0xc2, 0x7e, 0x05, 0xd1, 0xb8, 0x6c, 0x3b, 0xa1,
		0x65, 0x06, 0xb6, 0x5a, 0x44, 0x8e, 0x1a, 0x41, 0x2c, 0x46, 0x2c, 0x46, 0x2c, 0x46, 0x2c, 0x46,
		0x2c, 0x46, 0x2c, 0x46, 0x2c, 0x16, 0x8d, 0xc5, 0x2c, 0x08, 0xfc, 0x40, 0x2d, 0x12, 0x8f, 0x9b,
		0x40, 0x1c, 0x46, 0x1c, 0x46, 0x1c, 0x46, 0x1c, 0x46, 0x1c, 0x46, 0x1c, 0x46, 0x1c, 0x16, 0x8d,
		0xc3, 0x1d, 0x2b, 0xa4, 0x88, 0xc5, 0x33, 0xcd, 0x20, 0x1e, 0x23, 0x1e, 0x23, 0x1e, 0x23, 0x1e,
		0x23, 0x1e, 0x23, 0x1e, 0x23, 0x1e, 0x8b, 0xc6, 0xe3, 0x6e, 0xdf, 0xe5, 0x0e, 0xcd, 0xda, 0xf1,
		0x42, 0x53, 0x88, 0xcb, 0x88, 0xcb, 0x88, 0xcb, 0x88, 0xcb, 0x88, 0xcb, 0x88, 0xcb, 0x88, 0xcb,
		0xa2, 0x71, 0xd9, 0xb7, 0x38, 0x53, 0x8c, 0xc7, 0xe3, 0x26, 0x10, 0x87, 0x11, 0x87, 0x11, 0x87,
		0x11, 0x87, 0x11, 0x87, 0x11, 0x87, 0x11, 0x87, 0x45, 0xe3, 0xb0, 0x72, 0x56, 0x8c, 0x5c, 0x18,
		0x31, 0x18, 0x31, 0x18, 0x31, 0x18, 0x31, 0x18, 0x31, 0x18, 0x31, 0x58, 0x2a, 0x06, 0xf7, 0x3d,
		0x22, 0x85, 0x7a, 0xae, 0x21, 0xc4, 0x64, 0xc4, 0x64, 0xc4, 0x64, 0xc4, 0x64, 0xc4, 0x64, 0xc4,
		0x64, 0xc4, 0x64, 0xf1, 0x98, 0xfc, 0xdd, 0xf3, 0xff, 0xf2, 0x8c, 0x5e, 0xe0, 0x73, 0x5f, 0x35,
		0x2a, 0xcf, 0x35, 0x85, 0xb8, 0x8c, 0xb8, 0x8c, 0xb8, 0x8c, 0xb8, 0x8c, 0xb8, 0x8c, 0xb8, 0x8c,
		0xb8, 0x2c, 0x14, 0x97, 0xdd, 0x41, 0x72, 0x6b, 0xb9, 0xcc, 0x0c, 0xe4, 0x03, 0xf2, 0x4c, 0x1b,
		0x88, 0xc4, 0x88, 0xc4, 0xb9, 0x8a, 0xc4, 0xdc, 0xe9, 0x32, 0xee, 0x58, 0xdf, 0xc3, 0xc4, 0x63,
		0xf1, 0x37, 0x6f, 0xe4, 0xc7, 0x8a, 0x9e, 0xe9, 0xf9, 0x21, 0xb3, 0x7c, 0x4f, 0xf8, 0x8d, 0x7e,
		0xc4, 0x74, 0xc4, 0x74, 0xc4, 0xf4, 0x34, 0xc7, 0x74, 0x94, 0x64, 0x43, 0x49, 0xb6, 0xc1, 0x13,
		0xf8, 0x7d, 0x4e, 0x56, 0x93, 0x6d, 0x45, 0x5b, 0xc0, 0x32, 0x60, 0x19, 0x04, 0x12, 0x08, 0x24,
		0x80, 0x29, 0xc0, 0x14, 0x04, 0x12, 0xe1, 0xc8, 0xac, 0x5e, 0x95, 0x6d, 0xae, 0x15, 0x44, 0x63,
		0x44, 0x63, 0x44, 0x63, 0x44, 0x63, 0x44, 0x63, 0x44, 0x63, 0x44, 0x63, 0xe1, 0x68, 0xac, 0x5a,
		0x0b, 0x66, 0xa6, 0x0d, 0x44, 0x62, 0x44, 0x62, 0x44, 0x62, 0x44, 0x62, 0x44, 0x62, 0x44, 0x62,
		0x44, 0x62, 0xe1, 0x48, 0x4c, 0x55, 0x09, 0x66, 0x45, 0x5b, 0x88, 0xcc, 0x88, 0xcc, 0x88, 0xcc,
		0x88, 0xcc, 0x88, 0xcc, 0x88, 0xcc, 0x88, 0xcc, 0xc2, 0x91, 0x59, 0xb5, 0x16, 0xcc, 0x4c, 0x1b,
		0x88, 0xc4, 0x88, 0xc4, 0x88, 0xc4, 0x88, 0xc4, 0x88, 0xc4, 0x88, 0xc4, 0x88, 0xc4, 0xc2, 0x91,
		0x58, 0x3d, 0x33, 0x46, 0x3e, 0x8c, 0x28, 0x8c, 0x28, 0x8c, 0x28, 0x8c, 0x28, 0x8c, 0x28, 0x8c,
		0x28, 0x2c, 0x17, 0x85, 0x69, 0xea, 0xc1, 0x2c, 0xb5, 0x84, 0xa8, 0x8c, 0xa8, 0x8c, 0xa8, 0x8c,
		0xa8, 0x8c, 0xa8, 0x8c, 0xa8, 0x8c, 0xa8, 0x1c, 0xf3, 0x93, 0x31, 0xe7, 0x54, 0xb1, 0xe6, 0x79,
		0x3e, 0x37, 0x07, 0x5d, 0x2b, 0x34, 0x8d, 0x8a, 0xa1, 0xf5, 0xca, 0xba, 0x66, 0xcf, 0xe4, 0xaf,
		0x03, 0x8f, 0x76, 0xe8, 0xf7, 0x98, 0x67, 0x0d, 0x23, 0xa8, 0xe1, 0x0c, 0x7c, 0x5b, 0xc7, 0xb4,
		0x58, 0x78, 0xb8, 0xea, 0xc7, 0xc3, 0x90, 0x9b, 0x9c, 0x1d, 0x8e, 0x7d, 0xa0, 0x48, 0x74, 0x2f,
		0x86, 0x3c, 0xe8, 0x5b, 0xdc, 0x1b, 0x7b, 0xd1, 0xfb, 0xe8, 0x2b, 0xaf, 0xa3, 0xaf, 0x69, 0xaf,
		0xfa, 0xb1, 0xdd, 0x1c, 0x7c, 0x63, 0xfb, 0x72, 0xf2, 0x8d, 0x07, 0x34, 0xbd, 0x1c, 0xa3, 0x87,
		0x8b, 0x36, 0x0b, 0xad, 0xc0, 0xe9, 0x09, 0x75, 0x6f, 0x14, 0x26, 0x66, 0x2f, 0x8e, 0x39, 0x9a,
		0x62, 0x86, 0x2c, 0xcc, 0x3c, 0x32, 0xac, 0x23, 0xcd, 0x38, 0xb2, 0x6c, 0xa3, 0xcc, 0x34, 0xca,
		0x2c, 0xa3, 0xc2, 0x30, 0xb4, 0xd6, 0x2d, 0xcc, 0x2a, 0xd1, 0x68, 0x85, 0x3c, 0x70, 0xbc, 0x17,
		0x91, 0xe1, 0x1a, 0xcf, 0xbd, 0xf2, 0x59, 0x82, 0xf6, 0xc5, 0x3c, 0xf3, 0xd9, 0x65, 0xb6, 0xb8,
		0x6d, 0x4d, 0x2e, 0x8c, 0xd9, 0x8f, 0x57, 0xac, 0x63, 0xf6, 0xdd, 0xe1, 0x78, 0x0e, 0xa6, 0x03,
		0xcc, 0x11, 0xe6, 0x98, 0xac, 0x39, 0x3e, 0xfb, 0xbe, 0xcb, 0x4c, 0x4f, 0xc6, 0x1e, 0xcb, 0x09,
		0xda, 0xe3, 0xab, 0x19, 0xd8, 0x7f, 0x99, 0x01, 0x33, 0x7a, 0x7e, 0xc0, 0xc5, 0xad, 0x72, 0xfe,
		0xf2, 0x7c, 0x18, 0x99, 0xc0, 0xa3, 0xe4, 0xcb, 0xcc, 0x86, 0x0f, 0x9e, 0x39, 0x43, 0x73, 0x99,
		0xd9, 0x09, 0x58, 0x47, 0xc6, 0xd0, 0x4e, 0x05, 0xae, 0x69, 0x44, 0xe0, 0x6c, 0x19, 0x3d, 0xd7,
		0xe4, 0x1d, 0x3f, 0xe8, 0x7e, 0xb2, 0xfc, 0x6e, 0xcf, 0xf7, 0x98, 0xc7, 0xc3, 0xd5, 0xbf, 0x9e,
		0xfb, 0xed, 0x10, 0x83, 0x13, 0x34, 0x6d, 0xa7, 0xe3, 0x78, 0x36, 0xfb, 0x21, 0x6e, 0xd4, 0x93,
		0x0b, 0x11, 0x33, 0x11, 0x33, 0x13, 0x35, 0xe5, 0xbe, 0xe3, 0xf1, 0xa3, 0x8a, 0x84, 0x25, 0x8b,
		0x18, 0xb2, 0x9c, 0xa6, 0x26, 0x21, 0x1e, 0xaa, 0x68, 0x68, 0x8a, 0x02, 0x8f, 0xaa, 0x66, 0x46,
		0xa1, 0xde, 0x48, 0x68, 0x64, 0x4a, 0xda, 0x18, 0x55, 0x97, 0x55, 0x2b, 0xe7, 0xd5, 0xf3, 0x93,
		0xd3, 0xca, 0xf9, 0xf1, 0x0e, 0xfb, 0x4e, 0x93, 0x12, 0xf5, 0x44, 0x6a, 0xe8, 0xc2, 0x65, 0x97,
		0xe4, 0x7d, 0x2a, 0x59, 0x99, 0x25, 0xf5, 0xf2, 0x4a, 0x92, 0x65, 0x95, 0xe2, 0x0d, 0xd2, 0x13,
		0x49, 0xe4, 0x1f, 0x55, 0x9e, 0x7c, 0x1d, 0x3b, 0x3a, 0xc1, 0xe8, 0x3f, 0x7b, 0x31, 0x08, 0x00,
		0x04, 0x90, 0x28, 0x01, 0xc8, 0xd5, 0x95, 0x94, 0x58, 0x62, 0x53, 0xad, 0x23, 0x09, 0x8c, 0x00,
		0x46, 0x6c, 0xec, 0x32, 0xba, 0x25, 0x35, 0x00, 0x05, 0x80, 0x62, 0xd7, 0x40, 0xe1, 0xbf, 0x38,
		0x96, 0xe9, 0x4a, 0xc0, 0xc4, 0xf8, 0x42, 0x80, 0x04, 0x40, 0x22, 0x51, 0x90, 0xd0, 0x2f, 0xbf,
		0xc3, 0xa7, 0x65, 0xdd, 0xa7, 0xf9, 0xbd, 0x67, 0xd3, 0xfa, 0x6e, 0x74, 0x7d, 0x5b, 0x26, 0x4d,
		0x9a, 0xbb, 0x5c, 0x7c, 0x55, 0x72, 0xd8, 0xa9, 0xf0, 0x8b, 0xf0, 0x8b, 0x79, 0xf3, 0x8b, 0x24,
		0xc6, 0xd9, 0xe5, 0x7d, 0x71, 0x93, 0x1c, 0x5c, 0x04, 0x83, 0x82, 0x41, 0x25, 0x6a, 0x50, 0x7d,
		0xc7, 0xe3, 0xe5, 0x13, 0x09, 0x7b, 0x3a, 0x81, 0xd8, 0x00, 0xb1, 0x81, 0xa8, 0xcb, 0x4e, 0x8e,
		0x8f, 0x8f, 0xf6, 0x57, 0x5d, 0x20, 0x89, 0x38, 0xe3, 0x4d, 0xaa, 0x82, 0x21, 0x67, 0x78, 0x15,
		0x62, 0x0e, 0x62, 0x4e, 0xa2, 0x31, 0x27, 0x1b, 0x5b, 0x3d, 0xfd, 0x1e, 0x0b, 0x8c, 0x90, 0x9b,
		0xbc, 0x1f, 0x8a, 0x1b, 0xd6, 0xec, 0xc5, 0xb0, 0x2f, 0xd8, 0x57, 0xa2, 0xf6, 0xc5, 0xbc, 0x7e,
		0x97, 0x05, 0xa6, 0xc0, 0x3e, 0xfe, 0x39, 0x23, 0xab, 0x0a, 0x5c, 0x53, 0xf7, 0xfa, 0xdd, 0xc1,
		0x4d, 0xfe, 0x84, 0xe8, 0xb4, 0x0f, 0xa2, 0x53, 0xef, 0xf5, 0x3d, 0x74, 0x2c, 0xd3, 0x1d, 0x76,
		0x91, 0xc7, 0x24, 0x14, 0xf5, 0xa5, 0x16, 0xf2, 0xe1, 0x1d, 0x79, 0x60, 0x7a, 0xa1, 0xc5, 0x9c,
		0x37, 0x16, 0xec, 0xa5, 0x9b, 0x9c, 0x7d, 0x7e, 0x6c, 0xc1, 0x5d, 0x33, 0xc5, 0x64, 0xb6, 0xe0,
		0xfe, 0xb9, 0xb8, 0x05, 0xf7, 0xff, 0xb5, 0xfa, 0x41, 0xc0, 0x3c, 0xfe, 0xcb, 0xaf, 0x87, 0x1f,
		0x3f, 0x1e, 0xce, 0x77, 0xfd, 0xa7, 0x99, 0x9f, 0x9f, 0x36, 0xfc, 0xdb, 0xe2, 0x3f, 0x2d, 0x1a,
		0x65, 0xb8, 0xf8, 0x81, 0xf1, 0xef, 0x17, 0x7f, 0x3d, 0xda, 0x67, 0x4b, 0x3a, 0x8a, 0x37, 0x4e,
		0xc8, 0x6b, 0x9c, 0x8b, 0x9d, 0x5b, 0x3b, 0xc8, 0xfb, 0xeb, 0x03, 0x07, 0xee, 0x0d, 0xe3, 0x86,
		0xd7, 0x77, 0x5d, 0x81, 0x71, 0xb9, 0x35, 0x7f, 0xc8, 0x5f, 0x7c, 0x1f, 0xd8, 0x2c, 0x60, 0xf6,
		0xc5, 0xfb, 0xf8, 0xd2, 0x04, 0x01, 0x75, 0xd6, 0xe6, 0x84, 0xfd, 0xb0, 0xb8, 0xc3, 0x82, 0x0b,
		0x86, 0x0b, 0x86, 0x0b, 0x5e, 0xe9, 0x82, 0x7b, 0x7e, 0xc0, 0x3f, 0xcd, 0xbd, 0x4b, 0xf4, 0x34,
		0xd7, 0x54, 0xd8, 0x7f, 0x5e, 0xf3, 0x25, 0xb3, 0xff, 0xb2, 0xd3, 0xb7, 0x2d, 0xb8, 0xc8, 0xd0,
		0x4d, 0xbd, 0xc8, 0xe0, 0x2a, 0xe4, 0xb7, 0xc8, 0x6f, 0x13, 0x75, 0x16, 0x8e, 0xcd, 0x3c, 0xee,
		0xf0, 0x77, 0x49, 0x87, 0x21, 0xa0, 0x34, 0x17, 0xaf, 0xc7, 0x5f, 0x75, 0x61, 0x86, 0x4c, 0xbe,
		0xc2, 0x50, 0x54, 0x8b, 0xc0, 0x18, 0x1a, 0x0c, 0x75, 0x87, 0x1f, 0xa8, 0x7d, 0x62, 0xcb, 0x80,
		0x15, 0x6b, 0xfd, 0x97, 0xc1, 0x84, 0x19, 0xbe, 0xf5, 0xbc, 0x3d, 0x25, 0x17, 0xf4, 0x20, 0x87,
		0xc3, 0x39, 0xf8, 0x69, 0xa6, 0x70, 0xc3, 0xc2, 0x2f, 0xc6, 0x7f, 0x1f, 0x16, 0x71, 0x88, 0xbf,
		0x4f, 0x61, 0xb6, 0x0a, 0x42, 0xb1, 0x66, 0xdb, 0x61, 0xc1, 0x2c, 0x04, 0xac, 0xc3, 0x02, 0xe6,
		0x59, 0xac, 0xd0, 0x09, 0xfc, 0x6e, 0x81, 0xbf, 0xb2, 0xc2, 0xb3, 0x19, 0xb2, 0x42, 0xf4, 0x55,
		0x05, 0xee, 0x0f, 0x7f, 0x6b, 0xf9, 0x41, 0xc0, 0xc2, 0x9e, 0xef, 0xd9, 0x8e, 0xf7, 0xf2, 0xe8,
		0x0d, 0xfc, 0x79, 0x21, 0xf2, 0xd2, 0x05, 0xc7, 0x1b, 0x7e, 0xc8, 0x66, 0x6f, 0x8e, 0x35, 0xb8,
		0xf8, 0x8d, 0x79, 0xdc, 0x0f, 0xde, 0x3f, 0x0a, 0xfa, 0xc1, 0x32, 0x5e, 0x1f, 0xc5, 0xeb, 0xa3,
		0xd1, 0x84, 0x75, 0x04, 0x13, 0x1e, 0xb9, 0xf7, 0x9e, 0x97, 0xc6, 0x5b, 0xe6, 0xfd, 0xe7, 0x75,
		0x56, 0xf6, 0xd9, 0x0f, 0x0a, 0xde, 0x58, 0x3d, 0xf3, 0x98, 0xeb, 0xfc, 0x9b, 0xd9, 0x53, 0xd3,
		0x0a, 0x3f, 0x4c, 0xcd, 0x2f, 0x1c, 0xda, 0xcf, 0xe4, 0xab, 0x0b, 0x83, 0xaf, 0x7e, 0xf4, 0xe6,
		0x6c, 0x6e, 0x62, 0x88, 0xf3, 0xe6, 0xf9, 0x71, 0x4f, 0x0a, 0xb3, 0x49, 0x8c, 0x45, 0x61, 0x2f,
		0x4a, 0xb3, 0x89, 0x59, 0xa8, 0x98, 0xa5, 0x0a, 0x5a, 0xac, 0x3c, 0xc5, 0x10, 0xa4, 0x3e, 0x2a,
		0x29, 0x90, 0x5a, 0x2a, 0x24, 0x99, 0xa2, 0x88, 0x0f, 0xc5, 0xcf, 0xe4, 0x52, 0x9f, 0xcc, 0x00,
		0x8b, 0xe9, 0x6d, 0x45, 0x95, 0x19, 0x0d, 0x60, 0x4a, 0x2c, 0x79, 0x21, 0x13, 0x08, 0x3c, 0x3b,
		0x17, 0x78, 0x84, 0x39, 0x45, 0x46, 0xa3, 0x24, 0xd0, 0x2a, 0xd7, 0x19, 0x56, 0x23, 0xf0, 0xdf,
		0x1c, 0x9b, 0xcd, 0x1b, 0xd7, 0xd8, 0x94, 0x66, 0x6d, 0x67, 0x56, 0x96, 0x29, 0xf0, 0x57, 0x73,
		0x0e, 0x50, 0xc2, 0xc9, 0x15, 0x13, 0xd9, 0xbc, 0xb0, 0x90, 0x21, 0x74, 0xfc, 0xa0, 0xc0, 0x5f,
		0x9d, 0x70, 0x06, 0x5d, 0x1e, 0xbd, 0xd6, 0x34, 0x67, 0xe8, 0xf6, 0x43, 0x5e, 0xf0, 0x3d, 0xf7,
		0xbd, 0xd0, 0xf3, 0x7b, 0x7d, 0xd7, 0xe4, 0x6c, 0xf4, 0xf1, 0x41, 0x24, 0x28, 0xfc, 0xe5, 0xf0,
		0xd7, 0x85, 0xdb, 0x7b, 0xf4, 0xcc, 0x99, 0xd6, 0xfd, 0x4e, 0x61, 0x90, 0x45, 0x16, 0x5a, 0x0f,
		0xb5, 0xbb, 0xe6, 0x65, 0xfd, 0xfa, 0x9f, 0xf5, 0x87, 0x7d, 0x21, 0x23, 0xf9, 0x89, 0xb0, 0x1f,
		0x80, 0x24, 0xe5, 0x21, 0xc0, 0x49, 0x7b, 0x27, 0x19, 0x83, 0xc7, 0xf4, 0x09, 0x48, 0x0e, 0x0f,
		0x97, 0x04, 0xa4, 0x49, 0x9c, 0x98, 0x2c, 0xaf, 0x82, 0xc8, 0x40, 0x64, 0xbb, 0x22, 0x32, 0xe9,
		0x2d, 0x3c, 0x4b, 0x13, 0x40, 0x72, 0x2b, 0xcf, 0x26, 0xfd, 0xc8, 0x2c, 0xac, 0x54, 0x8f, 0x3e,
		0x14, 0x5c, 0x27, 0x1c, 0x92, 0xcf, 0xac, 0x88, 0x34, 0x84, 0xb0, 0x15, 0xd6, 0x55, 0xf8, 0xc5,
		0x35, 0x3d, 0x16, 0xfe, 0x5a, 0x58, 0xa9, 0x29, 0x2d, 0x32, 0xd9, 0xf2, 0xe5, 0x66, 0xc0, 0x0a,
		0x6c, 0xbc, 0x21, 0x60, 0xf0, 0x9d, 0x66, 0x61, 0x65, 0x5a, 0xf5, 0xe8, 0x8d, 0x95, 0xe0, 0x89,
		0x03, 0x2e, 0x74, 0x7d, 0x9b, 0xb9, 0x60, 0x31, 0xb0, 0x18, 0x58, 0x2c, 0x53, 0x2c, 0x96, 0x8d,
		0x1d, 0x54, 0xb2, 0xa3, 0x2d, 0xb5, 0xa3, 0x2a, 0xba, 0x5a, 0x65, 0x67, 0xd5, 0xb4, 0x11, 0x85,
		0x1d, 0x56, 0x51, 0x23, 0x52, 0x3b, 0xad, 0x76, 0x48, 0xba, 0x1b, 0x3f, 0xf1, 0xb4, 0x6d, 0xcd,
		0x55, 0xac, 0x4a, 0xbe, 0x6a, 0x75, 0xfc, 0x18, 0x86, 0xac, 0x56, 0x0c, 0x7f, 0xf3, 0x14, 0x5f,
		0xdf, 0x57, 0x1b, 0x26, 0x7b, 0x31, 0xec, 0x3f, 0x4f, 0x9f, 0x68, 0x6b, 0x37, 0x4d, 0xdf, 0x3e,
		0x99, 0xbb, 0x6c, 0xcb, 0x38, 0xc4, 0x03, 0xf0, 0xd8, 0xc1, 0x58, 0x24, 0xf8, 0x0a, 0x6f, 0x4e,
		0x11, 0x8d, 0xa9, 0xd2, 0x31, 0x54, 0x3a, 0x66, 0xca, 0x6c, 0x3e, 0x51, 0xdb, 0xbb, 0x10, 0x17,
		0x8f, 0xe7, 0x66, 0x85, 0xf8, 0x3e, 0xa8, 0xb9, 0xab, 0xf3, 0x91, 0xdb, 0x61, 0x3f, 0x54, 0xda,
		0x33, 0x39, 0x6b, 0x32, 0x23, 0x24, 0xf3, 0xb7, 0xf1, 0xf5, 0x72, 0xe9, 0x4a, 0x19, 0xa7, 0x9d,
		0xe5, 0x21, 0x4b, 0x49, 0xdf, 0x69, 0x67, 0xa2, 0x66, 0x10, 0x5d, 0x28, 0x73, 0xf4, 0xcd, 0xda,
		0x19, 0x23, 0x7e, 0x14, 0x0e, 0x51, 0x5e, 0xaf, 0x6c, 0x30, 0x14, 0x86, 0x43, 0x66, 0x40, 0x54,
		0x86, 0x44, 0x6e, 0x50, 0xe4, 0x86, 0x45, 0x69, 0x60, 0x72, 0x86, 0x26, 0x69, 0x70, 0xea, 0xaa,
		0xc0, 0x32, 0x0d, 0x89, 0xbe, 0xdf, 0xbd, 0x36, 0xc8, 0x9c, 0x25, 0x74, 0x74, 0x9a, 0x4c, 0xe1,
		0x0c, 0xd1, 0xa3, 0x80, 0xd6, 0x76, 0x97, 0xd8, 0xd1, 0x40, 0x2b, 0x64, 0x54, 0x99, 0xa3, 0x82,
		0xe0, 0xae, 0xe0, 0xae, 0xe0, 0xae, 0x24, 0x6b, 0x8a, 0xad, 0xf5, 0x57, 0xe5, 0x14, 0xfb, 0x2b,
		0xb1, 0xd3, 0x54, 0xd6, 0xf6, 0x96, 0xc8, 0xd9, 0x2a, 0x9b, 0x7c, 0x55, 0x09, 0x8e, 0x0a, 0x8e,
		0x0a, 0x8e, 0x4a, 0x64, 0xb6, 0x08, 0x9f, 0x2f, 0xb3, 0xce, 0x76, 0x4e, 0x15, 0x9a, 0x50, 0x3b,
		0xd3, 0x79, 0xf2, 0x9f, 0xda, 0x74, 0x2d, 0x50, 0x9d, 0xf1, 0x4c, 0xe4, 0x54, 0x96, 0x9a, 0x23,
		0x3a, 0xf3, 0x39, 0x6a, 0x8f, 0xf0, 0x34, 0x62, 0xc5, 0xe9, 0x3c, 0x3f, 0x04, 0x04, 0x67, 0x41,
		0xeb, 0x1e, 0x02, 0xd5, 0xf3, 0x70, 0x12, 0x19, 0x8b, 0x83, 0xdd, 0x5c, 0xfd, 0x94, 0x14, 0xae,
		0x68, 0x55, 0x8c, 0x84, 0xab, 0x05, 0xa9, 0x39, 0x21, 0x2d, 0xd5, 0x83, 0xd6, 0xc4, 0x4d, 0x89,
		0x2a, 0x42, 0x2b, 0x03, 0xa6, 0x6e, 0x91, 0xef, 0x49, 0x54, 0x74, 0x97, 0x3b, 0x04, 0x3c, 0xba,
		0x5e, 0x61, 0xb9, 0x73, 0x76, 0xf5, 0x6f, 0xee, 0x6f, 0x87, 0x52, 0x7a, 0x78, 0x41, 0x69, 0x69,
		0x74, 0xf6, 0x66, 0xe6, 0xfe, 0xd6, 0x1e, 0x63, 0xaa, 0xae, 0x45, 0x6e, 0x81, 0xa5, 0x1d, 0xb9,
		0xbc, 0x41, 0x29, 0x5f, 0xc8, 0xea, 0x9e, 0x28, 0x2c, 0x32, 0x90, 0xb1, 0x3a, 0x76, 0x40, 0xad,
		0x9e, 0xa8, 0x63, 0x97, 0xf7, 0xf1, 0xe3, 0xd8, 0x5d, 0x1d, 0xca, 0xec, 0x20, 0xd2, 0xe2, 0x27,
		0x46, 0x1b, 0x49, 0xa4, 0xfd, 0x84, 0xc8, 0xfe, 0xec, 0xa5, 0xae, 0x94, 0xf5, 0x13, 0x15, 0xf8,
		0x09, 0xf8, 0x89, 0x4d, 0x7a, 0x95, 0xec, 0x62, 0xa4, 0x69, 0x77, 0x1d, 0x4f, 0xb4, 0x7a, 0xec,
		0xda, 0x29, 0x33, 0xd7, 0x1a, 0x64, 0x33, 0xc8, 0x66, 0x90, 0xcd, 0x04, 0x66, 0x8b, 0x5c, 0x39,
		0xdc, 0xb5, 0xb1, 0xa6, 0xaa, 0xd0, 0x86, 0x58, 0xb9, 0x5c, 0xaa, 0xae, 0x94, 0x4e, 0x90, 0x69,
		0xd4, 0x3a, 0xad, 0x09, 0x33, 0x7d, 0xe2, 0x4c, 0x94, 0x40, 0xab, 0x59, 0xcd, 0x53, 0x22, 0x4b,
		0x42, 0x96, 0xdf, 0x1f, 0x24, 0x9c, 0x04, 0x11, 0x2a, 0x6a, 0x49, 0x2d, 0x3a, 0x95, 0x11, 0x9d,
		0x10, 0x9d, 0xb2, 0x10, 0x9d, 0x64, 0xc1, 0x70, 0x6a, 0x7a, 0x66, 0x10, 0x38, 0x2c, 0x18, 0xbd,
		0x0c, 0xe2, 0x0c, 0x62, 0x53, 0xa8, 0x3e, 0xe0, 0x91, 0x35, 0xae, 0x68, 0x5c, 0x71, 0xa4, 0x68,
		0xd4, 0x79, 0x65, 0x43, 0xa5, 0x34, 0x58, 0x72, 0xc3, 0xa5, 0x36, 0x60, 0x6d, 0x86, 0xac, 0xcd,
		0xa0, 0x75, 0x18, 0xb6, 0x9a, 0x81, 0x2b, 0x1a, 0x3a, 0x1d, 0x8e, 0xae, 0x0b, 0x99, 0x42, 0x27,
		0x85, 0x6f, 0x33, 0xcf, 0x33, 0x82, 0xa6, 0x68, 0x16, 0x78, 0x69, 0xd0, 0x71, 0xee, 0xc6, 0x28,
		0x17, 0x7c, 0x89, 0xfd, 0xda, 0x52, 0xb3, 0xc4, 0x0b, 0xc0, 0x51, 0xbb, 0x1a, 0x16, 0x1f, 0x89,
		0x2c, 0x64, 0x7e, 0xa8, 0x08, 0x17, 0x86, 0x93, 0x1a, 0x2a, 0xba, 0x13, 0xcf, 0x77, 0x32, 0x7a,
		0x07, 0xe9, 0x68, 0xe5, 0x69, 0xa7, 0x5e, 0x5a, 0x39, 0xd3, 0xa5, 0x75, 0x5b, 0x89, 0x64, 0xbe,
		0xfa, 0x32, 0x60, 0xe2, 0x4c, 0x98, 0x66, 0x92, 0xc9, 0x4f, 0x30, 0x85, 0xc9, 0x55, 0x74, 0x3c,
		0xe3, 0x39, 0xf0, 0x4d, 0xdb, 0x32, 0x43, 0x6e, 0xf4, 0xbe, 0x73, 0x42, 0x58, 0x5f, 0x6e, 0x1a,
		0xa8, 0x0e, 0x54, 0x07, 0xaa, 0x03, 0xd5, 0x81, 0xea, 0x40, 0x75, 0xa0, 0x3a, 0x50, 0x3d, 0x9d,
		0xa8, 0xbe, 0x2b, 0x0e, 0xb3, 0x9d, 0xd0, 0x32, 0x03, 0x9b, 0x96, 0xc0, 0xa2, 0x46, 0xc1, 0x5e,
		0x60, 0x2f, 0xb0, 0x17, 0xd8, 0x0b, 0xec, 0x05, 0xf6, 0x02, 0x7b, 0x81, 0xbd, 0xc0, 0x5e, 0xb3,
		0xec, 0xc5, 0x82, 0xc0, 0x0f, 0x68, 0xc9, 0x6b, 0xdc, 0x24, 0xb8, 0x0b, 0xdc, 0x05, 0xee, 0x02,
		0x77, 0x81, 0xbb, 0xc0, 0x5d, 0xe0, 0x2e, 0x70, 0x17, 0xb8, 0x6b, 0x96, 0xbb, 0x3a, 0x56, 0xa8,
		0x83, 0xbd, 0x66, 0x9a, 0x05, 0x7f, 0x81, 0xbf, 0xc0, 0x5f, 0xe0, 0x2f, 0xf0, 0x17, 0xf8, 0x0b,
		0xfc, 0x05, 0xfe, 0x02, 0x7f, 0xcd, 0xf2, 0x57, 0xb7, 0xef, 0x72, 0x47, 0xcf, 0xde, 0xaf, 0x85,
		0xa6, 0xc1, 0x61, 0xe0, 0x30, 0x70, 0x18, 0x38, 0x0c, 0x1c, 0x06, 0x0e, 0x03, 0x87, 0x81, 0xc3,
		0xc0, 0x61, 0xb3, 0x1c, 0xe6, 0x5b, 0x9c, 0x11, 0xf3, 0xd7, 0xb8, 0x49, 0x70, 0x17, 0xb8, 0x0b,
		0xdc, 0x05, 0xee, 0x02, 0x77, 0x81, 0xbb, 0xc0, 0x5d, 0xe0, 0x2e, 0x70, 0xd7, 0x2c, 0x77, 0x91,
		0xab, 0x5e, 0xd0, 0xba, 0xc0, 0x5c, 0x60, 0x2e, 0x30, 0x17, 0x98, 0x0b, 0xcc, 0x05, 0xe6, 0x02,
		0x73, 0x81, 0xb9, 0x96, 0x98, 0xab, 0xef, 0x69, 0x5a, 0x71, 0x9c, 0x6b, 0x18, 0x0c, 0x06, 0x06,
		0x03, 0x83, 0x81, 0xc1, 0xc0, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x36, 0xcf, 0x60,
		0xdf, 0x3d, 0xff, 0x2f, 0xcf, 0xe8, 0x05, 0x3e, 0xf7, 0xa9, 0x29, 0x6c, 0xae, 0x69, 0x70, 0x18,
		0x38, 0x0c, 0x1c, 0x06, 0x0e, 0x03, 0x87, 0x81, 0xc3, 0xc0, 0x61, 0xe0, 0x30, 0x70, 0x58, 0x34,
		0x2c, 0xae, 0x19, 0x72, 0xc3, 0x72, 0x99, 0x19, 0xd0, 0x01, 0xd8, 0x4c, 0x9b, 0x20, 0x2f, 0x90,
		0x17, 0xc8, 0x2b, 0x45, 0xe4, 0xc5, 0x9d, 0x2e, 0xe3, 0x8e, 0xf5, 0x3d, 0x4c, 0x1d, 0x7b, 0x7d,
		0xf3, 0x46, 0x71, 0xa1, 0xe8, 0x99, 0x9e, 0x1f, 0x32, 0xcb, 0xf7, 0x94, 0x2b, 0x06, 0x82, 0xe9,
		0xc0, 0x74, 0x60, 0x3a, 0x30, 0xdd, 0xee, 0x98, 0x0e, 0x47, 0x2e, 0x50, 0x61, 0x02, 0x8e, 0x5c,
		0xa0, 0xc4, 0x7e, 0xbf, 0xcf, 0xb5, 0x9d, 0xb9, 0xb0, 0xa2, 0x6d, 0xa4, 0x01, 0x48, 0x03, 0x90,
		0x06, 0xa4, 0x28, 0x0d, 0x80, 0x00, 0x0b, 0x58, 0x07, 0xac, 0x03, 0xd6, 0x01, 0xeb, 0x14, 0xdf,
		0xaf, 0x4a, 0x62, 0xf4, 0xa7, 0x2e, 0xcc, 0xb5, 0x0a, 0xfa, 0x02, 0x7d, 0x81, 0xbe, 0x40, 0x5f,
		0xa0, 0x2f, 0xd0, 0x17, 0xe8, 0x0b, 0xf4, 0x05, 0xfa, 0x9a, 0xa3, 0x2f, 0xea, 0xda, 0xbf, 0x33,
		0x6d, 0x82, 0xbc, 0x40, 0x5e, 0x20, 0x2f, 0x90, 0x17, 0xc8, 0x0b, 0xe4, 0x05, 0xf2, 0x02, 0x79,
		0x81, 0xbc, 0xe6, 0xc8, 0x4b, 0x57, 0xe5, 0xdf, 0x15, 0x6d, 0x83, 0xc4, 0x40, 0x62, 0x20, 0x31,
		0x90, 0x18, 0x48, 0x0c, 0x24, 0x06, 0x12, 0x03, 0x89, 0x81, 0xc4, 0xe6, 0x48, 0x8c, 0xba, 0xf6,
		0xef, 0x4c, 0x9b, 0x20, 0x2f, 0x90, 0x17, 0xc8, 0x0b, 0xe4, 0x05, 0xf2, 0x02, 0x79, 0x81, 0xbc,
		0x40, 0x5e, 0x20, 0xaf, 0x39, 0xf2, 0xa2, 0x57, 0xbe, 0xa0, 0x77, 0x81, 0xba, 0x40, 0x5d, 0xa0,
		0x2e, 0x50, 0x17, 0xa8, 0x0b, 0xd4, 0x05, 0xea, 0x02, 0x75, 0x2d, 0x53, 0x97, 0x9e, 0xfa, 0xbf,
		0x4b, 0x2d, 0x83, 0xc2, 0x40, 0x61, 0xa0, 0x30, 0x50, 0x18, 0x28, 0x0c, 0x14, 0x06, 0x0a, 0x03,
		0x85, 0xe5, 0x8d, 0xc2, 0x0e, 0x12, 0x9c, 0xf3, 0xc5, 0x9a, 0xe7, 0xf9, 0xdc, 0x1c, 0x0c, 0xa5,
		0xd2, 0x34, 0x2f, 0x86, 0xd6, 0x2b, 0xeb, 0x9a, 0x3d, 0x93, 0xbf, 0x0e, 0x22, 0xc2, 0xa1, 0xdf,
		0x63, 0x9e, 0x35, 0x24, 0x24, 0xc3, 0x19, 0xc4, 0x86, 0x8e, 0x69, 0xb1, 0xf0, 0x70, 0xd5, 0x8f,
		0x87, 0x61, 0xff, 0x79, 0xe6, 0xf7, 0xb3, 0x7f, 0x3b, 0x0c, 0xb9, 0xc9, 0xd9, 0xe1, 0x38, 0xbc,
		0xa8, 0x80, 0x5f, 0x31, 0xe4, 0x41, 0xdf, 0xe2, 0xde, 0x38, 0x60, 0xdd, 0x47, 0x77, 0x77, 0x1d,
		0x7d, 0x73, 0x7b, 0xd5, 0x8f, 0xed, 0xe6, 0xec, 0xcd, 0xcd, 0xfd, 0xad, 0xdd, 0x1c, 0xdc, 0x5c,
		0xfb, 0x72, 0x72, 0x73, 0x07, 0xc9, 0x8c, 0xb5, 0xc4, 0x38, 0x17, 0x6d, 0x16, 0x5a, 0x81, 0xd3,
		0x53, 0x1a, 0xe4, 0x28, 0xd8, 0xcf, 0x36, 0x26, 0x39, 0xe7, 0xd4, 0xdc, 0x9f, 0x32, 0x79, 0x53,
		0x10, 0x37, 0x19, 0x69, 0x53, 0x11, 0x36, 0x39, 0x59, 0x93, 0x13, 0x35, 0x25, 0x49, 0x27, 0xeb,
		0x23, 0x95, 0x89, 0x39, 0x9a, 0x2d, 0x21, 0x0f, 0x1c, 0xef, 0x45, 0x65, 0xba, 0x8c, 0x6d, 0xa7,
		0x7c, 0x96, 0x62, 0x7f, 0xc3, 0x3c, 0xf3, 0xd9, 0x65, 0xb6, 0xba, 0xaf, 0x99, 0x34, 0x24, 0x39,
		0x6e, 0x57, 0xac, 0x63, 0xf6, 0xdd, 0xe1, 0x7c, 0x1b, 0x4c, 0x5f, 0xb8, 0x2b, 0xb8, 0x2b, 0xb8,
		0x2b, 0x91, 0xd9, 0xf2, 0xec, 0xfb, 0x2e, 0x33, 0x3d, 0x0a, 0x7f, 0x55, 0x4e, 0xb1, 0xbf, 0x72,
		0x3a, 0x8e, 0x67, 0xb3, 0x1f, 0xea, 0xfe, 0x6a, 0xd2, 0x10, 0x1c, 0x0d, 0x1c, 0x0d, 0x1c, 0x8d,
		0xc0, 0x6c, 0xe9, 0x3b, 0x1e, 0x3f, 0xaa, 0x10, 0xf8, 0x99, 0x53, 0x85, 0x26, 0x68, 0xe4, 0x42,
		0x02, 0x5d, 0x95, 0x52, 0x1e, 0x24, 0xd6, 0x9a, 0xa8, 0xe5, 0x40, 0x1d, 0x42, 0x12, 0x81, 0xfc,
		0x47, 0x2a, 0xfb, 0xe9, 0x1a, 0x82, 0x6a, 0xe5, 0xbc, 0x7a, 0x7e, 0x72, 0x5a, 0x39, 0x3f, 0x4e,
		0xf1, 0x58, 0xec, 0x48, 0x44, 0x7b, 0x4a, 0xd4, 0x11, 0x2a, 0x57, 0x14, 0xa6, 0x8b, 0x71, 0xda,
		0x2a, 0x08, 0xd3, 0x57, 0x0e, 0x26, 0xaa, 0x18, 0x2c, 0x37, 0x49, 0x9e, 0x92, 0x21, 0x4b, 0x22,
		0xae, 0x54, 0xa1, 0xca, 0x99, 0x2c, 0xb8, 0x04, 0x32, 0x05, 0x99, 0x82, 0x4c, 0x41, 0xa6, 0x20,
		0x53, 0x90, 0x29, 0xc8, 0x34, 0x4b, 0x64, 0x9a, 0x08, 0xae, 0x8c, 0xce, 0x18, 0x7b, 0x1d, 0x7b,
		0x1b, 0x45, 0x68, 0x99, 0x6d, 0x0c, 0xd8, 0x01, 0xec, 0x00, 0x76, 0x08, 0xcc, 0x16, 0x9a, 0x13,
		0xc5, 0x08, 0x36, 0xd3, 0x51, 0x9f, 0x20, 0x06, 0x96, 0x01, 0xcb, 0x64, 0x8a, 0x65, 0xf4, 0x6d,
		0xa6, 0x03, 0xd5, 0x40, 0x6f, 0x83, 0xde, 0x46, 0x0b, 0xb0, 0xfe, 0x8b, 0x63, 0x99, 0x2e, 0x01,
		0xbc, 0x8e, 0x1b, 0x02, 0xb8, 0x02, 0x5c, 0x01, 0xae, 0x02, 0xb3, 0x65, 0xf7, 0x5b, 0x46, 0x10,
		0x53, 0x10, 0x53, 0x28, 0x63, 0xca, 0x78, 0xd3, 0xb8, 0x62, 0x40, 0x19, 0xb6, 0x82, 0x68, 0x82,
		0x68, 0x82, 0x68, 0x22, 0x30, 0x5b, 0x76, 0xbe, 0x5f, 0x1a, 0xc1, 0x04, 0xc1, 0x84, 0x32, 0x98,
		0xf8, 0x3d, 0x16, 0x18, 0x21, 0x37, 0x79, 0x3f, 0x54, 0x8f, 0x29, 0xb3, 0x8d, 0x21, 0xb4, 0x20,
		0xb4, 0x20, 0xb4, 0x08, 0xcc, 0x16, 0xe6, 0xf5, 0xbb, 0x2c, 0x30, 0x15, 0xde, 0x63, 0x9b, 0x8b,
		0x2f, 0x55, 0x85, 0x36, 0xea, 0x5e, 0xbf, 0x3b, 0x78, 0xa8, 0x9f, 0x88, 0x51, 0x88, 0x51, 0xc4,
		0x31, 0xea, 0x40, 0xe3, 0x54, 0x52, 0x7d, 0x79, 0x58, 0xe3, 0x4b, 0xc3, 0x12, 0xf3, 0x46, 0xdb,
		0x3b, 0xc2, 0x62, 0xb3, 0x24, 0xfe, 0x88, 0xc5, 0xfb, 0x64, 0xcc, 0x31, 0x1d, 0x98, 0xa3, 0xe8,
		0x56, 0xc3, 0xe2, 0x8d, 0x13, 0xf2, 0x1a, 0xe7, 0x81, 0xd0, 0xe8, 0x17, 0x6f, 0x1d, 0xaf, 0x3e,
		0x30, 0x74, 0x6f, 0xe8, 0x7f, 0xbc, 0xbe, 0xeb, 0x7e, 0x10, 0xb8, 0xd8, 0xfc, 0x21, 0x7f, 0xf1,
		0x7d, 0x60, 0xb3, 0x80, 0xd9, 0x17, 0xef, 0xe3, 0x4b, 0x49, 0x3b, 0x50, 0xd2, 0x18, 0xb4, 0x18,
		0x81, 0xc0, 0xf4, 0xd7, 0x30, 0xed, 0xe3, 0x4d, 0xf8, 0xed, 0xd3, 0x77, 0xf3, 0x27, 0xb6, 0x8c,
		0x8b, 0xe8, 0x78, 0x50, 0x8d, 0x43, 0x8c, 0xae, 0xa7, 0xe9, 0xf2, 0xcd, 0xbd, 0xbc, 0xbe, 0xef,
		0x56, 0xff, 0xcb, 0x9a, 0xde, 0x9c, 0xb8, 0x85, 0x0d, 0xf2, 0x55, 0x3c, 0x2f, 0x20, 0x64, 0xf5,
		0x42, 0x56, 0x1e, 0xcf, 0xaa, 0xd7, 0x3d, 0x5f, 0xad, 0xff, 0x32, 0xf8, 0x9a, 0xe1, 0xdb, 0xca,
		0xeb, 0x51, 0x68, 0xf3, 0xf4, 0x89, 0x98, 0xf2, 0x70, 0xc8, 0xd2, 0x9f, 0x66, 0x26, 0xc9, 0xc2,
		0x2f, 0xb6, 0x4c, 0x8e, 0xe2, 0xd5, 0x5c, 0xa5, 0x86, 0x62, 0xcd, 0xb6, 0xc3, 0x82, 0x69, 0xdb,
		0x83, 0xbf, 0x9b, 0x6e, 0xa1, 0xce, 0x5f, 0x59, 0xe0, 0x31, 0x6e, 0x84, 0x3d, 0x66, 0x39, 0x1d,
		0xc7, 0x2a, 0x8c, 0xa6, 0x4d, 0x7f, 0x84, 0xb1, 0x05, 0xee, 0x3f, 0x7a, 0xd3, 0xef, 0x2e, 0x74,
		0x7d, 0x9b, 0x6d, 0x5b, 0xc1, 0x8a, 0xf8, 0x75, 0xcb, 0xc7, 0xe2, 0x26, 0x7a, 0x22, 0x09, 0xdd,
		0x6c, 0xe2, 0xc6, 0xf8, 0x6b, 0x1c, 0xc3, 0x11, 0xcc, 0xd0, 0xa4, 0x33, 0x31, 0xe9, 0x8c, 0x6b,
		0x31, 0xb3, 0x1a, 0x3c, 0x97, 0x66, 0x3f, 0x77, 0xe5, 0xc4, 0x8b, 0xbf, 0x45, 0x36, 0x9e, 0x3e,
		0xf1, 0xbb, 0x2f, 0xca, 0x95, 0x26, 0x57, 0xc6, 0xec, 0x84, 0x85, 0x69, 0xdc, 0xf2, 0x7b, 0x86,
		0xcb, 0xde, 0x98, 0x3b, 0x98, 0xaf, 0xdc, 0x74, 0x3c, 0x16, 0x14, 0x3a, 0x7e, 0x50, 0x98, 0x34,
		0x3b, 0x3f, 0x8d, 0x1f, 0x3d, 0xd3, 0xb3, 0x0b, 0x22, 0x14, 0x17, 0x73, 0x12, 0x4b, 0xab, 0x16,
		0x32, 0x2a, 0x85, 0xf8, 0xe4, 0x56, 0x95, 0x21, 0x94, 0x65, 0x07, 0x65, 0x99, 0x41, 0x6a, 0xf2,
		0x0b, 0xd2, 0xac, 0xaa, 0x31, 0x09, 0x86, 0xc5, 0xa7, 0x75, 0x61, 0x23, 0x1e, 0x5c, 0xc8, 0x43,
		0xc5, 0x86, 0xb1, 0x93, 0xc5, 0x87, 0xd5, 0x63, 0xb1, 0xfc, 0xdc, 0xf3, 0xbf, 0x59, 0x70, 0x3f,
		0xdb, 0x9e, 0x5c, 0xf4, 0x89, 0x57, 0x3c, 0xa7, 0xd8, 0xf3, 0xcd, 0x3f, 0xd5, 0xf4, 0xde, 0x67,
		0xee, 0xbb, 0x38, 0xfd, 0x3a, 0x63, 0xe4, 0x57, 0x16, 0xef, 0x7c, 0xe6, 0x4d, 0xab, 0x85, 0x4f,
		0x2e, 0x3c, 0xfd, 0x6a, 0x4f, 0x33, 0xf5, 0x28, 0x95, 0x85, 0x7f, 0xd8, 0xe0, 0x39, 0x66, 0xaa,
		0x06, 0xac, 0xea, 0x84, 0x2d, 0x5e, 0x20, 0xb6, 0xb5, 0xc7, 0xb6, 0xea, 0x39, 0xeb, 0x5d, 0xa5,
		0x08, 0x6e, 0x9e, 0x17, 0xeb, 0xc2, 0xd0, 0xb4, 0x4b, 0xd7, 0x3f, 0xcb, 0x52, 0xef, 0xaf, 0x7b,
		0x96, 0xcd, 0x8e, 0x7e, 0xab, 0x63, 0x8f, 0xe3, 0xc8, 0x37, 0x0f, 0x8b, 0xa8, 0x93, 0x16, 0x76,
		0xca, 0xc2, 0x4e, 0x78, 0xeb, 0xb0, 0xc9, 0x71, 0xff, 0x36, 0xaa, 0x28, 0x9a, 0x76, 0xd7, 0xf1,
		0xe2, 0x2e, 0x65, 0x44, 0x9d, 0x3a, 0x77, 0x55, 0x3c, 0x34, 0x2d, 0xed, 0x12, 0x4d, 0x63, 0x2d,
		0x28, 0x64, 0x0c, 0x4b, 0xe3, 0xa8, 0xfd, 0x6a, 0x48, 0x1a, 0x5b, 0xa5, 0x97, 0x54, 0xe3, 0x45,
		0x54, 0xf7, 0x98, 0xea, 0xfa, 0x06, 0x30, 0xd8, 0xe0, 0x05, 0x5e, 0x9d, 0x97, 0x57, 0x16, 0x18,
		0xae, 0xf9, 0xce, 0x02, 0xc3, 0xe9, 0xc4, 0xb7, 0x83, 0xc5, 0x0b, 0x61, 0x0a, 0x30, 0x85, 0xc5,
		0x20, 0x38, 0x22, 0x10, 0x23, 0x60, 0x1d, 0x11, 0x93, 0x88, 0xf1, 0x9e, 0x69, 0xb1, 0x31, 0xa1,
		0xb3, 0x39, 0xb1, 0x62, 0xf4, 0x7d, 0x73, 0xbf, 0x1b, 0xfc, 0x65, 0xc8, 0x61, 0x4a, 0x7d, 0x20,
		0x24, 0x13, 0x4b, 0xc9, 0xc3, 0x52, 0xb2, 0xb0, 0x98, 0x1c, 0x2c, 0xe7, 0x20, 0x9c, 0x8e, 0x11,
		0xaf, 0x06, 0xc0, 0x8c, 0x99, 0x19, 0x71, 0x34, 0x78, 0xb8, 0x84, 0xfd, 0x72, 0x09, 0xb1, 0xde,
		0x41, 0x9f, 0x4c, 0x8a, 0xa3, 0x18, 0x1f, 0x15, 0x7b, 0x0f, 0x4b, 0x6c, 0x79, 0x47, 0x42, 0xbb,
		0x90, 0xda, 0x87, 0x32, 0x7d, 0x49, 0x47, 0xf0, 0x3a, 0x85, 0x37, 0x6f, 0x7e, 0x8a, 0x2d, 0x56,
		0x25, 0xde, 0x15, 0x95, 0x72, 0xf5, 0xb4, 0x7a, 0x76, 0x74, 0x52, 0x3d, 0x4d, 0xb0, 0x4f, 0x88,
		0xb4, 0x9b, 0x27, 0x0d, 0x1e, 0x58, 0xe4, 0x9d, 0x66, 0x89, 0x77, 0x97, 0xe1, 0x87, 0xf7, 0xc8,
		0x0f, 0xdb, 0x03, 0x1e, 0x33, 0x3d, 0xdb, 0xe0, 0x4e, 0xac, 0xdd, 0xdc, 0xd3, 0xdd, 0xa7, 0xf1,
		0xa0, 0x8c, 0xb3, 0xc0, 0x8b, 0xed, 0x92, 0x8b, 0x8f, 0x8f, 0xf6, 0xdf, 0xd5, 0x9f, 0xc6, 0xe0,
		0x8f, 0xca, 0xe4, 0x8f, 0xd6, 0xe8, 0x8f, 0x4f, 0x73, 0x7f, 0xfc, 0xf2, 0xf8, 0xf8, 0xf1, 0xf1,
		0xd1, 0xfe, 0xc7, 0xaf, 0xff, 0xf9, 0xcb, 0xbf, 0xfe, 0xf7, 0xcf, 0xc7, 0xc7, 0x7f, 0x3c, 0x3e,
		0x1a, 0x4f, 0x73, 0x9f, 0xf8, 0xb5, 0xb8, 0x1b, 0xdb, 0xf4, 0xff, 0x92, 0xca, 0x9e, 0x16, 0xae,
		0x83, 0x85, 0xc2, 0x42, 0x91, 0x3c, 0xe5, 0x2f, 0x79, 0x8a, 0xf5, 0xe6, 0x8d, 0xc8, 0x1b, 0x36,
		0x70, 0x05, 0x7b, 0xe4, 0x0a, 0x62, 0xbf, 0x3b, 0x12, 0xf3, 0x1d, 0x11, 0xb9, 0x39, 0x2c, 0xb2,
		0xe1, 0x5f, 0x62, 0x63, 0x3f, 0x66, 0x34, 0x44, 0xf2, 0xb4, 0x8b, 0xe4, 0xbd, 0xd7, 0xf7, 0xd0,
		0x30, 0x6d, 0x3b, 0x60, 0xa1, 0x80, 0x0d, 0xcc, 0x5d, 0x05, 0x23, 0x80, 0x11, 0x88, 0xcf, 0x0b,
		0xfd, 0x29, 0xd8, 0x2f, 0x7f, 0x96, 0x8c, 0x73, 0xd3, 0xe8, 0xd4, 0x8c, 0xcf, 0x4f, 0x83, 0x44,
		0xeb, 0xd3, 0xfc, 0xdf, 0x7f, 0xfd, 0x7f, 0x7e, 0xfd, 0xcf, 0xdd, 0x64, 0x56, 0x61, 0x8f, 0xc5,
		0x38, 0x80, 0x65, 0x1a, 0x2b, 0x87, 0x1f, 0x87, 0x95, 0xc1, 0xca, 0xc6, 0xfd, 0xfc, 0x62, 0xf6,
		0x5f, 0x58, 0xac, 0xda, 0x63, 0x02, 0x35, 0xc6, 0xf2, 0xa5, 0x39, 0x97, 0xa0, 0x39, 0xd3, 0xd5,
		0xc8, 0xca, 0xab, 0xfa, 0x3c, 0x80, 0x78, 0x27, 0xe4, 0x8e, 0x25, 0x40, 0x3e, 0x33, 0xd7, 0x64,
		0x60, 0xf3, 0x36, 0x3c, 0xb2, 0x8c, 0x47, 0x8e, 0xbd, 0x69, 0xdb, 0x76, 0x42, 0xcb, 0xf7, 0xb8,
		0xe3, 0xf5, 0x1d, 0xfe, 0x3e, 0xd2, 0x9d, 0x85, 0xb7, 0x6f, 0xaf, 0x68, 0x43, 0x6c, 0x63, 0x75,
		0x29, 0x8d, 0x1b, 0xab, 0x85, 0xde, 0xf5, 0xce, 0xc9, 0xa6, 0x6a, 0x91, 0x17, 0xb5, 0x69, 0x5f,
		0x0f, 0x14, 0x7e, 0xf1, 0x5a, 0x7a, 0xd1, 0x44, 0x86, 0xdc, 0xa5, 0x09, 0x3e, 0xba, 0x30, 0xd9,
		0xc5, 0x94, 0x78, 0x21, 0x27, 0xfe, 0x48, 0xc6, 0x18, 0xc5, 0xa2, 0xe3, 0x19, 0xcf, 0x81, 0x6f,
		0xda, 0x96, 0x19, 0x72, 0xa3, 0xf7, 0x9d, 0x87, 0xe2, 0x8e, 0x64, 0xb9, 0x09, 0xf8, 0x11, 0xf8,
		0x91, 0x84, 0xfc, 0xc8, 0xf8, 0x18, 0x68, 0xa1, 0x82, 0xc8, 0x12, 0x05, 0x90, 0x25, 0x0b, 0x14,
		0x4b, 0xbc, 0xfd, 0xae, 0x52, 0x80, 0x58, 0xb5, 0x70, 0x8b, 0x62, 0x81, 0x61, 0x8a, 0xd2, 0xb5,
		0x32, 0xe5, 0x73, 0x54, 0x0a, 0x06, 0x53, 0x75, 0x19, 0x5d, 0x41, 0x60, 0x92, 0x5e, 0xd4, 0x54,
		0x5c, 0x20, 0xe1, 0xc8, 0x34, 0x40, 0x54, 0x33, 0xb0, 0xe5, 0x62, 0x52, 0x74, 0x31, 0xa2, 0x11,
		0xa2, 0x51, 0xb2, 0xd1, 0x48, 0xe8, 0x68, 0x20, 0x89, 0xa3, 0x80, 0x10, 0x8d, 0x10, 0x8d, 0x36,
		0x76, 0x99, 0xea, 0x51, 0x3b, 0x88, 0x41, 0x51, 0x0c, 0x62, 0x41, 0xe0, 0x07, 0x72, 0x11, 0x68,
		0x7c, 0x29, 0xe2, 0x0f, 0xe2, 0x0f, 0xe2, 0x0f, 0xe2, 0x0f, 0xe2, 0x0f, 0xe2, 0x8f, 0x78, 0xfc,
		0xe9, 0xf6, 0x5d, 0xee, 0xa8, 0xa9, 0x73, 0x0b, 0x4d, 0x20, 0x1e, 0x21, 0x1e, 0x41, 0x9d, 0x43,
		0x3c, 0x82, 0x3a, 0x87, 0xc8, 0xa4, 0x12, 0x99, 0x7c, 0x8b, 0x33, 0xc9, 0x88, 0x34, 0xbe, 0x14,
		0x91, 0x08, 0x91, 0x08, 0x91, 0x08, 0x91, 0x08, 0x91, 0x08, 0x91, 0x48, 0x25, 0x12, 0xf5, 0x3d,
		0xc5, 0x0c, 0x69, 0xae, 0x01, 0x44, 0x25, 0x44, 0x25, 0x44, 0x25, 0x44, 0x25, 0x44, 0x25, 0x44,
		0x25, 0xb5, 0xa8, 0xf4, 0xdd, 0xf3, 0xff, 0xf2, 0x8c, 0x5e, 0xe0, 0x73, 0x5f, 0x36, 0x2e, 0xcd,
		0x35, 0x81, 0xc8, 0x84, 0xc8, 0x94, 0x6c, 0x64, 0xc2, 0x4a, 0x12, 0x22, 0x13, 0x56, 0x92, 0x72,
		0x10, 0x8f, 0xfc, 0x3e, 0x57, 0xde, 0xe8, 0xbd, 0xa2, 0x0d, 0x44, 0x24, 0x44, 0x24, 0xe4, 0x4a,
		0x88, 0x48, 0xc8, 0x95, 0x10, 0x9b, 0x94, 0x62, 0x93, 0xfc, 0x56, 0xef, 0xb9, 0xab, 0x11, 0x8f,
		0x10, 0x8f, 0x90, 0x21, 0x21, 0x1e, 0x21, 0x43, 0x42, 0x14, 0x92, 0x88, 0x42, 0xb2, 0x9b, 0xbd,
		0x67, 0xae, 0x45, 0x04, 0x42, 0x04, 0x42, 0x04, 0x42, 0x04, 0x42, 0x04, 0x42, 0x04, 0x92, 0x88,
		0x40, 0xaa, 0xdb, 0xbd, 0x57, 0xb4, 0x81, 0x88, 0x84, 0x88, 0x04, 0x8d, 0x0e, 0x11, 0x09, 0x1a,
		0x1d, 0x62, 0x93, 0x52, 0x6c, 0x92, 0xdd, 0xf0, 0x3d, 0x73, 0x2d, 0x62, 0x11, 0x62, 0x11, 0x62,
		0x11, 0x62, 0x11, 0x62, 0x11, 0x62, 0x91, 0x52, 0x2c, 0x52, 0xdb, 0xf2, 0xbd, 0xd4, 0x02, 0xe2,
		0x12, 0xe2, 0x12, 0xe2, 0x12, 0xe2, 0x12, 0xe2, 0x12, 0xe2, 0x92, 0xc4, 0x27, 0xb6, 0x15, 0x76,
		0xae, 0x79, 0x9e, 0xcf, 0x47, 0x47, 0xb4, 0xc4, 0xaa, 0xef, 0x1c, 0x5a, 0xaf, 0xac, 0x6b, 0xf6,
		0xa2, 0x33, 0xc5, 0x18, 0xef, 0x18, 0xd3, 0x53, 0xc5, 0x0e, 0x97, 0x0f, 0x18, 0x8b, 0x4e, 0x17,
		0x8b, 0x5d, 0x26, 0x7c, 0xf4, 0x3d, 0x3c, 0xe8, 0x5b, 0x7c, 0x7c, 0xa2, 0x56, 0xf1, 0xba, 0xde,
		0xfa, 0x7c, 0x1d, 0x35, 0xdd, 0x9e, 0xfe, 0xd8, 0x1c, 0x7c, 0xc9, 0xf4, 0xef, 0xed, 0xe6, 0xf4,
		0x4b, 0x34, 0x54, 0x47, 0xe7, 0x71, 0x5c, 0x6b, 0xe4, 0x4e, 0x87, 0x9f, 0xc6, 0x19, 0x15, 0x38,
		0xa3, 0x62, 0xd2, 0xcf, 0x36, 0xf3, 0xb8, 0xc3, 0xdf, 0x05, 0xcf, 0xf8, 0x8b, 0xe1, 0xfa, 0x8a,
		0xd7, 0xe3, 0xa6, 0x2f, 0xcc, 0x90, 0xc9, 0xbc, 0xce, 0x31, 0x39, 0x84, 0x70, 0x38, 0x65, 0x55,
		0x3b, 0xee, 0x40, 0xec, 0x5f, 0xd6, 0x74, 0xf4, 0x60, 0x02, 0x6d, 0x39, 0x26, 0x2f, 0xde, 0x59,
		0x83, 0x42, 0x67, 0x0c, 0x0a, 0x9d, 0x2d, 0x18, 0xef, 0x4c, 0xc1, 0x75, 0xcf, 0x17, 0xd3, 0xf3,
		0xca, 0x7b, 0xdc, 0xe2, 0xc6, 0x73, 0x1e, 0x64, 0xdc, 0xeb, 0xea, 0xa9, 0xb1, 0x3c, 0xac, 0xf3,
		0xbf, 0x59, 0xe8, 0x80, 0x6d, 0x0f, 0x2e, 0xfa, 0xc0, 0x2b, 0x1e, 0x53, 0xe8, 0xf1, 0xe6, 0x1f,
		0x6a, 0x7a, 0xeb, 0x33, 0xb7, 0x5d, 0x74, 0x5d, 0xbb, 0xb7, 0x74, 0xb3, 0xd3, 0xe3, 0x5d, 0x07,
		0xff, 0xba, 0xf0, 0x90, 0xab, 0x8f, 0xba, 0x58, 0xeb, 0xc8, 0x37, 0x39, 0xee, 0x69, 0x6e, 0x68,
		0x19, 0x2b, 0xbe, 0x2a, 0x8e, 0x77, 0x8e, 0xed, 0x8d, 0x63, 0x7b, 0xdf, 0x39, 0x6f, 0x3b, 0xb9,
		0x31, 0xc1, 0x89, 0xb0, 0xee, 0x50, 0x89, 0xa2, 0x35, 0xe9, 0xa5, 0x35, 0x4f, 0x33, 0x4d, 0x58,
		0x86, 0x9f, 0x5b, 0xe7, 0x40, 0x36, 0x9e, 0x36, 0xb2, 0x35, 0xa6, 0xc6, 0x89, 0xa5, 0x31, 0x86,
		0x46, 0x34, 0x80, 0x0a, 0x07, 0x4e, 0xe1, 0x80, 0x19, 0x6f, 0xe8, 0xe4, 0x9c, 0xf6, 0xb6, 0x73,
		0x42, 0x8a, 0xd6, 0xab, 0x19, 0x86, 0x4e, 0x68, 0x38, 0x02, 0xa7, 0x7d, 0xcd, 0x5c, 0x93, 0x01,
		0x9c, 0xda, 0x3e, 0x15, 0x32, 0xca, 0x54, 0x5b, 0xa7, 0xca, 0xae, 0xc0, 0x2a, 0x1d, 0x27, 0xa7,
		0x4e, 0x67, 0xa9, 0x21, 0x96, 0x27, 0x2c, 0x5e, 0x88, 0x39, 0x8e, 0x39, 0xae, 0x38, 0x49, 0x0a,
		0x69, 0x3a, 0x4f, 0x95, 0x79, 0xe6, 0xb3, 0x2b, 0x72, 0xba, 0xe3, 0xe4, 0x82, 0x6d, 0x67, 0x52,
		0xb1, 0x8e, 0xd9, 0x77, 0x87, 0xc3, 0x36, 0x18, 0x6d, 0xd8, 0x0d, 0xec, 0x66, 0xb9, 0xc7, 0x9f,
		0x7d, 0xdf, 0x65, 0xa6, 0xd0, 0xf9, 0xc3, 0x65, 0x0d, 0x36, 0xf0, 0xca, 0x5c, 0xd7, 0x1f, 0x9e,
		0x28, 0x15, 0xc4, 0xb7, 0x83, 0xd9, 0x8b, 0x30, 0xb9, 0x31, 0xb9, 0x97, 0x7a, 0xbc, 0xef, 0x78,
		0x1c, 0x87, 0x9e, 0x12, 0xae, 0xbe, 0xe0, 0xd0, 0x53, 0x6d, 0xbd, 0x93, 0xe6, 0x43, 0x4f, 0xfb,
		0xbd, 0x5e, 0xc0, 0xc2, 0xd0, 0xe0, 0xee, 0x9b, 0x61, 0xda, 0x6f, 0x2c, 0xe0, 0x4e, 0xc8, 0xc6,
		0xd6, 0x1f, 0xf7, 0x10, 0xd4, 0xf5, 0x6d, 0xc0, 0x75, 0xc3, 0x75, 0x67, 0x67, 0x31, 0xe0, 0xe6,
		0xe6, 0xaa, 0xd1, 0x6e, 0xdd, 0xfc, 0x33, 0xee, 0x30, 0x0d, 0xdd, 0x4b, 0x28, 0xb4, 0x9a, 0x2f,
		0xe8, 0xf7, 0x26, 0x77, 0xd6, 0xb8, 0x7f, 0x68, 0xb5, 0xaf, 0xea, 0xcd, 0xcb, 0x87, 0xeb, 0x46,
		0xeb, 0xfa, 0xfe, 0xae, 0xa8, 0xc3, 0x35, 0x4b, 0xde, 0x5b, 0xf3, 0x8f, 0x66, 0xab, 0x7e, 0xdb,
		0xbe, 0xac, 0x35, 0x6a, 0x17, 0xd7, 0x37, 0xd7, 0xad, 0xeb, 0x7a, 0x33, 0x85, 0xb7, 0x97, 0xd2,
		0xce, 0xbb, 0xfc, 0x5a, 0x6b, 0x36, 0xaf, 0x9b, 0xed, 0xeb, 0xab, 0x34, 0xdd, 0xd5, 0x6d, 0xed,
		0xae, 0xf6, 0xa5, 0x7e, 0x5b, 0xbf, 0x6b, 0xb5, 0x6b, 0x57, 0x57, 0x0f, 0xf5, 0x66, 0xaa, 0x46,
		0x74, 0x68, 0x0c, 0xe9, 0xea, 0xb0, 0xf1, 0x24, 0xbb, 0xab, 0xdd, 0xd6, 0xa9, 0xf7, 0x3e, 0x3d,
		0x69, 0xf6, 0xdf, 0xb1, 0x16, 0x12, 0x67, 0x41, 0x36, 0xf6, 0x1a, 0xe1, 0x2c, 0xf2, 0x89, 0x5f,
		0x14, 0x6b, 0x81, 0x51, 0x11, 0x7e, 0xde, 0x43, 0xce, 0xba, 0x86, 0xcd, 0x42, 0x2b, 0x70, 0x7a,
		0xb1, 0x36, 0x82, 0x4c, 0xa1, 0x67, 0xf9, 0x5a, 0xc0, 0x0e, 0x60, 0x87, 0x42, 0xa0, 0x8f, 0xf1,
		0xd9, 0x1b, 0xe6, 0xbd, 0x0c, 0xd7, 0x88, 0x91, 0xa9, 0xe6, 0x2b, 0x53, 0xad, 0x1c, 0x23, 0x31,
		0x9d, 0xf5, 0xcd, 0xe3, 0x7d, 0x0c, 0x62, 0x4e, 0x79, 0xc3, 0xbe, 0x19, 0x78, 0x63, 0x78, 0x63,
		0x78, 0x63, 0x78, 0x63, 0x78, 0xe3, 0x98, 0xff, 0x42, 0xbc, 0x85, 0xcf, 0xef, 0x31, 0x6f, 0xb4,
		0x75, 0x69, 0xe8, 0x21, 0x0e, 0x87, 0xff, 0xb7, 0x71, 0x2f, 0x53, 0x61, 0x79, 0x53, 0xdb, 0x7d,
		0xd4, 0xc8, 0x8d, 0x6b, 0xf7, 0xda, 0xc3, 0xff, 0x1b, 0x3b, 0xea, 0xb8, 0xbb, 0xf4, 0x56, 0xec,
		0x23, 0x9b, 0x6e, 0xae, 0xdb, 0xbe, 0xfb, 0x6a, 0xe6, 0xb3, 0xd8, 0x81, 0x95, 0x9d, 0x1d, 0x58,
		0xd3, 0xfd, 0xa1, 0xb1, 0x91, 0x22, 0xce, 0x96, 0xd2, 0x18, 0x03, 0x0e, 0xa0, 0xc8, 0x02, 0x50,
		0x6c, 0x9b, 0x40, 0xd1, 0x07, 0xb7, 0xec, 0xd2, 0x5c, 0x3b, 0x40, 0x5b, 0x3d, 0x9d, 0xc4, 0x94,
		0x12, 0x9e, 0x5a, 0x32, 0x53, 0x4c, 0x61, 0xaa, 0xc9, 0x4e, 0x39, 0xe5, 0xa9, 0xa7, 0x3c, 0x05,
		0xd5, 0xa6, 0xa2, 0x60, 0x5c, 0x8f, 0x39, 0x66, 0x71, 0xa7, 0x68, 0x74, 0x41, 0xdc, 0x2d, 0x48,
		0x6b, 0x47, 0x3a, 0xde, 0x96, 0xa4, 0xe5, 0x1b, 0x15, 0xda, 0xa2, 0x44, 0x45, 0x6e, 0xa2, 0x36,
		0xa0, 0x62, 0x0b, 0x04, 0x36, 0xa1, 0x6a, 0x1b, 0x64, 0x36, 0x42, 0x66, 0x2b, 0x34, 0x36, 0x23,
		0x66, 0x3b, 0x12, 0xe9, 0x44, 0x41, 0xea, 0x75, 0xe1, 0xa5, 0x11, 0x8f, 0xbf, 0xc5, 0x6a, 0xad,
		0x73, 0x2f, 0x6b, 0x7a, 0xc7, 0x52, 0x24, 0xb7, 0x8a, 0xa5, 0xb2, 0xac, 0xed, 0x84, 0x18, 0x72,
		0x0b, 0xcc, 0x1b, 0xe6, 0x9d, 0x45, 0xf3, 0x36, 0x43, 0x36, 0x7d, 0xff, 0xca, 0x88, 0xb7, 0x61,
		0x61, 0xad, 0xa5, 0x9f, 0x4a, 0x5c, 0xdb, 0x88, 0x12, 0x67, 0xcb, 0x70, 0x3a, 0x9f, 0x66, 0xde,
		0x05, 0x5b, 0xf8, 0xc5, 0xf8, 0xef, 0x43, 0x5b, 0xd4, 0xe5, 0x51, 0x48, 0x41, 0x46, 0xf0, 0xed,
		0x6b, 0x21, 0x41, 0x61, 0xd5, 0x2b, 0x73, 0x87, 0x42, 0xec, 0x1d, 0x53, 0x75, 0x58, 0xf5, 0x6a,
		0xdd, 0x46, 0x29, 0x42, 0xbc, 0x4f, 0xe3, 0xd4, 0x5e, 0x11, 0xf2, 0xdf, 0x32, 0x7e, 0x3b, 0xd5,
		0x35, 0x56, 0x90, 0x8a, 0xec, 0xc6, 0x82, 0xe5, 0xab, 0xad, 0xb8, 0xcc, 0xec, 0x88, 0x39, 0x53,
		0x19, 0x27, 0x1a, 0x39, 0xcf, 0x8f, 0x1f, 0xc7, 0xc6, 0x7f, 0x18, 0xdf, 0x3d, 0x12, 0x19, 0x26,
		0x73, 0x5e, 0x5e, 0x9f, 0xa5, 0xaa, 0x97, 0x4f, 0x2f, 0xd5, 0xac, 0x16, 0x54, 0x60, 0xa2, 0x50,
		0x0b, 0x16, 0x27, 0xac, 0x42, 0x36, 0x30, 0x69, 0x41, 0x2e, 0x23, 0x28, 0x23, 0x23, 0x40, 0x46,
		0xa0, 0x2b, 0x23, 0x10, 0x35, 0x87, 0xa9, 0xde, 0x6b, 0xf6, 0xcc, 0x67, 0xc7, 0x75, 0xb8, 0xc3,
		0x42, 0xf9, 0x31, 0x8b, 0x54, 0xe0, 0xd9, 0xd6, 0x3e, 0x28, 0xd5, 0x9b, 0x2a, 0x4b, 0x5e, 0x2e,
		0xea, 0xfd, 0x29, 0xcd, 0x87, 0xd0, 0x8c, 0xa8, 0xcc, 0x89, 0xdc, 0xac, 0xc8, 0xcd, 0x8b, 0xd6,
		0xcc, 0xe4, 0xcc, 0x4d, 0xd2, 0xec, 0x94, 0xcd, 0x6f, 0xd9, 0x0c, 0xdf, 0xd5, 0x47, 0x7a, 0xc9,
		0x18, 0xdf, 0x55, 0x87, 0x5a, 0xcd, 0x24, 0x95, 0x23, 0x9a, 0x0e, 0x13, 0xd5, 0x60, 0xaa, 0xd4,
		0x26, 0xab, 0xcd, 0x74, 0xb5, 0x99, 0xb0, 0x1e, 0x53, 0x56, 0x33, 0x69, 0x45, 0xd3, 0x26, 0x33,
		0xf1, 0xa9, 0xa9, 0x8b, 0xad, 0xb0, 0xc6, 0x37, 0x77, 0x51, 0x15, 0x28, 0x01, 0x93, 0x27, 0x37,
		0x7d, 0x1d, 0x2e, 0x40, 0xa3, 0x2b, 0xd0, 0xe5, 0x12, 0xb4, 0xbb, 0x06, 0xed, 0x2e, 0x42, 0xaf,
		0xab, 0xa0, 0x71, 0x19, 0x44, 0xae, 0x63, 0xfa, 0xa8, 0x72, 0xc2, 0xf0, 0xd6, 0x76, 0xa5, 0x85,
		0xe3, 0x48, 0x89, 0x89, 0x7e, 0x3a, 0x9c, 0x25, 0xf8, 0xe9, 0x5f, 0xde, 0x0f, 0x49, 0xbd, 0x4b,
		0x41, 0x41, 0x83, 0xbe, 0x9b, 0xdc, 0x73, 0xf4, 0x53, 0xfb, 0x72, 0xe6, 0x9e, 0xa7, 0x7f, 0x79,
		0x17, 0x92, 0xab, 0xf5, 0xcf, 0x24, 0x82, 0x59, 0x24, 0xb7, 0x9c, 0xb9, 0x5d, 0xd8, 0x10, 0x5f,
		0xe6, 0xdc, 0x16, 0x37, 0x4a, 0x88, 0x1b, 0x88, 0x1b, 0x88, 0x1b, 0x34, 0x73, 0x56, 0x7a, 0xb9,
		0x77, 0xeb, 0x8c, 0x15, 0x5f, 0xae, 0x88, 0x0d, 0x8e, 0xa7, 0x84, 0x6d, 0xce, 0x2c, 0x77, 0x8c,
		0xca, 0xa1, 0x8a, 0x2f, 0x06, 0xa7, 0xdb, 0xaf, 0x8f, 0x6a, 0x9e, 0x92, 0x3b, 0xf6, 0x75, 0xa5,
		0x54, 0x53, 0x95, 0x11, 0x54, 0xe0, 0xd9, 0xe1, 0xd9, 0xf7, 0xd4, 0xb3, 0x53, 0x89, 0x0a, 0x51,
		0x83, 0xb2, 0x7b, 0x62, 0x63, 0x5b, 0x82, 0xdc, 0x9e, 0xd9, 0x84, 0xb1, 0x51, 0x1b, 0x3e, 0xea,
		0x74, 0x36, 0x09, 0x38, 0x1d, 0xdd, 0xce, 0x27, 0x31, 0x27, 0x94, 0x98, 0x33, 0x4a, 0xc6, 0x29,
		0xd1, 0x3a, 0x27, 0x62, 0x27, 0xa5, 0x0f, 0x43, 0x97, 0x66, 0xbc, 0xfc, 0xa6, 0xe3, 0xd8, 0xf4,
		0x52, 0x3e, 0x48, 0xe7, 0x80, 0x11, 0x0e, 0x16, 0xad, 0x4a, 0xa0, 0x53, 0x2d, 0x80, 0xfb, 0x87,
		0xfb, 0x87, 0xfb, 0x87, 0xfb, 0x97, 0x2a, 0x9f, 0x27, 0x1d, 0x02, 0x8e, 0x35, 0xb4, 0x2d, 0x55,
		0x9e, 0x4f, 0xba, 0xa3, 0x86, 0xe5, 0xfc, 0x16, 0xab, 0xd3, 0xfd, 0xa1, 0xcb, 0xc8, 0x24, 0x8a,
		0x01, 0x8a, 0xfe, 0xf7, 0xb7, 0xb6, 0x96, 0xe7, 0xfa, 0xad, 0x55, 0xbf, 0xa9, 0x37, 0xbe, 0xde,
		0xdf, 0xd5, 0x8b, 0xda, 0xbe, 0xef, 0xe7, 0x87, 0xac, 0x77, 0xd2, 0xc3, 0xfd, 0xb7, 0x56, 0xfd,
		0x01, 0x3d, 0xb4, 0xbe, 0x87, 0xae, 0xee, 0x2f, 0x9b, 0xd7, 0xcd, 0xf6, 0x65, 0xed, 0xe2, 0xa6,
		0xde, 0xbe, 0xaa, 0xff, 0xf3, 0xfa, 0x12, 0x13, 0x6a, 0x43, 0x77, 0x35, 0x5b, 0xb5, 0xd6, 0xf5,
		0xfd, 0x5d, 0xfb, 0xfe, 0xee, 0xe6, 0x0f, 0xf4, 0xd3, 0x86, 0x7e, 0x6a, 0xff, 0xf3, 0xa6, 0x76,
		0x87, 0x1e, 0x5a, 0xdf, 0x43, 0xf7, 0xad, 0xaf, 0xf0, 0x4c, 0x9b, 0x3a, 0xe8, 0x12, 0x53, 0x68,
		0x4b, 0x0f, 0xdd, 0xd6, 0x2e, 0xdb, 0x17, 0x0f, 0xd7, 0x57, 0x5f, 0xe0, 0xb2, 0x37, 0x31, 0x40,
		0xbd, 0x51, 0xaf, 0x81, 0x02, 0x36, 0xc3, 0xe4, 0xef, 0xf7, 0xed, 0x61, 0xc1, 0xde, 0xc1, 0x94,
		0x7a, 0xa8, 0xdf, 0xd4, 0x10, 0xdc, 0x36, 0xf4, 0xd6, 0xef, 0x37, 0xb5, 0xbb, 0x76, 0xed, 0xf2,
		0xb2, 0xde, 0x6c, 0xb6, 0x1b, 0xf7, 0xd7, 0x77, 0x2d, 0x8d, 0x9d, 0xa5, 0xa5, 0xe5, 0xa7, 0xb4,
		0xa7, 0xfb, 0xd8, 0x34, 0x27, 0xd4, 0x6e, 0x12, 0x9b, 0xe6, 0x28, 0xd7, 0xdf, 0x0b, 0xc9, 0xec,
		0x99, 0x5b, 0x71, 0x7a, 0xea, 0xee, 0xe6, 0xd1, 0x6e, 0x77, 0x7c, 0x6f, 0x3f, 0xab, 0x38, 0x76,
		0x53, 0x42, 0xa5, 0xc8, 0xb7, 0xb6, 0x26, 0x53, 0xaa, 0x7c, 0x7b, 0xa3, 0x12, 0xa5, 0xcc, 0xb7,
		0x36, 0x2a, 0x54, 0xea, 0x5c, 0xf7, 0x78, 0x12, 0x7b, 0x92, 0x24, 0x3c, 0x48, 0x91, 0x64, 0x6f,
		0x91, 0x66, 0x9f, 0xa1, 0xe6, 0x2d, 0x7e, 0x66, 0xe4, 0x15, 0x2f, 0xa2, 0xd9, 0xa3, 0x6d, 0xd6,
		0xa8, 0xbc, 0x63, 0xa8, 0x67, 0x8a, 0xc8, 0xcd, 0x0b, 0xf1, 0x51, 0x95, 0x18, 0x51, 0xd5, 0x97,
		0x70, 0x68, 0x5e, 0xba, 0x21, 0x7b, 0xd5, 0xb5, 0x84, 0x57, 0x5d, 0x17, 0x02, 0x37, 0x5e, 0x75,
		0xdd, 0x2b, 0x3f, 0xa8, 0xfa, 0x72, 0x0a, 0xa5, 0x07, 0x54, 0x78, 0xe9, 0x24, 0x21, 0xdf, 0xd7,
		0x0f, 0xb9, 0xdf, 0x35, 0xb8, 0xfb, 0x46, 0xf1, 0xc6, 0xff, 0x4c, 0x63, 0x78, 0xe1, 0x1f, 0x5e,
		0x70, 0x4f, 0xbc, 0xa0, 0xf2, 0x0b, 0xff, 0xdc, 0x7d, 0xa3, 0x7b, 0xd3, 0x7f, 0xd0, 0x18, 0x5e,
		0xf1, 0x4f, 0xc0, 0x38, 0xa9, 0x8d, 0x54, 0x9b, 0xb1, 0x6a, 0x33, 0x5a, 0x3d, 0xc6, 0x9b, 0x0e,
		0xc1, 0x07, 0xaf, 0xf8, 0xa7, 0xc1, 0xf4, 0x75, 0xb8, 0x00, 0x8d, 0xae, 0x40, 0x97, 0x4b, 0xd0,
		0xee, 0x1a, 0xb4, 0xbb, 0x08, 0xbd, 0xae, 0x82, 0xc6, 0x65, 0x10, 0xb9, 0x0e, 0x5d, 0x1a, 0xa3,
		0x9e, 0x6c, 0x69, 0x8a, 0xec, 0x87, 0xdc, 0x7d, 0x4b, 0xf7, 0xab, 0xfd, 0xc3, 0x7b, 0x6d, 0xb9,
		0x6f, 0x61, 0xbb, 0xe5, 0xbe, 0xe5, 0xf0, 0x8d, 0x7e, 0xbf, 0xef, 0xd0, 0xc7, 0x89, 0x41, 0xa3,
		0x78, 0x9f, 0x1f, 0x41, 0x02, 0x41, 0x22, 0x95, 0x41, 0x02, 0xef, 0xf3, 0x2f, 0xbe, 0xcf, 0x3f,
		0x70, 0x58, 0xf9, 0x72, 0xea, 0x46, 0xd8, 0x7f, 0xe6, 0x94, 0xe3, 0x3c, 0xeb, 0xdc, 0xa3, 0xc6,
		0xe1, 0xe4, 0xe1, 0xe4, 0xe1, 0xe4, 0xe1, 0xe4, 0xb3, 0xe2, 0xe4, 0x23, 0xc7, 0x85, 0xda, 0x2d,
		0xdb, 0x46, 0x19, 0xb5, 0x5b, 0xe0, 0xe0, 0xe1, 0xe0, 0x53, 0xec, 0xe0, 0xc9, 0x6b, 0xb7, 0x50,
		0x4a, 0x01, 0x1a, 0x25, 0x01, 0x4d, 0xd4, 0xa8, 0x8d, 0x1e, 0x75, 0x3a, 0x99, 0x04, 0x9c, 0x8d,
		0x6e, 0xa7, 0x93, 0x98, 0xf3, 0x49, 0xcc, 0x09, 0x25, 0xe3, 0x8c, 0x68, 0x9d, 0x12, 0xb1, 0x73,
		0xd2, 0x47, 0xa1, 0x2b, 0x38, 0x25, 0x70, 0xbc, 0x17, 0x9d, 0xef, 0xeb, 0x9f, 0xed, 0x41, 0xc9,
		0x16, 0x1d, 0x8a, 0x41, 0x02, 0xca, 0x01, 0x62, 0x01, 0x62, 0x01, 0x62, 0x01, 0x62, 0x01, 0x62,
		0x01, 0x61, 0x2c, 0xd0, 0x1b, 0x04, 0xe0, 0xfd, 0xe1, 0xfd, 0xe1, 0xfd, 0xe1, 0xfd, 0xe9, 0x67,
		0xbc, 0xe3, 0xf1, 0xa3, 0x8a, 0x46, 0xe7, 0x7f, 0xa4, 0xa1, 0xe9, 0x07, 0xd3, 0x7b, 0x61, 0xda,
		0x4a, 0x5b, 0xe9, 0x7b, 0xb7, 0xbe, 0x78, 0xeb, 0x78, 0xda, 0x1c, 0xc0, 0x52, 0xd4, 0xfd, 0xa0,
		0xf7, 0x6b, 0x86, 0x05, 0xc6, 0x8a, 0x9f, 0x0a, 0x95, 0x72, 0xf5, 0xb4, 0x7a, 0x76, 0x74, 0x52,
		0x3d, 0xd3, 0xfc, 0x85, 0x9f, 0x03, 0xd3, 0xe2, 0x8e, 0xef, 0x5d, 0x39, 0x2f, 0xce, 0xf0, 0x75,
		0xd7, 0x52, 0x16, 0x2b, 0x37, 0x14, 0x6f, 0xcd, 0x1f, 0x89, 0xcd, 0x81, 0x52, 0xd2, 0x73, 0xe0,
		0x34, 0x47, 0x73, 0xe0, 0x20, 0x1b, 0xad, 0x3e, 0xed, 0x01, 0x5c, 0xbf, 0x8d, 0xe7, 0x99, 0x26,
		0xba, 0x1e, 0x35, 0x0f, 0xbc, 0x06, 0x5e, 0x03, 0xaf, 0x81, 0xd7, 0xa4, 0x33, 0xfe, 0xd9, 0xf1,
		0xcc, 0xe0, 0x5d, 0x23, 0x5f, 0x9f, 0xa3, 0x1e, 0x51, 0x9c, 0xb9, 0x9e, 0xc1, 0x1d, 0xfe, 0x69,
		0xae, 0x43, 0x34, 0xbf, 0xc1, 0x3f, 0x5d, 0xe5, 0x87, 0x08, 0x76, 0x07, 0xe9, 0xd9, 0x03, 0x8a,
		0xcd, 0x9f, 0x69, 0xa5, 0x08, 0xec, 0x0d, 0xda, 0x0d, 0x25, 0x60, 0xf3, 0xa7, 0xb2, 0xca, 0xa3,
		0x75, 0xf3, 0x67, 0xaa, 0x76, 0x7d, 0xa6, 0xa1, 0xac, 0xdc, 0xa0, 0x43, 0x0a, 0x7e, 0xdf, 0x29,
		0xd0, 0xad, 0xca, 0xa3, 0xcc, 0x1c, 0xca, 0xcc, 0x09, 0x81, 0x61, 0xca, 0xca, 0xcb, 0xcd, 0xa1,
		0x20, 0xaa, 0xca, 0xa5, 0x60, 0x92, 0xa4, 0xa4, 0xa4, 0x52, 0x34, 0x31, 0xd2, 0x5c, 0x56, 0xc9,
		0xb1, 0xd5, 0xab, 0x29, 0x39, 0xb6, 0x62, 0x11, 0xa5, 0x12, 0x4a, 0xc9, 0x15, 0x50, 0x44, 0x29,
		0x23, 0xce, 0x4f, 0x99, 0x92, 0x09, 0xa9, 0x98, 0x82, 0x82, 0x97, 0xa9, 0xd7, 0xb1, 0xd3, 0xec,
		0xb1, 0xd4, 0xde, 0x5c, 0x22, 0x79, 0x53, 0x09, 0xc5, 0xdf, 0xe0, 0xb7, 0xf6, 0xaf, 0xf8, 0x9b,
		0xf9, 0xc2, 0xe8, 0x8a, 0xbf, 0x0d, 0x1a, 0xa3, 0x29, 0xfe, 0x56, 0x42, 0xf1, 0xb7, 0x5d, 0x48,
		0x7c, 0x28, 0xfe, 0x96, 0x06, 0x59, 0x86, 0x4c, 0xb2, 0x8b, 0x66, 0x5c, 0xdf, 0xf1, 0xf8, 0x49,
		0x95, 0x62, 0xc2, 0x8d, 0xed, 0x93, 0x60, 0x5b, 0x14, 0xf1, 0x86, 0x37, 0x42, 0x81, 0x53, 0xc7,
		0x86, 0x36, 0x5d, 0x3b, 0x27, 0x26, 0x9b, 0x95, 0xa8, 0xdb, 0xd5, 0xb8, 0x27, 0x89, 0x72, 0x0f,
		0x8d, 0x8e, 0x7d, 0x67, 0xba, 0x87, 0xaa, 0x7c, 0x56, 0xad, 0x9e, 0x9c, 0x56, 0xab, 0xa5, 0xd3,
		0xa3, 0xd3, 0xd2, 0xf9, 0xf1, 0x71, 0xf9, 0x84, 0xfa, 0x1c, 0x58, 0xad, 0xa3, 0x97, 0x12, 0xe5,
		0xfc, 0x69, 0x57, 0xa2, 0x9c, 0x02, 0x52, 0x5b, 0xaf, 0x66, 0x18, 0x3a, 0xa1, 0xa1, 0xa0, 0xcf,
		0x2c, 0xb9, 0xf6, 0x99, 0x36, 0x81, 0x5e, 0x40, 0x2f, 0xa0, 0x57, 0xca, 0xd0, 0x8b, 0xec, 0x45,
		0x34, 0xa2, 0x17, 0xcf, 0x76, 0xed, 0xf9, 0x0c, 0x92, 0x6d, 0x28, 0x2b, 0xdc, 0x9f, 0x41, 0xb1,
		0x6c, 0x09, 0x1f, 0x08, 0x1f, 0x08, 0x1f, 0x48, 0xed, 0x03, 0x69, 0x8d, 0x74, 0xce, 0x19, 0x56,
		0x09, 0xda, 0xaa, 0x7b, 0xfd, 0xee, 0xe0, 0x81, 0x7f, 0x66, 0xd0, 0xb1, 0x52, 0xa2, 0x24, 0x10,
		0x12, 0xee, 0x13, 0xee, 0x13, 0x08, 0x99, 0x4e, 0x4f, 0xe7, 0x9a, 0x21, 0x37, 0xfa, 0x3d, 0x9b,
		0xa2, 0xc4, 0xe1, 0x74, 0xb5, 0x76, 0xa6, 0x51, 0xf8, 0x3e, 0xf8, 0x3e, 0xf8, 0xbe, 0x94, 0xf9,
		0x3e, 0xea, 0x85, 0x8b, 0x2a, 0x16, 0x2e, 0x24, 0x63, 0x86, 0x26, 0x35, 0xfc, 0xbc, 0x52, 0x39,
		0x3a, 0x3a, 0xad, 0x94, 0x8e, 0x4e, 0xce, 0x8e, 0xab, 0xa7, 0xa7, 0xc7, 0x67, 0xa5, 0x33, 0x2c,
		0x65, 0x50, 0x0f, 0x5e, 0x29, 0xb1, 0xc1, 0x3b, 0xc5, 0x4a, 0x86, 0xe8, 0x7f, 0x59, 0x5c, 0xc9,
		0xe8, 0x9a, 0x9e, 0xf9, 0x32, 0xdc, 0x3b, 0x6f, 0x98, 0xb6, 0x1d, 0xb0, 0x30, 0xa4, 0x63, 0xb2,
		0x15, 0x6d, 0x03, 0xcd, 0x80, 0x66, 0x40, 0x33, 0xa4, 0xa5, 0x99, 0xf0, 0x84, 0xc4, 0x2b, 0x1c,
		0xeb, 0xbe, 0x00, 0x3e, 0x11, 0x3e, 0x11, 0x3e, 0x11, 0x3e, 0x31, 0x85, 0x3e, 0xb1, 0xe7, 0x07,
		0xdc, 0xb0, 0x59, 0x68, 0x05, 0x4e, 0x8f, 0xe4, 0xed, 0xc3, 0xa8, 0x7f, 0x97, 0x5a, 0x86, 0x17,
		0x84, 0x17, 0x84, 0x17, 0x84, 0x17, 0x4c, 0xab, 0x17, 0xa4, 0x5c, 0x9f, 0x9d, 0x34, 0x08, 0x9f,
		0x07, 0x9f, 0x07, 0x9f, 0x07, 0x9f, 0x97, 0x5e, 0x9f, 0x47, 0x9c, 0x02, 0xcf, 0xb5, 0x0a, 0xef,
		0x07, 0xef, 0x07, 0xef, 0x97, 0x32, 0xef, 0x47, 0x68, 0xa1, 0x05, 0x6c, 0xef, 0x9b, 0xde, 0x7b,
		0xf8, 0x1e, 0x72, 0xd6, 0xd5, 0x93, 0x4b, 0xaf, 0x68, 0x1b, 0xbe, 0x15, 0xbe, 0x15, 0xbe, 0x35,
		0xff, 0x64, 0x49, 0xd0, 0xd6, 0x0d, 0xf3, 0x5e, 0x86, 0x25, 0x46, 0xf0, 0xfa, 0xae, 0x42, 0xb3,
		0x78, 0x7d, 0x37, 0x73, 0x43, 0x55, 0x39, 0xc6, 0xdb, 0xba, 0xc2, 0xff, 0x3d, 0x65, 0x97, 0xbd,
		0xc6, 0x65, 0xe3, 0x68, 0xa1, 0x6b, 0xd8, 0x28, 0x68, 0x0b, 0xb4, 0x05, 0xda, 0x02, 0x6d, 0x81,
		0xb6, 0x40, 0x5b, 0xa0, 0x2d, 0xd0, 0xd6, 0x5e, 0xd3, 0x16, 0xe7, 0x2e, 0x1d, 0x65, 0x0d, 0x1a,
		0x03, 0x5d, 0x81, 0xae, 0x40, 0x57, 0x29, 0xa3, 0xab, 0xbe, 0xe3, 0xf1, 0xf2, 0x09, 0x21, 0x5d,
		0x9d, 0xe0, 0x7d, 0x2e, 0xb0, 0x15, 0xd8, 0x4a, 0x6a, 0xa8, 0x4e, 0x8e, 0x8f, 0x8f, 0x40, 0x57,
		0xd9, 0xa1, 0xab, 0xbd, 0x3f, 0x0e, 0x42, 0xf5, 0xf0, 0x38, 0xc2, 0x83, 0x20, 0x14, 0x4e, 0x87,
		0x93, 0xa8, 0xa8, 0x7e, 0xa0, 0x71, 0xc4, 0x27, 0xa7, 0x00, 0x09, 0x6f, 0x2c, 0x54, 0x3b, 0xe3,
		0x87, 0xe4, 0x4c, 0x1f, 0x92, 0x33, 0x7c, 0xd4, 0xce, 0xec, 0x11, 0xed, 0x6d, 0x45, 0xbb, 0xa2,
		0xb4, 0xa7, 0xa2, 0x54, 0xa1, 0x7e, 0x22, 0x0b, 0x12, 0xb3, 0x9d, 0xf8, 0x16, 0x10, 0xef, 0x93,
		0x31, 0x47, 0x4d, 0x76, 0xb4, 0x08, 0x46, 0x49, 0x60, 0x70, 0x94, 0x07, 0x25, 0xde, 0x58, 0x6c,
		0xef, 0xd9, 0x18, 0xbd, 0x2a, 0x78, 0xd2, 0x83, 0xd4, 0xc9, 0x0e, 0x82, 0x25, 0x0b, 0x84, 0x4f,
		0x6e, 0x90, 0xc9, 0xc5, 0x15, 0x72, 0x6e, 0xd9, 0xdc, 0x5a, 0x39, 0x87, 0x56, 0xce, 0x95, 0xd5,
		0x72, 0x62, 0x5a, 0x4b, 0x16, 0x3d, 0x29, 0xa1, 0x68, 0xf9, 0xfd, 0x81, 0xa5, 0x88, 0xbf, 0xd8,
		0x3e, 0x2d, 0x7b, 0x37, 0x69, 0x41, 0x34, 0x20, 0x4b, 0x55, 0xdc, 0x90, 0x96, 0x9a, 0x54, 0xa4,
		0x25, 0x02, 0x29, 0x49, 0x55, 0x3a, 0x22, 0x93, 0x8a, 0xc8, 0xa4, 0x21, 0x1a, 0x29, 0x48, 0x2f,
		0xf4, 0xc9, 0x1e, 0x1c, 0x52, 0xec, 0x04, 0x66, 0x97, 0x19, 0xb6, 0x13, 0x5a, 0x66, 0x40, 0x70,
		0xcc, 0xd8, 0x7c, 0x73, 0x38, 0x71, 0x0c, 0x27, 0xf7, 0xec, 0x4c, 0x73, 0xcd, 0xea, 0x89, 0x63,
		0xe3, 0x30, 0xa3, 0x54, 0x26, 0x8b, 0xe0, 0x5c, 0x0f, 0x22, 0x19, 0x95, 0xe6, 0xb4, 0x58, 0xc2,
		0x85, 0x08, 0xda, 0x33, 0xc9, 0x89, 0x65, 0x52, 0x1d, 0x7a, 0xdb, 0x4f, 0x9a, 0xb3, 0x75, 0x53,
		0x3f, 0x04, 0xfa, 0xce, 0xe1, 0xd0, 0x32, 0x2a, 0x3b, 0x52, 0x1d, 0x9f, 0x52, 0x7c, 0x6a, 0xe0,
		0x08, 0x1e, 0x58, 0x10, 0xf8, 0x81, 0xa1, 0x60, 0xf3, 0x0b, 0x30, 0x12, 0xb5, 0x07, 0x1a, 0x01,
		0x8d, 0x80, 0x46, 0x40, 0x23, 0xa0, 0x11, 0xd0, 0x08, 0x68, 0x04, 0x34, 0x22, 0x40, 0x23, 0x7e,
		0x9f, 0xd3, 0xe2, 0xc8, 0xa0, 0x41, 0xf0, 0x08, 0x78, 0x04, 0x3c, 0x02, 0x1e, 0x01, 0x8f, 0x80,
		0x47, 0xc0, 0x23, 0xe0, 0x91, 0x58, 0x3c, 0x42, 0xa7, 0x8b, 0x40, 0x11, 0x01, 0x81, 0x80, 0x40,
		0x40, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x12, 0x97, 0x40, 0x08, 0xb5, 0x10, 0xa8,
		0x20, 0x60, 0x10, 0x30, 0x08, 0x18, 0x04, 0x0c, 0x02, 0x06, 0x01, 0x83, 0x80, 0x41, 0x62, 0x74,
		0xf3, 0xf0, 0x84, 0x57, 0xcb, 0x65, 0x66, 0xa0, 0x0e, 0x21, 0x33, 0x6d, 0x81, 0x42, 0x40, 0x21,
		0xa0, 0x10, 0xc1, 0x19, 0x63, 0x9b, 0x9c, 0x19, 0xa6, 0x67, 0x1b, 0xdc, 0x51, 0x2a, 0x7f, 0x46,
		0x51, 0x5a, 0xa9, 0xd8, 0x30, 0x39, 0x67, 0x81, 0xa7, 0x0c, 0x23, 0xc5, 0xc7, 0x47, 0xfb, 0xef,
		0xea, 0x4f, 0x63, 0xf0, 0x47, 0x65, 0xf2, 0x47, 0x6b, 0xf4, 0xc7, 0xa7, 0xb9, 0x3f, 0x7e, 0x79,
		0x7c, 0xfc, 0xf8, 0xf8, 0x68, 0xff, 0xe3, 0xd7, 0xff, 0xfc, 0xe5, 0x5f, 0xff, 0xfb, 0xe7, 0xe3,
		0xe3, 0x3f, 0x1e, 0x1f, 0x8d, 0xa7, 0xb9, 0x4f, 0xfc, 0x5a, 0xcc, 0xa5, 0x0f, 0xe6, 0xee, 0x1b,
		0xdd, 0x1b, 0x03, 0xb3, 0x8d, 0xc1, 0x0b, 0xc3, 0x0b, 0xc3, 0x0b, 0x23, 0x17, 0x44, 0x2e, 0x88,
		0x5c, 0x10, 0xb9, 0x20, 0x72, 0xc1, 0x18, 0x1c, 0xd2, 0xf7, 0xbe, 0x7b, 0xfe, 0x5f, 0x1e, 0x0d,
		0x87, 0x4c, 0x1a, 0x03, 0x87, 0x80, 0x43, 0xc0, 0x21, 0xe0, 0x10, 0x70, 0x08, 0x38, 0x04, 0x1c,
		0xb2, 0x5f, 0x1c, 0x92, 0xcf, 0x6a, 0x51, 0xc3, 0x7a, 0x3b, 0x87, 0x92, 0x15, 0x4c, 0x0a, 0x0a,
		0x45, 0x89, 0x86, 0x85, 0xd5, 0xda, 0x97, 0x93, 0x2f, 0xd6, 0x55, 0x25, 0x4a, 0xa0, 0xfc, 0x0e,
		0xf3, 0xcc, 0x67, 0x97, 0xd9, 0xf2, 0x75, 0x60, 0x26, 0x0d, 0x88, 0x96, 0xe8, 0x60, 0x1d, 0xb3,
		0xef, 0x0e, 0x19, 0x61, 0x80, 0x1c, 0x92, 0x55, 0x64, 0x4a, 0xa8, 0x22, 0x93, 0x28, 0x34, 0xee,
		0x55, 0x15, 0x19, 0x69, 0x18, 0x8c, 0x46, 0xfc, 0xd9, 0xf7, 0x5d, 0x66, 0xca, 0x64, 0x50, 0xd1,
		0x22, 0x40, 0x39, 0x05, 0x3e, 0x42, 0xea, 0x90, 0x98, 0xa8, 0x13, 0x24, 0x4e, 0x83, 0x81, 0x79,
		0xc3, 0xbc, 0xb3, 0x60, 0xde, 0x66, 0xc8, 0x8c, 0x88, 0x2a, 0x8c, 0x80, 0x75, 0x54, 0x2c, 0xfd,
		0x54, 0xe2, 0xda, 0x46, 0xc4, 0x3e, 0x96, 0xe1, 0x74, 0x3e, 0xcd, 0xc0, 0xce, 0xc2, 0x2f, 0xc6,
		0x7f, 0x1f, 0xda, 0x22, 0x6a, 0x53, 0xae, 0x65, 0xc2, 0x04, 0xea, 0x52, 0x0a, 0xd4, 0xd6, 0x8d,
		0x51, 0x93, 0xf2, 0x40, 0xa1, 0xaf, 0x27, 0xb5, 0x71, 0x63, 0x38, 0x68, 0xb1, 0x6a, 0xb8, 0x52,
		0xd5, 0x6f, 0xa5, 0xaa, 0xdd, 0x8a, 0x55, 0xb7, 0xdd, 0xd6, 0x1f, 0x82, 0x73, 0x4e, 0x7a, 0xae,
		0x15, 0x63, 0x55, 0x12, 0x95, 0x99, 0x5d, 0x9b, 0xe7, 0xd5, 0xfa, 0xd9, 0xb2, 0xfa, 0x5f, 0xd6,
		0xf4, 0x57, 0xdc, 0x7e, 0x12, 0xec, 0x9f, 0x0d, 0xbd, 0x22, 0xd4, 0x1b, 0xab, 0xfb, 0x60, 0xf9,
		0x09, 0x57, 0x3c, 0xdd, 0x96, 0xfa, 0xad, 0xb1, 0xea, 0xb5, 0x6e, 0x29, 0x70, 0xb9, 0xb5, 0x1e,
		0x6b, 0x1c, 0x16, 0x11, 0x60, 0x8e, 0xb8, 0x6c, 0x21, 0xcc, 0x10, 0xc2, 0xac, 0x20, 0xc6, 0x04,
		0x62, 0x33, 0x72, 0x5b, 0xc1, 0xc7, 0xa2, 0xf5, 0x6a, 0x86, 0xa1, 0x13, 0x1a, 0xce, 0xf6, 0x4c,
		0x77, 0x2a, 0xe1, 0x4e, 0xaf, 0xd9, 0xe6, 0x48, 0x63, 0xe1, 0x6a, 0x6c, 0x3c, 0x15, 0xc1, 0x51,
		0x09, 0xfc, 0x14, 0xc5, 0x4d, 0x69, 0xbc, 0x94, 0xc6, 0x49, 0x39, 0x7c, 0x54, 0x0b, 0x86, 0xb1,
		0x71, 0x50, 0xfc, 0x30, 0xbd, 0xe9, 0x8e, 0x2e, 0x59, 0xf7, 0xfc, 0x21, 0xce, 0xcc, 0x1e, 0x9d,
		0x4f, 0x2f, 0x31, 0xbd, 0xe3, 0x1c, 0x6c, 0x8f, 0x39, 0xbe, 0x97, 0x73, 0x5c, 0x6c, 0x92, 0xcc,
		0x4d, 0xf6, 0x6a, 0x8c, 0xcf, 0xd6, 0xbd, 0x7e, 0x77, 0x70, 0x43, 0x3f, 0x75, 0x18, 0x46, 0xdc,
		0x12, 0xd7, 0xa2, 0x25, 0xad, 0x63, 0x96, 0xb0, 0x86, 0x29, 0xa4, 0xd9, 0x14, 0xe2, 0x96, 0x88,
		0x2e, 0x32, 0x8f, 0x07, 0x0e, 0x0b, 0x0d, 0xf3, 0x85, 0xd9, 0x42, 0x6f, 0xfb, 0xcd, 0x28, 0xe4,
		0x0b, 0x2d, 0x88, 0x15, 0xfa, 0x2f, 0x89, 0x16, 0xfa, 0x2f, 0xa1, 0xd0, 0x3f, 0xa9, 0xa8, 0x95,
		0xa6, 0x42, 0xff, 0xc2, 0xa2, 0x95, 0xd2, 0x86, 0x04, 0x89, 0x0d, 0x08, 0x92, 0x1b, 0x0e, 0xe4,
		0x8e, 0xd8, 0x51, 0x50, 0x4c, 0xd5, 0x36, 0x27, 0x29, 0x6e, 0x18, 0xa0, 0x58, 0x8a, 0xfe, 0x29,
		0x77, 0xa0, 0xd0, 0xce, 0xbb, 0x8c, 0x6e, 0x81, 0x9f, 0xa4, 0x17, 0x35, 0x89, 0xa1, 0x4f, 0x09,
		0x1e, 0x3a, 0x23, 0x77, 0x68, 0x81, 0xd2, 0x21, 0x05, 0x88, 0x4d, 0x88, 0x4d, 0x88, 0x4d, 0x88,
		0x4d, 0x88, 0x4d, 0x88, 0x4d, 0x31, 0x62, 0x93, 0x70, 0x11, 0x7b, 0xb5, 0xa2, 0xf5, 0x88, 0x4e,
		0x88, 0x4e, 0x88, 0x4e, 0x88, 0x4e, 0x88, 0x4e, 0x88, 0x4e, 0x31, 0xa2, 0x93, 0x7c, 0x5c, 0x42,
		0x44, 0x42, 0x44, 0x42, 0x44, 0x42, 0x44, 0x42, 0x44, 0x42, 0x44, 0xa2, 0x8c, 0x48, 0x52, 0xcb,
		0x4c, 0xa2, 0x45, 0x24, 0x11, 0x93, 0x10, 0x93, 0x10, 0x93, 0x10, 0x93, 0x10, 0x93, 0x10, 0x93,
		0x36, 0x76, 0x83, 0x44, 0x91, 0x41, 0xf9, 0xa2, 0x82, 0x88, 0x4a, 0x88, 0x4a, 0x84, 0x51, 0x49,
		0xb6, 0x28, 0x9f, 0x4c, 0x11, 0x3e, 0xe9, 0xa2, 0x7b, 0x3b, 0x2a, 0xb2, 0x97, 0xa4, 0x0f, 0xe1,
		0xee, 0x9b, 0x61, 0x5a, 0x16, 0xeb, 0x71, 0x26, 0xb1, 0x44, 0x3d, 0x77, 0x35, 0xfc, 0x08, 0xfc,
		0x08, 0xe8, 0x16, 0x74, 0x0b, 0xba, 0x05, 0xdd, 0x12, 0x45, 0x26, 0xe9, 0xbd, 0x53, 0xe2, 0xe5,
		0x5a, 0x11, 0x97, 0x10, 0x97, 0x10, 0x97, 0x10, 0x97, 0x10, 0x97, 0x10, 0x97, 0xb6, 0xc6, 0x25,
		0xd1, 0x72, 0x9e, 0x0a, 0xe5, 0x3b, 0x11, 0x97, 0x10, 0x97, 0x10, 0x97, 0x10, 0x97, 0x10, 0x97,
		0xf6, 0x39, 0x2e, 0xa5, 0xae, 0x7c, 0x8a, 0x70, 0xa5, 0xc6, 0x18, 0xa5, 0x42, 0x44, 0x8a, 0x30,
		0xca, 0xbd, 0x7a, 0x1c, 0xb7, 0xa8, 0xa2, 0x60, 0x11, 0x45, 0xc1, 0xa2, 0x89, 0x78, 0x65, 0x9f,
		0x38, 0x44, 0x67, 0xe3, 0x95, 0xfd, 0xf8, 0x45, 0x07, 0x63, 0x16, 0x19, 0x94, 0xb3, 0x81, 0x57,
		0xe6, 0xba, 0xfe, 0x70, 0xd9, 0x25, 0x88, 0x6f, 0x07, 0xb3, 0x17, 0x61, 0x72, 0x63, 0x72, 0x2f,
		0xf5, 0x78, 0xdf, 0xf1, 0x78, 0x2c, 0xa8, 0x14, 0x80, 0x49, 0x41, 0x88, 0x14, 0xa0, 0x61, 0x19,
		0x68, 0x94, 0xad, 0x7d, 0x29, 0x09, 0x89, 0x2a, 0x58, 0x23, 0x52, 0x43, 0x54, 0x06, 0x06, 0x55,
		0xbb, 0x42, 0x1d, 0xfe, 0x94, 0x7a, 0x87, 0x08, 0xca, 0x9e, 0x34, 0x38, 0xe7, 0xb0, 0xdf, 0xeb,
		0x05, 0x2c, 0x0c, 0x8d, 0xe1, 0xca, 0xaa, 0xfd, 0xc6, 0x02, 0xee, 0x84, 0x6c, 0x6c, 0xfd, 0x31,
		0x7d, 0xf5, 0x86, 0x36, 0xe0, 0xba, 0xe1, 0xba, 0x97, 0x7a, 0xdc, 0xb1, 0x99, 0xc7, 0x1d, 0xfe,
		0x1e, 0xaf, 0x4c, 0x6a, 0xc4, 0x26, 0x31, 0x2c, 0xb6, 0x78, 0x3d, 0x6e, 0xfa, 0xc2, 0x0c, 0x99,
		0xb8, 0x58, 0x76, 0x73, 0x73, 0xd5, 0x68, 0xb7, 0x6e, 0xfe, 0x19, 0x77, 0x98, 0x86, 0xee, 0x25,
		0x14, 0x12, 0x1d, 0x24, 0x4b, 0x27, 0x37, 0xee, 0x1f, 0x5a, 0xed, 0xab, 0x7a, 0xf3, 0xf2, 0xe1,
		0xba, 0xd1, 0xba, 0xbe, 0xbf, 0x2b, 0xea, 0x70, 0xcd, 0x92, 0xf7, 0xd6, 0xfc, 0xa3, 0xd9, 0xaa,
		0xdf, 0xb6, 0x2f, 0x6b, 0x8d, 0xda, 0xc5, 0xf5, 0xcd, 0x75, 0xeb, 0xba, 0xde, 0x4c, 0xe1, 0xed,
		0xa5, 0xb4, 0xf3, 0x2e, 0xbf, 0xd6, 0x9a, 0xcd, 0xeb, 0x66, 0xfb, 0xfa, 0x2a, 0x4d, 0x77, 0x75,
		0x5b, 0xbb, 0xab, 0x7d, 0xa9, 0xdf, 0xd6, 0xef, 0x5a, 0xed, 0xda, 0xd5, 0xd5, 0x43, 0xbd, 0x99,
		0xaa, 0x11, 0x1d, 0x1a, 0x43, 0xba, 0x3a, 0x6c, 0x3c, 0xc9, 0xee, 0x6a, 0xb7, 0x75, 0x6a, 0x89,
		0xf6, 0x49, 0xb3, 0xff, 0xce, 0x47, 0x41, 0x5f, 0x39, 0xf8, 0x79, 0x0f, 0x39, 0xeb, 0x1a, 0x36,
		0x0b, 0xad, 0xc0, 0xe9, 0xc5, 0xd2, 0xab, 0xa6, 0xd0, 0xb3, 0x7c, 0x2d, 0x60, 0x07, 0xb0, 0xb3,
		0x3c, 0x4f, 0xc4, 0x6b, 0x83, 0xc6, 0xf8, 0xec, 0x0d, 0xf3, 0x5e, 0x86, 0x6a, 0x29, 0x32, 0xd5,
		0x7c, 0x65, 0xaa, 0x95, 0x63, 0x24, 0xa6, 0xb3, 0xbe, 0x39, 0xd6, 0x89, 0x23, 0x8b, 0x4e, 0x39,
		0x4e, 0x1d, 0x7b, 0x78, 0x63, 0x78, 0x63, 0x78, 0x63, 0x78, 0x63, 0x78, 0xe3, 0xcd, 0xff, 0x92,
		0xc4, 0xd1, 0x0f, 0xdb, 0x4e, 0x5c, 0x89, 0xbb, 0x94, 0x1b, 0xfb, 0xc0, 0x87, 0x83, 0x0d, 0x4f,
		0xb8, 0xed, 0xc9, 0xe2, 0x3c, 0x51, 0x71, 0xe5, 0x89, 0x12, 0x5b, 0x9e, 0x61, 0xfe, 0xee, 0xa7,
		0xf7, 0x38, 0x73, 0x7f, 0x45, 0xce, 0x82, 0xae, 0xe3, 0x99, 0xae, 0x61, 0xb3, 0x37, 0x67, 0x45,
		0x3c, 0x98, 0xee, 0xfb, 0x5a, 0xf8, 0xe0, 0xc2, 0x33, 0xae, 0x2e, 0x5c, 0xbd, 0x36, 0xda, 0x6d,
		0x8a, 0x6e, 0xb3, 0xd1, 0xcc, 0xef, 0x71, 0x63, 0xf0, 0xcd, 0xab, 0x9e, 0x7f, 0x4b, 0x04, 0x8b,
		0x1d, 0xb1, 0x62, 0x47, 0xa8, 0xc5, 0x88, 0x14, 0xdd, 0x9c, 0xe0, 0x7c, 0x58, 0x57, 0x20, 0xba,
		0x68, 0x4d, 0x7a, 0x6b, 0xcb, 0x21, 0x21, 0xe3, 0xcf, 0x29, 0x9e, 0x12, 0x52, 0xa2, 0x39, 0x25,
		0x64, 0xc3, 0x10, 0x89, 0xc2, 0x46, 0xf2, 0x27, 0x85, 0xac, 0x1f, 0xc2, 0x5d, 0x39, 0xb1, 0x05,
		0x3b, 0x3b, 0x5c, 0xfc, 0xfb, 0xc6, 0xb1, 0xdf, 0xe8, 0x17, 0x5a, 0xe3, 0x96, 0xae, 0x86, 0x0d,
		0xb5, 0x17, 0xfe, 0x3a, 0x9e, 0x16, 0x0a, 0x27, 0xdc, 0xb8, 0xfe, 0x8b, 0x63, 0x99, 0xae, 0x61,
		0xbd, 0x9a, 0x9e, 0xc7, 0xdc, 0x70, 0xfb, 0x3c, 0x5e, 0xba, 0x02, 0x33, 0x3a, 0x75, 0x33, 0x3a,
		0xce, 0xf9, 0x37, 0x83, 0xc1, 0x13, 0x3a, 0x1d, 0x64, 0x78, 0x41, 0x36, 0x8e, 0x42, 0x88, 0x31,
		0x19, 0xb2, 0x9b, 0x53, 0x6d, 0x9f, 0x2c, 0x34, 0x79, 0x55, 0xec, 0x23, 0x11, 0xb6, 0x44, 0x40,
		0xb9, 0x88, 0x28, 0x39, 0xb5, 0x84, 0xa7, 0x98, 0xcc, 0x54, 0x53, 0x9c, 0x72, 0xb2, 0x53, 0x4f,
		0x79, 0x0a, 0x2a, 0x4f, 0x45, 0xf5, 0x29, 0x29, 0x98, 0xe6, 0xc4, 0x1c, 0xbb, 0xb8, 0x53, 0x35,
		0xba, 0xc0, 0xb4, 0xbb, 0x8e, 0x67, 0x6c, 0x3e, 0xde, 0x6d, 0xeb, 0xa8, 0xcf, 0x36, 0xb2, 0x1f,
		0x07, 0xda, 0x4a, 0x4c, 0x72, 0xd5, 0xc9, 0x4e, 0x36, 0xe9, 0xc9, 0x26, 0x3f, 0x9d, 0x11, 0x88,
		0x19, 0x83, 0x84, 0x5c, 0x52, 0xa0, 0x39, 0xd8, 0x76, 0x66, 0xa2, 0xc7, 0x3d, 0xf6, 0x69, 0xad,
		0xfb, 0xae, 0x4a, 0x5c, 0x1b, 0xef, 0x58, 0x28, 0xf9, 0x5e, 0x15, 0x11, 0xa0, 0x44, 0x96, 0x09,
		0xd7, 0x76, 0x68, 0xfc, 0xf5, 0x42, 0x78, 0x0e, 0x78, 0x8e, 0x0c, 0x7b, 0x8e, 0xd8, 0x4a, 0xfb,
		0x7a, 0xe5, 0x3d, 0x05, 0x36, 0xef, 0x78, 0x36, 0xfb, 0x21, 0x6f, 0xed, 0xa3, 0xcb, 0x61, 0xe7,
		0xb0, 0xf3, 0xdc, 0xda, 0x79, 0xdf, 0xf1, 0xf8, 0x51, 0x45, 0xc1, 0xce, 0x65, 0x4e, 0xbb, 0x97,
		0x7b, 0xd9, 0x73, 0xf2, 0x9f, 0xdc, 0x24, 0x2b, 0xa8, 0xbe, 0xfc, 0xa9, 0x68, 0xe0, 0x4b, 0xcd,
		0x28, 0xbe, 0x0c, 0x1a, 0xb5, 0x43, 0xf0, 0x3a, 0xa3, 0xe4, 0xf4, 0x9b, 0xef, 0x5a, 0x85, 0x97,
		0x44, 0x75, 0x75, 0x6d, 0xb5, 0x72, 0x5e, 0x3d, 0x3f, 0x39, 0xad, 0x9c, 0x1f, 0xa7, 0xa8, 0x8f,
		0x0f, 0x92, 0xb9, 0xea, 0x29, 0x05, 0xe1, 0x77, 0x41, 0x71, 0x8e, 0x77, 0xae, 0xf1, 0x5a, 0x57,
		0xb5, 0xb2, 0x35, 0x04, 0x67, 0x04, 0xe7, 0xdc, 0x06, 0x67, 0xb1, 0x37, 0x2d, 0xd6, 0x92, 0xb8,
		0x84, 0xf7, 0x93, 0x7b, 0x13, 0x63, 0xed, 0x83, 0xdc, 0xdc, 0x7f, 0xb9, 0xbe, 0xac, 0xdd, 0xb4,
		0xeb, 0x37, 0xa3, 0x5d, 0xe9, 0x8d, 0x87, 0xfb, 0xd6, 0xfd, 0xe5, 0xfd, 0x4d, 0xbb, 0xf5, 0x47,
		0xa3, 0x5e, 0x54, 0x29, 0x0d, 0x10, 0x4a, 0x63, 0x84, 0x1a, 0x4a, 0xcc, 0x3d, 0xde, 0xe0, 0x71,
		0xda, 0xf7, 0xad, 0xbb, 0xe2, 0x2e, 0x22, 0x2f, 0xe5, 0x33, 0xd4, 0x5b, 0x5f, 0xeb, 0x0f, 0x77,
		0xf5, 0x56, 0x31, 0xe1, 0xf0, 0xf6, 0x94, 0x9a, 0x0a, 0x0c, 0x62, 0xe1, 0xcd, 0xef, 0x3d, 0x9b,
		0xd6, 0x77, 0xa3, 0xeb, 0xdb, 0x4a, 0x71, 0x6d, 0xb6, 0x19, 0x04, 0x34, 0x04, 0xb4, 0xdc, 0x06,
		0xb4, 0xb9, 0xa9, 0xbe, 0x5b, 0x45, 0x5a, 0xe2, 0xda, 0x99, 0xaa, 0x1d, 0x77, 0xf7, 0x77, 0xf5,
		0x62, 0x0a, 0x5c, 0x50, 0x60, 0x72, 0x66, 0x58, 0xae, 0x19, 0x86, 0xf2, 0xfe, 0x67, 0xa6, 0x0d,
		0x38, 0x1f, 0x38, 0x1f, 0xd0, 0x74, 0xda, 0x69, 0xba, 0xf5, 0x70, 0x7d, 0xf1, 0xad, 0x55, 0x7b,
		0xf8, 0xa3, 0xfd, 0x50, 0x6b, 0xd5, 0xdb, 0x97, 0x37, 0xb5, 0x66, 0x33, 0x27, 0x24, 0x3d, 0x78,
		0xb4, 0xd1, 0x53, 0x1d, 0x97, 0x4a, 0x5f, 0xb2, 0xcc, 0xd3, 0xd3, 0x27, 0x39, 0xcb, 0xcd, 0x93,
		0x94, 0xcb, 0xb9, 0x79, 0x94, 0x6a, 0x5e, 0x1e, 0xe4, 0x24, 0x47, 0x43, 0x92, 0x1b, 0x3b, 0xc9,
		0xd1, 0x93, 0xe4, 0xe5, 0x41, 0x72, 0xf2, 0x1c, 0x95, 0x8f, 0xc7, 0x79, 0x79, 0x92, 0xdc, 0x18,
		0xc9, 0x79, 0x6e, 0x9e, 0xa4, 0x72, 0x9c, 0x1b, 0x7b, 0xcf, 0xcd, 0x93, 0x9c, 0xe6, 0x29, 0x2c,
		0xe6, 0xe5, 0x51, 0x8e, 0xd4, 0x9e, 0x64, 0x8f, 0x44, 0x72, 0xce, 0x42, 0x6e, 0x84, 0xce, 0x8b,
		0x67, 0xba, 0xf2, 0x12, 0xd5, 0x6c, 0x23, 0xd0, 0xa8, 0xa0, 0x51, 0xe5, 0x56, 0xa3, 0x8a, 0x5f,
		0xf3, 0x77, 0xad, 0x3e, 0x55, 0x4e, 0x83, 0xd1, 0x07, 0xce, 0xb3, 0xd1, 0x0b, 0x7c, 0xee, 0x5b,
		0xbe, 0x8a, 0xd9, 0xcf, 0x35, 0x03, 0xc3, 0x87, 0xe1, 0x43, 0x9c, 0xde, 0x6c, 0xfc, 0x69, 0x12,
		0xa7, 0xf3, 0xb8, 0xc9, 0xa3, 0xfc, 0xa5, 0x9e, 0xf9, 0x4d, 0x1e, 0xf7, 0xad, 0x6f, 0xd5, 0xec,
		0x3f, 0xc4, 0xd5, 0xb7, 0xa3, 0xcc, 0x3f, 0x44, 0xb3, 0x75, 0x5b, 0x39, 0x3e, 0xc9, 0xfe, 0x58,
		0x5c, 0x9e, 0x9e, 0x9c, 0xe5, 0xe0, 0x29, 0xaa, 0x67, 0x79, 0xb0, 0xed, 0x4a, 0xf6, 0x3d, 0x54,
		0xb9, 0xf4, 0xa5, 0xde, 0xbe, 0xa9, 0xdd, 0xe5, 0x61, 0x38, 0x8e, 0xf2, 0xe0, 0x6a, 0x73, 0x31,
		0xa7, 0x4a, 0x39, 0x88, 0xdd, 0xcd, 0xd6, 0x6d, 0xf9, 0x24, 0x17, 0x63, 0xd1, 0xbe, 0xbd, 0xf9,
		0x92, 0x07, 0xd3, 0xb8, 0xbc, 0xcb, 0x87, 0xbb, 0xfd, 0x3d, 0x1f, 0xee, 0xb6, 0x9c, 0x0b, 0x3e,
		0xaf, 0xe4, 0xe1, 0x21, 0x72, 0x60, 0x19, 0x83, 0xd0, 0x97, 0x87, 0x98, 0x71, 0x92, 0xfd, 0x84,
		0xaf, 0x9a, 0x87, 0xf0, 0x7d, 0x7f, 0x95, 0x87, 0xd4, 0xfb, 0xb2, 0x7c, 0x5e, 0xd9, 0xe3, 0xc5,
		0x2f, 0xd2, 0x02, 0x48, 0x82, 0x67, 0x6d, 0x46, 0xd7, 0xc9, 0x97, 0x34, 0x5c, 0x2c, 0x03, 0x78,
		0x38, 0xfe, 0xe1, 0x50, 0xa8, 0xaa, 0x57, 0x41, 0xbe, 0xf6, 0xe1, 0xcd, 0xe8, 0x06, 0x2e, 0xc7,
		0xdf, 0xdf, 0x1e, 0xff, 0xb0, 0xb1, 0x26, 0xa2, 0xf8, 0x20, 0xc4, 0x39, 0x9a, 0x9b, 0xf1, 0x57,
		0x16, 0x78, 0x8c, 0x8b, 0x57, 0x40, 0x8b, 0xae, 0x44, 0x0d, 0x34, 0xd4, 0x40, 0x53, 0x74, 0x01,
		0xc2, 0x35, 0xd0, 0x04, 0xcb, 0xf6, 0x2d, 0x0d, 0xb8, 0xb0, 0xa1, 0x4b, 0x4c, 0x61, 0xe9, 0xa9,
		0xac, 0x32, 0xa5, 0x89, 0xa6, 0xb6, 0xea, 0x14, 0x27, 0x9b, 0xea, 0x64, 0x53, 0x9e, 0x6e, 0xea,
		0x4b, 0x46, 0x57, 0xc1, 0xb1, 0x17, 0x35, 0x89, 0xe8, 0x42, 0xd3, 0x0d, 0x0d, 0x9b, 0xb9, 0xe6,
		0xbb, 0xfa, 0x42, 0xd6, 0xb4, 0x29, 0xc9, 0xbe, 0x9e, 0x79, 0x5d, 0xac, 0x24, 0xdb, 0x86, 0xe2,
		0xe9, 0xe9, 0xb2, 0xc6, 0x47, 0x61, 0x84, 0xc4, 0xc6, 0x48, 0x65, 0x94, 0xe4, 0xc6, 0x49, 0x6e,
		0xa4, 0xf4, 0xc6, 0xaa, 0x86, 0xde, 0x92, 0x69, 0x87, 0xfc, 0xa2, 0xf8, 0xd2, 0xcc, 0x91, 0x2e,
		0x52, 0xb4, 0x68, 0x47, 0xa7, 0x0a, 0x4d, 0xa8, 0x15, 0x2d, 0xa2, 0x49, 0xc4, 0x0a, 0x54, 0x45,
		0x8c, 0x88, 0x1c, 0xcc, 0x52, 0x73, 0x44, 0x45, 0x8d, 0xa2, 0xf6, 0x08, 0x0b, 0xef, 0x10, 0x64,
		0xd1, 0xd3, 0x21, 0x20, 0x28, 0x76, 0xa4, 0x7b, 0x08, 0xa8, 0x8a, 0x1f, 0x69, 0x1d, 0x8b, 0x83,
		0xdd, 0x5c, 0xfd, 0x94, 0x50, 0x11, 0x26, 0x99, 0xb7, 0xcc, 0x2d, 0xd7, 0x61, 0x1e, 0x37, 0x4c,
		0x37, 0x54, 0x67, 0x98, 0x99, 0xb6, 0xd4, 0x21, 0x26, 0x2a, 0x0e, 0x02, 0x96, 0x01, 0xcb, 0x80,
		0x65, 0x24, 0x67, 0x0e, 0xf3, 0xfa, 0x5d, 0x16, 0x98, 0x12, 0x15, 0x84, 0x57, 0x66, 0xe3, 0x55,
		0x85, 0x36, 0xe4, 0xaa, 0x33, 0x2b, 0x78, 0x43, 0xad, 0x39, 0xa3, 0xa4, 0x92, 0xaa, 0x53, 0x51,
		0x9d, 0xa8, 0x84, 0x87, 0x52, 0x8a, 0x8b, 0x06, 0x89, 0xb5, 0x3e, 0xbe, 0x21, 0x21, 0xad, 0x55,
		0x7c, 0xf8, 0x84, 0x8a, 0x28, 0xb9, 0x76, 0x4f, 0xa1, 0x76, 0x52, 0xbc, 0xf3, 0x17, 0x21, 0x64,
		0x41, 0xc8, 0xca, 0x96, 0x90, 0x25, 0xa9, 0xf1, 0x2e, 0x13, 0xa0, 0xac, 0xe7, 0x51, 0x30, 0x15,
		0x20, 0x1b, 0x90, 0x6d, 0xf7, 0xc8, 0x26, 0x6b, 0x7a, 0x51, 0x03, 0xcc, 0x33, 0x9f, 0x5d, 0x66,
		0xab, 0x0f, 0xf5, 0x14, 0xfd, 0x46, 0x0d, 0x2a, 0x8e, 0xcb, 0x4c, 0x4a, 0xd6, 0x31, 0xdd, 0x90,
		0xa9, 0xb6, 0x47, 0x54, 0x74, 0x59, 0xd5, 0xd8, 0x29, 0x8d, 0x5e, 0x93, 0xf1, 0x53, 0x3b, 0x01,
		0x6d, 0xce, 0x40, 0x9b, 0x53, 0xd0, 0xe7, 0x1c, 0x88, 0x24, 0x21, 0xc5, 0xb9, 0xa7, 0x9c, 0xe7,
		0x2d, 0xcd, 0x3c, 0xf9, 0x37, 0x3a, 0xd7, 0x46, 0xe3, 0xf2, 0x8e, 0x54, 0x33, 0x95, 0xf2, 0xf0,
		0xa1, 0xe7, 0xfb, 0x3d, 0xc7, 0x7b, 0xa1, 0xf3, 0xa6, 0x51, 0x8b, 0x70, 0xa7, 0x70, 0xa7, 0x70,
		0xa7, 0x70, 0xa7, 0x99, 0x73, 0xa7, 0x89, 0xe2, 0xb0, 0xa2, 0x3c, 0x96, 0x88, 0x4c, 0x36, 0x3c,
		0x80, 0x5d, 0x29, 0x63, 0xd5, 0xa9, 0x99, 0x0d, 0x4f, 0x7a, 0x97, 0x11, 0xce, 0x14, 0x14, 0x53,
		0x09, 0xad, 0xc7, 0x63, 0xce, 0xcb, 0xeb, 0xb3, 0x1f, 0x10, 0x2c, 0x1f, 0x4d, 0x9b, 0xda, 0xb1,
		0x7e, 0x50, 0x81, 0x7e, 0x00, 0xfd, 0x20, 0x6b, 0xfa, 0xc1, 0xc4, 0x7a, 0xe8, 0x90, 0x37, 0x6a,
		0x91, 0x06, 0x51, 0xcb, 0x40, 0x54, 0x20, 0xea, 0xbe, 0x23, 0xaa, 0xaa, 0x99, 0x47, 0x0d, 0x29,
		0x2a, 0xf6, 0x6b, 0x27, 0xb2, 0x32, 0x0f, 0x69, 0x30, 0x7d, 0x72, 0x17, 0xa0, 0xc3, 0x15, 0x68,
		0x76, 0x09, 0xba, 0x5c, 0x83, 0x76, 0x17, 0xa1, 0xdd, 0x55, 0xe8, 0x77, 0x19, 0x34, 0xae, 0x83,
		0xc8, 0x85, 0x50, 0xa7, 0x58, 0xc9, 0xa7, 0x5c, 0x11, 0xe7, 0x47, 0x3f, 0x1d, 0x92, 0x7a, 0x1d,
		0xed, 0x59, 0xd9, 0xdd, 0xe4, 0x01, 0xa2, 0x9f, 0x94, 0x12, 0x35, 0xfa, 0x69, 0x46, 0xb1, 0xe9,
		0xd4, 0xea, 0x87, 0xdc, 0xef, 0x1a, 0xdc, 0x7d, 0x0b, 0x35, 0x44, 0x99, 0x99, 0xc6, 0x53, 0x1e,
		0x6a, 0x2a, 0xd9, 0x08, 0x35, 0x12, 0x5b, 0x53, 0x10, 0x66, 0x28, 0xc2, 0xcc, 0xb0, 0xe3, 0x73,
		0x1a, 0x62, 0xa8, 0x68, 0x35, 0x6a, 0x90, 0xbb, 0x6f, 0xf4, 0x53, 0x2a, 0xaa, 0xdf, 0xe9, 0xbe,
		0x51, 0x4f, 0x26, 0x5a, 0xa7, 0xa2, 0x8d, 0x63, 0x75, 0x3a, 0x99, 0x04, 0x9c, 0x8d, 0x6e, 0xa7,
		0x93, 0x98, 0xf3, 0x49, 0xcc, 0x09, 0x25, 0xe3, 0x8c, 0x68, 0x9d, 0x12, 0xb1, 0x73, 0xd2, 0xe6,
		0xa4, 0x74, 0xa5, 0xd8, 0xc9, 0xa4, 0xdc, 0x09, 0xb9, 0x30, 0xed, 0xae, 0x2c, 0x09, 0x97, 0x96,
		0xa0, 0x6b, 0x4b, 0xca, 0xc5, 0x25, 0xee, 0xea, 0x12, 0x77, 0x79, 0xc9, 0xba, 0x3e, 0x3d, 0x2e,
		0x50, 0x93, 0x2b, 0xd4, 0x2d, 0x0d, 0xa4, 0x43, 0x2a, 0x98, 0xa6, 0x8e, 0x87, 0xdc, 0x7d, 0x3b,
		0xd4, 0xea, 0x3d, 0x77, 0x22, 0x25, 0x0c, 0x1f, 0xb0, 0xe5, 0xbe, 0x85, 0xed, 0x96, 0xfb, 0x46,
		0xaa, 0x2c, 0xe8, 0x9f, 0xd5, 0x1a, 0x66, 0x74, 0xd1, 0xef, 0x3b, 0xfa, 0x83, 0xf0, 0xe0, 0x4b,
		0xf4, 0x46, 0xe0, 0x12, 0x22, 0x30, 0x22, 0x30, 0x22, 0xf0, 0x7e, 0x44, 0x60, 0xb2, 0xad, 0x68,
		0x5b, 0x2d, 0xc6, 0x65, 0x66, 0x47, 0xee, 0x18, 0x07, 0xe1, 0x14, 0xe2, 0x54, 0xe3, 0x77, 0x34,
		0xc6, 0x10, 0xf1, 0xf1, 0xe3, 0x61, 0xc8, 0x4d, 0xce, 0x0e, 0x07, 0x0e, 0x79, 0xbf, 0x83, 0x9e,
		0x11, 0xf6, 0x9f, 0xb9, 0xce, 0x79, 0x34, 0x1b, 0xfc, 0xa2, 0x2f, 0x43, 0x10, 0x44, 0x10, 0x44,
		0x10, 0x44, 0x10, 0x44, 0x10, 0x4c, 0x47, 0x10, 0x8c, 0x1c, 0xf3, 0x1e, 0x07, 0xc3, 0x61, 0x67,
		0xe8, 0x0f, 0x83, 0xa3, 0xaf, 0xc9, 0xb8, 0x0e, 0x5b, 0x41, 0x00, 0x44, 0x00, 0x44, 0x00, 0x4c,
		0x45, 0x00, 0xd4, 0xb5, 0x34, 0x95, 0x88, 0x34, 0xb6, 0x2a, 0x4b, 0xd0, 0x3d, 0x79, 0xf5, 0x66,
		0x09, 0x89, 0x65, 0x0b, 0x49, 0x3a, 0xcd, 0x1d, 0x38, 0xcf, 0xa4, 0x9d, 0xe8, 0xce, 0x9c, 0xe9,
		0xce, 0x9c, 0xea, 0x6e, 0x9c, 0xab, 0x5e, 0x27, 0xab, 0xd9, 0xd9, 0x26, 0x97, 0x75, 0xac, 0xe0,
		0xc6, 0x40, 0xfd, 0xcd, 0x70, 0x21, 0x88, 0x3c, 0x3b, 0xc8, 0xe6, 0xf8, 0x6b, 0x1c, 0xfb, 0x44,
		0x14, 0xb3, 0x55, 0x31, 0x51, 0xb3, 0x72, 0x86, 0xd8, 0x88, 0xd8, 0x88, 0xd8, 0x88, 0xd8, 0x88,
		0xd8, 0x88, 0xd8, 0x28, 0xdd, 0x37, 0xc9, 0x06, 0x45, 0x44, 0x43, 0x44, 0x43, 0x44, 0x43, 0x44,
		0x43, 0x44, 0xc3, 0x45, 0x8b, 0x53, 0x3d, 0x59, 0x44, 0xd4, 0x3d, 0x1e, 0x25, 0xf0, 0x55, 0x34,
		0x27, 0x95, 0xc4, 0xfd, 0x2f, 0x19, 0xff, 0x51, 0xa0, 0x3e, 0xf9, 0x44, 0x98, 0x62, 0x3e, 0x24,
		0xfb, 0xb5, 0x93, 0x63, 0x3c, 0x2a, 0xe5, 0xea, 0x69, 0xf5, 0xec, 0xe8, 0xa4, 0x7a, 0x96, 0xf0,
		0x0d, 0x68, 0x38, 0xee, 0x23, 0x25, 0x6e, 0x66, 0x7e, 0x4e, 0x99, 0x3f, 0x76, 0x36, 0xa7, 0x4a,
		0xbb, 0x9e, 0x53, 0xa7, 0x7b, 0x34, 0xa7, 0x0e, 0xf2, 0xf1, 0x2d, 0x4f, 0x48, 0xa6, 0x96, 0xa6,
		0xd5, 0xdb, 0x78, 0x5e, 0x27, 0x94, 0x4d, 0x8d, 0xbe, 0x0e, 0xe9, 0x14, 0xd2, 0x29, 0xa4, 0x53,
		0x48, 0xa7, 0x90, 0x4e, 0xcd, 0x96, 0x67, 0x75, 0x3c, 0x33, 0x78, 0x4f, 0x30, 0x9f, 0x3a, 0xcf,
		0x6a, 0x38, 0xc4, 0xeb, 0x8b, 0x2b, 0xbe, 0x27, 0x0d, 0xaf, 0x2f, 0xea, 0xdc, 0x73, 0x58, 0xd8,
		0xfd, 0xdb, 0x8b, 0xcd, 0xe1, 0xe3, 0xed, 0xf1, 0xd6, 0xd5, 0x64, 0x5e, 0xe0, 0xc0, 0x9b, 0x1b,
		0x3b, 0x45, 0x41, 0x6c, 0x5c, 0xcd, 0x20, 0xea, 0x61, 0xe3, 0xea, 0x0e, 0x51, 0x2e, 0xf7, 0x6f,
		0x6e, 0x64, 0xea, 0x95, 0x8d, 0x54, 0xd7, 0xf7, 0xf9, 0x8d, 0xbd, 0x4f, 0x42, 0x5c, 0xc1, 0xef,
		0x3b, 0x05, 0x7d, 0x5b, 0xae, 0x8a, 0x37, 0x4e, 0xc8, 0x6b, 0x9c, 0x6b, 0xaa, 0x27, 0x74, 0xeb,
		0x78, 0x75, 0x97, 0x0d, 0x3c, 0x4e, 0x58, 0xfc, 0x54, 0xf0, 0xfa, 0xae, 0xab, 0x81, 0x37, 0x6e,
		0xcd, 0x1f, 0xfa, 0xbf, 0xe4, 0x3e, 0xb0, 0x59, 0xc0, 0xec, 0x8b, 0xf7, 0xf1, 0x57, 0xa4, 0x7a,
		0xfe, 0x68, 0xce, 0x26, 0xd2, 0x90, 0x45, 0x14, 0xb5, 0xbc, 0x73, 0xb5, 0xc3, 0xbc, 0x81, 0xd6,
		0x73, 0xfe, 0x44, 0x05, 0xe0, 0x2c, 0xcd, 0xe8, 0x2c, 0x97, 0x01, 0x8e, 0x66, 0x71, 0x9e, 0x4a,
		0x01, 0x3b, 0x36, 0x7d, 0x05, 0x60, 0xc7, 0x26, 0x2e, 0xfc, 0x5b, 0x42, 0x8d, 0xf9, 0xb4, 0xe7,
		0x98, 0xa8, 0x31, 0x9f, 0xb5, 0x08, 0x43, 0x9e, 0x07, 0x6a, 0xcc, 0xfb, 0x74, 0xe4, 0x79, 0xcb,
		0x79, 0x9d, 0x63, 0xe7, 0xc9, 0xb3, 0xd3, 0xbe, 0x58, 0xaf, 0xe5, 0x45, 0xfa, 0x7d, 0x2f, 0xec,
		0x0e, 0xff, 0x0e, 0xff, 0xae, 0xcd, 0xbf, 0x93, 0x17, 0x78, 0x37, 0x5f, 0x98, 0xbe, 0x02, 0xef,
		0x83, 0xc6, 0xf5, 0x14, 0x78, 0x2f, 0xa1, 0xc0, 0x3b, 0x0a, 0xbc, 0xa7, 0xc9, 0x11, 0xad, 0x73,
		0x48, 0xfb, 0x58, 0xe0, 0x5d, 0xdb, 0x62, 0x44, 0x34, 0xe3, 0xfb, 0x8e, 0xc7, 0x4f, 0xaa, 0x3a,
		0x26, 0xfc, 0xd8, 0xbf, 0x68, 0xd8, 0x4d, 0xad, 0x79, 0xdf, 0xbd, 0xc6, 0xa5, 0x9f, 0x24, 0xf6,
		0xd5, 0x27, 0xb5, 0xa1, 0x71, 0xb2, 0xc7, 0x59, 0xf7, 0xf7, 0x24, 0xb8, 0x95, 0x59, 0xe7, 0xd6,
		0xd9, 0x24, 0xb6, 0xbf, 0x27, 0x3d, 0xf4, 0xe5, 0xb3, 0x6a, 0xf5, 0xe4, 0xb4, 0x5a, 0x2d, 0x9d,
		0x1e, 0x9d, 0x96, 0xce, 0x8f, 0x8f, 0xcb, 0x27, 0xe5, 0xe3, 0x1c, 0xcd, 0x86, 0x8c, 0xac, 0x61,
		0x3e, 0xa5, 0x75, 0xc5, 0x80, 0x30, 0x6d, 0xb3, 0x5e, 0xcd, 0x30, 0x74, 0x42, 0x83, 0x50, 0x8f,
		0x5d, 0x0a, 0x85, 0x33, 0xdf, 0x01, 0xd4, 0x06, 0x6a, 0x03, 0xb5, 0x81, 0xda, 0xa4, 0x33, 0x5e,
		0x5b, 0x3d, 0x08, 0x4d, 0xf5, 0x1f, 0xd2, 0x1e, 0x09, 0x0c, 0x2d, 0x1b, 0x4c, 0x57, 0x84, 0x03,
		0x43, 0xc7, 0x86, 0x1b, 0xc4, 0x04, 0xc4, 0x04, 0xc4, 0x84, 0x7d, 0x8f, 0x09, 0x7a, 0x9d, 0xcc,
		0x5c, 0x70, 0xa8, 0x6a, 0x68, 0xbb, 0xee, 0xf5, 0xbb, 0x83, 0x0e, 0xfa, 0xb9, 0x07, 0x81, 0x47,
		0x67, 0xea, 0x81, 0x94, 0x03, 0xe1, 0x05, 0xe1, 0x05, 0xe1, 0x05, 0x29, 0x47, 0x1a, 0x3d, 0xbf,
		0x6b, 0x86, 0xdc, 0xe8, 0xf7, 0x6c, 0x1d, 0x27, 0x31, 0x4c, 0x77, 0x05, 0xcd, 0x7c, 0x09, 0x62,
		0x01, 0x62, 0x01, 0x62, 0x01, 0x62, 0x01, 0x2d, 0x63, 0x6a, 0x5e, 0xe8, 0xad, 0x62, 0xa1, 0x77,
		0x7a, 0xe3, 0x49, 0x2e, 0xf4, 0x96, 0x13, 0x5a, 0xed, 0x3b, 0xaf, 0x54, 0x8e, 0x8e, 0x4e, 0x2b,
		0xa5, 0xa3, 0x93, 0xb3, 0xe3, 0xea, 0xe9, 0xe9, 0xf1, 0x59, 0xe9, 0x0c, 0x4b, 0xbf, 0xb1, 0x26,
		0x43, 0x0e, 0x97, 0x7e, 0x97, 0x27, 0xc3, 0x29, 0x56, 0x7e, 0x93, 0x6e, 0x75, 0x1f, 0x56, 0x7e,
		0xbb, 0xa6, 0x67, 0xbe, 0x0c, 0xdf, 0xea, 0x34, 0x4c, 0xdb, 0x0e, 0x58, 0x18, 0xea, 0x63, 0xf0,
		0x15, 0xdf, 0x05, 0x14, 0x07, 0x8a, 0x03, 0xc5, 0x81, 0xe2, 0x90, 0x65, 0x32, 0x10, 0x19, 0x34,
		0xaf, 0x08, 0xaf, 0xfb, 0x42, 0xc4, 0x08, 0xc4, 0x08, 0xc4, 0x08, 0xc4, 0x08, 0xc4, 0x88, 0xd4,
		0xc5, 0x88, 0x9e, 0x1f, 0x70, 0xc3, 0x66, 0xa1, 0x15, 0x38, 0x3d, 0x2d, 0x75, 0x50, 0xa2, 0xf1,
		0x5a, 0xfa, 0x26, 0x44, 0x05, 0x44, 0x05, 0x44, 0x05, 0x44, 0x05, 0x44, 0x85, 0x74, 0x46, 0x05,
		0x9d, 0xfb, 0x79, 0x26, 0x5f, 0x80, 0x18, 0x80, 0x18, 0x80, 0x18, 0x80, 0x18, 0x80, 0x18, 0x90,
		0xd6, 0x18, 0xa0, 0x59, 0x32, 0x9a, 0xfb, 0x16, 0x44, 0x03, 0x44, 0x03, 0x44, 0x03, 0x44, 0x83,
		0xac, 0x78, 0x98, 0x02, 0x5e, 0x1f, 0x20, 0x2c, 0xc7, 0xf9, 0x1e, 0x72, 0xd6, 0x4d, 0x46, 0x8b,
		0x5a, 0xf1, 0x5d, 0x88, 0x3d, 0x88, 0x3d, 0x88, 0x3d, 0x88, 0x3d, 0x59, 0xcb, 0x44, 0x34, 0xb4,
		0x7d, 0xc3, 0xbc, 0x97, 0x61, 0x69, 0x4b, 0xec, 0x2a, 0x4d, 0xce, 0xb5, 0x2f, 0x7d, 0x0d, 0xca,
		0x07, 0x89, 0x0d, 0x7d, 0x0e, 0xf7, 0x90, 0x56, 0x8e, 0x51, 0x2d, 0x28, 0xf1, 0x56, 0x9f, 0xf6,
		0x87, 0xb5, 0xc7, 0xb5, 0xef, 0xf5, 0x42, 0xf6, 0xf0, 0x4b, 0x40, 0xd7, 0xa0, 0x6b, 0xd0, 0x35,
		0xe8, 0x1a, 0x74, 0x0d, 0xba, 0x06, 0x5d, 0x83, 0xae, 0x41, 0xd7, 0xa0, 0xeb, 0xdc, 0xd2, 0x35,
		0xe7, 0xae, 0x3e, 0xaa, 0x1e, 0x34, 0x0e, 0x9a, 0x06, 0x4d, 0x83, 0xa6, 0x41, 0xd3, 0xa4, 0x33,
		0xbe, 0xef, 0x78, 0xbc, 0x7c, 0xa2, 0x91, 0xa6, 0x4f, 0x50, 0xff, 0x00, 0x2c, 0x0d, 0x96, 0xce,
		0x25, 0x4b, 0x9f, 0x1c, 0x1f, 0x1f, 0x81, 0xa6, 0x41, 0xd3, 0xa4, 0x2d, 0xe1, 0x2c, 0xdc, 0xe5,
		0xb3, 0x70, 0x29, 0x8f, 0xcf, 0x2b, 0xec, 0xe0, 0x14, 0xdc, 0xe6, 0xf0, 0xfe, 0xd3, 0x72, 0x4c,
		0xe2, 0xc1, 0x0e, 0xa7, 0xe7, 0xe4, 0xf0, 0x7a, 0xe5, 0xb7, 0x20, 0x68, 0x8f, 0xa6, 0xd7, 0x72,
		0x14, 0xbd, 0x96, 0xa3, 0xe7, 0x69, 0x8f, 0x9a, 0x57, 0x1d, 0x4d, 0x62, 0x27, 0xb3, 0x0b, 0xe7,
		0x52, 0x24, 0x39, 0x35, 0x34, 0x49, 0x77, 0xa2, 0xe6, 0x48, 0xe4, 0xcd, 0x5f, 0xee, 0x4a, 0xc9,
		0x29, 0x46, 0x35, 0xb5, 0x12, 0x9c, 0x52, 0x0a, 0x33, 0x29, 0x99, 0x19, 0x24, 0x37, 0x71, 0xc4,
		0x87, 0x5d, 0x62, 0xc8, 0x15, 0x0f, 0xde, 0x25, 0x39, 0x68, 0x57, 0xb1, 0x72, 0x9e, 0xf2, 0x41,
		0xba, 0x14, 0x12, 0x1f, 0xf1, 0x41, 0xb9, 0x54, 0xb2, 0x1d, 0xb9, 0x3c, 0x47, 0x2e, 0xc3, 0xd1,
		0x1f, 0x74, 0x9b, 0xac, 0xbb, 0x54, 0x3d, 0xb8, 0xb6, 0x68, 0xf9, 0x7d, 0x8f, 0xb3, 0x40, 0xbd,
		0x8e, 0xda, 0xf4, 0x14, 0x83, 0x49, 0x8b, 0xaa, 0xc8, 0x48, 0x52, 0xd0, 0x92, 0x4c, 0x99, 0xa7,
		0x54, 0xe2, 0x35, 0x28, 0xef, 0xd4, 0x4a, 0xbb, 0x36, 0x65, 0x5d, 0x9b, 0x92, 0xae, 0x47, 0x39,
		0xdf, 0x6d, 0xda, 0x44, 0x75, 0x2e, 0x75, 0xb1, 0x13, 0x98, 0x5d, 0x66, 0xd8, 0x4e, 0x68, 0x99,
		0x81, 0x4d, 0x7f, 0xd0, 0xfd, 0x7c, 0xf3, 0xb4, 0x07, 0xde, 0x97, 0xa8, 0x0f, 0xbc, 0x2f, 0x65,
		0xe3, 0xc0, 0x7b, 0xe2, 0x25, 0x39, 0x1c, 0x76, 0x9f, 0xac, 0xe3, 0x48, 0xa7, 0x3c, 0x48, 0xbe,
		0xb4, 0xb6, 0x18, 0xf6, 0x49, 0xab, 0x8a, 0x6b, 0x38, 0x36, 0x5a, 0xd3, 0x2a, 0x9a, 0x86, 0xb5,
		0x4a, 0x9d, 0xab, 0x66, 0x9a, 0x97, 0x4c, 0x74, 0xaf, 0x92, 0x25, 0xb1, 0x3c, 0xa2, 0x61, 0x55,
		0x4c, 0xeb, 0x6a, 0x58, 0x52, 0x43, 0x9a, 0xdc, 0x31, 0xcf, 0x89, 0x8c, 0x72, 0x4a, 0x17, 0x95,
		0x9e, 0xd2, 0xb2, 0x6a, 0xf0, 0x81, 0x8a, 0x3d, 0x59, 0x10, 0xf8, 0x81, 0x41, 0xe8, 0xd3, 0x16,
		0xe0, 0x33, 0x6a, 0x1f, 0xf4, 0x09, 0xfa, 0x04, 0x7d, 0x82, 0x3e, 0x41, 0x9f, 0xa0, 0x4f, 0xd0,
		0x27, 0xe8, 0x13, 0xf4, 0x09, 0xfa, 0x1c, 0xd3, 0xa1, 0xdf, 0xe7, 0x7a, 0xf1, 0x73, 0xf0, 0x05,
		0xe0, 0x4f, 0xf0, 0x27, 0xf8, 0x13, 0xfc, 0x09, 0xfe, 0x04, 0x7f, 0x82, 0x3f, 0xc1, 0x9f, 0xe0,
		0x4f, 0xf0, 0xa7, 0x46, 0xdd, 0x13, 0x8a, 0x27, 0x88, 0x13, 0xc4, 0x09, 0xe2, 0x04, 0x71, 0x82,
		0x38, 0x41, 0x9c, 0x20, 0x4e, 0x10, 0x27, 0x88, 0x73, 0xc0, 0x85, 0x1a, 0xb5, 0x4e, 0xa8, 0x9c,
		0x60, 0x4e, 0x30, 0x27, 0x98, 0x13, 0xcc, 0x09, 0xe6, 0x04, 0x73, 0x82, 0x39, 0xc1, 0x9c, 0x7b,
		0xcf, 0x9c, 0xae, 0x19, 0x72, 0xc3, 0x72, 0x99, 0x19, 0xd0, 0x43, 0xe7, 0x4c, 0xdb, 0xa0, 0x4e,
		0x50, 0x27, 0xa8, 0x73, 0xcf, 0xa8, 0xd3, 0x36, 0x39, 0x33, 0x4c, 0xcf, 0x36, 0xb8, 0x43, 0x5a,
		0x5d, 0x5f, 0x47, 0xe5, 0xeb, 0x62, 0xc3, 0xe4, 0x9c, 0x05, 0x1e, 0x39, 0x7c, 0x16, 0x1f, 0x1f,
		0xed, 0xbf, 0xab, 0x3f, 0x8d, 0xc1, 0x1f, 0x95, 0xc9, 0x1f, 0xad, 0xd1, 0x1f, 0x9f, 0xe6, 0xfe,
		0xf8, 0xe5, 0xf1, 0xf1, 0xe3, 0xe3, 0xa3, 0xfd, 0x8f, 0x5f, 0xff, 0xf3, 0x97, 0x7f, 0xfd, 0xef,
		0x9f, 0x8f, 0x8f, 0xff, 0x78, 0x7c, 0x34, 0x9e, 0xe6, 0x3e, 0xf1, 0x6b, 0x11, 0x31, 0x6c, 0x45,
		0x0f, 0x73, 0xf7, 0x4d, 0xdf, 0x1b, 0xb2, 0xb3, 0x8d, 0x23, 0x8a, 0x21, 0x8a, 0x21, 0x8a, 0x41,
		0x3b, 0x81, 0x76, 0x02, 0xed, 0x04, 0xda, 0x09, 0xb4, 0x13, 0x68, 0x27, 0x7b, 0xcf, 0x9d, 0x7d,
		0xef, 0xbb, 0xe7, 0xff, 0xe5, 0xe9, 0xe1, 0xce, 0x49, 0xe3, 0xe0, 0x4e, 0x70, 0x27, 0xb8, 0x13,
		0xdc, 0x09, 0xee, 0x04, 0x77, 0x82, 0x3b, 0xc1, 0x9d, 0xe0, 0xce, 0xec, 0x72, 0x27, 0xea, 0x7f,
		0x8b, 0x14, 0x6b, 0x1e, 0xd6, 0x07, 0x3e, 0x24, 0xaa, 0x4c, 0x5a, 0xd0, 0x5d, 0xb9, 0x79, 0x78,
		0x6e, 0x40, 0xfb, 0x72, 0x72, 0xb7, 0xbb, 0xaa, 0xfb, 0xad, 0x50, 0x3f, 0x98, 0x79, 0xe6, 0xb3,
		0xcb, 0x6c, 0xba, 0xa2, 0xb2, 0x93, 0x06, 0x55, 0xeb, 0x69, 0xb2, 0x8e, 0xd9, 0x77, 0x87, 0x40,
		0xd9, 0x31, 0xdd, 0x90, 0x11, 0xd5, 0xa8, 0x2d, 0xe5, 0xbc, 0x46, 0x2d, 0x41, 0x49, 0x69, 0x5d,
		0xe9, 0x4e, 0xf6, 0xeb, 0xd4, 0xaa, 0x97, 0x9c, 0x4e, 0x47, 0x50, 0x20, 0x4b, 0x61, 0xa2, 0x99,
		0xf7, 0xec, 0xfb, 0x2e, 0x33, 0x29, 0x74, 0x8b, 0x68, 0xa9, 0xb7, 0x9c, 0x41, 0x67, 0x1a, 0x7a,
		0xbe, 0xdf, 0x73, 0xbc, 0x17, 0x3a, 0x6f, 0x1a, 0xb5, 0x08, 0x77, 0x0a, 0x77, 0x0a, 0x77, 0x0a,
		0x77, 0x9a, 0x39, 0x77, 0x8a, 0x33, 0x69, 0xd6, 0xa6, 0x39, 0x69, 0x3d, 0x8f, 0x46, 0xe1, 0x34,
		0x34, 0x89, 0xb3, 0x68, 0x0e, 0x34, 0x4e, 0x0c, 0xd5, 0x09, 0xa1, 0x7d, 0x22, 0x14, 0xa5, 0x4e,
		0xe2, 0xd1, 0x36, 0xf4, 0x62, 0x83, 0x1e, 0x7f, 0xe8, 0x04, 0x86, 0x4d, 0xf2, 0xa0, 0x21, 0xa5,
		0x03, 0x86, 0x24, 0x4f, 0x30, 0x91, 0x3e, 0x50, 0x48, 0x05, 0x57, 0x88, 0xf0, 0x44, 0x15, 0x47,
		0xc8, 0xf0, 0x83, 0x0c, 0x37, 0xe8, 0xf0, 0x42, 0xaf, 0x4b, 0x92, 0x3d, 0x29, 0xa4, 0x68, 0xba,
		0xa1, 0x61, 0x33, 0xd7, 0x7c, 0x57, 0x3f, 0x85, 0x6b, 0xda, 0x94, 0xec, 0x69, 0x46, 0xd3, 0x7c,
		0xa2, 0xa4, 0x78, 0x9a, 0x57, 0x49, 0xf5, 0x34, 0xaf, 0x12, 0x4e, 0xf3, 0xd2, 0x9d, 0x1b, 0xe0,
		0x34, 0x2f, 0x6a, 0xe6, 0x9f, 0x3b, 0xe0, 0xfe, 0xa8, 0xa2, 0x32, 0x69, 0xc6, 0x76, 0x74, 0xaa,
		0xd0, 0x04, 0xcd, 0x92, 0x2e, 0xcd, 0x31, 0xaf, 0x84, 0x19, 0x32, 0xed, 0xf6, 0x17, 0xe2, 0x25,
		0x59, 0x1d, 0x8b, 0x73, 0x3f, 0x69, 0x0e, 0xc5, 0x4d, 0xfd, 0x10, 0x54, 0x2b, 0xe7, 0xd5, 0xf3,
		0x93, 0xd3, 0xca, 0xf9, 0x71, 0x8a, 0xc7, 0x62, 0x47, 0x19, 0xf7, 0x53, 0x8a, 0x0f, 0x11, 0xb5,
		0x5c, 0x87, 0x79, 0xdc, 0x30, 0xdd, 0x50, 0x9d, 0x61, 0x66, 0xda, 0x52, 0x87, 0x98, 0x7a, 0xeb,
		0x6b, 0xfd, 0xe1, 0xae, 0xde, 0x02, 0xcb, 0x80, 0x65, 0xc0, 0x32, 0xb2, 0x33, 0x87, 0x79, 0xfd,
		0x2e, 0x0b, 0x46, 0x72, 0x8b, 0x3a, 0xd0, 0x94, 0xab, 0x0a, 0x6d, 0xd4, 0xbd, 0x7e, 0x77, 0xf0,
		0x50, 0x3f, 0x53, 0xec, 0x0d, 0x1d, 0xcf, 0x38, 0x2b, 0x55, 0xca, 0xff, 0x63, 0x0c, 0x8b, 0xf5,
		0x10, 0xb8, 0xc4, 0xc5, 0x06, 0xe1, 0xcc, 0x06, 0xf6, 0xc8, 0xf8, 0x2b, 0xfc, 0x98, 0x84, 0x1f,
		0x1b, 0xf4, 0xdb, 0xde, 0xb9, 0x30, 0x8a, 0x4d, 0xb8, 0x04, 0x9b, 0x6e, 0x91, 0x91, 0x21, 0x23,
		0xcb, 0x54, 0x46, 0xa6, 0x6f, 0x53, 0x2b, 0x72, 0xb3, 0xc4, 0x68, 0xe4, 0xd9, 0xf5, 0xad, 0xef,
		0xa3, 0x03, 0x52, 0x68, 0x68, 0x64, 0xae, 0x41, 0xd0, 0x08, 0x68, 0x04, 0x34, 0x02, 0x1a, 0x01,
		0x8d, 0x80, 0x46, 0x40, 0x23, 0xa0, 0x91, 0x6d, 0x34, 0x62, 0x05, 0x16, 0x25, 0x8b, 0xcc, 0x34,
		0x07, 0x12, 0x01, 0x89, 0x80, 0x44, 0x40, 0x22, 0x20, 0x11, 0x90, 0x08, 0x48, 0x04, 0x24, 0xb2,
		0x8d, 0x44, 0x3a, 0x81, 0xf9, 0x32, 0x08, 0x00, 0x94, 0x0b, 0x35, 0x8b, 0x6d, 0x82, 0x49, 0xc0,
		0x24, 0x60, 0x12, 0x30, 0x09, 0x98, 0x04, 0x4c, 0x02, 0x26, 0x01, 0x93, 0x6c, 0x63, 0x92, 0xff,
		0x6b, 0x3e, 0x3f, 0xb3, 0x80, 0x92, 0x48, 0xe6, 0x5b, 0x04, 0x8f, 0x80, 0x47, 0xc0, 0x23, 0xe0,
		0x11, 0xf0, 0x08, 0x78, 0x04, 0x3c, 0x02, 0x1e, 0xd9, 0xc6, 0x23, 0x5d, 0xd3, 0x32, 0x2c, 0xdf,
		0xe3, 0x81, 0xef, 0x52, 0x42, 0xc9, 0x8a, 0x66, 0x41, 0x26, 0x20, 0x13, 0x90, 0x09, 0xc8, 0x04,
		0x64, 0x02, 0x32, 0x01, 0x99, 0x80, 0x4c, 0xe2, 0x90, 0x49, 0xcf, 0xec, 0x87, 0x8c, 0x9a, 0x4b,
		0xe6, 0x1a, 0x05, 0x95, 0x80, 0x4a, 0x40, 0x25, 0xa0, 0x12, 0x50, 0x09, 0xa8, 0x04, 0x54, 0x02,
		0x2a, 0xd9, 0x46, 0x25, 0xfe, 0x1b, 0x0b, 0x42, 0xe7, 0xdf, 0xa4, 0x50, 0xb2, 0xd8, 0x26, 0x98,
		0x04, 0x4c, 0x02, 0x26, 0x01, 0x93, 0x80, 0x49, 0xc0, 0x24, 0x60, 0x12, 0x30, 0xc9, 0x36, 0x26,
		0xe9, 0x59, 0xa1, 0xf1, 0xec, 0xf4, 0x28, 0xdf, 0xba, 0x59, 0x68, 0x12, 0x44, 0x82, 0xf2, 0x4a,
		0x8a, 0x58, 0xb2, 0xbf, 0xe5, 0x95, 0xc0, 0x26, 0x60, 0x13, 0xb0, 0x09, 0xd8, 0x64, 0x6f, 0xd9,
		0x64, 0x08, 0x11, 0xcc, 0x36, 0x42, 0x66, 0xf9, 0x9e, 0x4d, 0x07, 0x28, 0x8b, 0xed, 0x82, 0x52,
		0x40, 0x29, 0xa0, 0x14, 0x50, 0x0a, 0x28, 0x05, 0x94, 0x02, 0x4a, 0x01, 0xa5, 0x88, 0x51, 0x4a,
		0xc8, 0xde, 0x58, 0xc0, 0xdc, 0x77, 0x6d, 0xb8, 0xb2, 0xf6, 0x0b, 0xc0, 0x2d, 0xe0, 0x16, 0x70,
		0x0b, 0xb8, 0x05, 0xdc, 0x02, 0x6e, 0x01, 0xb7, 0x80, 0x5b, 0xc4, 0xb8, 0xa5, 0xef, 0x99, 0x6f,
		0xa6, 0xe3, 0x9a, 0xcf, 0x2e, 0x23, 0x47, 0x96, 0x55, 0x6d, 0x83, 0x56, 0x40, 0x2b, 0xa0, 0x15,
		0xd0, 0x0a, 0x68, 0x05, 0xb4, 0x02, 0x5a, 0x01, 0xad, 0xc4, 0xa7, 0x95, 0xbe, 0x67, 0xd3, 0x6f,
		0x9e, 0x5d, 0x6a, 0x14, 0x7c, 0x82, 0xdd, 0xb3, 0xf2, 0x68, 0x82, 0xdd, 0xb3, 0xa0, 0x12, 0x50,
		0x09, 0xa8, 0x04, 0x54, 0xb2, 0x17, 0x54, 0xe2, 0xf7, 0x39, 0xf1, 0x61, 0x7e, 0x4b, 0x2d, 0x82,
		0x47, 0xc0, 0x23, 0xe0, 0x11, 0xf0, 0x08, 0x78, 0x04, 0x3c, 0x02, 0x1e, 0x01, 0x8f, 0x6c, 0xe5,
		0x11, 0xda, 0xe3, 0xfc, 0x96, 0x5a, 0x04, 0x8f, 0x60, 0xfd, 0x46, 0x11, 0x4a, 0xb0, 0x7e, 0x03,
		0x32, 0x01, 0x99, 0x80, 0x4c, 0x40, 0x26, 0xfb, 0x45, 0x26, 0x94, 0x47, 0xfb, 0x2d, 0xb4, 0x07,
		0x2a, 0x01, 0x95, 0x80, 0x4a, 0x40, 0x25, 0xa0, 0x12, 0x50, 0x09, 0xa8, 0x04, 0x54, 0x22, 0x40,
		0x25, 0x3a, 0x4a, 0xd8, 0xaf, 0x69, 0x17, 0x94, 0x82, 0xb5, 0x1c, 0x79, 0x40, 0xc1, 0x5a, 0x0e,
		0xd8, 0x04, 0x6c, 0x02, 0x36, 0x01, 0x9b, 0xec, 0x15, 0x9b, 0xd0, 0x16, 0xb1, 0x5f, 0xd9, 0x2a,
		0xb8, 0x04, 0x5c, 0x02, 0x2e, 0x01, 0x97, 0x80, 0x4b, 0xc0, 0x25, 0xe0, 0x12, 0x70, 0xc9, 0x56,
		0x2e, 0xa1, 0x2e, 0x19, 0xbb, 0xa2, 0x4d, 0x30, 0x09, 0x56, 0x74, 0x14, 0xc1, 0x04, 0x2b, 0x3a,
		0xa0, 0x13, 0xd0, 0x09, 0xe8, 0x04, 0x74, 0x92, 0x51, 0x3a, 0x39, 0xd0, 0x38, 0x47, 0x8b, 0x35,
		0xcf, 0xf3, 0xb9, 0x39, 0x18, 0x12, 0xa9, 0x69, 0x59, 0x0c, 0xad, 0x57, 0xd6, 0x35, 0x7b, 0x26,
		0x7f, 0x1d, 0x78, 0xdc, 0x43, 0xbf, 0xc7, 0x3c, 0x6b, 0x48, 0x0f, 0xc3, 0x98, 0xe3, 0x78, 0xa6,
		0x6b, 0xd8, 0xec, 0xcd, 0xb1, 0xd8, 0xe1, 0xe2, 0xdf, 0x5d, 0xff, 0xc5, 0xb1, 0x4c, 0xd7, 0xb0,
		0x5e, 0x4d, 0xcf, 0x63, 0x6e, 0x78, 0x38, 0xfe, 0xe1, 0x90, 0xf1, 0x57, 0x16, 0x78, 0x8c, 0x1f,
		0x86, 0xdc, 0xe4, 0x4c, 0xc2, 0x77, 0x17, 0x43, 0x1e, 0xf4, 0x2d, 0xee, 0x8d, 0xc3, 0xc0, 0x7d,
		0x74, 0x4f, 0xad, 0xf1, 0x2d, 0x5c, 0x0d, 0xef, 0xa0, 0xbd, 0xf0, 0xd7, 0x9b, 0xd1, 0x0d, 0x5d,
		0x8e, 0xef, 0xa7, 0x3d, 0xfe, 0xa1, 0x5d, 0x1f, 0xdf, 0x4f, 0xbb, 0x39, 0xbc, 0x9f, 0x03, 0x3d,
		0x83, 0x17, 0xef, 0x93, 0x31, 0x87, 0x57, 0x76, 0x58, 0x75, 0x0e, 0xa7, 0xc0, 0x40, 0x6a, 0x1a,
		0xc0, 0x78, 0x43, 0xb7, 0x7d, 0x20, 0x62, 0x0c, 0x42, 0xd1, 0xf1, 0x6c, 0x16, 0xdf, 0xd3, 0xcf,
		0xbc, 0x8b, 0x3f, 0xb8, 0x2c, 0xe6, 0x20, 0x8b, 0xb9, 0x7f, 0x61, 0xaa, 0x97, 0xa1, 0x78, 0x45,
		0x6a, 0x97, 0xa5, 0x74, 0x65, 0x2a, 0x57, 0xa6, 0x70, 0x75, 0xea, 0xa6, 0x75, 0x00, 0xc2, 0x14,
		0x1d, 0x8d, 0x9c, 0xcb, 0xcc, 0x4e, 0xc0, 0x3a, 0x22, 0xa3, 0x36, 0x9e, 0x88, 0xe5, 0x53, 0x81,
		0x6b, 0x1a, 0x63, 0x1f, 0xf3, 0xf1, 0xe3, 0xe1, 0xc8, 0xb6, 0x0f, 0x47, 0x73, 0x3f, 0x51, 0x1b,
		0x7d, 0x09, 0x58, 0x18, 0xca, 0x58, 0xe9, 0xe8, 0x42, 0x31, 0x3b, 0x2d, 0xc3, 0x4e, 0x61, 0xa7,
		0x8b, 0xb7, 0x73, 0xe5, 0x04, 0x62, 0x03, 0x67, 0x4d, 0x66, 0x87, 0x60, 0xcf, 0x4f, 0x93, 0xe2,
		0xe1, 0xf5, 0x82, 0xbd, 0x26, 0x36, 0x85, 0x95, 0x85, 0x24, 0x15, 0x01, 0x89, 0x48, 0x38, 0x52,
		0x15, 0x8c, 0xc8, 0x84, 0x22, 0x32, 0x81, 0x88, 0x4e, 0x18, 0xd2, 0x9b, 0x92, 0x88, 0x9a, 0x44,
		0x74, 0x61, 0xef, 0xf5, 0x3d, 0x9c, 0x65, 0x50, 0x75, 0x45, 0x76, 0xa9, 0x45, 0xe8, 0xb1, 0xd0,
		0x63, 0xa1, 0xc7, 0x4a, 0xce, 0x1c, 0x71, 0xb2, 0xa4, 0x20, 0xcd, 0xb5, 0xe4, 0x79, 0xe8, 0x5b,
		0x46, 0xcf, 0x35, 0x79, 0xc7, 0x0f, 0xba, 0x9f, 0x2c, 0xbf, 0xdb, 0xf3, 0x3d, 0xe6, 0xf1, 0x70,
		0xf5, 0xaf, 0x07, 0xbf, 0xe5, 0x81, 0xe9, 0x85, 0x16, 0x73, 0xde, 0x58, 0xf0, 0x69, 0xe6, 0xe7,
		0xc5, 0x7f, 0x5a, 0x74, 0x1a, 0xe1, 0xe2, 0x07, 0x26, 0x99, 0xf1, 0xc2, 0xaf, 0x05, 0xf8, 0x97,
		0x6a, 0x6c, 0x6f, 0x9c, 0x90, 0xd7, 0x38, 0x0f, 0xd4, 0xc6, 0xf7, 0xd6, 0xf1, 0xea, 0x2e, 0x1b,
		0x4c, 0xf1, 0x01, 0x4b, 0x7b, 0x7d, 0xd7, 0x55, 0x18, 0x9d, 0x5b, 0xf3, 0x07, 0x5d, 0x63, 0xf7,
		0x81, 0xcd, 0x02, 0x66, 0x5f, 0xbc, 0x8f, 0x9b, 0x4a, 0xf1, 0x82, 0xe2, 0xcc, 0x4c, 0x50, 0x8f,
		0x5b, 0xb3, 0x8d, 0x21, 0x64, 0x21, 0x64, 0x21, 0x64, 0xed, 0x69, 0xc8, 0x8a, 0x7e, 0x3b, 0xd4,
		0x52, 0xb1, 0x62, 0xa1, 0x47, 0xe2, 0x1e, 0xeb, 0x41, 0x87, 0x52, 0xb9, 0xb5, 0x06, 0xc1, 0xfb,
		0x7a, 0x74, 0x3f, 0xed, 0xb1, 0x13, 0xd6, 0xb5, 0x62, 0x21, 0x24, 0xe8, 0x9b, 0x9c, 0xc9, 0x8b,
		0x16, 0x32, 0x2b, 0x41, 0xca, 0x9a, 0x45, 0x05, 0x9a, 0x05, 0x34, 0x0b, 0x68, 0x16, 0x00, 0x40,
		0x00, 0x20, 0x00, 0x10, 0x9a, 0x05, 0x34, 0x0b, 0x68, 0x16, 0xd0, 0x2c, 0x10, 0xb2, 0x10, 0xb2,
		0x10, 0xb2, 0xa0, 0x59, 0xe4, 0x46, 0xb3, 0x48, 0xc9, 0x26, 0xcb, 0x89, 0x64, 0x81, 0x3d, 0x96,
		0x0a, 0x83, 0xb9, 0xbb, 0x2d, 0x96, 0xe3, 0xe1, 0x4b, 0x72, 0xf7, 0xd6, 0x42, 0x67, 0x18, 0x66,
		0x18, 0x3a, 0x2f, 0xde, 0x04, 0xc2, 0x04, 0x77, 0x74, 0x6d, 0x6a, 0x0c, 0xbb, 0xbc, 0xb0, 0xcb,
		0x4b, 0xd1, 0x55, 0x08, 0xef, 0xf2, 0x9a, 0xce, 0x3f, 0x79, 0xd1, 0x74, 0xa6, 0x0d, 0xec, 0xf6,
		0x82, 0x72, 0x9a, 0x37, 0xe5, 0x54, 0x72, 0x23, 0xe4, 0xd2, 0xc4, 0x91, 0x5e, 0xb4, 0x51, 0x30,
		0x15, 0xa4, 0x9c, 0x48, 0x39, 0x77, 0x9f, 0x72, 0xca, 0x9a, 0xde, 0x34, 0x4a, 0xb9, 0xae, 0x6f,
		0xc9, 0xa7, 0x35, 0xab, 0xa3, 0xd6, 0xb4, 0x4d, 0xc5, 0xd1, 0xa1, 0x79, 0x3b, 0x52, 0xd9, 0x44,
		0x29, 0x4d, 0x55, 0x93, 0xc9, 0x52, 0x9b, 0xae, 0x36, 0x13, 0xd6, 0x66, 0xca, 0xfa, 0x4c, 0x5a,
		0xcd, 0xb4, 0x15, 0x4d, 0x9c, 0x4e, 0x5d, 0x5a, 0x9a, 0x79, 0x36, 0xb3, 0x9c, 0xae, 0xe9, 0x2a,
		0xbd, 0x5c, 0xbf, 0x14, 0x45, 0x2b, 0x04, 0x6d, 0x2d, 0xbd, 0x62, 0x7c, 0x44, 0xd0, 0x28, 0xcd,
		0x2b, 0xfc, 0x93, 0xff, 0x68, 0xac, 0xab, 0x40, 0xfd, 0x4a, 0xff, 0xe2, 0x70, 0x54, 0x3e, 0xd0,
		0x36, 0x4b, 0xfc, 0x8a, 0xff, 0xfa, 0x11, 0x2f, 0x91, 0xb5, 0xff, 0xf3, 0x03, 0xe1, 0x50, 0x11,
		0xbe, 0xfa, 0xbf, 0x38, 0x54, 0x47, 0x18, 0xaa, 0x9f, 0x07, 0xe9, 0x68, 0xe5, 0x69, 0x47, 0xf5,
		0x08, 0x14, 0xa6, 0xea, 0x8c, 0x54, 0x60, 0x70, 0x8a, 0x48, 0xb1, 0x42, 0x83, 0x18, 0x35, 0x0c,
		0xa4, 0x03, 0xd2, 0x01, 0xe9, 0x52, 0x8a, 0x74, 0xcc, 0xeb, 0x77, 0x59, 0x40, 0x91, 0x7b, 0xcd,
		0x41, 0x5d, 0x95, 0xa0, 0xad, 0xba, 0xd7, 0xef, 0x0e, 0x1e, 0xf6, 0x67, 0x06, 0x9d, 0xab, 0xcd,
		0x42, 0x2b, 0x70, 0x7a, 0xb4, 0x69, 0xf2, 0x6c, 0xa3, 0x70, 0xaa, 0x70, 0xaa, 0x70, 0xaa, 0x29,
		0x75, 0xaa, 0x21, 0x0f, 0x1c, 0xef, 0x85, 0xd2, 0x9f, 0x9e, 0x65, 0xd0, 0x07, 0x8a, 0x95, 0xc3,
		0xd9, 0xda, 0xa9, 0x22, 0x65, 0x72, 0xe0, 0xf7, 0xe0, 0xf7, 0xe0, 0xf7, 0x12, 0xf7, 0x7b, 0x7d,
		0xc7, 0xe3, 0x47, 0x15, 0x42, 0xbf, 0x77, 0x0a, 0x19, 0x6f, 0x27, 0x0e, 0x0e, 0x32, 0x5e, 0x72,
		0x32, 0x9e, 0xae, 0xa1, 0xaa, 0x56, 0xce, 0xab, 0xe7, 0x27, 0xa7, 0x95, 0xf3, 0x63, 0xe8, 0x79,
		0xfb, 0xa0, 0xe7, 0x2d, 0x6c, 0x67, 0xa3, 0x03, 0xaf, 0xc5, 0x86, 0x81, 0x60, 0x40, 0x30, 0x20,
		0x58, 0x4a, 0x11, 0x4c, 0xfd, 0x45, 0x80, 0xa5, 0xdc, 0x93, 0x02, 0xc2, 0x66, 0x5f, 0x0c, 0x98,
		0x0c, 0xde, 0xa7, 0xc5, 0xad, 0xce, 0xb3, 0xff, 0xb6, 0xb4, 0xed, 0x79, 0xf6, 0x1f, 0x67, 0x5e,
		0x4c, 0x8b, 0x7e, 0xa7, 0xf0, 0x56, 0xda, 0x6e, 0xfd, 0x76, 0xd7, 0xec, 0xf5, 0x1c, 0xef, 0x85,
		0xce, 0x5f, 0x4f, 0x1a, 0x84, 0x9f, 0x86, 0x9f, 0x86, 0x9f, 0x4e, 0xa9, 0x9f, 0x76, 0x6c, 0xe6,
		0x71, 0x87, 0xbf, 0x13, 0xfb, 0x6a, 0x02, 0xd6, 0x2f, 0x5e, 0x8f, 0x6f, 0xed, 0xc2, 0x0c, 0x09,
		0xe7, 0xf2, 0xe4, 0xc1, 0x3f, 0x3f, 0xd4, 0x6e, 0xeb, 0xed, 0xdb, 0x5a, 0xa3, 0x71, 0x7d, 0xf7,
		0xa5, 0xdd, 0x78, 0xb8, 0x6f, 0xdd, 0x5f, 0xde, 0xdf, 0x14, 0x29, 0x8f, 0x33, 0x08, 0xc9, 0xb2,
		0x7d, 0xda, 0x8c, 0x7f, 0xae, 0x1f, 0xbe, 0xdc, 0x36, 0x8a, 0x69, 0xcc, 0x75, 0x75, 0x3d, 0xee,
		0xe7, 0x46, 0xbb, 0xb5, 0x4f, 0x0f, 0x5c, 0xdb, 0xbf, 0xf1, 0xfd, 0xbc, 0x4f, 0x0f, 0x7c, 0xb1,
		0x5f, 0xe3, 0x7b, 0x79, 0xf1, 0x50, 0x4c, 0x99, 0xcc, 0xf3, 0x94, 0xd9, 0x63, 0x64, 0x54, 0xd2,
		0x05, 0xbf, 0xc7, 0xf5, 0xc8, 0x3c, 0x8b, 0x0d, 0x23, 0x7d, 0x40, 0xfa, 0x80, 0xf4, 0x01, 0x32,
		0x8f, 0xac, 0xcc, 0x93, 0x74, 0xfd, 0x87, 0xdd, 0xba, 0x65, 0x1e, 0x38, 0xcf, 0x7d, 0x6e, 0x06,
		0xef, 0x46, 0xe8, 0xfa, 0xdc, 0x20, 0xde, 0xfb, 0xb0, 0xb2, 0x75, 0x38, 0x68, 0x38, 0x68, 0x38,
		0xe8, 0xb4, 0xea, 0x3b, 0xc4, 0x3b, 0x21, 0xf0, 0x42, 0x93, 0x6c, 0x5c, 0xd3, 0xb4, 0xbc, 0x5e,
		0x29, 0x57, 0x4f, 0xab, 0x67, 0x47, 0x27, 0xd5, 0x33, 0x6c, 0x89, 0xa0, 0x1e, 0xb3, 0x92, 0xee,
		0x31, 0x3b, 0xc5, 0x96, 0x88, 0x64, 0xb3, 0xed, 0x9f, 0x19, 0x79, 0x3d, 0x5e, 0xb1, 0x68, 0x57,
		0xd4, 0x8e, 0x86, 0x7a, 0x4f, 0x1b, 0xca, 0x15, 0x1d, 0x4e, 0x7f, 0x3e, 0x54, 0x2a, 0x6d, 0x51,
		0xa0, 0xaf, 0x12, 0x35, 0xff, 0xfb, 0xda, 0xf4, 0xa6, 0xdb, 0xd3, 0x9f, 0xa5, 0x8a, 0x96, 0xcb,
		0x4f, 0x10, 0x99, 0xb2, 0x97, 0x6a, 0x40, 0x4f, 0xb2, 0x89, 0x19, 0xa5, 0x2e, 0xb5, 0x11, 0x39,
		0xea, 0x8e, 0xe8, 0x76, 0xac, 0xb9, 0x2d, 0x75, 0x29, 0x75, 0x96, 0xe9, 0x6e, 0x7c, 0x98, 0xdc,
		0x81, 0x0c, 0x4b, 0x03, 0x20, 0x5b, 0x3d, 0xb2, 0x40, 0x59, 0x3b, 0xa9, 0x02, 0x1f, 0x06, 0x1f,
		0x86, 0xda, 0x49, 0xa8, 0x9d, 0x04, 0x41, 0x10, 0x82, 0x60, 0x16, 0x04, 0x41, 0xd4, 0x4e, 0xca,
		0xbd, 0xd4, 0x88, 0xda, 0x49, 0xa8, 0x9d, 0x04, 0x61, 0x31, 0x33, 0xc2, 0x22, 0x6a, 0x27, 0x01,
		0xe9, 0x80, 0x74, 0x40, 0x3a, 0xe9, 0x99, 0x87, 0xda, 0x49, 0x5a, 0x9c, 0x2b, 0x6a, 0x27, 0xc1,
		0xa9, 0xc2, 0xa9, 0xee, 0xab, 0x53, 0x45, 0xed, 0x24, 0xd4, 0x4e, 0x82, 0xdf, 0x83, 0xdf, 0xdb,
		0x37, 0xbf, 0x87, 0xda, 0x49, 0x69, 0x91, 0xf1, 0x50, 0x3b, 0x09, 0xb5, 0x93, 0x50, 0x3b, 0x69,
		0xaf, 0xf4, 0x3c, 0xd4, 0x4e, 0x02, 0x82, 0x01, 0xc1, 0xf6, 0x1d, 0xc1, 0x50, 0x3b, 0x29, 0x6b,
		0x7e, 0x1b, 0xb5, 0x93, 0xe0, 0xa7, 0xe1, 0xa7, 0xf7, 0xcd, 0x4f, 0xa3, 0x76, 0x12, 0x6a, 0x27,
		0xa1, 0x76, 0x52, 0x8e, 0x1f, 0x18, 0xb5, 0x93, 0xf2, 0xfd, 0xc0, 0xa8, 0x9d, 0xb4, 0x6b, 0x99,
		0x07, 0xb5, 0x93, 0x50, 0x3b, 0x09, 0xe9, 0x03, 0xd2, 0x07, 0xc8, 0x3c, 0xa9, 0x94, 0x79, 0x50,
		0x3b, 0x09, 0xb5, 0x93, 0xe0, 0xa0, 0xe1, 0xa0, 0xf7, 0x54, 0xdf, 0x41, 0xed, 0xa4, 0xf8, 0x37,
		0x86, 0xda, 0x49, 0x33, 0x5f, 0x80, 0x2d, 0x11, 0xa8, 0x9d, 0x44, 0x9e, 0x2b, 0xa3, 0x76, 0x52,
		0xcc, 0xf8, 0x96, 0xf9, 0xda, 0x49, 0x2a, 0x95, 0x2d, 0x0a, 0x3b, 0x2a, 0x9d, 0xd4, 0x1c, 0xde,
		0x73, 0x52, 0x55, 0x47, 0x0e, 0x34, 0x4e, 0xa4, 0x01, 0xd2, 0xc9, 0x6e, 0x56, 0x2e, 0xde, 0x38,
		0x21, 0xaf, 0x71, 0x2e, 0x57, 0xa0, 0x61, 0x10, 0x44, 0xeb, 0x2e, 0x1b, 0xf6, 0x6d, 0xf1, 0x53,
		0xc1, 0xeb, 0xbb, 0xae, 0x44, 0x79, 0x95, 0x5b, 0xf3, 0x87, 0x7a, 0x23, 0xf7, 0x81, 0xcd, 0x02,
		0x66, 0x5f, 0xbc, 0x8f, 0x9b, 0xd0, 0xda, 0xe1, 0x8a, 0x16, 0xbb, 0x3b, 0x4b, 0x2d, 0x4a, 0x55,
		0xbf, 0x49, 0xda, 0x36, 0xc5, 0xac, 0x32, 0xbe, 0x6d, 0xc5, 0xfb, 0x64, 0xcc, 0xc9, 0x20, 0x3b,
		0x09, 0x12, 0x1e, 0x7c, 0x81, 0x11, 0x4f, 0x6a, 0xa4, 0xe3, 0x0d, 0xef, 0xf6, 0xc1, 0x8a, 0x31,
		0x50, 0x45, 0x9f, 0xc7, 0x1f, 0x9d, 0x69, 0x06, 0xcf, 0xe3, 0xbe, 0xeb, 0x26, 0x08, 0xfc, 0xc2,
		0xc2, 0x85, 0x8c, 0x40, 0xa1, 0x28, 0x44, 0xc8, 0x0a, 0x0e, 0xca, 0xc2, 0x82, 0xb2, 0x80, 0xa0,
		0x2e, 0x14, 0xd0, 0x3a, 0x08, 0xd1, 0xb2, 0x47, 0x45, 0x6b, 0x32, 0x3b, 0x04, 0x7b, 0x7e, 0x32,
		0xe0, 0x52, 0x25, 0x2c, 0x25, 0x73, 0x56, 0x69, 0x0d, 0x4e, 0x45, 0x73, 0x23, 0xd2, 0xd8, 0x54,
		0x35, 0x35, 0x32, 0x0d, 0x8d, 0x4c, 0x33, 0xa3, 0xd3, 0xc8, 0xf4, 0x92, 0xaa, 0x6c, 0x25, 0xb0,
		0x45, 0x31, 0xfa, 0x25, 0x30, 0xbd, 0xbe, 0x6b, 0x06, 0x0e, 0x7f, 0x57, 0xaf, 0xcb, 0xb7, 0xa1,
		0x6d, 0x14, 0x1c, 0x45, 0xb1, 0xbe, 0x9d, 0xcb, 0xd5, 0x59, 0x2d, 0x38, 0x4a, 0xb3, 0xdd, 0x90,
		0x62, 0x9b, 0x21, 0xed, 0xf6, 0xc2, 0xe8, 0x01, 0x5b, 0x0f, 0xd7, 0x17, 0xdf, 0x5a, 0xb5, 0x87,
		0x3f, 0xda, 0xcd, 0x9b, 0xfb, 0x56, 0xfb, 0xcb, 0x43, 0xed, 0xee, 0xdb, 0x4d, 0xed, 0xe1, 0xba,
		0xf5, 0x87, 0xea, 0xa4, 0x24, 0xdc, 0x52, 0x48, 0xbc, 0x95, 0x72, 0xf0, 0xcc, 0xa3, 0xc7, 0xad,
		0x7c, 0x3c, 0xfe, 0x42, 0xb0, 0x06, 0xf3, 0x21, 0xbd, 0x4f, 0x98, 0xf7, 0xe7, 0x2b, 0x7f, 0xac,
		0x90, 0x3c, 0xe2, 0xc1, 0x6e, 0x34, 0xde, 0x9f, 0x29, 0x2e, 0x19, 0xcc, 0xb9, 0x63, 0x74, 0xc3,
		0x17, 0xc3, 0xec, 0x73, 0x9f, 0x80, 0x50, 0x66, 0x5b, 0x03, 0x93, 0x80, 0x49, 0xc0, 0x24, 0x92,
		0x33, 0xe7, 0xd9, 0xf7, 0x5d, 0x66, 0x7a, 0x14, 0x3c, 0x52, 0xce, 0x80, 0xfb, 0x61, 0x3f, 0x7a,
		0xcc, 0xe2, 0xcc, 0xa6, 0x73, 0x41, 0x51, 0x8b, 0x70, 0x43, 0x70, 0x43, 0x70, 0x43, 0x92, 0x33,
		0x47, 0xb9, 0x58, 0x93, 0x62, 0x91, 0xa6, 0x64, 0xbd, 0x10, 0x0f, 0x4c, 0x2f, 0xec, 0x3a, 0x9c,
		0xce, 0x0b, 0x45, 0x2d, 0xc2, 0x0b, 0xc1, 0x0b, 0xc1, 0x0b, 0xed, 0x8f, 0x17, 0xda, 0xb7, 0x65,
		0x7d, 0x9f, 0x7b, 0xf2, 0x27, 0x93, 0x11, 0x2f, 0xe8, 0xde, 0x73, 0x4f, 0xea, 0xc0, 0x31, 0x81,
		0x05, 0x7a, 0xa1, 0xc5, 0x6a, 0x99, 0x43, 0x79, 0x94, 0x0e, 0xe3, 0x51, 0x5e, 0x2a, 0xab, 0x60,
		0xa9, 0x0c, 0x4b, 0x65, 0x31, 0x6f, 0x53, 0x7a, 0xa9, 0xec, 0xd9, 0xb4, 0xbe, 0xbf, 0x04, 0x7e,
		0xdf, 0xb3, 0x8d, 0x67, 0xd7, 0xb7, 0xbe, 0x1b, 0x2c, 0x08, 0xfc, 0x20, 0x54, 0x87, 0xaf, 0x75,
		0x0d, 0x83, 0xc1, 0xc0, 0x60, 0x60, 0x30, 0xc9, 0x99, 0x63, 0xf9, 0x7d, 0x8f, 0xb3, 0x40, 0xe9,
		0x78, 0x9b, 0x89, 0x29, 0x29, 0xbc, 0x15, 0x40, 0xf4, 0x9e, 0x06, 0xc1, 0xcb, 0x2c, 0x94, 0xef,
		0x65, 0x10, 0xef, 0xed, 0xa7, 0xae, 0x48, 0xa9, 0x63, 0x0b, 0x3f, 0xc1, 0x7a, 0x13, 0xe9, 0x6b,
		0x16, 0xba, 0x86, 0xa0, 0x7c, 0x56, 0xad, 0x9e, 0x9c, 0x56, 0xab, 0xa5, 0xd3, 0xa3, 0xd3, 0xd2,
		0xf9, 0xf1, 0x71, 0xf9, 0xa4, 0x7c, 0x9c, 0xe2, 0x51, 0xd9, 0xd1, 0x8b, 0x0c, 0x4f, 0x29, 0x56,
		0x87, 0x2c, 0xdf, 0x66, 0xc6, 0x9b, 0xe3, 0xbb, 0xc3, 0x8c, 0x8b, 0x80, 0x4f, 0x16, 0x1b, 0x04,
		0x97, 0x80, 0x4b, 0xc0, 0x25, 0xe0, 0x12, 0x70, 0x09, 0xb8, 0x04, 0x5c, 0x02, 0x2e, 0x89, 0xd9,
		0xcd, 0x43, 0x55, 0x83, 0x8d, 0x35, 0x0e, 0x02, 0x2c, 0x59, 0x68, 0x0f, 0x54, 0x02, 0x2a, 0x01,
		0x95, 0x80, 0x4a, 0x40, 0x25, 0xa0, 0x12, 0x50, 0x09, 0xa8, 0x44, 0x90, 0x4a, 0x42, 0x66, 0xf9,
		0x9e, 0x4d, 0x88, 0x25, 0x93, 0x06, 0xc1, 0x25, 0xe0, 0x12, 0x70, 0x09, 0xb8, 0x04, 0x5c, 0x02,
		0x2e, 0x01, 0x97, 0x80, 0x4b, 0xe2, 0x72, 0x49, 0xe8, 0x05, 0x04, 0x30, 0x32, 0x68, 0x45, 0x8d,
		0x40, 0xca, 0x20, 0x10, 0x10, 0x48, 0xd6, 0x08, 0x44, 0x76, 0x93, 0x57, 0xd4, 0x80, 0xf9, 0x46,
		0x78, 0x88, 0xd3, 0xa0, 0x31, 0x14, 0xf8, 0x8d, 0x63, 0xa4, 0xfc, 0xbd, 0xc7, 0x42, 0x54, 0xf7,
		0xa5, 0x68, 0x78, 0xc1, 0x82, 0x47, 0x3d, 0x8b, 0xd2, 0xbe, 0x0b, 0x73, 0xce, 0x66, 0x96, 0xd3,
		0x35, 0x5d, 0xa5, 0x04, 0x63, 0x29, 0x62, 0x56, 0x08, 0xda, 0x5a, 0xc2, 0xac, 0x0a, 0x8a, 0x06,
		0xcb, 0x0d, 0x47, 0x05, 0xc7, 0x27, 0x67, 0xa5, 0x56, 0xf0, 0x11, 0x86, 0x0a, 0xa7, 0x26, 0xcb,
		0x43, 0x9b, 0xe3, 0x85, 0xdc, 0xf4, 0x38, 0x1d, 0xb8, 0x4d, 0x1a, 0x04, 0xbc, 0x01, 0xde, 0x00,
		0x6f, 0x80, 0x37, 0xc0, 0x1b, 0xe0, 0x0d, 0xf0, 0x06, 0x78, 0x03, 0xbc, 0xe9, 0x80, 0x37, 0xce,
		0x82, 0x37, 0xd3, 0xa5, 0xa4, 0xb7, 0x71, 0x8b, 0xc0, 0x37, 0xe0, 0x1b, 0xf0, 0x2d, 0x75, 0xf8,
		0x16, 0x72, 0x93, 0x1b, 0x44, 0x46, 0x5a, 0xa0, 0x59, 0xe8, 0x8f, 0x9a, 0xfa, 0xe6, 0x8d, 0x62,
		0x43, 0xd1, 0x33, 0x3d, 0x5f, 0x6d, 0x2b, 0x0f, 0x20, 0xae, 0x04, 0x32, 0xd8, 0xf7, 0xd3, 0xba,
		0xf4, 0x6d, 0x48, 0x00, 0xd7, 0xa5, 0x9b, 0xeb, 0xba, 0x26, 0xe1, 0xd9, 0xa9, 0x83, 0xc6, 0x40,
		0x73, 0xa0, 0x39, 0xd0, 0x1c, 0xc4, 0x38, 0x88, 0x71, 0x10, 0xe3, 0xc0, 0x71, 0x10, 0xe3, 0x00,
		0x6d, 0x5a, 0xa0, 0xcd, 0xe0, 0x4e, 0x97, 0x91, 0x92, 0xdb, 0xa8, 0x45, 0xe0, 0x1b, 0xf0, 0x0d,
		0xf8, 0x96, 0x3a, 0x7c, 0x1b, 0xd8, 0x26, 0x77, 0xac, 0xef, 0x21, 0x29, 0xc0, 0x41, 0x8a, 0x83,
		0x14, 0x07, 0x84, 0x83, 0x14, 0x07, 0xaa, 0x4b, 0x05, 0xd5, 0x11, 0x38, 0x96, 0x29, 0xd0, 0x39,
		0x1e, 0x58, 0x0e, 0x2c, 0x07, 0x96, 0x83, 0x14, 0x07, 0x29, 0x0e, 0x52, 0x1c, 0x38, 0x0e, 0x52,
		0x1c, 0xa0, 0x4d, 0x0f, 0xb4, 0x51, 0x4b, 0x71, 0x93, 0x16, 0x81, 0x6f, 0xc0, 0x37, 0xe0, 0x1b,
		0xa4, 0x38, 0x48, 0x71, 0x90, 0xe2, 0x80, 0x70, 0x90, 0xe2, 0x40, 0x75, 0x09, 0x5c, 0x29, 0x5b,
		0xd2, 0x44, 0xf1, 0x10, 0xbd, 0xa8, 0x1d, 0x4d, 0x87, 0xe9, 0x0d, 0xcf, 0x7d, 0x3b, 0x54, 0xa8,
		0x37, 0x54, 0xd0, 0x73, 0xb0, 0x5e, 0x73, 0x70, 0x5f, 0xed, 0xfa, 0xe0, 0xbe, 0x52, 0x5c, 0xed,
		0xa9, 0xc3, 0x2c, 0xc3, 0xf2, 0x83, 0x60, 0x78, 0x04, 0xb4, 0xf1, 0x3c, 0xb2, 0x54, 0xc5, 0xda,
		0x4f, 0x2b, 0xda, 0x44, 0x2d, 0x4a, 0x54, 0x82, 0x52, 0x64, 0x76, 0xd4, 0xa2, 0x44, 0x2d, 0x4a,
		0x0d, 0x70, 0x8c, 0x5a, 0x94, 0x3b, 0x87, 0x5e, 0xd4, 0xa2, 0x2c, 0xa0, 0x16, 0x65, 0x1c, 0x3a,
		0x79, 0xe7, 0x8c, 0x1e, 0x4f, 0x86, 0x8d, 0x82, 0x4f, 0xc0, 0x27, 0xe0, 0x13, 0xf0, 0x09, 0xf8,
		0x04, 0x7c, 0x02, 0x3e, 0x01, 0x9f, 0x08, 0xf0, 0x49, 0xdf, 0x1b, 0xc3, 0x84, 0xf9, 0xec, 0x32,
		0xb2, 0x33, 0xc6, 0xd6, 0xb6, 0x0c, 0x52, 0x01, 0xa9, 0x80, 0x54, 0x40, 0x2a, 0x20, 0x15, 0x90,
		0x0a, 0x48, 0x05, 0xa4, 0x22, 0x4d, 0x2a, 0x83, 0x98, 0xa5, 0x05, 0x54, 0x46, 0x0d, 0x83, 0x53,
		0xc0, 0x29, 0xe0, 0x14, 0x70, 0x0a, 0x38, 0x05, 0x9c, 0x02, 0x4e, 0x01, 0xa7, 0xc4, 0xec, 0xe6,
		0x9e, 0x1f, 0x72, 0x63, 0xc0, 0x14, 0xcf, 0x8c, 0xe0, 0x14, 0xb2, 0xb9, 0xd6, 0x70, 0x1a, 0x19,
		0x88, 0x64, 0xcf, 0x88, 0x04, 0xa7, 0x91, 0xe9, 0x31, 0x4a, 0x4a, 0xe3, 0x5c, 0x6b, 0xa4, 0x78,
		0xfb, 0x43, 0xd3, 0xdb, 0x1f, 0xd3, 0xde, 0xc5, 0x1b, 0x20, 0x0b, 0x73, 0x2f, 0x3b, 0x2f, 0xf0,
		0x96, 0xcf, 0xf0, 0xfa, 0x87, 0xdc, 0x78, 0xe0, 0x0d, 0x5e, 0xbc, 0xc1, 0x8b, 0x77, 0x3d, 0x92,
		0x49, 0x9a, 0xd4, 0xbf, 0x1f, 0xc7, 0x92, 0x81, 0xe2, 0x40, 0x71, 0xa0, 0x38, 0x50, 0x1c, 0x28,
		0x0e, 0x14, 0x07, 0x8a, 0x03, 0xc5, 0xed, 0x1f, 0xc5, 0xe1, 0x7c, 0xb2, 0x9d, 0x72, 0x1c, 0x18,
		0x0e, 0x75, 0x58, 0x12, 0xe5, 0x37, 0x9c, 0x4f, 0xb6, 0x27, 0x10, 0x87, 0x4a, 0x2c, 0xa8, 0xc4,
		0x82, 0x4a, 0x2c, 0x38, 0x9f, 0x4c, 0x3d, 0x64, 0xe0, 0x7c, 0x32, 0xa8, 0x72, 0x50, 0xe5, 0xa0,
		0xca, 0x41, 0x95, 0x83, 0x2a, 0xf7, 0xff, 0xb3, 0x77, 0x2e, 0x3d, 0x8d, 0x23, 0x51, 0x14, 0xde,
		0xf3, 0x2b, 0x90, 0xf7, 0xa1, 0x49, 0x80, 0x00, 0xcb, 0x40, 0xa7, 0x19, 0x34, 0x79, 0x30, 0xc1,
		0x68, 0xd4, 0x0b, 0x14, 0x99, 0xa4, 0xba, 0x65, 0xb5, 0x63, 0x33, 0xb6, 0x83, 0x9a, 0x45, 0xff,
		0xf7, 0x11, 0x79, 0x90, 0x00, 0x21, 0xb8, 0x1e, 0x0e, 0x76, 0xe5, 0x9b, 0x05, 0x1a, 0x89, 0x76,
		0xe1, 0x5b, 0x75, 0x1f, 0xe7, 0x9e, 0xaa, 0x3a, 0x06, 0xd0, 0xc1, 0xca, 0x81, 0xde, 0xf2, 0x47,
		0x6f, 0x7c, 0xa8, 0x0c, 0x56, 0x0e, 0x56, 0x6e, 0x6b, 0xf0, 0x1b, 0xea, 0xc8, 0x70, 0x72, 0x40,
		0x38, 0x38, 0x39, 0x50, 0x9d, 0xc5, 0xa8, 0x8e, 0x0f, 0x95, 0xc1, 0xc9, 0xc1, 0xc9, 0xc1, 0xc9,
		0xc1, 0xc9, 0xc1, 0xc9, 0x01, 0xe8, 0xe0, 0xe4, 0x40, 0x6f, 0xe5, 0x42, 0x6f, 0x7c, 0xb1, 0x0c,
		0x4e, 0x0e, 0x4e, 0x0e, 0x4e, 0x0e, 0x4e, 0x0e, 0x4e, 0x0e, 0x08, 0x07, 0x27, 0x07, 0xaa, 0x2b,
		0x06, 0xaa, 0xe3, 0x8b, 0x65, 0xaf, 0xbf, 0x58, 0x66, 0x40, 0x9b, 0x68, 0x37, 0xcf, 0x2f, 0x97,
		0x5d, 0x45, 0x49, 0xfa, 0x4d, 0x0c, 0xce, 0x44, 0xa1, 0xbf, 0x5f, 0x76, 0x1f, 0x0b, 0x83, 0x72,
		0x51, 0x4b, 0x83, 0xa1, 0x16, 0x85, 0x5a, 0x94, 0x26, 0x66, 0x47, 0x2d, 0x4a, 0xc7, 0xfb, 0x50,
		0x8b, 0x92, 0x0a, 0x52, 0x3a, 0x6f, 0x76, 0x4f, 0x36, 0xdd, 0x7d, 0xb3, 0x7b, 0x62, 0x7f, 0xeb,
		0xcd, 0xee, 0x09, 0xbb, 0x27, 0xf4, 0xd9, 0xa5, 0xe9, 0xb3, 0x51, 0x8b, 0x02, 0xc5, 0x81, 0xe2,
		0x40, 0x71, 0xa0, 0x38, 0x50, 0x1c, 0x28, 0x0e, 0x14, 0x07, 0x8a, 0xdb, 0x3a, 0x14, 0x87, 0x5a,
		0xd4, 0xa7, 0xe2, 0x38, 0x30, 0x1c, 0x67, 0x60, 0x36, 0x8a, 0xdf, 0x50, 0x8b, 0xda, 0x12, 0x10,
		0xc7, 0x29, 0x18, 0x4e, 0xc1, 0x70, 0x0a, 0x06, 0xb5, 0x28, 0xfd, 0x92, 0x81, 0x5a, 0x14, 0xac,
		0x1c, 0xac, 0x1c, 0xac, 0x1c, 0xac, 0x1c, 0xac, 0x1c, 0x80, 0x0e, 0x56, 0x0e, 0xf4, 0x96, 0x3f,
		0x7a, 0x43, 0x2d, 0x0a, 0x56, 0x0e, 0x56, 0x6e, 0x6b, 0xf0, 0x1b, 0x37, 0xd3, 0xe0, 0xe4, 0x80,
		0x70, 0x70, 0x72, 0xa0, 0x3a, 0x8b, 0x51, 0x1d, 0x6a, 0x51, 0x70, 0x72, 0x70, 0x72, 0x70, 0x72,
		0x70, 0x72, 0x70, 0x72, 0x00, 0x3a, 0x38, 0x39, 0xd0, 0x5b, 0xb9, 0xd0, 0x1b, 0x6a, 0x51, 0x70,
		0x72, 0x70, 0x72, 0x70, 0x72, 0x70, 0x72, 0x70, 0x72, 0x40, 0x38, 0x38, 0x39, 0x50, 0x5d, 0x31,
		0x50, 0x1d, 0x6a, 0x51, 0x6f, 0xd4, 0xa2, 0xb4, 0xa5, 0x89, 0x76, 0x73, 0x15, 0x8b, 0x8a, 0x45,
		0xf1, 0xb5, 0xa2, 0xfe, 0xab, 0x3c, 0xcc, 0xd2, 0x83, 0xa6, 0x4e, 0xd4, 0x7c, 0x20, 0x34, 0xa2,
		0xd0, 0x88, 0xd2, 0x44, 0xea, 0x68, 0x44, 0xe9, 0x78, 0x1f, 0x1a, 0x51, 0xf4, 0xda, 0xf4, 0xda,
		0xec, 0x95, 0x68, 0xe1, 0xf6, 0x1a, 0x7d, 0xb6, 0xda, 0x72, 0xb0, 0x55, 0xc2, 0x56, 0x09, 0x4d,
		0x75, 0x69, 0x9a, 0x6a, 0xa4, 0xa1, 0x00, 0x6f, 0x80, 0x37, 0xc0, 0x1b, 0xe0, 0x0d, 0xf0, 0x06,
		0x78, 0x03, 0xbc, 0x01, 0xde, 0xb6, 0x05, 0xbc, 0xa1, 0x08, 0x05, 0x7c, 0x03, 0xbe, 0x6d, 0x0f,
		0x7c, 0x43, 0x11, 0x6a, 0x4b, 0x40, 0x1c, 0x27, 0x5d, 0x38, 0xe9, 0xc2, 0x49, 0x17, 0x14, 0xa1,
		0xf4, 0x4b, 0x06, 0x8a, 0x50, 0xa0, 0x39, 0xd0, 0x1c, 0x64, 0x1c, 0x64, 0x1c, 0x64, 0x1c, 0x38,
		0x0e, 0x32, 0x0e, 0xd0, 0x96, 0x1b, 0x68, 0x43, 0x08, 0x0a, 0xf8, 0x06, 0x7c, 0xdb, 0x1a, 0xf8,
		0xc6, 0xa5, 0x33, 0xa8, 0x38, 0x20, 0x1c, 0x54, 0x1c, 0xa8, 0xce, 0x62, 0x54, 0x87, 0x10, 0x14,
		0x58, 0x0e, 0x2c, 0x07, 0x15, 0x07, 0x15, 0x07, 0x15, 0x07, 0x8e, 0x83, 0x8a, 0x03, 0xb4, 0x95,
		0x02, 0xb4, 0xa1, 0xff, 0x04, 0x7c, 0x03, 0xbe, 0x41, 0xc5, 0x41, 0xc5, 0x41, 0xc5, 0x01, 0xe1,
		0xa0, 0xe2, 0x40, 0x75, 0xc5, 0x40, 0x75, 0xe8, 0x3f, 0xbd, 0xd6, 0x7f, 0xd2, 0x93, 0x1c, 0xda,
		0xcd, 0x53, 0xfb, 0xe9, 0x9f, 0x69, 0xd0, 0x15, 0x58, 0xf8, 0x29, 0x1e, 0xfa, 0x95, 0x51, 0xf2,
		0x53, 0x5f, 0xf8, 0x69, 0x3e, 0x90, 0x9e, 0xf0, 0xd3, 0x3e, 0xc2, 0x4f, 0xa6, 0xa1, 0x3b, 0xc2,
		0x4f, 0x79, 0x67, 0x49, 0x6d, 0x34, 0xbe, 0x74, 0x3b, 0x25, 0xf6, 0x43, 0x1d, 0xdd, 0xa6, 0x67,
		0xe6, 0xf4, 0xa4, 0xc0, 0x39, 0x27, 0x11, 0x0f, 0x22, 0x16, 0xc1, 0x63, 0x45, 0xc4, 0x71, 0x14,
		0x8b, 0x61, 0x65, 0x8e, 0xea, 0xb5, 0x93, 0xd0, 0xbb, 0x23, 0x93, 0x95, 0xc8, 0x4a, 0x64, 0x25,
		0x45, 0xcf, 0x19, 0x44, 0xe3, 0x30, 0x15, 0xb1, 0x16, 0x33, 0x60, 0x80, 0x11, 0x30, 0xd4, 0xb1,
		0x1b, 0x20, 0x4d, 0x4c, 0x76, 0xe8, 0x86, 0xdb, 0x3d, 0xd3, 0x1d, 0x79, 0x1e, 0xbd, 0x9c, 0x81,
		0x0e, 0xdc, 0x68, 0xe7, 0x9d, 0xd7, 0x12, 0xe4, 0xd7, 0x69, 0xe7, 0xb2, 0x2a, 0x9f, 0xd4, 0xd1,
		0xde, 0x16, 0x18, 0xa9, 0xa4, 0xb1, 0x7f, 0x37, 0x4e, 0xbd, 0xf8, 0xb1, 0x92, 0x04, 0x51, 0x5a,
		0xf9, 0x19, 0x7b, 0xe1, 0x38, 0xf0, 0x62, 0x3f, 0x7d, 0xd4, 0xc7, 0x2a, 0x6b, 0xc6, 0x06, 0xad,
		0x80, 0x56, 0x40, 0x2b, 0x8a, 0x9e, 0xe3, 0x0f, 0x45, 0x98, 0xfa, 0xe9, 0x63, 0x2c, 0x7e, 0x98,
		0x68, 0xa4, 0x34, 0x32, 0xb6, 0x73, 0x39, 0x7b, 0x95, 0x33, 0x2f, 0x31, 0xb8, 0x95, 0xea, 0xf6,
		0x2e, 0xcf, 0x6e, 0xdc, 0x46, 0xef, 0x7b, 0xff, 0xba, 0xd5, 0x75, 0xfb, 0x17, 0xbd, 0x46, 0xe7,
		0xa6, 0xd5, 0xe8, 0x5d, 0xba, 0xdf, 0x75, 0x9d, 0x72, 0x52, 0xb8, 0x12, 0x23, 0x7b, 0x22, 0x86,
		0x2a, 0xf3, 0xb2, 0xcd, 0x53, 0x73, 0x6b, 0x7b, 0x47, 0x17, 0x4e, 0x11, 0x20, 0x48, 0x6e, 0x16,
		0xda, 0x6e, 0x5f, 0x75, 0xaf, 0x66, 0xc4, 0x44, 0xad, 0x11, 0x6e, 0x37, 0x9d, 0x17, 0x37, 0x83,
		0x57, 0xd2, 0x09, 0x09, 0x5b, 0xf1, 0xc6, 0x69, 0x64, 0x00, 0xa1, 0x2c, 0x8f, 0x06, 0x26, 0x01,
		0x93, 0x80, 0x49, 0x14, 0x3d, 0xe7, 0x2e, 0x8a, 0x02, 0xe1, 0x85, 0x26, 0xf0, 0x48, 0xb5, 0x04,
		0xe9, 0x47, 0xfc, 0xbe, 0x17, 0x83, 0x54, 0x0c, 0xcd, 0xa5, 0xa0, 0xe7, 0x11, 0x49, 0x43, 0xa4,
		0x21, 0xd2, 0x90, 0xa2, 0xe7, 0x6c, 0xc7, 0xf6, 0xd2, 0x3c, 0x67, 0xc4, 0x62, 0xf0, 0x60, 0x2e,
		0x03, 0x4d, 0x46, 0x23, 0xfb, 0x90, 0x7d, 0xc8, 0x3e, 0x64, 0x9f, 0x0c, 0xd9, 0x27, 0x8d, 0xbd,
		0x30, 0x19, 0xf9, 0xa9, 0xb9, 0x0c, 0xf4, 0x3c, 0x22, 0x59, 0x88, 0x2c, 0x44, 0x16, 0x22, 0x0b,
		0xad, 0x79, 0xc7, 0x71, 0xe8, 0x3d, 0x78, 0x7e, 0xe0, 0xdd, 0x05, 0xc2, 0xdc, 0xe9, 0x9a, 0x55,
		0x83, 0x92, 0x8b, 0xc8, 0x45, 0xe4, 0x22, 0x45, 0xcf, 0xe1, 0x60, 0xcd, 0xab, 0x17, 0xe1, 0x60,
		0x8d, 0xd6, 0x7f, 0x1c, 0xac, 0x29, 0xe4, 0xaa, 0xd8, 0x7e, 0xb0, 0x66, 0x27, 0x47, 0x1f, 0xd5,
		0xbd, 0x82, 0x92, 0xeb, 0xd5, 0x13, 0x47, 0xe5, 0xf0, 0x73, 0x3e, 0x57, 0x4d, 0xe4, 0x8a, 0x67,
		0xf6, 0x25, 0xcb, 0xf6, 0x2f, 0x33, 0x2e, 0xaa, 0xea, 0x62, 0xe6, 0xb4, 0x88, 0x12, 0xcb, 0x67,
		0x7e, 0xd9, 0xb2, 0x2d, 0xd8, 0xc7, 0xd3, 0x9f, 0x61, 0xea, 0x9d, 0xa9, 0xb3, 0x66, 0x9d, 0xf1,
		0x17, 0xdf, 0xca, 0xc8, 0xea, 0xe3, 0x92, 0x5f, 0x6e, 0x5f, 0x20, 0xf8, 0x8c, 0xa2, 0x22, 0x2a,
		0x88, 0x5d, 0x13, 0xa1, 0xab, 0x22, 0x72, 0x6d, 0x04, 0xae, 0x8d, 0xb8, 0xf5, 0x11, 0xb6, 0xd9,
		0xb0, 0x97, 0xfd, 0x32, 0xba, 0xe3, 0x0d, 0x47, 0x7e, 0x58, 0x91, 0x73, 0xdb, 0x37, 0xab, 0xbe,
		0x3c, 0x88, 0xe4, 0xfc, 0xa9, 0xe1, 0x16, 0xe5, 0xb6, 0x54, 0xa7, 0x1d, 0x35, 0xd4, 0x86, 0xea,
		0xb6, 0x9f, 0xc6, 0xda, 0x4e, 0x63, 0xed, 0xa6, 0xb9, 0x36, 0x33, 0x5f, 0x80, 0xa3, 0xdc, 0x4e,
		0xae, 0x72, 0xf4, 0x89, 0xbc, 0x85, 0xca, 0xf2, 0xcf, 0xd3, 0xf7, 0xa1, 0xc2, 0xb3, 0xcd, 0x70,
		0x3c, 0x7a, 0xb2, 0xe0, 0x4f, 0x5e, 0x18, 0x44, 0x22, 0x67, 0x0f, 0x45, 0x32, 0x88, 0xfd, 0x7b,
		0x25, 0xbc, 0xb8, 0xa4, 0x65, 0xb6, 0x18, 0x84, 0xcc, 0x41, 0xe6, 0xb0, 0x36, 0x73, 0x28, 0x93,
		0xe1, 0x8a, 0x24, 0x78, 0x3e, 0x31, 0xef, 0x87, 0x43, 0xf1, 0x5b, 0x3d, 0xda, 0xa7, 0x8f, 0x13,
		0xe7, 0xc4, 0xb9, 0xb5, 0x71, 0x3e, 0xf6, 0xc3, 0xf4, 0xa0, 0xa6, 0x11, 0xe7, 0xc7, 0x0a, 0x8f,
		0xea, 0xb1, 0xca, 0x1a, 0xf4, 0xba, 0x09, 0x16, 0xd9, 0x94, 0xd0, 0x9c, 0x21, 0xd6, 0xd8, 0x24,
		0x2f, 0xa9, 0x23, 0x0c, 0x68, 0x82, 0x1d, 0x36, 0x3d, 0xb5, 0x87, 0xb5, 0xd3, 0xc3, 0xd3, 0xfa,
		0x71, 0xed, 0xf4, 0xa8, 0x40, 0x73, 0xbc, 0x21, 0xee, 0xf5, 0xb6, 0x00, 0xe5, 0x37, 0xf0, 0xc3,
		0x5f, 0xba, 0xbd, 0xfa, 0xd2, 0x18, 0x14, 0x62, 0x0a, 0xb1, 0xb5, 0x85, 0x58, 0x84, 0xe3, 0x91,
		0x88, 0x3d, 0x85, 0xce, 0xd2, 0xaa, 0x2e, 0xfd, 0x15, 0x2b, 0x3f, 0x65, 0x2d, 0xd4, 0x93, 0xc7,
		0xaa, 0xd1, 0x48, 0x23, 0xa4, 0x11, 0x6b, 0xd3, 0x88, 0xde, 0x1d, 0x67, 0x9d, 0xbb, 0xcd, 0x66,
		0xee, 0x34, 0x3f, 0x1b, 0xd2, 0xea, 0x5e, 0x5c, 0x9e, 0x37, 0x5a, 0xfd, 0x66, 0xab, 0xd9, 0x6e,
		0x76, 0xdc, 0xfe, 0x55, 0xaf, 0xeb, 0x76, 0xcf, 0xbb, 0xad, 0xbe, 0xfb, 0xfd, 0xaa, 0xa9, 0xea,
		0x4f, 0x06, 0xae, 0x31, 0x1b, 0xba, 0xaa, 0xfd, 0x64, 0x4e, 0xbf, 0xeb, 0x76, 0x9c, 0xcf, 0x00,
		0xeb, 0x26, 0x6d, 0x68, 0xba, 0x7f, 0x35, 0x7b, 0x9d, 0xa6, 0xbb, 0xe9, 0x33, 0x5a, 0xb7, 0x79,
		0x87, 0x6e, 0x4e, 0xe5, 0x2d, 0xba, 0xbf, 0xf3, 0x06, 0xbf, 0x2a, 0xa3, 0x68, 0xa8, 0x55, 0xd7,
		0x96, 0x87, 0xa1, 0xa0, 0x51, 0xd0, 0xac, 0x2d, 0x68, 0x2f, 0x5c, 0xfd, 0x73, 0x37, 0xb1, 0x14,
		0x9e, 0xfd, 0x2a, 0x7e, 0x78, 0xe3, 0x60, 0xb2, 0x4a, 0x9d, 0x6e, 0xa7, 0xe9, 0x14, 0x20, 0x05,
		0xc5, 0x5e, 0x2a, 0x2a, 0x83, 0xc0, 0x4b, 0x12, 0xf5, 0xfc, 0xb3, 0x34, 0x06, 0xc9, 0x87, 0xe4,
		0x03, 0x9a, 0x2e, 0x3a, 0x9a, 0x5e, 0x28, 0x03, 0xf5, 0x1a, 0x6e, 0xb3, 0x7f, 0xde, 0x6a, 0x5c,
		0x5f, 0x5b, 0x82, 0xa4, 0x27, 0xf2, 0x31, 0x13, 0xab, 0x8e, 0xf6, 0xf7, 0x2f, 0xca, 0x8c, 0xa7,
		0x17, 0x96, 0x9c, 0x58, 0x63, 0x49, 0xb5, 0x6a, 0x8d, 0x29, 0x87, 0xb6, 0x18, 0x52, 0xb7, 0x68,
		0x49, 0xac, 0x89, 0x13, 0x8b, 0x2c, 0xb1, 0xc5, 0x10, 0x4b, 0xec, 0xd0, 0xd3, 0xc5, 0x2b, 0x94,
		0x25, 0xd6, 0x04, 0xc9, 0xa9, 0x35, 0x96, 0xd4, 0x8e, 0xac, 0x89, 0x77, 0x6b, 0x2c, 0x39, 0xb6,
		0xa9, 0x2c, 0xda, 0x62, 0xca, 0x81, 0x9e, 0x25, 0x5b, 0x44, 0x92, 0xa7, 0x22, 0x49, 0x2b, 0x89,
		0xff, 0x33, 0xf4, 0x02, 0x75, 0x8a, 0x6a, 0x79, 0x10, 0x38, 0x2a, 0x38, 0x2a, 0x6b, 0x39, 0x2a,
		0x75, 0x05, 0x49, 0x45, 0xe5, 0xc8, 0x9c, 0x82, 0x3e, 0xf6, 0xef, 0x2a, 0xf7, 0x71, 0x94, 0x46,
		0x83, 0x48, 0x27, 0xec, 0x5f, 0x0c, 0x43, 0xe0, 0x13, 0xf8, 0x90, 0xd3, 0xeb, 0x83, 0xbf, 0x48,
		0xe4, 0xb4, 0x8d, 0x87, 0x3c, 0xaa, 0x17, 0xcd, 0xd2, 0x1f, 0xf2, 0xe8, 0xba, 0x37, 0x87, 0xe5,
		0x37, 0xe2, 0xeb, 0xcd, 0x41, 0xe9, 0x8d, 0xb8, 0x76, 0xdb, 0xb5, 0xa3, 0x7a, 0xf9, 0xd7, 0xe2,
		0xfc, 0xb8, 0x7e, 0x62, 0x81, 0x15, 0x87, 0x27, 0x36, 0xc4, 0x76, 0xad, 0xfc, 0x19, 0xaa, 0xba,
		0x7f, 0xd1, 0xec, 0xb7, 0x1a, 0x1d, 0x1b, 0x96, 0xe3, 0xc0, 0x86, 0x54, 0x6b, 0x85, 0x4f, 0xed,
		0x5b, 0x50, 0xbb, 0xaf, 0xdd, 0x76, 0xb5, 0x6e, 0xc5, 0x5a, 0xf4, 0xdb, 0xad, 0x0b, 0x1b, 0x42,
		0xe3, 0xbc, 0x63, 0x47, 0xba, 0xfd, 0xd7, 0x8e, 0x74, 0x5b, 0xb5, 0x02, 0x9f, 0xd7, 0x6c, 0x30,
		0xc2, 0x82, 0xc8, 0x78, 0x2a, 0x7d, 0x36, 0xd4, 0x8c, 0x7a, 0xf9, 0x1b, 0xbe, 0x43, 0x1b, 0xca,
		0x77, 0xf7, 0xab, 0x0d, 0xad, 0xf7, 0x79, 0xf5, 0xb4, 0xb6, 0xc5, 0x9b, 0x5f, 0xb6, 0x4a, 0x25,
		0xca, 0xde, 0xcb, 0x36, 0x2c, 0x96, 0x28, 0xa1, 0x6f, 0x99, 0x41, 0x2e, 0x71, 0x47, 0x63, 0x71,
		0x9c, 0xbf, 0xc5, 0x63, 0x56, 0xc5, 0x18, 0xa7, 0xe5, 0x27, 0x69, 0x23, 0x4d, 0xb3, 0x29, 0xdf,
		0x39, 0x6d, 0x3f, 0x6c, 0x06, 0x62, 0x24, 0xc2, 0x89, 0xf0, 0x40, 0x38, 0x0e, 0x82, 0x0c, 0xba,
		0x8e, 0x6d, 0xef, 0xb7, 0xfc, 0x43, 0xdd, 0x78, 0x28, 0x62, 0x31, 0x3c, 0x7b, 0x9c, 0x3d, 0xa2,
		0x35, 0x21, 0x92, 0x5e, 0x9a, 0x83, 0x77, 0x3a, 0x99, 0xf4, 0x2f, 0x0d, 0xfa, 0xe3, 0x7a, 0x4f,
		0x7c, 0xdf, 0xbf, 0x56, 0xff, 0xe6, 0x9d, 0x09, 0xce, 0x3a, 0xb1, 0x06, 0x27, 0x74, 0xcd, 0x44,
		0x9a, 0x99, 0xc0, 0xd5, 0x13, 0xf7, 0x76, 0x5a, 0x56, 0x4c, 0x89, 0x13, 0xdd, 0xcf, 0x6e, 0xcd,
		0x7b, 0xc1, 0xe4, 0x8a, 0xd0, 0xfb, 0xb7, 0x5a, 0x16, 0x5b, 0x66, 0x6f, 0x1e, 0x79, 0x67, 0xaa,
		0xd7, 0x2b, 0x97, 0x7e, 0xb8, 0xef, 0x97, 0x65, 0x7f, 0x4f, 0x72, 0x1f, 0x2f, 0xeb, 0x7e, 0x9d,
		0xf4, 0xbe, 0x9c, 0xf4, 0xfe, 0x9b, 0xfc, 0x3e, 0x9b, 0x9c, 0x9b, 0x7f, 0xa4, 0x0c, 0xea, 0x64,
		0xba, 0x41, 0xf9, 0x3c, 0xbd, 0x19, 0x2e, 0x4a, 0x66, 0x14, 0xaa, 0xcd, 0x2c, 0x50, 0x2b, 0xb3,
		0xbd, 0xab, 0xb8, 0x9d, 0x2b, 0xbb, 0x7d, 0xab, 0xbc, 0x5d, 0xab, 0xbc, 0x3d, 0xab, 0xbe, 0x1d,
		0xab, 0x57, 0x8f, 0xb3, 0x0a, 0xcb, 0x3a, 0x83, 0xf9, 0x6a, 0x4a, 0x4a, 0x20, 0xcf, 0x9e, 0xcb,
		0x59, 0x03, 0x79, 0x1f, 0x0d, 0x64, 0x63, 0xae, 0xa8, 0xef, 0x92, 0xb6, 0xe0, 0xf9, 0x37, 0x05,
		0xf0, 0xcb, 0xd3, 0xcf, 0x2f, 0x52, 0x2e, 0xad, 0x51, 0xfd, 0xbb, 0x8b, 0x3f, 0xdf, 0x7e, 0xfa,
		0xeb, 0xfd, 0xa7, 0x9f, 0xfd, 0x99, 0xcf, 0x6f, 0x50, 0xfc, 0x7c, 0x72, 0xa3, 0xd8, 0x1f, 0xca,
		0xc7, 0xfe, 0xfc, 0x41, 0xb9, 0xe0, 0xdf, 0x27, 0xf8, 0x09, 0xfe, 0xd7, 0xaf, 0x23, 0x7d, 0x0c,
		0x68, 0x71, 0x31, 0x5e, 0x78, 0x3f, 0xe4, 0x8e, 0xfe, 0x3c, 0x57, 0x21, 0x09, 0xcd, 0x46, 0xe7,
		0x6a, 0x96, 0x5f, 0xf6, 0xf6, 0xa6, 0xdd, 0xfe, 0x97, 0xb9, 0xf3, 0xf3, 0x95, 0x02, 0xbe, 0x52,
		0xb0, 0x25, 0x41, 0x2a, 0xfd, 0x95, 0x02, 0xb4, 0xc6, 0x77, 0x37, 0xe4, 0xe4, 0xba, 0xce, 0x6e,
		0xcc, 0xe9, 0x8d, 0x39, 0xbf, 0xb9, 0x20, 0x50, 0xa4, 0xb5, 0xd1, 0x1a, 0x57, 0x99, 0x0b, 0x69,
		0x34, 0xa9, 0x89, 0x2a, 0x89, 0x75, 0x62, 0xbd, 0x84, 0xb1, 0x3e, 0xf6, 0xc3, 0xb4, 0x5a, 0xd7,
		0x88, 0xf5, 0x3a, 0x7a, 0xe3, 0x6a, 0xc3, 0xa0, 0x37, 0x9e, 0xfb, 0xd4, 0xd6, 0x8f, 0x8e, 0x0e,
		0x90, 0x1a, 0xff, 0x94, 0xea, 0xfb, 0x20, 0xc2, 0x61, 0x14, 0x6b, 0xd5, 0xdf, 0xc5, 0x10, 0x54,
		0x60, 0x2a, 0x30, 0x68, 0x7b, 0xf3, 0x68, 0xdb, 0x4e, 0x5a, 0x7d, 0x43, 0x87, 0x64, 0x56, 0xb3,
		0xea, 0xc5, 0x3b, 0x22, 0x93, 0xad, 0xcd, 0xe1, 0x90, 0xcc, 0x26, 0x7c, 0x33, 0xbf, 0x23, 0x32,
		0x2b, 0xbd, 0xd1, 0x96, 0x03, 0x32, 0x59, 0x0f, 0x90, 0x18, 0x9c, 0x3f, 0x9d, 0x23, 0x32, 0xeb,
		0xe9, 0xf3, 0x4c, 0x74, 0x79, 0xe6, 0xa3, 0x30, 0x35, 0x8e, 0xc2, 0x18, 0x3f, 0x0a, 0x93, 0xbf,
		0x43, 0x7f, 0x54, 0xa2, 0x14, 0x9d, 0x78, 0x4d, 0xf1, 0x59, 0xe1, 0xb9, 0x3b, 0x6b, 0xe6, 0xe2,
		0xa3, 0x39, 0x50, 0xb7, 0xdd, 0x59, 0x19, 0x30, 0x0a, 0xd6, 0xbe, 0xb4, 0x73, 0x61, 0xcd, 0xf4,
		0xff, 0x66, 0xf6, 0xbc, 0x67, 0x87, 0xe3, 0x27, 0xdf, 0xbc, 0x5f, 0xa2, 0x17, 0x45, 0x6f, 0x5d,
		0xee, 0xb5, 0x6d, 0xce, 0xf2, 0xaf, 0x5e, 0xbc, 0xe9, 0xf2, 0x8b, 0xfc, 0xd9, 0xf9, 0xf3, 0x3f,
		0x00, 0x00, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0xc4, 0x58, 0x11, 0x83, 0xc0, 0xed,
		0x12, 0x00,
	}
)


// ΛEnumTypes is a map, keyed by a YANG schema path, of the enumerated types that
// correspond with the leaf. The type is represented as a reflect.Type. The naming
// of the map ensures that there are no clashes with valid YANG identifiers.
var ΛEnumTypes = map[string][]reflect.Type{
	"/components/component/port/breakout-mode/config/channel-speed": []reflect.Type{
		reflect.TypeOf((E_OpenconfigIfEthernet_ETHERNET_SPEED)(0)),
	},
	"/components/component/port/breakout-mode/state/channel-speed": []reflect.Type{
		reflect.TypeOf((E_OpenconfigIfEthernet_ETHERNET_SPEED)(0)),
	},
	"/components/component/state/oper-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS)(0)),
	},
	"/components/component/state/temperature/alarm-severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY)(0)),
	},
	"/components/component/state/type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT)(0)),
		reflect.TypeOf((E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT)(0)),
	},
	"/components/component/transceiver/config/ethernet-pmd-preconf": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE)(0)),
	},
	"/components/component/transceiver/config/fec-mode": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_FEC_MODE_TYPE)(0)),
	},
	"/components/component/transceiver/config/form-factor-preconf": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE)(0)),
	},
	"/components/component/transceiver/state/connector-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_FIBER_CONNECTOR_TYPE)(0)),
	},
	"/components/component/transceiver/state/ethernet-pmd": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE)(0)),
	},
	"/components/component/transceiver/state/ethernet-pmd-preconf": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_ETHERNET_PMD_TYPE)(0)),
	},
	"/components/component/transceiver/state/fec-mode": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_FEC_MODE_TYPE)(0)),
	},
	"/components/component/transceiver/state/fec-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_FEC_STATUS_TYPE)(0)),
	},
	"/components/component/transceiver/state/form-factor": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE)(0)),
	},
	"/components/component/transceiver/state/form-factor-preconf": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_TRANSCEIVER_FORM_FACTOR_TYPE)(0)),
	},
	"/components/component/transceiver/state/otn-compliance-code": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_OTN_APPLICATION_CODE)(0)),
	},
	"/components/component/transceiver/state/present": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatform_Components_Component_Transceiver_State_Present)(0)),
	},
	"/components/component/transceiver/state/sonet-sdh-compliance-code": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_SONET_APPLICATION_CODE)(0)),
	},
	"/interfaces-state/interface/admin-status": []reflect.Type{
		reflect.TypeOf((E_IETFInterfaces_InterfacesState_Interface_AdminStatus)(0)),
	},
	"/interfaces-state/interface/oper-status": []reflect.Type{
		reflect.TypeOf((E_IETFInterfaces_InterfacesState_Interface_OperStatus)(0)),
	},
	"/interfaces-state/interface/type": []reflect.Type{
		reflect.TypeOf((E_IETFInterfaces_InterfaceType)(0)),
	},
	"/interfaces/interface/config/type": []reflect.Type{
		reflect.TypeOf((E_IETFInterfaces_InterfaceType)(0)),
	},
	"/interfaces/interface/ethernet/config/duplex-mode": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode)(0)),
	},
	"/interfaces/interface/ethernet/config/port-speed": []reflect.Type{
		reflect.TypeOf((E_OpenconfigIfEthernet_ETHERNET_SPEED)(0)),
	},
	"/interfaces/interface/ethernet/state/duplex-mode": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode)(0)),
	},
	"/interfaces/interface/ethernet/state/negotiated-duplex-mode": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode)(0)),
	},
	"/interfaces/interface/ethernet/state/negotiated-port-speed": []reflect.Type{
		reflect.TypeOf((E_OpenconfigIfEthernet_ETHERNET_SPEED)(0)),
	},
	"/interfaces/interface/ethernet/state/port-speed": []reflect.Type{
		reflect.TypeOf((E_OpenconfigIfEthernet_ETHERNET_SPEED)(0)),
	},
	"/interfaces/interface/state/admin-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus)(0)),
	},
	"/interfaces/interface/state/oper-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus)(0)),
	},
	"/interfaces/interface/state/type": []reflect.Type{
		reflect.TypeOf((E_IETFInterfaces_InterfaceType)(0)),
	},
	"/interfaces/interface/subinterfaces/subinterface/state/admin-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus)(0)),
	},
	"/interfaces/interface/subinterfaces/subinterface/state/oper-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus)(0)),
	},
	"/lldp/config/chassis-id-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigLldp_ChassisIdType)(0)),
	},
	"/lldp/config/suppress-tlv-advertisement": []reflect.Type{
		reflect.TypeOf((E_OpenconfigLldpTypes_LLDP_TLV)(0)),
	},
	"/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/name": []reflect.Type{
		reflect.TypeOf((E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY)(0)),
	},
	"/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state/name": []reflect.Type{
		reflect.TypeOf((E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY)(0)),
	},
	"/lldp/interfaces/interface/neighbors/neighbor/state/chassis-id-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigLldp_ChassisIdType)(0)),
	},
	"/lldp/interfaces/interface/neighbors/neighbor/state/port-id-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigLldp_PortIdType)(0)),
	},
	"/lldp/state/chassis-id-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigLldp_ChassisIdType)(0)),
	},
	"/lldp/state/suppress-tlv-advertisement": []reflect.Type{
		reflect.TypeOf((E_OpenconfigLldpTypes_LLDP_TLV)(0)),
	},
	"/terminal-device/logical-channels/channel/config/admin-state": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTerminalDevice_AdminStateType)(0)),
	},
	"/terminal-device/logical-channels/channel/config/logical-channel-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE)(0)),
	},
	"/terminal-device/logical-channels/channel/config/loopback-mode": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTerminalDevice_LoopbackModeType)(0)),
	},
	"/terminal-device/logical-channels/channel/config/rate-class": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE)(0)),
	},
	"/terminal-device/logical-channels/channel/config/trib-protocol": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE)(0)),
	},
	"/terminal-device/logical-channels/channel/ethernet/config/client-als": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls)(0)),
	},
	"/terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/state/chassis-id-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigLldp_ChassisIdType)(0)),
	},
	"/terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/state/port-id-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigLldp_PortIdType)(0)),
	},
	"/terminal-device/logical-channels/channel/ethernet/state/client-als": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_Ethernet_Config_ClientAls)(0)),
	},
	"/terminal-device/logical-channels/channel/logical-channel-assignments/assignment/config/assignment-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType)(0)),
	},
	"/terminal-device/logical-channels/channel/logical-channel-assignments/assignment/config/mapping": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL)(0)),
	},
	"/terminal-device/logical-channels/channel/logical-channel-assignments/assignment/state/assignment-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_LogicalChannelAssignments_Assignment_Config_AssignmentType)(0)),
	},
	"/terminal-device/logical-channels/channel/logical-channel-assignments/assignment/state/mapping": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_FRAME_MAPPING_PROTOCOL)(0)),
	},
	"/terminal-device/logical-channels/channel/otn/config/tributary-slot-granularity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY)(0)),
	},
	"/terminal-device/logical-channels/channel/otn/state/tributary-slot-granularity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_TRIBUTARY_SLOT_GRANULARITY)(0)),
	},
	"/terminal-device/logical-channels/channel/state/admin-state": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTerminalDevice_AdminStateType)(0)),
	},
	"/terminal-device/logical-channels/channel/state/link-state": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTerminalDevice_TerminalDevice_LogicalChannels_Channel_State_LinkState)(0)),
	},
	"/terminal-device/logical-channels/channel/state/logical-channel-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_LOGICAL_ELEMENT_PROTOCOL_TYPE)(0)),
	},
	"/terminal-device/logical-channels/channel/state/loopback-mode": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTerminalDevice_LoopbackModeType)(0)),
	},
	"/terminal-device/logical-channels/channel/state/rate-class": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_TRIBUTARY_RATE_CLASS_TYPE)(0)),
	},
	"/terminal-device/logical-channels/channel/state/trib-protocol": []reflect.Type{
		reflect.TypeOf((E_OpenconfigTransportTypes_TRIBUTARY_PROTOCOL_TYPE)(0)),
	},
}

