# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import last_switchover_reason
from . import temperature
from . import memory
from . import pcie
class state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each component
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__id','__location','__description','__mfg_name','__mfg_date','__hardware_version','__firmware_version','__software_version','__serial_no','__part_no','__clei_code','__removable','__oper_status','__empty','__parent','__redundant_role','__last_switchover_reason','__last_switchover_time','__last_reboot_reason','__last_reboot_time','__switchover_ready','__temperature','__memory','__allocated_power','__used_power','__pcie',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__location = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__mfg_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__mfg_date = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)
    self.__hardware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__firmware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__software_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__serial_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__part_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__clei_code = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="clei-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__removable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    self.__empty = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    self.__parent = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)
    self.__redundant_role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)
    self.__last_switchover_reason = YANGDynClass(base=last_switchover_reason.last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__last_switchover_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    self.__last_reboot_reason = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    self.__last_reboot_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    self.__switchover_ready = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="switchover-ready", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    self.__temperature = YANGDynClass(base=temperature.temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__memory = YANGDynClass(base=memory.memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__allocated_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    self.__used_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    self.__pcie = YANGDynClass(base=pcie.pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/state/name (string)

    YANG Description: Device name for the component -- this may not be a
configurable parameter on many implementations.  Where
component preconfiguration is supported, for example,
the component name may be configurable.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Device name for the component -- this may not be a
configurable parameter on many implementations.  Where
component preconfiguration is supported, for example,
the component name may be configurable.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /components/component/state/type (union)

    YANG Description: Type of component as identified by the system
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /components/component/state/type (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of component as identified by the system
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with union""",
          'defined-type': "openconfig-platform:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)


  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /components/component/state/id (string)

    YANG Description: Unique identifier assigned by the system for the
component
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /components/component/state/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Unique identifier assigned by the system for the
component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_location(self):
    """
    Getter method for location, mapped from YANG variable /components/component/state/location (string)

    YANG Description: System-supplied description of the location of the
component within the system. This could be a bay position,
slot number, socket location, etc. For component types that
have an explicit slot-id attribute, such as linecards, the
system should populate the more specific slot-id.
    """
    return self.__location
      
  def _set_location(self, v, load=False):
    """
    Setter method for location, mapped from YANG variable /components/component/state/location (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_location is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_location() directly.

    YANG Description: System-supplied description of the location of the
component within the system. This could be a bay position,
slot number, socket location, etc. For component types that
have an explicit slot-id attribute, such as linecards, the
system should populate the more specific slot-id.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """location must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__location = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_location(self):
    self.__location = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /components/component/state/description (string)

    YANG Description: System-supplied description of the component
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /components/component/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: System-supplied description of the component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_mfg_name(self):
    """
    Getter method for mfg_name, mapped from YANG variable /components/component/state/mfg_name (string)

    YANG Description: System-supplied identifier for the manufacturer of the
component.  This data is particularly useful when a
component manufacturer is different than the overall
device vendor.
    """
    return self.__mfg_name
      
  def _set_mfg_name(self, v, load=False):
    """
    Setter method for mfg_name, mapped from YANG variable /components/component/state/mfg_name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mfg_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mfg_name() directly.

    YANG Description: System-supplied identifier for the manufacturer of the
component.  This data is particularly useful when a
component manufacturer is different than the overall
device vendor.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mfg_name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__mfg_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mfg_name(self):
    self.__mfg_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_mfg_date(self):
    """
    Getter method for mfg_date, mapped from YANG variable /components/component/state/mfg_date (oc-yang:date)

    YANG Description: System-supplied representation of the component's
manufacturing date.
    """
    return self.__mfg_date
      
  def _set_mfg_date(self, v, load=False):
    """
    Setter method for mfg_date, mapped from YANG variable /components/component/state/mfg_date (oc-yang:date)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mfg_date is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mfg_date() directly.

    YANG Description: System-supplied representation of the component's
manufacturing date.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mfg_date must be of a type compatible with oc-yang:date""",
          'defined-type': "oc-yang:date",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)""",
        })

    self.__mfg_date = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mfg_date(self):
    self.__mfg_date = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)


  def _get_hardware_version(self):
    """
    Getter method for hardware_version, mapped from YANG variable /components/component/state/hardware_version (string)

    YANG Description: For hardware components, this is the hardware revision of
the component.
    """
    return self.__hardware_version
      
  def _set_hardware_version(self, v, load=False):
    """
    Setter method for hardware_version, mapped from YANG variable /components/component/state/hardware_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hardware_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hardware_version() directly.

    YANG Description: For hardware components, this is the hardware revision of
the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hardware_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__hardware_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hardware_version(self):
    self.__hardware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_firmware_version(self):
    """
    Getter method for firmware_version, mapped from YANG variable /components/component/state/firmware_version (string)

    YANG Description: For hardware components, this is the version of associated
firmware that is running on the component, if applicable.
    """
    return self.__firmware_version
      
  def _set_firmware_version(self, v, load=False):
    """
    Setter method for firmware_version, mapped from YANG variable /components/component/state/firmware_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_firmware_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_firmware_version() directly.

    YANG Description: For hardware components, this is the version of associated
firmware that is running on the component, if applicable.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """firmware_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__firmware_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_firmware_version(self):
    self.__firmware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_software_version(self):
    """
    Getter method for software_version, mapped from YANG variable /components/component/state/software_version (string)

    YANG Description: For software components such as operating system or other
software module, this is the version of the currently
running software.
    """
    return self.__software_version
      
  def _set_software_version(self, v, load=False):
    """
    Setter method for software_version, mapped from YANG variable /components/component/state/software_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_software_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_software_version() directly.

    YANG Description: For software components such as operating system or other
software module, this is the version of the currently
running software.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """software_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__software_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_software_version(self):
    self.__software_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_serial_no(self):
    """
    Getter method for serial_no, mapped from YANG variable /components/component/state/serial_no (string)

    YANG Description: System-assigned serial number of the component.
    """
    return self.__serial_no
      
  def _set_serial_no(self, v, load=False):
    """
    Setter method for serial_no, mapped from YANG variable /components/component/state/serial_no (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_serial_no is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_serial_no() directly.

    YANG Description: System-assigned serial number of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """serial_no must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__serial_no = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_serial_no(self):
    self.__serial_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_part_no(self):
    """
    Getter method for part_no, mapped from YANG variable /components/component/state/part_no (string)

    YANG Description: System-assigned part number for the component.  This should
be present in particular if the component is also an FRU
(field replaceable unit)
    """
    return self.__part_no
      
  def _set_part_no(self, v, load=False):
    """
    Setter method for part_no, mapped from YANG variable /components/component/state/part_no (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_part_no is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_part_no() directly.

    YANG Description: System-assigned part number for the component.  This should
be present in particular if the component is also an FRU
(field replaceable unit)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """part_no must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__part_no = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_part_no(self):
    self.__part_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_clei_code(self):
    """
    Getter method for clei_code, mapped from YANG variable /components/component/state/clei_code (string)

    YANG Description: Common Language Equipment Identifier (CLEI) code of the
component.  This should be present in particular if the
component is also an FRU (field replaceable unit)
    """
    return self.__clei_code
      
  def _set_clei_code(self, v, load=False):
    """
    Setter method for clei_code, mapped from YANG variable /components/component/state/clei_code (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_clei_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_clei_code() directly.

    YANG Description: Common Language Equipment Identifier (CLEI) code of the
component.  This should be present in particular if the
component is also an FRU (field replaceable unit)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="clei-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """clei_code must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="clei-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__clei_code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_clei_code(self):
    self.__clei_code = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="clei-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_removable(self):
    """
    Getter method for removable, mapped from YANG variable /components/component/state/removable (boolean)

    YANG Description: If true, this component is removable or is a field
replaceable unit
    """
    return self.__removable
      
  def _set_removable(self, v, load=False):
    """
    Setter method for removable, mapped from YANG variable /components/component/state/removable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_removable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_removable() directly.

    YANG Description: If true, this component is removable or is a field
replaceable unit
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """removable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)""",
        })

    self.__removable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_removable(self):
    self.__removable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)


  def _get_oper_status(self):
    """
    Getter method for oper_status, mapped from YANG variable /components/component/state/oper_status (identityref)

    YANG Description: If applicable, this reports the current operational status
of the component.
    """
    return self.__oper_status
      
  def _set_oper_status(self, v, load=False):
    """
    Setter method for oper_status, mapped from YANG variable /components/component/state/oper_status (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oper_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oper_status() directly.

    YANG Description: If applicable, this reports the current operational status
of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oper_status must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)""",
        })

    self.__oper_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oper_status(self):
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)


  def _get_empty(self):
    """
    Getter method for empty, mapped from YANG variable /components/component/state/empty (boolean)

    YANG Description: The empty leaf may be used by the device to indicate that a
component position exists but is not populated.  Using this
flag, it is possible for the management system to learn how
many positions are available (e.g., occupied vs. empty
linecard slots in a chassis).
    """
    return self.__empty
      
  def _set_empty(self, v, load=False):
    """
    Setter method for empty, mapped from YANG variable /components/component/state/empty (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_empty is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_empty() directly.

    YANG Description: The empty leaf may be used by the device to indicate that a
component position exists but is not populated.  Using this
flag, it is possible for the management system to learn how
many positions are available (e.g., occupied vs. empty
linecard slots in a chassis).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """empty must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)""",
        })

    self.__empty = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_empty(self):
    self.__empty = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)


  def _get_parent(self):
    """
    Getter method for parent, mapped from YANG variable /components/component/state/parent (leafref)

    YANG Description: Reference to the name of the parent component.  Note that
this reference must be kept synchronized with the
corresponding subcomponent reference from the parent
component.
    """
    return self.__parent
      
  def _set_parent(self, v, load=False):
    """
    Setter method for parent, mapped from YANG variable /components/component/state/parent (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_parent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_parent() directly.

    YANG Description: Reference to the name of the parent component.  Note that
this reference must be kept synchronized with the
corresponding subcomponent reference from the parent
component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """parent must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)""",
        })

    self.__parent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_parent(self):
    self.__parent = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)


  def _get_redundant_role(self):
    """
    Getter method for redundant_role, mapped from YANG variable /components/component/state/redundant_role (oc-platform-types:component-redundant-role)

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the role of the component.
    """
    return self.__redundant_role
      
  def _set_redundant_role(self, v, load=False):
    """
    Setter method for redundant_role, mapped from YANG variable /components/component/state/redundant_role (oc-platform-types:component-redundant-role)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_redundant_role is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_redundant_role() directly.

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the role of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """redundant_role must be of a type compatible with oc-platform-types:component-redundant-role""",
          'defined-type': "oc-platform-types:component-redundant-role",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)""",
        })

    self.__redundant_role = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_redundant_role(self):
    self.__redundant_role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)


  def _get_last_switchover_reason(self):
    """
    Getter method for last_switchover_reason, mapped from YANG variable /components/component/state/last_switchover_reason (container)

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the reason of the last change of the
component's role.
    """
    return self.__last_switchover_reason
      
  def _set_last_switchover_reason(self, v, load=False):
    """
    Setter method for last_switchover_reason, mapped from YANG variable /components/component/state/last_switchover_reason (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_switchover_reason is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_switchover_reason() directly.

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the reason of the last change of the
component's role.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=last_switchover_reason.last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_switchover_reason must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=last_switchover_reason.last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__last_switchover_reason = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_switchover_reason(self):
    self.__last_switchover_reason = YANGDynClass(base=last_switchover_reason.last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_last_switchover_time(self):
    """
    Getter method for last_switchover_time, mapped from YANG variable /components/component/state/last_switchover_time (oc-types:timeticks64)

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as
secondary), this reports the time of the last change of
the component's role. The value is the timestamp in
nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_switchover_time
      
  def _set_last_switchover_time(self, v, load=False):
    """
    Setter method for last_switchover_time, mapped from YANG variable /components/component/state/last_switchover_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_switchover_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_switchover_time() directly.

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as
secondary), this reports the time of the last change of
the component's role. The value is the timestamp in
nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_switchover_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_switchover_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_switchover_time(self):
    self.__last_switchover_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)


  def _get_last_reboot_reason(self):
    """
    Getter method for last_reboot_reason, mapped from YANG variable /components/component/state/last_reboot_reason (identityref)

    YANG Description: This reports the reason of the last reboot of the component.
    """
    return self.__last_reboot_reason
      
  def _set_last_reboot_reason(self, v, load=False):
    """
    Setter method for last_reboot_reason, mapped from YANG variable /components/component/state/last_reboot_reason (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_reboot_reason is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_reboot_reason() directly.

    YANG Description: This reports the reason of the last reboot of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_reboot_reason must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)""",
        })

    self.__last_reboot_reason = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_reboot_reason(self):
    self.__last_reboot_reason = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)


  def _get_last_reboot_time(self):
    """
    Getter method for last_reboot_time, mapped from YANG variable /components/component/state/last_reboot_time (oc-types:timeticks64)

    YANG Description: This reports the time of the last reboot of the component. The
value is the timestamp in nanoseconds relative to the Unix Epoch
(Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_reboot_time
      
  def _set_last_reboot_time(self, v, load=False):
    """
    Setter method for last_reboot_time, mapped from YANG variable /components/component/state/last_reboot_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_reboot_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_reboot_time() directly.

    YANG Description: This reports the time of the last reboot of the component. The
value is the timestamp in nanoseconds relative to the Unix Epoch
(Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_reboot_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_reboot_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_reboot_time(self):
    self.__last_reboot_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)


  def _get_switchover_ready(self):
    """
    Getter method for switchover_ready, mapped from YANG variable /components/component/state/switchover_ready (boolean)

    YANG Description: For components that have redundant roles, this reports a value
that indicates if the component is ready to support failover.

The components with a redundant-role should reflect the overall
system's switchover status.  For example, two supervisors in a
device, one as primary and the other as secondary, should both
report the same value.
    """
    return self.__switchover_ready
      
  def _set_switchover_ready(self, v, load=False):
    """
    Setter method for switchover_ready, mapped from YANG variable /components/component/state/switchover_ready (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_switchover_ready is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_switchover_ready() directly.

    YANG Description: For components that have redundant roles, this reports a value
that indicates if the component is ready to support failover.

The components with a redundant-role should reflect the overall
system's switchover status.  For example, two supervisors in a
device, one as primary and the other as secondary, should both
report the same value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="switchover-ready", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """switchover_ready must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="switchover-ready", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)""",
        })

    self.__switchover_ready = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_switchover_ready(self):
    self.__switchover_ready = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="switchover-ready", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)


  def _get_temperature(self):
    """
    Getter method for temperature, mapped from YANG variable /components/component/state/temperature (container)

    YANG Description: Temperature in degrees Celsius of the component. Values include
the instantaneous, average, minimum, and maximum statistics. If
avg/min/max statistics are not supported, the target is expected
to just supply the instant value
    """
    return self.__temperature
      
  def _set_temperature(self, v, load=False):
    """
    Setter method for temperature, mapped from YANG variable /components/component/state/temperature (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_temperature is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_temperature() directly.

    YANG Description: Temperature in degrees Celsius of the component. Values include
the instantaneous, average, minimum, and maximum statistics. If
avg/min/max statistics are not supported, the target is expected
to just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=temperature.temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """temperature must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=temperature.temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__temperature = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_temperature(self):
    self.__temperature = YANGDynClass(base=temperature.temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_memory(self):
    """
    Getter method for memory, mapped from YANG variable /components/component/state/memory (container)

    YANG Description: For components that have associated memory, these values
report information about available and utilized memory.
    """
    return self.__memory
      
  def _set_memory(self, v, load=False):
    """
    Setter method for memory, mapped from YANG variable /components/component/state/memory (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_memory is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_memory() directly.

    YANG Description: For components that have associated memory, these values
report information about available and utilized memory.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=memory.memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """memory must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=memory.memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__memory = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_memory(self):
    self.__memory = YANGDynClass(base=memory.memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_allocated_power(self):
    """
    Getter method for allocated_power, mapped from YANG variable /components/component/state/allocated_power (uint32)

    YANG Description: Power allocated by the system for the component.
    """
    return self.__allocated_power
      
  def _set_allocated_power(self, v, load=False):
    """
    Setter method for allocated_power, mapped from YANG variable /components/component/state/allocated_power (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_allocated_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_allocated_power() directly.

    YANG Description: Power allocated by the system for the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """allocated_power must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)""",
        })

    self.__allocated_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_allocated_power(self):
    self.__allocated_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)


  def _get_used_power(self):
    """
    Getter method for used_power, mapped from YANG variable /components/component/state/used_power (uint32)

    YANG Description: Actual power used by the component.
    """
    return self.__used_power
      
  def _set_used_power(self, v, load=False):
    """
    Setter method for used_power, mapped from YANG variable /components/component/state/used_power (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_used_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_used_power() directly.

    YANG Description: Actual power used by the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """used_power must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)""",
        })

    self.__used_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_used_power(self):
    self.__used_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)


  def _get_pcie(self):
    """
    Getter method for pcie, mapped from YANG variable /components/component/state/pcie (container)

    YANG Description: Components that are connected to the system over the Peripheral
Component Interconnect Express (PCIe), report the fatal, non-fatal
and correctable PCIe error counts.
    """
    return self.__pcie
      
  def _set_pcie(self, v, load=False):
    """
    Setter method for pcie, mapped from YANG variable /components/component/state/pcie (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_pcie is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_pcie() directly.

    YANG Description: Components that are connected to the system over the Peripheral
Component Interconnect Express (PCIe), report the fatal, non-fatal
and correctable PCIe error counts.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=pcie.pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """pcie must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=pcie.pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__pcie = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_pcie(self):
    self.__pcie = YANGDynClass(base=pcie.pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)
  id = __builtin__.property(_get_id)
  location = __builtin__.property(_get_location)
  description = __builtin__.property(_get_description)
  mfg_name = __builtin__.property(_get_mfg_name)
  mfg_date = __builtin__.property(_get_mfg_date)
  hardware_version = __builtin__.property(_get_hardware_version)
  firmware_version = __builtin__.property(_get_firmware_version)
  software_version = __builtin__.property(_get_software_version)
  serial_no = __builtin__.property(_get_serial_no)
  part_no = __builtin__.property(_get_part_no)
  clei_code = __builtin__.property(_get_clei_code)
  removable = __builtin__.property(_get_removable)
  oper_status = __builtin__.property(_get_oper_status)
  empty = __builtin__.property(_get_empty)
  parent = __builtin__.property(_get_parent)
  redundant_role = __builtin__.property(_get_redundant_role)
  last_switchover_reason = __builtin__.property(_get_last_switchover_reason)
  last_switchover_time = __builtin__.property(_get_last_switchover_time)
  last_reboot_reason = __builtin__.property(_get_last_reboot_reason)
  last_reboot_time = __builtin__.property(_get_last_reboot_time)
  switchover_ready = __builtin__.property(_get_switchover_ready)
  temperature = __builtin__.property(_get_temperature)
  memory = __builtin__.property(_get_memory)
  allocated_power = __builtin__.property(_get_allocated_power)
  used_power = __builtin__.property(_get_used_power)
  pcie = __builtin__.property(_get_pcie)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('id', id), ('location', location), ('description', description), ('mfg_name', mfg_name), ('mfg_date', mfg_date), ('hardware_version', hardware_version), ('firmware_version', firmware_version), ('software_version', software_version), ('serial_no', serial_no), ('part_no', part_no), ('clei_code', clei_code), ('removable', removable), ('oper_status', oper_status), ('empty', empty), ('parent', parent), ('redundant_role', redundant_role), ('last_switchover_reason', last_switchover_reason), ('last_switchover_time', last_switchover_time), ('last_reboot_reason', last_reboot_reason), ('last_reboot_time', last_reboot_time), ('switchover_ready', switchover_ready), ('temperature', temperature), ('memory', memory), ('allocated_power', allocated_power), ('used_power', used_power), ('pcie', pcie), ])


from . import last_switchover_reason
from . import temperature
from . import memory
from . import pcie
class state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /components/component/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each component
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__id','__location','__description','__mfg_name','__mfg_date','__hardware_version','__firmware_version','__software_version','__serial_no','__part_no','__clei_code','__removable','__oper_status','__empty','__parent','__redundant_role','__last_switchover_reason','__last_switchover_time','__last_reboot_reason','__last_reboot_time','__switchover_ready','__temperature','__memory','__allocated_power','__used_power','__pcie',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__location = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__mfg_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__mfg_date = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)
    self.__hardware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__firmware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__software_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__serial_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__part_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__clei_code = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="clei-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__removable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    self.__empty = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    self.__parent = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)
    self.__redundant_role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)
    self.__last_switchover_reason = YANGDynClass(base=last_switchover_reason.last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__last_switchover_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    self.__last_reboot_reason = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    self.__last_reboot_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    self.__switchover_ready = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="switchover-ready", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    self.__temperature = YANGDynClass(base=temperature.temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__memory = YANGDynClass(base=memory.memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    self.__allocated_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    self.__used_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    self.__pcie = YANGDynClass(base=pcie.pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/state/name (string)

    YANG Description: Device name for the component -- this may not be a
configurable parameter on many implementations.  Where
component preconfiguration is supported, for example,
the component name may be configurable.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Device name for the component -- this may not be a
configurable parameter on many implementations.  Where
component preconfiguration is supported, for example,
the component name may be configurable.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /components/component/state/type (union)

    YANG Description: Type of component as identified by the system
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /components/component/state/type (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Type of component as identified by the system
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with union""",
          'defined-type': "openconfig-platform:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CHASSIS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BACKPLANE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FABRIC': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:POWER_SUPPLY': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FAN': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SENSOR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:FRU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:LINECARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CONTROLLER_CARD': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:PORT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:TRANSCEIVER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:CPU': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:STORAGE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INTEGRATED_CIRCUIT': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:OPERATING_SYSTEM_UPDATE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BIOS': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:BOOT_LOADER': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:SOFTWARE_MODULE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},),], is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='union', is_config=False)


  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /components/component/state/id (string)

    YANG Description: Unique identifier assigned by the system for the
component
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /components/component/state/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Unique identifier assigned by the system for the
component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_location(self):
    """
    Getter method for location, mapped from YANG variable /components/component/state/location (string)

    YANG Description: System-supplied description of the location of the
component within the system. This could be a bay position,
slot number, socket location, etc. For component types that
have an explicit slot-id attribute, such as linecards, the
system should populate the more specific slot-id.
    """
    return self.__location
      
  def _set_location(self, v, load=False):
    """
    Setter method for location, mapped from YANG variable /components/component/state/location (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_location is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_location() directly.

    YANG Description: System-supplied description of the location of the
component within the system. This could be a bay position,
slot number, socket location, etc. For component types that
have an explicit slot-id attribute, such as linecards, the
system should populate the more specific slot-id.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """location must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__location = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_location(self):
    self.__location = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="location", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /components/component/state/description (string)

    YANG Description: System-supplied description of the component
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /components/component/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: System-supplied description of the component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_mfg_name(self):
    """
    Getter method for mfg_name, mapped from YANG variable /components/component/state/mfg_name (string)

    YANG Description: System-supplied identifier for the manufacturer of the
component.  This data is particularly useful when a
component manufacturer is different than the overall
device vendor.
    """
    return self.__mfg_name
      
  def _set_mfg_name(self, v, load=False):
    """
    Setter method for mfg_name, mapped from YANG variable /components/component/state/mfg_name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mfg_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mfg_name() directly.

    YANG Description: System-supplied identifier for the manufacturer of the
component.  This data is particularly useful when a
component manufacturer is different than the overall
device vendor.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mfg_name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__mfg_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mfg_name(self):
    self.__mfg_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mfg-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_mfg_date(self):
    """
    Getter method for mfg_date, mapped from YANG variable /components/component/state/mfg_date (oc-yang:date)

    YANG Description: System-supplied representation of the component's
manufacturing date.
    """
    return self.__mfg_date
      
  def _set_mfg_date(self, v, load=False):
    """
    Setter method for mfg_date, mapped from YANG variable /components/component/state/mfg_date (oc-yang:date)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mfg_date is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mfg_date() directly.

    YANG Description: System-supplied representation of the component's
manufacturing date.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mfg_date must be of a type compatible with oc-yang:date""",
          'defined-type': "oc-yang:date",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)""",
        })

    self.__mfg_date = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mfg_date(self):
    self.__mfg_date = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9]{4}\\-(0[1-9]|1[0-2])\\-(0[1-9]|[12][0-9]|3[01])'}), is_leaf=True, yang_name="mfg-date", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:date', is_config=False)


  def _get_hardware_version(self):
    """
    Getter method for hardware_version, mapped from YANG variable /components/component/state/hardware_version (string)

    YANG Description: For hardware components, this is the hardware revision of
the component.
    """
    return self.__hardware_version
      
  def _set_hardware_version(self, v, load=False):
    """
    Setter method for hardware_version, mapped from YANG variable /components/component/state/hardware_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hardware_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hardware_version() directly.

    YANG Description: For hardware components, this is the hardware revision of
the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hardware_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__hardware_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hardware_version(self):
    self.__hardware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="hardware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_firmware_version(self):
    """
    Getter method for firmware_version, mapped from YANG variable /components/component/state/firmware_version (string)

    YANG Description: For hardware components, this is the version of associated
firmware that is running on the component, if applicable.
    """
    return self.__firmware_version
      
  def _set_firmware_version(self, v, load=False):
    """
    Setter method for firmware_version, mapped from YANG variable /components/component/state/firmware_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_firmware_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_firmware_version() directly.

    YANG Description: For hardware components, this is the version of associated
firmware that is running on the component, if applicable.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """firmware_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__firmware_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_firmware_version(self):
    self.__firmware_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="firmware-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_software_version(self):
    """
    Getter method for software_version, mapped from YANG variable /components/component/state/software_version (string)

    YANG Description: For software components such as operating system or other
software module, this is the version of the currently
running software.
    """
    return self.__software_version
      
  def _set_software_version(self, v, load=False):
    """
    Setter method for software_version, mapped from YANG variable /components/component/state/software_version (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_software_version is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_software_version() directly.

    YANG Description: For software components such as operating system or other
software module, this is the version of the currently
running software.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """software_version must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__software_version = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_software_version(self):
    self.__software_version = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="software-version", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_serial_no(self):
    """
    Getter method for serial_no, mapped from YANG variable /components/component/state/serial_no (string)

    YANG Description: System-assigned serial number of the component.
    """
    return self.__serial_no
      
  def _set_serial_no(self, v, load=False):
    """
    Setter method for serial_no, mapped from YANG variable /components/component/state/serial_no (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_serial_no is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_serial_no() directly.

    YANG Description: System-assigned serial number of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """serial_no must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__serial_no = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_serial_no(self):
    self.__serial_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="serial-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_part_no(self):
    """
    Getter method for part_no, mapped from YANG variable /components/component/state/part_no (string)

    YANG Description: System-assigned part number for the component.  This should
be present in particular if the component is also an FRU
(field replaceable unit)
    """
    return self.__part_no
      
  def _set_part_no(self, v, load=False):
    """
    Setter method for part_no, mapped from YANG variable /components/component/state/part_no (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_part_no is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_part_no() directly.

    YANG Description: System-assigned part number for the component.  This should
be present in particular if the component is also an FRU
(field replaceable unit)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """part_no must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__part_no = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_part_no(self):
    self.__part_no = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="part-no", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_clei_code(self):
    """
    Getter method for clei_code, mapped from YANG variable /components/component/state/clei_code (string)

    YANG Description: Common Language Equipment Identifier (CLEI) code of the
component.  This should be present in particular if the
component is also an FRU (field replaceable unit)
    """
    return self.__clei_code
      
  def _set_clei_code(self, v, load=False):
    """
    Setter method for clei_code, mapped from YANG variable /components/component/state/clei_code (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_clei_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_clei_code() directly.

    YANG Description: Common Language Equipment Identifier (CLEI) code of the
component.  This should be present in particular if the
component is also an FRU (field replaceable unit)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="clei-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """clei_code must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="clei-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__clei_code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_clei_code(self):
    self.__clei_code = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="clei-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_removable(self):
    """
    Getter method for removable, mapped from YANG variable /components/component/state/removable (boolean)

    YANG Description: If true, this component is removable or is a field
replaceable unit
    """
    return self.__removable
      
  def _set_removable(self, v, load=False):
    """
    Setter method for removable, mapped from YANG variable /components/component/state/removable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_removable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_removable() directly.

    YANG Description: If true, this component is removable or is a field
replaceable unit
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """removable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)""",
        })

    self.__removable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_removable(self):
    self.__removable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="removable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)


  def _get_oper_status(self):
    """
    Getter method for oper_status, mapped from YANG variable /components/component/state/oper_status (identityref)

    YANG Description: If applicable, this reports the current operational status
of the component.
    """
    return self.__oper_status
      
  def _set_oper_status(self, v, load=False):
    """
    Setter method for oper_status, mapped from YANG variable /components/component/state/oper_status (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oper_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oper_status() directly.

    YANG Description: If applicable, this reports the current operational status
of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oper_status must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)""",
        })

    self.__oper_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oper_status(self):
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:ACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:INACTIVE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:DISABLED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)


  def _get_empty(self):
    """
    Getter method for empty, mapped from YANG variable /components/component/state/empty (boolean)

    YANG Description: The empty leaf may be used by the device to indicate that a
component position exists but is not populated.  Using this
flag, it is possible for the management system to learn how
many positions are available (e.g., occupied vs. empty
linecard slots in a chassis).
    """
    return self.__empty
      
  def _set_empty(self, v, load=False):
    """
    Setter method for empty, mapped from YANG variable /components/component/state/empty (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_empty is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_empty() directly.

    YANG Description: The empty leaf may be used by the device to indicate that a
component position exists but is not populated.  Using this
flag, it is possible for the management system to learn how
many positions are available (e.g., occupied vs. empty
linecard slots in a chassis).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """empty must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)""",
        })

    self.__empty = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_empty(self):
    self.__empty = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="empty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)


  def _get_parent(self):
    """
    Getter method for parent, mapped from YANG variable /components/component/state/parent (leafref)

    YANG Description: Reference to the name of the parent component.  Note that
this reference must be kept synchronized with the
corresponding subcomponent reference from the parent
component.
    """
    return self.__parent
      
  def _set_parent(self, v, load=False):
    """
    Setter method for parent, mapped from YANG variable /components/component/state/parent (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_parent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_parent() directly.

    YANG Description: Reference to the name of the parent component.  Note that
this reference must be kept synchronized with the
corresponding subcomponent reference from the parent
component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """parent must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)""",
        })

    self.__parent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_parent(self):
    self.__parent = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=False)


  def _get_redundant_role(self):
    """
    Getter method for redundant_role, mapped from YANG variable /components/component/state/redundant_role (oc-platform-types:component-redundant-role)

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the role of the component.
    """
    return self.__redundant_role
      
  def _set_redundant_role(self, v, load=False):
    """
    Setter method for redundant_role, mapped from YANG variable /components/component/state/redundant_role (oc-platform-types:component-redundant-role)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_redundant_role is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_redundant_role() directly.

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the role of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """redundant_role must be of a type compatible with oc-platform-types:component-redundant-role""",
          'defined-type': "oc-platform-types:component-redundant-role",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)""",
        })

    self.__redundant_role = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_redundant_role(self):
    self.__redundant_role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'PRIMARY': {}, 'SECONDARY': {}},), is_leaf=True, yang_name="redundant-role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-platform-types:component-redundant-role', is_config=False)


  def _get_last_switchover_reason(self):
    """
    Getter method for last_switchover_reason, mapped from YANG variable /components/component/state/last_switchover_reason (container)

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the reason of the last change of the
component's role.
    """
    return self.__last_switchover_reason
      
  def _set_last_switchover_reason(self, v, load=False):
    """
    Setter method for last_switchover_reason, mapped from YANG variable /components/component/state/last_switchover_reason (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_switchover_reason is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_switchover_reason() directly.

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the reason of the last change of the
component's role.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=last_switchover_reason.last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_switchover_reason must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=last_switchover_reason.last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__last_switchover_reason = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_switchover_reason(self):
    self.__last_switchover_reason = YANGDynClass(base=last_switchover_reason.last_switchover_reason, is_container='container', yang_name="last-switchover-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_last_switchover_time(self):
    """
    Getter method for last_switchover_time, mapped from YANG variable /components/component/state/last_switchover_time (oc-types:timeticks64)

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as
secondary), this reports the time of the last change of
the component's role. The value is the timestamp in
nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_switchover_time
      
  def _set_last_switchover_time(self, v, load=False):
    """
    Setter method for last_switchover_time, mapped from YANG variable /components/component/state/last_switchover_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_switchover_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_switchover_time() directly.

    YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as
secondary), this reports the time of the last change of
the component's role. The value is the timestamp in
nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_switchover_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_switchover_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_switchover_time(self):
    self.__last_switchover_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-switchover-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)


  def _get_last_reboot_reason(self):
    """
    Getter method for last_reboot_reason, mapped from YANG variable /components/component/state/last_reboot_reason (identityref)

    YANG Description: This reports the reason of the last reboot of the component.
    """
    return self.__last_reboot_reason
      
  def _set_last_reboot_reason(self, v, load=False):
    """
    Setter method for last_reboot_reason, mapped from YANG variable /components/component/state/last_reboot_reason (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_reboot_reason is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_reboot_reason() directly.

    YANG Description: This reports the reason of the last reboot of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_reboot_reason must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)""",
        })

    self.__last_reboot_reason = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_reboot_reason(self):
    self.__last_reboot_reason = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_USER_INITIATED': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_POWER_FAILURE': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}, 'oc-platform-types:REBOOT_CRITICAL_ERROR': {'@module': 'openconfig-platform-types', '@namespace': 'http://openconfig.net/yang/platform-types'}},), is_leaf=True, yang_name="last-reboot-reason", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='identityref', is_config=False)


  def _get_last_reboot_time(self):
    """
    Getter method for last_reboot_time, mapped from YANG variable /components/component/state/last_reboot_time (oc-types:timeticks64)

    YANG Description: This reports the time of the last reboot of the component. The
value is the timestamp in nanoseconds relative to the Unix Epoch
(Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_reboot_time
      
  def _set_last_reboot_time(self, v, load=False):
    """
    Setter method for last_reboot_time, mapped from YANG variable /components/component/state/last_reboot_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_reboot_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_reboot_time() directly.

    YANG Description: This reports the time of the last reboot of the component. The
value is the timestamp in nanoseconds relative to the Unix Epoch
(Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_reboot_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_reboot_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_reboot_time(self):
    self.__last_reboot_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-reboot-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)


  def _get_switchover_ready(self):
    """
    Getter method for switchover_ready, mapped from YANG variable /components/component/state/switchover_ready (boolean)

    YANG Description: For components that have redundant roles, this reports a value
that indicates if the component is ready to support failover.

The components with a redundant-role should reflect the overall
system's switchover status.  For example, two supervisors in a
device, one as primary and the other as secondary, should both
report the same value.
    """
    return self.__switchover_ready
      
  def _set_switchover_ready(self, v, load=False):
    """
    Setter method for switchover_ready, mapped from YANG variable /components/component/state/switchover_ready (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_switchover_ready is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_switchover_ready() directly.

    YANG Description: For components that have redundant roles, this reports a value
that indicates if the component is ready to support failover.

The components with a redundant-role should reflect the overall
system's switchover status.  For example, two supervisors in a
device, one as primary and the other as secondary, should both
report the same value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="switchover-ready", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """switchover_ready must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="switchover-ready", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)""",
        })

    self.__switchover_ready = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_switchover_ready(self):
    self.__switchover_ready = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="switchover-ready", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='boolean', is_config=False)


  def _get_temperature(self):
    """
    Getter method for temperature, mapped from YANG variable /components/component/state/temperature (container)

    YANG Description: Temperature in degrees Celsius of the component. Values include
the instantaneous, average, minimum, and maximum statistics. If
avg/min/max statistics are not supported, the target is expected
to just supply the instant value
    """
    return self.__temperature
      
  def _set_temperature(self, v, load=False):
    """
    Setter method for temperature, mapped from YANG variable /components/component/state/temperature (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_temperature is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_temperature() directly.

    YANG Description: Temperature in degrees Celsius of the component. Values include
the instantaneous, average, minimum, and maximum statistics. If
avg/min/max statistics are not supported, the target is expected
to just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=temperature.temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """temperature must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=temperature.temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__temperature = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_temperature(self):
    self.__temperature = YANGDynClass(base=temperature.temperature, is_container='container', yang_name="temperature", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_memory(self):
    """
    Getter method for memory, mapped from YANG variable /components/component/state/memory (container)

    YANG Description: For components that have associated memory, these values
report information about available and utilized memory.
    """
    return self.__memory
      
  def _set_memory(self, v, load=False):
    """
    Setter method for memory, mapped from YANG variable /components/component/state/memory (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_memory is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_memory() directly.

    YANG Description: For components that have associated memory, these values
report information about available and utilized memory.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=memory.memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """memory must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=memory.memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__memory = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_memory(self):
    self.__memory = YANGDynClass(base=memory.memory, is_container='container', yang_name="memory", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)


  def _get_allocated_power(self):
    """
    Getter method for allocated_power, mapped from YANG variable /components/component/state/allocated_power (uint32)

    YANG Description: Power allocated by the system for the component.
    """
    return self.__allocated_power
      
  def _set_allocated_power(self, v, load=False):
    """
    Setter method for allocated_power, mapped from YANG variable /components/component/state/allocated_power (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_allocated_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_allocated_power() directly.

    YANG Description: Power allocated by the system for the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """allocated_power must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)""",
        })

    self.__allocated_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_allocated_power(self):
    self.__allocated_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="allocated-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)


  def _get_used_power(self):
    """
    Getter method for used_power, mapped from YANG variable /components/component/state/used_power (uint32)

    YANG Description: Actual power used by the component.
    """
    return self.__used_power
      
  def _set_used_power(self, v, load=False):
    """
    Setter method for used_power, mapped from YANG variable /components/component/state/used_power (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_used_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_used_power() directly.

    YANG Description: Actual power used by the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """used_power must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)""",
        })

    self.__used_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_used_power(self):
    self.__used_power = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="used-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint32', is_config=False)


  def _get_pcie(self):
    """
    Getter method for pcie, mapped from YANG variable /components/component/state/pcie (container)

    YANG Description: Components that are connected to the system over the Peripheral
Component Interconnect Express (PCIe), report the fatal, non-fatal
and correctable PCIe error counts.
    """
    return self.__pcie
      
  def _set_pcie(self, v, load=False):
    """
    Setter method for pcie, mapped from YANG variable /components/component/state/pcie (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_pcie is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_pcie() directly.

    YANG Description: Components that are connected to the system over the Peripheral
Component Interconnect Express (PCIe), report the fatal, non-fatal
and correctable PCIe error counts.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=pcie.pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """pcie must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=pcie.pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)""",
        })

    self.__pcie = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_pcie(self):
    self.__pcie = YANGDynClass(base=pcie.pcie, is_container='container', yang_name="pcie", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)
  id = __builtin__.property(_get_id)
  location = __builtin__.property(_get_location)
  description = __builtin__.property(_get_description)
  mfg_name = __builtin__.property(_get_mfg_name)
  mfg_date = __builtin__.property(_get_mfg_date)
  hardware_version = __builtin__.property(_get_hardware_version)
  firmware_version = __builtin__.property(_get_firmware_version)
  software_version = __builtin__.property(_get_software_version)
  serial_no = __builtin__.property(_get_serial_no)
  part_no = __builtin__.property(_get_part_no)
  clei_code = __builtin__.property(_get_clei_code)
  removable = __builtin__.property(_get_removable)
  oper_status = __builtin__.property(_get_oper_status)
  empty = __builtin__.property(_get_empty)
  parent = __builtin__.property(_get_parent)
  redundant_role = __builtin__.property(_get_redundant_role)
  last_switchover_reason = __builtin__.property(_get_last_switchover_reason)
  last_switchover_time = __builtin__.property(_get_last_switchover_time)
  last_reboot_reason = __builtin__.property(_get_last_reboot_reason)
  last_reboot_time = __builtin__.property(_get_last_reboot_time)
  switchover_ready = __builtin__.property(_get_switchover_ready)
  temperature = __builtin__.property(_get_temperature)
  memory = __builtin__.property(_get_memory)
  allocated_power = __builtin__.property(_get_allocated_power)
  used_power = __builtin__.property(_get_used_power)
  pcie = __builtin__.property(_get_pcie)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('id', id), ('location', location), ('description', description), ('mfg_name', mfg_name), ('mfg_date', mfg_date), ('hardware_version', hardware_version), ('firmware_version', firmware_version), ('software_version', software_version), ('serial_no', serial_no), ('part_no', part_no), ('clei_code', clei_code), ('removable', removable), ('oper_status', oper_status), ('empty', empty), ('parent', parent), ('redundant_role', redundant_role), ('last_switchover_reason', last_switchover_reason), ('last_switchover_time', last_switchover_time), ('last_reboot_reason', last_reboot_reason), ('last_reboot_time', last_reboot_time), ('switchover_ready', switchover_ready), ('temperature', temperature), ('memory', memory), ('allocated_power', allocated_power), ('used_power', used_power), ('pcie', pcie), ])


