from flask.app import Flask
from flask.helpers import url_for
import pytest
# from device.client.DeviceClient import DeviceClient
from webui.service import create_app

# @pytest.fixture(scope='session')
# def device_client(device_service):
#     _client = DeviceClient(address='127.0.0.1', port=100)
#     yield _client
#     _client.close()

@pytest.fixture
def app():

    app = create_app(use_config={'TESTING': True, 
                                 'SERVER_NAME': 'localhost.localdomain',
                                 'SECRET_KEY': '>s&}24@{]]#k3&^5$f3#?6?h3{W@[}/7z}2pa]>{3&5%RP<)[('})

    yield app

@pytest.fixture
def client(app):
    return app.test_client()

def test_routes(app):
    with app.app_context():
        url = url_for('main.home')
        url = url_for('service.home')

def test_home_page(client):
    assert client.get('/').status_code == 200

def test_service_home_page(client):
    response = client.get('/service/')
    assert response.status_code == 200
    assert b'Search' in response.data
