import copy
import random
from lorem_text import lorem
from flask import render_template, Blueprint, flash, session
from webui.Config import CONTEXT_SERVICE_ADDRESS, CONTEXT_SERVICE_PORT
from context.client.ContextClient import ContextClient
from webui.proto.context_pb2 import ContextId, ServiceList, ServiceTypeEnum, ServiceStatusEnum, ConfigActionEnum


service = Blueprint('service', __name__, url_prefix='/service')

@service.get('/')
def home():
    # flash('This is an info message', 'info')
    # flash('This is a danger message', 'danger')
    client: ContextClient = ContextClient(CONTEXT_SERVICE_ADDRESS, CONTEXT_SERVICE_PORT)
    client.connect()
    request: ContextId = ContextId()
    request.context_uuid.uuid = session['context_uuid']
    service_list: ServiceList = client.ListServices(request)
    # print(service_list)

    client.close()
    return render_template('service/home.html', services=service_list.services, 
                                                ste=ServiceTypeEnum,
                                                sse=ServiceStatusEnum,
                                                cae=ConfigActionEnum)


@service.route('add', methods=['GET', 'POST'])
def add():
    flash('Add service route called', 'danger')
    return render_template('service/home.html')


@service.get('detail/<service_uuid>')
def detail(service_uuid: str):
    flash('Detail service route called', 'danger')
    return render_template('service/home.html')
