# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import ingress_egress_bandwidth_profile
from . import ingress_bandwidth_profile
from . import egress_bandwidth_profile
class eth_link_tp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point/eth-link-tp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Attributes of the Ethernet Link Termination Point (LTP).
  """
  __slots__ = ('_path_helper', '_extmethods', '__ltp_mac_address','__port_vlan_id','__maximum_frame_size','__ingress_egress_bandwidth_profile','__ingress_bandwidth_profile','__egress_bandwidth_profile',)

  _yang_name = 'eth-link-tp'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__ltp_mac_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="ltp-mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='yang:mac-address', is_config=True)
    self.__port_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="port-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vlanid', is_config=True)
    self.__maximum_frame_size = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['64 .. 65535']}), is_leaf=True, yang_name="maximum-frame-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint16', is_config=True)
    self.__ingress_egress_bandwidth_profile = YANGDynClass(base=ingress_egress_bandwidth_profile.ingress_egress_bandwidth_profile, is_container='container', yang_name="ingress-egress-bandwidth-profile", parent=self, choice=('direction', 'symmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    self.__ingress_bandwidth_profile = YANGDynClass(base=ingress_bandwidth_profile.ingress_bandwidth_profile, is_container='container', yang_name="ingress-bandwidth-profile", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    self.__egress_bandwidth_profile = YANGDynClass(base=egress_bandwidth_profile.egress_bandwidth_profile, is_container='container', yang_name="egress-bandwidth-profile", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point', 'eth-link-tp']

  def _get_ltp_mac_address(self):
    """
    Getter method for ltp_mac_address, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ltp_mac_address (yang:mac-address)

    YANG Description: The MAC address of the Ethernet LTP.
    """
    return self.__ltp_mac_address
      
  def _set_ltp_mac_address(self, v, load=False):
    """
    Setter method for ltp_mac_address, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ltp_mac_address (yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ltp_mac_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ltp_mac_address() directly.

    YANG Description: The MAC address of the Ethernet LTP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="ltp-mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ltp_mac_address must be of a type compatible with yang:mac-address""",
          'defined-type': "yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="ltp-mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='yang:mac-address', is_config=True)""",
        })

    self.__ltp_mac_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ltp_mac_address(self):
    self.__ltp_mac_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="ltp-mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='yang:mac-address', is_config=True)


  def _get_port_vlan_id(self):
    """
    Getter method for port_vlan_id, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/port_vlan_id (etht-types:vlanid)

    YANG Description: The Port VLAN ID of the Ethernet LTP.
    """
    return self.__port_vlan_id
      
  def _set_port_vlan_id(self, v, load=False):
    """
    Setter method for port_vlan_id, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/port_vlan_id (etht-types:vlanid)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_vlan_id() directly.

    YANG Description: The Port VLAN ID of the Ethernet LTP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="port-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vlanid', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_vlan_id must be of a type compatible with etht-types:vlanid""",
          'defined-type': "etht-types:vlanid",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="port-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vlanid', is_config=True)""",
        })

    self.__port_vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_vlan_id(self):
    self.__port_vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="port-vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vlanid', is_config=True)


  def _get_maximum_frame_size(self):
    """
    Getter method for maximum_frame_size, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/maximum_frame_size (uint16)

    YANG Description: Maximum frame size
    """
    return self.__maximum_frame_size
      
  def _set_maximum_frame_size(self, v, load=False):
    """
    Setter method for maximum_frame_size, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/maximum_frame_size (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_maximum_frame_size is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_maximum_frame_size() directly.

    YANG Description: Maximum frame size
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['64 .. 65535']}), is_leaf=True, yang_name="maximum-frame-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """maximum_frame_size must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['64 .. 65535']}), is_leaf=True, yang_name="maximum-frame-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint16', is_config=True)""",
        })

    self.__maximum_frame_size = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_maximum_frame_size(self):
    self.__maximum_frame_size = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['64 .. 65535']}), is_leaf=True, yang_name="maximum-frame-size", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='uint16', is_config=True)


  def _get_ingress_egress_bandwidth_profile(self):
    """
    Getter method for ingress_egress_bandwidth_profile, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_egress_bandwidth_profile (container)

    YANG Description: The bandwith profile used in the ingress and egress
direction.
    """
    return self.__ingress_egress_bandwidth_profile
      
  def _set_ingress_egress_bandwidth_profile(self, v, load=False):
    """
    Setter method for ingress_egress_bandwidth_profile, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_egress_bandwidth_profile (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ingress_egress_bandwidth_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ingress_egress_bandwidth_profile() directly.

    YANG Description: The bandwith profile used in the ingress and egress
direction.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=ingress_egress_bandwidth_profile.ingress_egress_bandwidth_profile, is_container='container', yang_name="ingress-egress-bandwidth-profile", parent=self, choice=('direction', 'symmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ingress_egress_bandwidth_profile must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=ingress_egress_bandwidth_profile.ingress_egress_bandwidth_profile, is_container='container', yang_name="ingress-egress-bandwidth-profile", parent=self, choice=('direction', 'symmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__ingress_egress_bandwidth_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ingress_egress_bandwidth_profile(self):
    self.__ingress_egress_bandwidth_profile = YANGDynClass(base=ingress_egress_bandwidth_profile.ingress_egress_bandwidth_profile, is_container='container', yang_name="ingress-egress-bandwidth-profile", parent=self, choice=('direction', 'symmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)


  def _get_ingress_bandwidth_profile(self):
    """
    Getter method for ingress_bandwidth_profile, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile (container)

    YANG Description: The bandwidth profile used in the ingress direction.
    """
    return self.__ingress_bandwidth_profile
      
  def _set_ingress_bandwidth_profile(self, v, load=False):
    """
    Setter method for ingress_bandwidth_profile, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/ingress_bandwidth_profile (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ingress_bandwidth_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ingress_bandwidth_profile() directly.

    YANG Description: The bandwidth profile used in the ingress direction.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=ingress_bandwidth_profile.ingress_bandwidth_profile, is_container='container', yang_name="ingress-bandwidth-profile", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ingress_bandwidth_profile must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=ingress_bandwidth_profile.ingress_bandwidth_profile, is_container='container', yang_name="ingress-bandwidth-profile", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__ingress_bandwidth_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ingress_bandwidth_profile(self):
    self.__ingress_bandwidth_profile = YANGDynClass(base=ingress_bandwidth_profile.ingress_bandwidth_profile, is_container='container', yang_name="ingress-bandwidth-profile", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)


  def _get_egress_bandwidth_profile(self):
    """
    Getter method for egress_bandwidth_profile, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/egress_bandwidth_profile (container)

    YANG Description: The bandwidth profile used in the egress direction.
    """
    return self.__egress_bandwidth_profile
      
  def _set_egress_bandwidth_profile(self, v, load=False):
    """
    Setter method for egress_bandwidth_profile, mapped from YANG variable /networks/network/node/termination_point/eth_link_tp/egress_bandwidth_profile (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_egress_bandwidth_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_egress_bandwidth_profile() directly.

    YANG Description: The bandwidth profile used in the egress direction.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=egress_bandwidth_profile.egress_bandwidth_profile, is_container='container', yang_name="egress-bandwidth-profile", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """egress_bandwidth_profile must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=egress_bandwidth_profile.egress_bandwidth_profile, is_container='container', yang_name="egress-bandwidth-profile", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__egress_bandwidth_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_egress_bandwidth_profile(self):
    self.__egress_bandwidth_profile = YANGDynClass(base=egress_bandwidth_profile.egress_bandwidth_profile, is_container='container', yang_name="egress-bandwidth-profile", parent=self, choice=('direction', 'asymmetrical'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

  ltp_mac_address = __builtin__.property(_get_ltp_mac_address, _set_ltp_mac_address)
  port_vlan_id = __builtin__.property(_get_port_vlan_id, _set_port_vlan_id)
  maximum_frame_size = __builtin__.property(_get_maximum_frame_size, _set_maximum_frame_size)
  ingress_egress_bandwidth_profile = __builtin__.property(_get_ingress_egress_bandwidth_profile, _set_ingress_egress_bandwidth_profile)
  ingress_bandwidth_profile = __builtin__.property(_get_ingress_bandwidth_profile, _set_ingress_bandwidth_profile)
  egress_bandwidth_profile = __builtin__.property(_get_egress_bandwidth_profile, _set_egress_bandwidth_profile)

  __choices__ = {'direction': {'symmetrical': ['ingress_egress_bandwidth_profile'], 'asymmetrical': ['ingress_bandwidth_profile', 'egress_bandwidth_profile']}}
  _pyangbind_elements = OrderedDict([('ltp_mac_address', ltp_mac_address), ('port_vlan_id', port_vlan_id), ('maximum_frame_size', maximum_frame_size), ('ingress_egress_bandwidth_profile', ingress_egress_bandwidth_profile), ('ingress_bandwidth_profile', ingress_bandwidth_profile), ('egress_bandwidth_profile', egress_bandwidth_profile), ])


