# build the software
# uncomment the line below if you want to build it
# cargo build --release --target=x86_64-unknown-linux-musl

# build a .env file with the info from context and monitoring services

if [ -z "${CONTEXTSERVICE_SERVICE_HOST}" ] || [ -z "${CONTEXTSERVICE_SERVICE_PORT_GRPC}" ] || \
   [ -z "${MONITORINGSERVICE_SERVICE_HOST}" ] || [ -z "${MONITORINGSERVICE_SERVICE_PORT_GRPC}" ]
then
    echo "TFS_ENV_VARS are not loaded."
    exit 1
fi

echo "CONTEXTSERVICE_SERVICE_HOST=${CONTEXTSERVICE_SERVICE_HOST}" > .env
echo "CONTEXTSERVICE_SERVICE_PORT_GRPC=${CONTEXTSERVICE_SERVICE_PORT_GRPC}" >> .env
echo "MONITORINGSERVICE_SERVICE_HOST=${MONITORINGSERVICE_SERVICE_HOST}" >> .env
echo "MONITORINGSERVICE_SERVICE_PORT_GRPC=${MONITORINGSERVICE_SERVICE_PORT_GRPC}" >> .env

# get container id
CONTAINER=`docker ps | grep mininet | cut -f1 -d" "`
docker cp target/x86_64-unknown-linux-musl/release/tfsping $CONTAINER:/root
docker cp target/x86_64-unknown-linux-musl/release/tfsagent $CONTAINER:/root
docker cp .env $CONTAINER:/root