# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class correctable_errors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/pcie/correctable-errors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The count of the correctable PCIe errors.
  """
  __slots__ = ('_path_helper', '_extmethods', '__total_errors','__receiver_errors','__bad_tlp_errors','__bad_dllp_errors','__relay_rollover_errors','__replay_timeout_errors','__advisory_non_fatal_errors','__internal_errors','__hdr_log_overflow_errors',)

  _yang_name = 'correctable-errors'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__receiver_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__bad_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__bad_dllp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__relay_rollover_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__replay_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__advisory_non_fatal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__hdr_log_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'pcie', 'correctable-errors']

  def _get_total_errors(self):
    """
    Getter method for total_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/total_errors (oc-yang:counter64)

    YANG Description: Total number of correctable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__total_errors
      
  def _set_total_errors(self, v, load=False):
    """
    Setter method for total_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/total_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_errors() directly.

    YANG Description: Total number of correctable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__total_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_errors(self):
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_receiver_errors(self):
    """
    Getter method for receiver_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/receiver_errors (oc-yang:counter64)

    YANG Description: Number of receiver errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__receiver_errors
      
  def _set_receiver_errors(self, v, load=False):
    """
    Setter method for receiver_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/receiver_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_receiver_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_receiver_errors() directly.

    YANG Description: Number of receiver errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """receiver_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__receiver_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_receiver_errors(self):
    self.__receiver_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_bad_tlp_errors(self):
    """
    Getter method for bad_tlp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_tlp_errors (oc-yang:counter64)

    YANG Description: Number of TLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__bad_tlp_errors
      
  def _set_bad_tlp_errors(self, v, load=False):
    """
    Setter method for bad_tlp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bad_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bad_tlp_errors() directly.

    YANG Description: Number of TLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bad_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bad_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bad_tlp_errors(self):
    self.__bad_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_bad_dllp_errors(self):
    """
    Getter method for bad_dllp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_dllp_errors (oc-yang:counter64)

    YANG Description: Number of DLLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__bad_dllp_errors
      
  def _set_bad_dllp_errors(self, v, load=False):
    """
    Setter method for bad_dllp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_dllp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bad_dllp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bad_dllp_errors() directly.

    YANG Description: Number of DLLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bad_dllp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bad_dllp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bad_dllp_errors(self):
    self.__bad_dllp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_relay_rollover_errors(self):
    """
    Getter method for relay_rollover_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/relay_rollover_errors (oc-yang:counter64)

    YANG Description: Number of relay rollover errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__relay_rollover_errors
      
  def _set_relay_rollover_errors(self, v, load=False):
    """
    Setter method for relay_rollover_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/relay_rollover_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_relay_rollover_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_relay_rollover_errors() directly.

    YANG Description: Number of relay rollover errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """relay_rollover_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__relay_rollover_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_relay_rollover_errors(self):
    self.__relay_rollover_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_replay_timeout_errors(self):
    """
    Getter method for replay_timeout_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/replay_timeout_errors (oc-yang:counter64)

    YANG Description: Number of replay timeout errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__replay_timeout_errors
      
  def _set_replay_timeout_errors(self, v, load=False):
    """
    Setter method for replay_timeout_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/replay_timeout_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_replay_timeout_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_replay_timeout_errors() directly.

    YANG Description: Number of replay timeout errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """replay_timeout_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__replay_timeout_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_replay_timeout_errors(self):
    self.__replay_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_advisory_non_fatal_errors(self):
    """
    Getter method for advisory_non_fatal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/advisory_non_fatal_errors (oc-yang:counter64)

    YANG Description: Number of advisory non fatal errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__advisory_non_fatal_errors
      
  def _set_advisory_non_fatal_errors(self, v, load=False):
    """
    Setter method for advisory_non_fatal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/advisory_non_fatal_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_advisory_non_fatal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_advisory_non_fatal_errors() directly.

    YANG Description: Number of advisory non fatal errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """advisory_non_fatal_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__advisory_non_fatal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_advisory_non_fatal_errors(self):
    self.__advisory_non_fatal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_internal_errors(self):
    """
    Getter method for internal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/internal_errors (oc-yang:counter64)

    YANG Description: Number of internal errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    return self.__internal_errors
      
  def _set_internal_errors(self, v, load=False):
    """
    Setter method for internal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/internal_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_internal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_internal_errors() directly.

    YANG Description: Number of internal errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """internal_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__internal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_internal_errors(self):
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_hdr_log_overflow_errors(self):
    """
    Getter method for hdr_log_overflow_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/hdr_log_overflow_errors (oc-yang:counter64)

    YANG Description: Number of header log overflow errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__hdr_log_overflow_errors
      
  def _set_hdr_log_overflow_errors(self, v, load=False):
    """
    Setter method for hdr_log_overflow_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/hdr_log_overflow_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hdr_log_overflow_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hdr_log_overflow_errors() directly.

    YANG Description: Number of header log overflow errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hdr_log_overflow_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__hdr_log_overflow_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hdr_log_overflow_errors(self):
    self.__hdr_log_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

  total_errors = __builtin__.property(_get_total_errors)
  receiver_errors = __builtin__.property(_get_receiver_errors)
  bad_tlp_errors = __builtin__.property(_get_bad_tlp_errors)
  bad_dllp_errors = __builtin__.property(_get_bad_dllp_errors)
  relay_rollover_errors = __builtin__.property(_get_relay_rollover_errors)
  replay_timeout_errors = __builtin__.property(_get_replay_timeout_errors)
  advisory_non_fatal_errors = __builtin__.property(_get_advisory_non_fatal_errors)
  internal_errors = __builtin__.property(_get_internal_errors)
  hdr_log_overflow_errors = __builtin__.property(_get_hdr_log_overflow_errors)


  _pyangbind_elements = OrderedDict([('total_errors', total_errors), ('receiver_errors', receiver_errors), ('bad_tlp_errors', bad_tlp_errors), ('bad_dllp_errors', bad_dllp_errors), ('relay_rollover_errors', relay_rollover_errors), ('replay_timeout_errors', replay_timeout_errors), ('advisory_non_fatal_errors', advisory_non_fatal_errors), ('internal_errors', internal_errors), ('hdr_log_overflow_errors', hdr_log_overflow_errors), ])


class correctable_errors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /components/component/state/pcie/correctable-errors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The count of the correctable PCIe errors.
  """
  __slots__ = ('_path_helper', '_extmethods', '__total_errors','__receiver_errors','__bad_tlp_errors','__bad_dllp_errors','__relay_rollover_errors','__replay_timeout_errors','__advisory_non_fatal_errors','__internal_errors','__hdr_log_overflow_errors',)

  _yang_name = 'correctable-errors'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__receiver_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__bad_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__bad_dllp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__relay_rollover_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__replay_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__advisory_non_fatal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__hdr_log_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'pcie', 'correctable-errors']

  def _get_total_errors(self):
    """
    Getter method for total_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/total_errors (oc-yang:counter64)

    YANG Description: Total number of correctable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__total_errors
      
  def _set_total_errors(self, v, load=False):
    """
    Setter method for total_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/total_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_errors() directly.

    YANG Description: Total number of correctable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__total_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_errors(self):
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_receiver_errors(self):
    """
    Getter method for receiver_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/receiver_errors (oc-yang:counter64)

    YANG Description: Number of receiver errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__receiver_errors
      
  def _set_receiver_errors(self, v, load=False):
    """
    Setter method for receiver_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/receiver_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_receiver_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_receiver_errors() directly.

    YANG Description: Number of receiver errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """receiver_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__receiver_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_receiver_errors(self):
    self.__receiver_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_bad_tlp_errors(self):
    """
    Getter method for bad_tlp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_tlp_errors (oc-yang:counter64)

    YANG Description: Number of TLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__bad_tlp_errors
      
  def _set_bad_tlp_errors(self, v, load=False):
    """
    Setter method for bad_tlp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bad_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bad_tlp_errors() directly.

    YANG Description: Number of TLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bad_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bad_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bad_tlp_errors(self):
    self.__bad_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_bad_dllp_errors(self):
    """
    Getter method for bad_dllp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_dllp_errors (oc-yang:counter64)

    YANG Description: Number of DLLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__bad_dllp_errors
      
  def _set_bad_dllp_errors(self, v, load=False):
    """
    Setter method for bad_dllp_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/bad_dllp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bad_dllp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bad_dllp_errors() directly.

    YANG Description: Number of DLLPs with bad LCRC detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bad_dllp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bad_dllp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bad_dllp_errors(self):
    self.__bad_dllp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bad-dllp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_relay_rollover_errors(self):
    """
    Getter method for relay_rollover_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/relay_rollover_errors (oc-yang:counter64)

    YANG Description: Number of relay rollover errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__relay_rollover_errors
      
  def _set_relay_rollover_errors(self, v, load=False):
    """
    Setter method for relay_rollover_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/relay_rollover_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_relay_rollover_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_relay_rollover_errors() directly.

    YANG Description: Number of relay rollover errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """relay_rollover_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__relay_rollover_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_relay_rollover_errors(self):
    self.__relay_rollover_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="relay-rollover-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_replay_timeout_errors(self):
    """
    Getter method for replay_timeout_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/replay_timeout_errors (oc-yang:counter64)

    YANG Description: Number of replay timeout errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__replay_timeout_errors
      
  def _set_replay_timeout_errors(self, v, load=False):
    """
    Setter method for replay_timeout_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/replay_timeout_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_replay_timeout_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_replay_timeout_errors() directly.

    YANG Description: Number of replay timeout errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """replay_timeout_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__replay_timeout_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_replay_timeout_errors(self):
    self.__replay_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="replay-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_advisory_non_fatal_errors(self):
    """
    Getter method for advisory_non_fatal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/advisory_non_fatal_errors (oc-yang:counter64)

    YANG Description: Number of advisory non fatal errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__advisory_non_fatal_errors
      
  def _set_advisory_non_fatal_errors(self, v, load=False):
    """
    Setter method for advisory_non_fatal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/advisory_non_fatal_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_advisory_non_fatal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_advisory_non_fatal_errors() directly.

    YANG Description: Number of advisory non fatal errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """advisory_non_fatal_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__advisory_non_fatal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_advisory_non_fatal_errors(self):
    self.__advisory_non_fatal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="advisory-non-fatal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_internal_errors(self):
    """
    Getter method for internal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/internal_errors (oc-yang:counter64)

    YANG Description: Number of internal errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    return self.__internal_errors
      
  def _set_internal_errors(self, v, load=False):
    """
    Setter method for internal_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/internal_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_internal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_internal_errors() directly.

    YANG Description: Number of internal errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """internal_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__internal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_internal_errors(self):
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_hdr_log_overflow_errors(self):
    """
    Getter method for hdr_log_overflow_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/hdr_log_overflow_errors (oc-yang:counter64)

    YANG Description: Number of header log overflow errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__hdr_log_overflow_errors
      
  def _set_hdr_log_overflow_errors(self, v, load=False):
    """
    Setter method for hdr_log_overflow_errors, mapped from YANG variable /components/component/state/pcie/correctable_errors/hdr_log_overflow_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hdr_log_overflow_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hdr_log_overflow_errors() directly.

    YANG Description: Number of header log overflow errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hdr_log_overflow_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__hdr_log_overflow_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hdr_log_overflow_errors(self):
    self.__hdr_log_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="hdr-log-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

  total_errors = __builtin__.property(_get_total_errors)
  receiver_errors = __builtin__.property(_get_receiver_errors)
  bad_tlp_errors = __builtin__.property(_get_bad_tlp_errors)
  bad_dllp_errors = __builtin__.property(_get_bad_dllp_errors)
  relay_rollover_errors = __builtin__.property(_get_relay_rollover_errors)
  replay_timeout_errors = __builtin__.property(_get_replay_timeout_errors)
  advisory_non_fatal_errors = __builtin__.property(_get_advisory_non_fatal_errors)
  internal_errors = __builtin__.property(_get_internal_errors)
  hdr_log_overflow_errors = __builtin__.property(_get_hdr_log_overflow_errors)


  _pyangbind_elements = OrderedDict([('total_errors', total_errors), ('receiver_errors', receiver_errors), ('bad_tlp_errors', bad_tlp_errors), ('bad_dllp_errors', bad_dllp_errors), ('relay_rollover_errors', relay_rollover_errors), ('replay_timeout_errors', replay_timeout_errors), ('advisory_non_fatal_errors', advisory_non_fatal_errors), ('internal_errors', internal_errors), ('hdr_log_overflow_errors', hdr_log_overflow_errors), ])


