# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class path_srlgs_list(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/local-link-connectivities/local-link-connectivity/path-constraints/path-srlgs-lists/path-srlgs-list. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of SRLG values to be included or excluded.
  """
  __slots__ = ('_path_helper', '_extmethods', '__usage','__values',)

  _yang_name = 'path-srlgs-list'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__usage = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="usage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    self.__values = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)), is_leaf=False, yang_name="values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='srlg', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'local-link-connectivities', 'local-link-connectivity', 'path-constraints', 'path-srlgs-lists', 'path-srlgs-list']

  def _get_usage(self):
    """
    Getter method for usage, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/path_constraints/path_srlgs_lists/path_srlgs_list/usage (identityref)

    YANG Description: Identifies an entry in a list of SRLGs to either
include or exclude.
    """
    return self.__usage
      
  def _set_usage(self, v, load=False):
    """
    Setter method for usage, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/path_constraints/path_srlgs_lists/path_srlgs_list/usage (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_usage is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_usage() directly.

    YANG Description: Identifies an entry in a list of SRLGs to either
include or exclude.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="usage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """usage must be of a type compatible with identityref""",
          'defined-type': "ietf-te-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="usage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)""",
        })

    self.__usage = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_usage(self):
    self.__usage = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-include-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-exclude-object': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:route-exclude-srlg': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="usage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=True)


  def _get_values(self):
    """
    Getter method for values, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/path_constraints/path_srlgs_lists/path_srlgs_list/values (srlg)

    YANG Description: List of SRLG values.
    """
    return self.__values
      
  def _set_values(self, v, load=False):
    """
    Setter method for values, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/path_constraints/path_srlgs_lists/path_srlgs_list/values (srlg)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_values is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_values() directly.

    YANG Description: List of SRLG values.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)), is_leaf=False, yang_name="values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='srlg', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """values must be of a type compatible with srlg""",
          'defined-type': "ietf-te-topology:srlg",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)), is_leaf=False, yang_name="values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='srlg', is_config=True)""",
        })

    self.__values = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_values(self):
    self.__values = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)), is_leaf=False, yang_name="values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='srlg', is_config=True)

  usage = __builtin__.property(_get_usage, _set_usage)
  values = __builtin__.property(_get_values, _set_values)


  _pyangbind_elements = OrderedDict([('usage', usage), ('values', values), ])


