/*
* Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.context.model;

public class ConstraintCustom {

    private final String constraintType;
    private final String constraintValue;

    public ConstraintCustom(String constraintType, String constraintValue) {
        this.constraintType = constraintType;
        this.constraintValue = constraintValue;
    }

    public String getConstraintType() {
        return constraintType;
    }

    public String getConstraintValue() {
        return constraintValue;
    }

    @Override
    public String toString() {
        return String.format(
                "%s:{constraintType:\"%s\", constraintValue:\"%s\"}",
                getClass().getSimpleName(), constraintType, constraintValue);
    }
}
