/*
* Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.monitoring;

import eu.teraflow.policy.context.model.Empty;
import eu.teraflow.policy.monitoring.model.AlarmDescriptor;
import eu.teraflow.policy.monitoring.model.AlarmResponse;
import eu.teraflow.policy.monitoring.model.AlarmSubscription;
import eu.teraflow.policy.monitoring.model.Kpi;
import eu.teraflow.policy.monitoring.model.KpiDescriptor;
import eu.teraflow.policy.monitoring.model.SubsDescriptor;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.List;

public interface MonitoringService {

    Uni<String> setKpi(KpiDescriptor kpiDescriptor);

    Uni<KpiDescriptor> getKpiDescriptor(String kpiId);

    Multi<List<Kpi>> setKpiSubscription(SubsDescriptor subsDescriptor);

    Uni<SubsDescriptor> getSubsDescriptor(String subscriptionId);

    Uni<String> setKpiAlarm(AlarmDescriptor alarmDescriptor);

    Uni<AlarmDescriptor> getAlarmDescriptor(String alarmId);

    Multi<AlarmResponse> getAlarmResponseStream(AlarmSubscription alarmSubscription);

    Uni<Empty> deleteAlarm(String deviceId);
}
