import grpc
from common.database.api.Database import Database
from common.database.api.context.slice.Slice import Slice
from common.exceptions.ServiceException import ServiceException

def check_slice_exists(database : Database, context_id : str, slice_id : str) -> Slice:
    db_context = database.context(context_id).create()
    if db_context.slices.contains(slice_id): return db_context.slice(slice_id)
    msg = 'Context({})/Slice({}) does not exist in the database.'
    msg = msg.format(context_id, slice_id)
    raise ServiceException(grpc.StatusCode.NOT_FOUND, msg)

def check_slice_not_exists(database : Database, context_id : str, slice_id : str):
    db_context = database.context(context_id).create()
    if not db_context.slices.contains(slice_id): return
    msg = 'Context({})/Slice({}) already exists in the database.'
    msg = msg.format(context_id, slice_id)
    raise ServiceException(grpc.StatusCode.ALREADY_EXISTS, msg)
