import grpc
from common.exceptions.ServiceException import ServiceException
from context.service.database.api.Database import Database

def check_service_exists(database : Database, context_id : str, service_id : str):
    if not database.contexts.contains(context_id):
        msg = 'Context({}) does not exist in the database.'
        msg = msg.format(context_id)
        raise ServiceException(grpc.StatusCode.NOT_FOUND, msg)

    db_context = database.context(context_id)
    if db_context.services.contains(service_id): return

    msg = 'Context({})/Service({}) does not exist in the database.'
    msg = msg.format(context_id, service_id)
    raise ServiceException(grpc.StatusCode.NOT_FOUND, msg)

def check_service_not_exists(database : Database, context_id : str, service_id : str):
    if not database.contexts.contains(context_id):
        msg = 'Context({}) does not exist in the database.'
        msg = msg.format(context_id)
        raise ServiceException(grpc.StatusCode.NOT_FOUND, msg)

    db_context = database.context(context_id)
    if not db_context.services.contains(service_id): return

    msg = 'Context({})/Service({}) already exists in the database.'
    msg = msg.format(context_id, service_id)
    raise ServiceException(grpc.StatusCode.ALREADY_EXISTS, msg)
