from typing import Dict, List, Set, Tuple

class _Backend:
    def __init__(self, **settings) -> None:
        raise NotImplementedError()

    def lock(self) -> Tuple[bool, str]:
        raise NotImplementedError()

    def unlock(self, owner_key : str) -> bool:
        raise NotImplementedError()

    def keys(self) -> list:
        raise NotImplementedError()

    def exists(self, key_name : str) -> bool:
        raise NotImplementedError()

    def delete(self, key_name : str) -> bool:
        raise NotImplementedError()

    def dict_get(self, key_name : str, fields : List[str] = []) -> Dict[str, str]:
        raise NotImplementedError()

    def dict_update(self, key_name : str, update_fields : Dict[str,str] = {}, remove_fields : Set[str] = set()) -> None:
        raise NotImplementedError()

    def dict_delete(self, key_name : str, fields : List[str] = []) -> None:
        raise NotImplementedError()

    def list_get_all(self, key_name : str) -> List[str]:
        raise NotImplementedError()

    def list_push_last(self, key_name : str, item : str) -> None:
        raise NotImplementedError()

    def list_remove_first_occurrence(self, key_name : str, item: str) -> None:
        raise NotImplementedError()

    def set_add(self, key_name : str, item : str) -> None:
        raise NotImplementedError()

    def set_has(self, key_name : str, item : str) -> bool:
        raise NotImplementedError()

    def set_remove(self, key_name : str, item : str) -> None:
        raise NotImplementedError()

    def dump(self) -> List[str]:
        raise NotImplementedError()
