from typing import Any, Callable, Dict
from ._Object import _Object
from .Attributes import Attributes

class _ObjectWithAttributes(_Object):
    def __init__(
        self, parent, object_uuid: str, key_pattern : str, validators : Dict[str, Callable[[Any], bool]],
        transcoders : Dict[str, Dict[Any, Callable[[Any], Any]]] = {}) -> None:

        super().__init__(parent, object_uuid)
        self._attributes = Attributes(parent, key_pattern, validators, transcoders=transcoders)

    @property
    def attributes(self) -> Attributes: return self._attributes
