from typing import Dict
from ..backend._Backend import _Backend

class _Object:
    def __init__(self, parent, object_uuid : str):
        if not issubclass(parent, _Object):
            str_class_path = '{}.{}'.format(_Object.__module__, _Object.__name__)
            raise AttributeError('parent must inherit from {}'.format(str_class_path))
        if (not isinstance(object_uuid, str)) or (len(object_uuid) == 0):
            raise AttributeError('object_uuid must be a non-empty instance of str')
        self._object_uuid = object_uuid
        self._parent = parent

    @property
    def parent(self) -> '_Object': return self._parent

    @property
    def backend(self) -> _Backend: return self._parent.backend

    def create(self) -> None:
        raise NotImplementedError()

    def delete(self) -> None:
        raise NotImplementedError()

    def dump_id(self) -> Dict:
        raise NotImplementedError()

    def dump(self) -> Dict:
        raise NotImplementedError()
