/*
 * Decompiled with CFR 0.152.
 */
package jcckit.transformation;

import jcckit.data.DataPoint;
import jcckit.graphic.GraphPoint;
import jcckit.transformation.Transformation;
import jcckit.util.Util;

public class CartesianTransformation
implements Transformation {
    private final boolean _xLogScale;
    private final double _xOffset;
    private final double _xScale;
    private final boolean _yLogScale;
    private final double _yOffset;
    private final double _yScale;

    public CartesianTransformation(boolean bl, boolean bl2, DataPoint dataPoint, GraphPoint graphPoint, DataPoint dataPoint2, GraphPoint graphPoint2) {
        this._xLogScale = bl;
        double d = Util.log(dataPoint.getX(), bl);
        double d2 = Util.log(dataPoint2.getX(), bl) - d;
        this.check(d2, "data", "x", d);
        this._xScale = (graphPoint2.getX() - graphPoint.getX()) / d2;
        this.check(this._xScale, "graphical", "x", graphPoint.getX());
        this._xOffset = graphPoint.getX() - d * this._xScale;
        this._yLogScale = bl2;
        d = Util.log(dataPoint.getY(), bl2);
        d2 = Util.log(dataPoint2.getY(), bl2) - d;
        this.check(d2, "data", "y", d);
        this._yScale = (graphPoint2.getY() - graphPoint.getY()) / d2;
        this.check(this._yScale, "graphical", "y", graphPoint.getY());
        this._yOffset = graphPoint.getY() - d * this._yScale;
    }

    private void check(double d, String string, String string2, double d2) {
        if (d == 0.0) {
            throw new IllegalArgumentException("The " + string + " reference points in " + string2 + " must be different; both are " + d2);
        }
    }

    public GraphPoint transformToGraph(DataPoint dataPoint) {
        return new GraphPoint(this._xOffset + Util.log(dataPoint.getX(), this._xLogScale) * this._xScale, this._yOffset + Util.log(dataPoint.getY(), this._yLogScale) * this._yScale);
    }

    public DataPoint transformToData(GraphPoint graphPoint) {
        return new DataPoint(Util.exp((graphPoint.getX() - this._xOffset) / this._xScale, this._xLogScale), Util.exp((graphPoint.getY() - this._yOffset) / this._yScale, this._yLogScale));
    }
}

