# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import calendar
from datetime import datetime, timezone

def time_datetime_to_int(dt_time : datetime) -> int:
    return int(calendar.timegm(dt_time.timetuple()))

def time_datetime_to_float(dt_time : datetime) -> float:
    return time_datetime_to_int(dt_time) + (dt_time.microsecond / 1.e6)

def time_utc_now_to_datetime() -> datetime:
    return datetime.now(tz=timezone.utc)

def time_utc_now_to_float() -> float:
    return time_datetime_to_float(time_utc_now_to_datetime())
