# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server import util


class TapiTopologyCostCharacteristic(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, cost_value: str=None, cost_algorithm: str=None, cost_name: str=None):  # noqa: E501
        """TapiTopologyCostCharacteristic - a model defined in Swagger

        :param cost_value: The cost_value of this TapiTopologyCostCharacteristic.  # noqa: E501
        :type cost_value: str
        :param cost_algorithm: The cost_algorithm of this TapiTopologyCostCharacteristic.  # noqa: E501
        :type cost_algorithm: str
        :param cost_name: The cost_name of this TapiTopologyCostCharacteristic.  # noqa: E501
        :type cost_name: str
        """
        self.swagger_types = {
            'cost_value': str,
            'cost_algorithm': str,
            'cost_name': str
        }

        self.attribute_map = {
            'cost_value': 'cost-value',
            'cost_algorithm': 'cost-algorithm',
            'cost_name': 'cost-name'
        }
        self._cost_value = cost_value
        self._cost_algorithm = cost_algorithm
        self._cost_name = cost_name

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyCostCharacteristic':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.CostCharacteristic of this TapiTopologyCostCharacteristic.  # noqa: E501
        :rtype: TapiTopologyCostCharacteristic
        """
        return util.deserialize_model(dikt, cls)

    @property
    def cost_value(self) -> str:
        """Gets the cost_value of this TapiTopologyCostCharacteristic.

        The specific cost.  # noqa: E501

        :return: The cost_value of this TapiTopologyCostCharacteristic.
        :rtype: str
        """
        return self._cost_value

    @cost_value.setter
    def cost_value(self, cost_value: str):
        """Sets the cost_value of this TapiTopologyCostCharacteristic.

        The specific cost.  # noqa: E501

        :param cost_value: The cost_value of this TapiTopologyCostCharacteristic.
        :type cost_value: str
        """

        self._cost_value = cost_value

    @property
    def cost_algorithm(self) -> str:
        """Gets the cost_algorithm of this TapiTopologyCostCharacteristic.

        The cost may vary based upon some properties of the TopologicalEntity. The rules for the variation are conveyed by the costAlgorithm.  # noqa: E501

        :return: The cost_algorithm of this TapiTopologyCostCharacteristic.
        :rtype: str
        """
        return self._cost_algorithm

    @cost_algorithm.setter
    def cost_algorithm(self, cost_algorithm: str):
        """Sets the cost_algorithm of this TapiTopologyCostCharacteristic.

        The cost may vary based upon some properties of the TopologicalEntity. The rules for the variation are conveyed by the costAlgorithm.  # noqa: E501

        :param cost_algorithm: The cost_algorithm of this TapiTopologyCostCharacteristic.
        :type cost_algorithm: str
        """

        self._cost_algorithm = cost_algorithm

    @property
    def cost_name(self) -> str:
        """Gets the cost_name of this TapiTopologyCostCharacteristic.

        The cost characteristic will related to some aspect of the TopologicalEntity (e.g. $ cost, routing weight). This aspect will be conveyed by the costName.  # noqa: E501

        :return: The cost_name of this TapiTopologyCostCharacteristic.
        :rtype: str
        """
        return self._cost_name

    @cost_name.setter
    def cost_name(self, cost_name: str):
        """Sets the cost_name of this TapiTopologyCostCharacteristic.

        The cost characteristic will related to some aspect of the TopologicalEntity (e.g. $ cost, routing weight). This aspect will be conveyed by the costName.  # noqa: E501

        :param cost_name: The cost_name of this TapiTopologyCostCharacteristic.
        :type cost_name: str
        """

        self._cost_name = cost_name
