# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_global_class import TapiCommonGlobalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_lifecycle_state import TapiCommonLifecycleState  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_common_operational_state import TapiCommonOperationalState  # noqa: F401,E501
from tapi_server.models.tapi_common_operational_state_pac import TapiCommonOperationalStatePac  # noqa: F401,E501
from tapi_server.models.tapi_common_port_direction import TapiCommonPortDirection  # noqa: F401,E501
from tapi_server.models.tapi_common_port_role import TapiCommonPortRole  # noqa: F401,E501
from tapi_server.models.tapi_common_termination_direction import TapiCommonTerminationDirection  # noqa: F401,E501
from tapi_server.models.tapi_common_termination_pac import TapiCommonTerminationPac  # noqa: F401,E501
from tapi_server.models.tapi_common_termination_state import TapiCommonTerminationState  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_cep_role import TapiConnectivityCepRole  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connection_end_point_ref import TapiConnectivityConnectionEndPointRef  # noqa: F401,E501
from tapi_server.models.tapi_topology_node_edge_point_ref import TapiTopologyNodeEdgePointRef  # noqa: F401,E501
from tapi_server import util


class TapiConnectivityConnectionEndPoint(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, operational_state: TapiCommonOperationalState=None, lifecycle_state: TapiCommonLifecycleState=None, termination_direction: TapiCommonTerminationDirection=None, termination_state: TapiCommonTerminationState=None, name: List[TapiCommonNameAndValue]=None, uuid: str=None, client_node_edge_point: List[TapiTopologyNodeEdgePointRef]=None, connection_port_role: TapiCommonPortRole=None, layer_protocol_name: TapiCommonLayerProtocolName=None, layer_protocol_qualifier: str=None, parent_node_edge_point: TapiTopologyNodeEdgePointRef=None, cep_role: List[TapiConnectivityCepRole]=None, aggregated_connection_end_point: List[TapiConnectivityConnectionEndPointRef]=None, connection_port_direction: TapiCommonPortDirection=None):  # noqa: E501
        """TapiConnectivityConnectionEndPoint - a model defined in Swagger

        :param operational_state: The operational_state of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type operational_state: TapiCommonOperationalState
        :param lifecycle_state: The lifecycle_state of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type lifecycle_state: TapiCommonLifecycleState
        :param termination_direction: The termination_direction of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type termination_direction: TapiCommonTerminationDirection
        :param termination_state: The termination_state of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type termination_state: TapiCommonTerminationState
        :param name: The name of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type uuid: str
        :param client_node_edge_point: The client_node_edge_point of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type client_node_edge_point: List[TapiTopologyNodeEdgePointRef]
        :param connection_port_role: The connection_port_role of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type connection_port_role: TapiCommonPortRole
        :param layer_protocol_name: The layer_protocol_name of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type layer_protocol_name: TapiCommonLayerProtocolName
        :param layer_protocol_qualifier: The layer_protocol_qualifier of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type layer_protocol_qualifier: str
        :param parent_node_edge_point: The parent_node_edge_point of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type parent_node_edge_point: TapiTopologyNodeEdgePointRef
        :param cep_role: The cep_role of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type cep_role: List[TapiConnectivityCepRole]
        :param aggregated_connection_end_point: The aggregated_connection_end_point of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type aggregated_connection_end_point: List[TapiConnectivityConnectionEndPointRef]
        :param connection_port_direction: The connection_port_direction of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :type connection_port_direction: TapiCommonPortDirection
        """
        self.swagger_types = {
            'operational_state': TapiCommonOperationalState,
            'lifecycle_state': TapiCommonLifecycleState,
            'termination_direction': TapiCommonTerminationDirection,
            'termination_state': TapiCommonTerminationState,
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'client_node_edge_point': List[TapiTopologyNodeEdgePointRef],
            'connection_port_role': TapiCommonPortRole,
            'layer_protocol_name': TapiCommonLayerProtocolName,
            'layer_protocol_qualifier': str,
            'parent_node_edge_point': TapiTopologyNodeEdgePointRef,
            'cep_role': List[TapiConnectivityCepRole],
            'aggregated_connection_end_point': List[TapiConnectivityConnectionEndPointRef],
            'connection_port_direction': TapiCommonPortDirection
        }

        self.attribute_map = {
            'operational_state': 'operational-state',
            'lifecycle_state': 'lifecycle-state',
            'termination_direction': 'termination-direction',
            'termination_state': 'termination-state',
            'name': 'name',
            'uuid': 'uuid',
            'client_node_edge_point': 'client-node-edge-point',
            'connection_port_role': 'connection-port-role',
            'layer_protocol_name': 'layer-protocol-name',
            'layer_protocol_qualifier': 'layer-protocol-qualifier',
            'parent_node_edge_point': 'parent-node-edge-point',
            'cep_role': 'cep-role',
            'aggregated_connection_end_point': 'aggregated-connection-end-point',
            'connection_port_direction': 'connection-port-direction'
        }
        self._operational_state = operational_state
        self._lifecycle_state = lifecycle_state
        self._termination_direction = termination_direction
        self._termination_state = termination_state
        self._name = name
        self._uuid = uuid
        self._client_node_edge_point = client_node_edge_point
        self._connection_port_role = connection_port_role
        self._layer_protocol_name = layer_protocol_name
        self._layer_protocol_qualifier = layer_protocol_qualifier
        self._parent_node_edge_point = parent_node_edge_point
        self._cep_role = cep_role
        self._aggregated_connection_end_point = aggregated_connection_end_point
        self._connection_port_direction = connection_port_direction

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivityConnectionEndPoint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.ConnectionEndPoint of this TapiConnectivityConnectionEndPoint.  # noqa: E501
        :rtype: TapiConnectivityConnectionEndPoint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def operational_state(self) -> TapiCommonOperationalState:
        """Gets the operational_state of this TapiConnectivityConnectionEndPoint.


        :return: The operational_state of this TapiConnectivityConnectionEndPoint.
        :rtype: TapiCommonOperationalState
        """
        return self._operational_state

    @operational_state.setter
    def operational_state(self, operational_state: TapiCommonOperationalState):
        """Sets the operational_state of this TapiConnectivityConnectionEndPoint.


        :param operational_state: The operational_state of this TapiConnectivityConnectionEndPoint.
        :type operational_state: TapiCommonOperationalState
        """

        self._operational_state = operational_state

    @property
    def lifecycle_state(self) -> TapiCommonLifecycleState:
        """Gets the lifecycle_state of this TapiConnectivityConnectionEndPoint.


        :return: The lifecycle_state of this TapiConnectivityConnectionEndPoint.
        :rtype: TapiCommonLifecycleState
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state: TapiCommonLifecycleState):
        """Sets the lifecycle_state of this TapiConnectivityConnectionEndPoint.


        :param lifecycle_state: The lifecycle_state of this TapiConnectivityConnectionEndPoint.
        :type lifecycle_state: TapiCommonLifecycleState
        """

        self._lifecycle_state = lifecycle_state

    @property
    def termination_direction(self) -> TapiCommonTerminationDirection:
        """Gets the termination_direction of this TapiConnectivityConnectionEndPoint.


        :return: The termination_direction of this TapiConnectivityConnectionEndPoint.
        :rtype: TapiCommonTerminationDirection
        """
        return self._termination_direction

    @termination_direction.setter
    def termination_direction(self, termination_direction: TapiCommonTerminationDirection):
        """Sets the termination_direction of this TapiConnectivityConnectionEndPoint.


        :param termination_direction: The termination_direction of this TapiConnectivityConnectionEndPoint.
        :type termination_direction: TapiCommonTerminationDirection
        """

        self._termination_direction = termination_direction

    @property
    def termination_state(self) -> TapiCommonTerminationState:
        """Gets the termination_state of this TapiConnectivityConnectionEndPoint.


        :return: The termination_state of this TapiConnectivityConnectionEndPoint.
        :rtype: TapiCommonTerminationState
        """
        return self._termination_state

    @termination_state.setter
    def termination_state(self, termination_state: TapiCommonTerminationState):
        """Sets the termination_state of this TapiConnectivityConnectionEndPoint.


        :param termination_state: The termination_state of this TapiConnectivityConnectionEndPoint.
        :type termination_state: TapiCommonTerminationState
        """

        self._termination_state = termination_state

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiConnectivityConnectionEndPoint.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiConnectivityConnectionEndPoint.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiConnectivityConnectionEndPoint.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiConnectivityConnectionEndPoint.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiConnectivityConnectionEndPoint.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiConnectivityConnectionEndPoint.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiConnectivityConnectionEndPoint.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiConnectivityConnectionEndPoint.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def client_node_edge_point(self) -> List[TapiTopologyNodeEdgePointRef]:
        """Gets the client_node_edge_point of this TapiConnectivityConnectionEndPoint.

        none  # noqa: E501

        :return: The client_node_edge_point of this TapiConnectivityConnectionEndPoint.
        :rtype: List[TapiTopologyNodeEdgePointRef]
        """
        return self._client_node_edge_point

    @client_node_edge_point.setter
    def client_node_edge_point(self, client_node_edge_point: List[TapiTopologyNodeEdgePointRef]):
        """Sets the client_node_edge_point of this TapiConnectivityConnectionEndPoint.

        none  # noqa: E501

        :param client_node_edge_point: The client_node_edge_point of this TapiConnectivityConnectionEndPoint.
        :type client_node_edge_point: List[TapiTopologyNodeEdgePointRef]
        """

        self._client_node_edge_point = client_node_edge_point

    @property
    def connection_port_role(self) -> TapiCommonPortRole:
        """Gets the connection_port_role of this TapiConnectivityConnectionEndPoint.


        :return: The connection_port_role of this TapiConnectivityConnectionEndPoint.
        :rtype: TapiCommonPortRole
        """
        return self._connection_port_role

    @connection_port_role.setter
    def connection_port_role(self, connection_port_role: TapiCommonPortRole):
        """Sets the connection_port_role of this TapiConnectivityConnectionEndPoint.


        :param connection_port_role: The connection_port_role of this TapiConnectivityConnectionEndPoint.
        :type connection_port_role: TapiCommonPortRole
        """

        self._connection_port_role = connection_port_role

    @property
    def layer_protocol_name(self) -> TapiCommonLayerProtocolName:
        """Gets the layer_protocol_name of this TapiConnectivityConnectionEndPoint.


        :return: The layer_protocol_name of this TapiConnectivityConnectionEndPoint.
        :rtype: TapiCommonLayerProtocolName
        """
        return self._layer_protocol_name

    @layer_protocol_name.setter
    def layer_protocol_name(self, layer_protocol_name: TapiCommonLayerProtocolName):
        """Sets the layer_protocol_name of this TapiConnectivityConnectionEndPoint.


        :param layer_protocol_name: The layer_protocol_name of this TapiConnectivityConnectionEndPoint.
        :type layer_protocol_name: TapiCommonLayerProtocolName
        """

        self._layer_protocol_name = layer_protocol_name

    @property
    def layer_protocol_qualifier(self) -> str:
        """Gets the layer_protocol_qualifier of this TapiConnectivityConnectionEndPoint.

        none  # noqa: E501

        :return: The layer_protocol_qualifier of this TapiConnectivityConnectionEndPoint.
        :rtype: str
        """
        return self._layer_protocol_qualifier

    @layer_protocol_qualifier.setter
    def layer_protocol_qualifier(self, layer_protocol_qualifier: str):
        """Sets the layer_protocol_qualifier of this TapiConnectivityConnectionEndPoint.

        none  # noqa: E501

        :param layer_protocol_qualifier: The layer_protocol_qualifier of this TapiConnectivityConnectionEndPoint.
        :type layer_protocol_qualifier: str
        """

        self._layer_protocol_qualifier = layer_protocol_qualifier

    @property
    def parent_node_edge_point(self) -> TapiTopologyNodeEdgePointRef:
        """Gets the parent_node_edge_point of this TapiConnectivityConnectionEndPoint.


        :return: The parent_node_edge_point of this TapiConnectivityConnectionEndPoint.
        :rtype: TapiTopologyNodeEdgePointRef
        """
        return self._parent_node_edge_point

    @parent_node_edge_point.setter
    def parent_node_edge_point(self, parent_node_edge_point: TapiTopologyNodeEdgePointRef):
        """Sets the parent_node_edge_point of this TapiConnectivityConnectionEndPoint.


        :param parent_node_edge_point: The parent_node_edge_point of this TapiConnectivityConnectionEndPoint.
        :type parent_node_edge_point: TapiTopologyNodeEdgePointRef
        """

        self._parent_node_edge_point = parent_node_edge_point

    @property
    def cep_role(self) -> List[TapiConnectivityCepRole]:
        """Gets the cep_role of this TapiConnectivityConnectionEndPoint.

        Defines the role of the CEP in the context of the connection spec.                  There may be many cep role - connection spec combinations for a particular CEP where each corresponds to a specific connection associated with the CEP.  # noqa: E501

        :return: The cep_role of this TapiConnectivityConnectionEndPoint.
        :rtype: List[TapiConnectivityCepRole]
        """
        return self._cep_role

    @cep_role.setter
    def cep_role(self, cep_role: List[TapiConnectivityCepRole]):
        """Sets the cep_role of this TapiConnectivityConnectionEndPoint.

        Defines the role of the CEP in the context of the connection spec.                  There may be many cep role - connection spec combinations for a particular CEP where each corresponds to a specific connection associated with the CEP.  # noqa: E501

        :param cep_role: The cep_role of this TapiConnectivityConnectionEndPoint.
        :type cep_role: List[TapiConnectivityCepRole]
        """

        self._cep_role = cep_role

    @property
    def aggregated_connection_end_point(self) -> List[TapiConnectivityConnectionEndPointRef]:
        """Gets the aggregated_connection_end_point of this TapiConnectivityConnectionEndPoint.

        none  # noqa: E501

        :return: The aggregated_connection_end_point of this TapiConnectivityConnectionEndPoint.
        :rtype: List[TapiConnectivityConnectionEndPointRef]
        """
        return self._aggregated_connection_end_point

    @aggregated_connection_end_point.setter
    def aggregated_connection_end_point(self, aggregated_connection_end_point: List[TapiConnectivityConnectionEndPointRef]):
        """Sets the aggregated_connection_end_point of this TapiConnectivityConnectionEndPoint.

        none  # noqa: E501

        :param aggregated_connection_end_point: The aggregated_connection_end_point of this TapiConnectivityConnectionEndPoint.
        :type aggregated_connection_end_point: List[TapiConnectivityConnectionEndPointRef]
        """

        self._aggregated_connection_end_point = aggregated_connection_end_point

    @property
    def connection_port_direction(self) -> TapiCommonPortDirection:
        """Gets the connection_port_direction of this TapiConnectivityConnectionEndPoint.


        :return: The connection_port_direction of this TapiConnectivityConnectionEndPoint.
        :rtype: TapiCommonPortDirection
        """
        return self._connection_port_direction

    @connection_port_direction.setter
    def connection_port_direction(self, connection_port_direction: TapiCommonPortDirection):
        """Sets the connection_port_direction of this TapiConnectivityConnectionEndPoint.


        :param connection_port_direction: The connection_port_direction of this TapiConnectivityConnectionEndPoint.
        :type connection_port_direction: TapiCommonPortDirection
        """

        self._connection_port_direction = connection_port_direction
