import grpc
import pytest
from common.proto.context_pb2 import Empty, ContextId, Uuid
from common.proto.context_pb2_grpc import ContextServiceStub

@pytest.fixture
def grpc_stub():
    channel = grpc.insecure_channel('10.152.183.77:1010')  # Replace with actual server address
    stub = ContextServiceStub(channel)
    return stub

def test_retrieve_all_contexts(grpc_stub):
    try:
        response = grpc_stub.ListContexts(Empty())
        assert response is not None
        assert len(response.contexts) > 0
        for context in response.contexts:
            assert isinstance(context.context_uuid.uuid, str)
            assert isinstance(context.name, str)
    except grpc.RpcError as e:
        print(f"gRPC Error: {e}")

def test_retrieve_context_details(grpc_stub):
    try:
        uuid = Uuid(uuid="valid-id-here")
        context_id = ContextId(context_uuid=uuid)
        response = grpc_stub.GetContext(context_id)
        assert response is not None
        assert response.context_uuid.uuid == "valid-id-here"
    except grpc.RpcError as e:
        print(f"gRPC Error: {e}")
