import pytest
from src.device.service.drivers.qkd.QKDDriver2 import QKDDriver
from typing import List, Tuple


@pytest.fixture
def qkd_driver():
    # Initialize the QKD driver
    return QKDDriver(address='10.211.36.220', port=11111, username='user', password='pass')


def test_state_subscription(qkd_driver):
    """
    Test Case ID: SBI_Test_06 - Subscribe to state changes and validate the subscription process.
    """
    qkd_driver.Connect()

    try:
        # Step 1: Define the subscription
        subscriptions = [
            ('00000001-0000-0000-0000-000000000000', 60, 10)  # (node_id, frequency, timeout)
        ]
        
        # Step 2: Subscribe to state changes using the driver method
        subscription_results = qkd_driver.SubscribeState(subscriptions)
        
        # Step 3: Validate that the subscription was successful
        assert all(result is True for result in subscription_results), "Subscription to state changes failed."

        print("State subscription successful:", subscription_results)
    
    except Exception as e:
        pytest.fail(f"An unexpected error occurred during state subscription: {e}")
    
    finally:
        qkd_driver.Disconnect()
