import pytest
from unittest.mock import patch
from src.device.service.drivers.qkd.QKDDriver import QKDDriver
import requests

@pytest.fixture
def qkd_driver():
    return QKDDriver(address='10.211.36.220', port=11111, username='user', password='pass')

# Deliverable Test ID: SBI_Test_01
def test_qkd_driver_connection(qkd_driver):
    assert qkd_driver.Connect() is True

# Deliverable Test ID: SBI_Test_01
def test_qkd_driver_invalid_connection():
    qkd_driver = QKDDriver(address='10.211.36.220', port=12345, username='user', password='pass')  # Use invalid port directly
    assert qkd_driver.Connect() is False

# Deliverable Test ID: SBI_Test_10
@patch('src.device.service.drivers.qkd.QKDDriver2.requests.get')
def test_qkd_driver_timeout_connection(mock_get, qkd_driver):
    mock_get.side_effect = requests.exceptions.Timeout
    qkd_driver.timeout = 0.001  # Simulate very short timeout
    assert qkd_driver.Connect() is False
