import pytest
import requests
from requests.exceptions import ConnectionError

def test_mock_qkd_node_responses():
    response = requests.get('http://10.211.36.220:11111/restconf/data/etsi-qkd-sdn-node:qkd_node')
    assert response.status_code == 200
    data = response.json()
    assert 'qkd_node' in data

def test_mock_node_failure_scenarios():
    try:
        response = requests.get('http://10.211.36.220:12345/restconf/data/etsi-qkd-sdn-node:qkd_node')
    except ConnectionError as e:
        assert isinstance(e, ConnectionError)
    else:
        pytest.fail("ConnectionError not raised as expected")
