import pytest
import json
from src.device.service.drivers.qkd.QKDDriver import QKDDriver

@pytest.fixture
def qkd_driver():
    # Initialize the QKD driver with the appropriate settings
    return QKDDriver(address='10.211.36.220', port=11111, username='user', password='pass')

def test_application_deployment(qkd_driver):
    qkd_driver.Connect()

    # Application registration data
    app_data = {
        'qkd_app': [
            {
                'app_id': '00000001-0001-0000-0000-000000000001',
                'client_app_id': [],
                'app_statistics': {'statistics': []},
                'app_qos': {},
                'backing_qkdl_id': []
            }
        ]
    }

    # Send a POST request to create the application
    response = qkd_driver.SetConfig([('/qkd_applications/qkd_app', json.dumps(app_data))])
    
    # Verify response
    assert response[0] is True, "Expected application registration to succeed"
