import pytest
from src.device.service.drivers.qkd.QKDDriver2 import QKDDriver

def test_end_to_end_workflow():
    driver = QKDDriver(address='10.211.36.220', port=11111, username='user', password='pass')
    assert driver.Connect() is True
    
    # Retrieve initial configuration
    config = driver.GetInitialConfig()
    assert isinstance(config, dict)
    assert 'qkd_node' in config
    
    # Define the new configuration
    new_config = {'uuid': 'test', 'device': 'device1', 'port': 'port1'}
    
    # Use a valid resource key based on driver implementation
    valid_resource_key = '/link/valid_resource_key'  # Adjust this key as necessary
    
    try:
        result = driver.SetConfig([(valid_resource_key, new_config)])
        
        # Check for ValueErrors in results
        if any(isinstance(res, ValueError) for res in result):
            pytest.fail(f"SetConfig failed with error: {next(res for res in result if isinstance(res, ValueError))}")

        # Ensure result is a list of booleans
        assert isinstance(result, list)
        assert all(isinstance(res, bool) for res in result)
        assert all(result)  # Ensure all operations succeeded
    except Exception as e:
        pytest.fail(f"SetConfig failed: {e}")




