# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_topology_protection_type import TapiTopologyProtectionType  # noqa: F401,E501
from tapi_server.models.tapi_topology_restoration_policy import TapiTopologyRestorationPolicy  # noqa: F401,E501
from tapi_server import util


class TapiTopologyResilienceType(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, restoration_policy: TapiTopologyRestorationPolicy=None, protection_type: TapiTopologyProtectionType=None):  # noqa: E501
        """TapiTopologyResilienceType - a model defined in Swagger

        :param restoration_policy: The restoration_policy of this TapiTopologyResilienceType.  # noqa: E501
        :type restoration_policy: TapiTopologyRestorationPolicy
        :param protection_type: The protection_type of this TapiTopologyResilienceType.  # noqa: E501
        :type protection_type: TapiTopologyProtectionType
        """
        self.swagger_types = {
            'restoration_policy': TapiTopologyRestorationPolicy,
            'protection_type': TapiTopologyProtectionType
        }

        self.attribute_map = {
            'restoration_policy': 'restoration-policy',
            'protection_type': 'protection-type'
        }
        self._restoration_policy = restoration_policy
        self._protection_type = protection_type

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyResilienceType':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.ResilienceType of this TapiTopologyResilienceType.  # noqa: E501
        :rtype: TapiTopologyResilienceType
        """
        return util.deserialize_model(dikt, cls)

    @property
    def restoration_policy(self) -> TapiTopologyRestorationPolicy:
        """Gets the restoration_policy of this TapiTopologyResilienceType.


        :return: The restoration_policy of this TapiTopologyResilienceType.
        :rtype: TapiTopologyRestorationPolicy
        """
        return self._restoration_policy

    @restoration_policy.setter
    def restoration_policy(self, restoration_policy: TapiTopologyRestorationPolicy):
        """Sets the restoration_policy of this TapiTopologyResilienceType.


        :param restoration_policy: The restoration_policy of this TapiTopologyResilienceType.
        :type restoration_policy: TapiTopologyRestorationPolicy
        """

        self._restoration_policy = restoration_policy

    @property
    def protection_type(self) -> TapiTopologyProtectionType:
        """Gets the protection_type of this TapiTopologyResilienceType.


        :return: The protection_type of this TapiTopologyResilienceType.
        :rtype: TapiTopologyProtectionType
        """
        return self._protection_type

    @protection_type.setter
    def protection_type(self, protection_type: TapiTopologyProtectionType):
        """Sets the protection_type of this TapiTopologyResilienceType.


        :param protection_type: The protection_type of this TapiTopologyResilienceType.
        :type protection_type: TapiTopologyProtectionType
        """

        self._protection_type = protection_type
