# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_local_class import TapiCommonLocalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_notification_notification_type import TapiNotificationNotificationType  # noqa: F401,E501
from tapi_server.models.tapi_notification_object_type import TapiNotificationObjectType  # noqa: F401,E501
from tapi_server import util


class TapiNotificationSubscriptionFilter(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, local_id: str=None, requested_notification_types: List[TapiNotificationNotificationType]=None, requested_object_identifier: List[str]=None, requested_layer_protocols: List[TapiCommonLayerProtocolName]=None, include_content: bool=False, requested_object_types: List[TapiNotificationObjectType]=None):  # noqa: E501
        """TapiNotificationSubscriptionFilter - a model defined in Swagger

        :param name: The name of this TapiNotificationSubscriptionFilter.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param local_id: The local_id of this TapiNotificationSubscriptionFilter.  # noqa: E501
        :type local_id: str
        :param requested_notification_types: The requested_notification_types of this TapiNotificationSubscriptionFilter.  # noqa: E501
        :type requested_notification_types: List[TapiNotificationNotificationType]
        :param requested_object_identifier: The requested_object_identifier of this TapiNotificationSubscriptionFilter.  # noqa: E501
        :type requested_object_identifier: List[str]
        :param requested_layer_protocols: The requested_layer_protocols of this TapiNotificationSubscriptionFilter.  # noqa: E501
        :type requested_layer_protocols: List[TapiCommonLayerProtocolName]
        :param include_content: The include_content of this TapiNotificationSubscriptionFilter.  # noqa: E501
        :type include_content: bool
        :param requested_object_types: The requested_object_types of this TapiNotificationSubscriptionFilter.  # noqa: E501
        :type requested_object_types: List[TapiNotificationObjectType]
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'local_id': str,
            'requested_notification_types': List[TapiNotificationNotificationType],
            'requested_object_identifier': List[str],
            'requested_layer_protocols': List[TapiCommonLayerProtocolName],
            'include_content': bool,
            'requested_object_types': List[TapiNotificationObjectType]
        }

        self.attribute_map = {
            'name': 'name',
            'local_id': 'local-id',
            'requested_notification_types': 'requested-notification-types',
            'requested_object_identifier': 'requested-object-identifier',
            'requested_layer_protocols': 'requested-layer-protocols',
            'include_content': 'include-content',
            'requested_object_types': 'requested-object-types'
        }
        self._name = name
        self._local_id = local_id
        self._requested_notification_types = requested_notification_types
        self._requested_object_identifier = requested_object_identifier
        self._requested_layer_protocols = requested_layer_protocols
        self._include_content = include_content
        self._requested_object_types = requested_object_types

    @classmethod
    def from_dict(cls, dikt) -> 'TapiNotificationSubscriptionFilter':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.notification.SubscriptionFilter of this TapiNotificationSubscriptionFilter.  # noqa: E501
        :rtype: TapiNotificationSubscriptionFilter
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiNotificationSubscriptionFilter.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiNotificationSubscriptionFilter.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiNotificationSubscriptionFilter.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiNotificationSubscriptionFilter.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def local_id(self) -> str:
        """Gets the local_id of this TapiNotificationSubscriptionFilter.

        none  # noqa: E501

        :return: The local_id of this TapiNotificationSubscriptionFilter.
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id: str):
        """Sets the local_id of this TapiNotificationSubscriptionFilter.

        none  # noqa: E501

        :param local_id: The local_id of this TapiNotificationSubscriptionFilter.
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def requested_notification_types(self) -> List[TapiNotificationNotificationType]:
        """Gets the requested_notification_types of this TapiNotificationSubscriptionFilter.

        none  # noqa: E501

        :return: The requested_notification_types of this TapiNotificationSubscriptionFilter.
        :rtype: List[TapiNotificationNotificationType]
        """
        return self._requested_notification_types

    @requested_notification_types.setter
    def requested_notification_types(self, requested_notification_types: List[TapiNotificationNotificationType]):
        """Sets the requested_notification_types of this TapiNotificationSubscriptionFilter.

        none  # noqa: E501

        :param requested_notification_types: The requested_notification_types of this TapiNotificationSubscriptionFilter.
        :type requested_notification_types: List[TapiNotificationNotificationType]
        """

        self._requested_notification_types = requested_notification_types

    @property
    def requested_object_identifier(self) -> List[str]:
        """Gets the requested_object_identifier of this TapiNotificationSubscriptionFilter.

        none  # noqa: E501

        :return: The requested_object_identifier of this TapiNotificationSubscriptionFilter.
        :rtype: List[str]
        """
        return self._requested_object_identifier

    @requested_object_identifier.setter
    def requested_object_identifier(self, requested_object_identifier: List[str]):
        """Sets the requested_object_identifier of this TapiNotificationSubscriptionFilter.

        none  # noqa: E501

        :param requested_object_identifier: The requested_object_identifier of this TapiNotificationSubscriptionFilter.
        :type requested_object_identifier: List[str]
        """

        self._requested_object_identifier = requested_object_identifier

    @property
    def requested_layer_protocols(self) -> List[TapiCommonLayerProtocolName]:
        """Gets the requested_layer_protocols of this TapiNotificationSubscriptionFilter.

        none  # noqa: E501

        :return: The requested_layer_protocols of this TapiNotificationSubscriptionFilter.
        :rtype: List[TapiCommonLayerProtocolName]
        """
        return self._requested_layer_protocols

    @requested_layer_protocols.setter
    def requested_layer_protocols(self, requested_layer_protocols: List[TapiCommonLayerProtocolName]):
        """Sets the requested_layer_protocols of this TapiNotificationSubscriptionFilter.

        none  # noqa: E501

        :param requested_layer_protocols: The requested_layer_protocols of this TapiNotificationSubscriptionFilter.
        :type requested_layer_protocols: List[TapiCommonLayerProtocolName]
        """

        self._requested_layer_protocols = requested_layer_protocols

    @property
    def include_content(self) -> bool:
        """Gets the include_content of this TapiNotificationSubscriptionFilter.

        Indicates whether the published Notification includes content or just the Notification Id (which enables retrieval of the notification at the later stage)  # noqa: E501

        :return: The include_content of this TapiNotificationSubscriptionFilter.
        :rtype: bool
        """
        return self._include_content

    @include_content.setter
    def include_content(self, include_content: bool):
        """Sets the include_content of this TapiNotificationSubscriptionFilter.

        Indicates whether the published Notification includes content or just the Notification Id (which enables retrieval of the notification at the later stage)  # noqa: E501

        :param include_content: The include_content of this TapiNotificationSubscriptionFilter.
        :type include_content: bool
        """

        self._include_content = include_content

    @property
    def requested_object_types(self) -> List[TapiNotificationObjectType]:
        """Gets the requested_object_types of this TapiNotificationSubscriptionFilter.

        none  # noqa: E501

        :return: The requested_object_types of this TapiNotificationSubscriptionFilter.
        :rtype: List[TapiNotificationObjectType]
        """
        return self._requested_object_types

    @requested_object_types.setter
    def requested_object_types(self, requested_object_types: List[TapiNotificationObjectType]):
        """Sets the requested_object_types of this TapiNotificationSubscriptionFilter.

        none  # noqa: E501

        :param requested_object_types: The requested_object_types of this TapiNotificationSubscriptionFilter.
        :type requested_object_types: List[TapiNotificationObjectType]
        """

        self._requested_object_types = requested_object_types
