-module(tfte_util).

%%% INCLUDES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-include_lib("kernel/include/logger.hrl").


%%% EXPORTS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% API functions
-export([custom_config/2]).


%%% API FUNCTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

custom_config(#{config_rules := Rules}, Key) ->
    custom_config(Rules, Key);
custom_config([], _Key) ->
    undefined;
custom_config([#{action := 'CONFIGACTION_SET',
                       config_rule := {custom, Rule}} | Rest], Key) ->
    case Rule of
        #{resource_key := Key, resource_value := Value} -> jsx:decode(Value);
        _ -> custom_config(Rest, Key)
    end;
custom_config([_Rule | Rest], Key) ->
    custom_config(Rest, Key).
