# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server import util


class TapiTopologyValidationMechanism(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, layer_protocol_adjacency_validated: str=None, validation_mechanism: str=None, validation_robustness: str=None):  # noqa: E501
        """TapiTopologyValidationMechanism - a model defined in Swagger

        :param layer_protocol_adjacency_validated: The layer_protocol_adjacency_validated of this TapiTopologyValidationMechanism.  # noqa: E501
        :type layer_protocol_adjacency_validated: str
        :param validation_mechanism: The validation_mechanism of this TapiTopologyValidationMechanism.  # noqa: E501
        :type validation_mechanism: str
        :param validation_robustness: The validation_robustness of this TapiTopologyValidationMechanism.  # noqa: E501
        :type validation_robustness: str
        """
        self.swagger_types = {
            'layer_protocol_adjacency_validated': str,
            'validation_mechanism': str,
            'validation_robustness': str
        }

        self.attribute_map = {
            'layer_protocol_adjacency_validated': 'layer-protocol-adjacency-validated',
            'validation_mechanism': 'validation-mechanism',
            'validation_robustness': 'validation-robustness'
        }
        self._layer_protocol_adjacency_validated = layer_protocol_adjacency_validated
        self._validation_mechanism = validation_mechanism
        self._validation_robustness = validation_robustness

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyValidationMechanism':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.ValidationMechanism of this TapiTopologyValidationMechanism.  # noqa: E501
        :rtype: TapiTopologyValidationMechanism
        """
        return util.deserialize_model(dikt, cls)

    @property
    def layer_protocol_adjacency_validated(self) -> str:
        """Gets the layer_protocol_adjacency_validated of this TapiTopologyValidationMechanism.

        State of validatiion  # noqa: E501

        :return: The layer_protocol_adjacency_validated of this TapiTopologyValidationMechanism.
        :rtype: str
        """
        return self._layer_protocol_adjacency_validated

    @layer_protocol_adjacency_validated.setter
    def layer_protocol_adjacency_validated(self, layer_protocol_adjacency_validated: str):
        """Sets the layer_protocol_adjacency_validated of this TapiTopologyValidationMechanism.

        State of validatiion  # noqa: E501

        :param layer_protocol_adjacency_validated: The layer_protocol_adjacency_validated of this TapiTopologyValidationMechanism.
        :type layer_protocol_adjacency_validated: str
        """

        self._layer_protocol_adjacency_validated = layer_protocol_adjacency_validated

    @property
    def validation_mechanism(self) -> str:
        """Gets the validation_mechanism of this TapiTopologyValidationMechanism.

        Name of mechanism used to validate adjacency  # noqa: E501

        :return: The validation_mechanism of this TapiTopologyValidationMechanism.
        :rtype: str
        """
        return self._validation_mechanism

    @validation_mechanism.setter
    def validation_mechanism(self, validation_mechanism: str):
        """Sets the validation_mechanism of this TapiTopologyValidationMechanism.

        Name of mechanism used to validate adjacency  # noqa: E501

        :param validation_mechanism: The validation_mechanism of this TapiTopologyValidationMechanism.
        :type validation_mechanism: str
        """

        self._validation_mechanism = validation_mechanism

    @property
    def validation_robustness(self) -> str:
        """Gets the validation_robustness of this TapiTopologyValidationMechanism.

        Quality of validation (i.e. how likely is the stated validation to be invalid)  # noqa: E501

        :return: The validation_robustness of this TapiTopologyValidationMechanism.
        :rtype: str
        """
        return self._validation_robustness

    @validation_robustness.setter
    def validation_robustness(self, validation_robustness: str):
        """Sets the validation_robustness of this TapiTopologyValidationMechanism.

        Quality of validation (i.e. how likely is the stated validation to be invalid)  # noqa: E501

        :param validation_robustness: The validation_robustness of this TapiTopologyValidationMechanism.
        :type validation_robustness: str
        """

        self._validation_robustness = validation_robustness
