def validate_empty(message):
    assert type(message) is dict
    assert len(message.keys()) == 0

def validate_uuid(message, allow_empty=False):
    assert type(message) is dict
    assert len(message.keys()) == 1
    assert 'uuid' in message
    assert type(message['uuid']) is str
    if allow_empty: return
    assert len(message['uuid']) > 1

def validate_device_id(message):
    assert type(message) is dict
    assert len(message.keys()) == 1
    assert 'device_id' in message
    validate_uuid(message['device_id'])

def validate_topology(message):
    assert type(message) is dict
    assert len(message.keys()) > 0
    assert 'topoId' in message
    assert 'device' in message
    assert 'link' in message
