from __future__ import annotations
from typing import TYPE_CHECKING, Dict
from ..entity._Entity import _Entity
from ..entity.EntityCollection import EntityCollection
from .LinkEndpoint import LinkEndpoint
from .Keys import KEY_LINK_ENDPOINTS

if TYPE_CHECKING:
    from .Context import Context
    from .Topology import Topology

class Link(_Entity):
    def __init__(self, link_uuid : str, parent : 'Topology'):
        super().__init__(parent=parent)
        self._link_uuid = link_uuid
        self._topology_uuid = self._parent.topology_uuid
        self._context_uuid = self._parent.context_uuid
        self._endpoints = EntityCollection(self, KEY_LINK_ENDPOINTS)

    @property
    def context(self) -> 'Context': return self._parent.context

    @property
    def context_uuid(self) -> str: return self.context.context_uuid

    @property
    def parent(self) -> 'Topology': return self._parent

    @property
    def topology_uuid(self) -> str: return self.parent.topology_uuid

    @property
    def link_uuid(self) -> str: return self._link_uuid

    @property
    def endpoints(self) -> EntityCollection: return self._endpoints

    def endpoint(self, link_endpoint_uuid : str) -> LinkEndpoint: return LinkEndpoint(link_endpoint_uuid, self)

    def create(self) -> 'Link':
        self.parent.links.add(self.link_uuid)
        return self

    def delete(self) -> None:
        for endpoint_uuid in self.endpoints.get(): self.endpoint(endpoint_uuid).delete()
        self.parent.links.delete(self.link_uuid)

    def dump(self) -> Dict:
        endpoints = [self.endpoint(link_endpoint_uuid).dump() for link_endpoint_uuid in self.endpoints.get()]
        return {
            'link_id': {'link_id': {'uuid': self.link_uuid}},
            'endpointList': endpoints
        }
