from ..driver_api.FilterFields import FilterFieldEnum, DeviceTypeFilterFieldEnum, ORM_DeviceDriverEnum
from .emulated.EmulatedDriver import EmulatedDriver
from .openconfig.OpenConfigDriver import OpenConfigDriver
from .transport_api.TransportApiDriver import TransportApiDriver
from .p4.p4_driver import P4Driver

DRIVERS = [
    (EmulatedDriver, [
        {
            FilterFieldEnum.DEVICE_TYPE: DeviceTypeFilterFieldEnum.EMULATED,
            FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.UNDEFINED,
        }
    ]),
    (OpenConfigDriver, [
        {
            FilterFieldEnum.DEVICE_TYPE: DeviceTypeFilterFieldEnum.PACKET_ROUTER,
            FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.OPENCONFIG,
        }
    ]),
    (TransportApiDriver, [
        {
            FilterFieldEnum.DEVICE_TYPE: DeviceTypeFilterFieldEnum.OPTICAL_LINE_SYSTEM,
            FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.TRANSPORT_API,
        }
    ]),
    (P4Driver, [
        {
            FilterFieldEnum.DEVICE_TYPE: DeviceTypeFilterFieldEnum.P4_SWITCH,
            FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.P4,
        }
    ]),
]
