/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.posimo.Decor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class DecorInterfaceProvider
implements Decor {
    private final double radius = 5.0;
    private final double radius2 = 9.0;
    private final LinkStyle style;

    public DecorInterfaceProvider(LinkStyle linkStyle) {
        if (linkStyle != LinkStyle.__toremove_INTERFACE_PROVIDER && linkStyle != LinkStyle.__toremove_INTERFACE_USER) {
            throw new IllegalArgumentException();
        }
        this.style = linkStyle;
    }

    public void drawDecor(UGraphic uGraphic, Point2D point2D, double d) {
        double d2 = point2D.getX() - 5.0;
        double d3 = point2D.getY() - 5.0;
        double d4 = point2D.getX() - 9.0 - 0.0 * Math.sin(d * Math.PI / 180.0);
        double d5 = point2D.getY() - 9.0 - 0.0 * Math.cos(d * Math.PI / 180.0);
        if (this.style == LinkStyle.__toremove_INTERFACE_USER) {
            d += 180.0;
        }
        if (d >= 360.0) {
            d -= 360.0;
        }
        UEllipse uEllipse = new UEllipse(18.0, 18.0, d + 15.0, 150.0);
        uGraphic = uGraphic.apply(new UStroke(1.5));
        uGraphic.apply(new UTranslate(d4, d5)).draw(uEllipse);
        uGraphic.apply(new UTranslate(d2, d3)).draw(new UEllipse(10.0, 10.0));
    }
}

