# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class statistics(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/statistics. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Statistics data.
  """
  __slots__ = ('_path_helper', '_extmethods', '__discontinuity_time','__disables','__enables','__maintenance_clears','__maintenance_sets','__modifies','__downs','__ups','__fault_clears','__fault_detects','__protection_switches','__protection_reverts','__restoration_failures','__restoration_starts','__restoration_successes','__restoration_reversion_failures','__restoration_reversion_starts','__restoration_reversion_successes',)

  _yang_name = 'statistics'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__discontinuity_time = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)
    self.__disables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__enables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__maintenance_clears = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__maintenance_sets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__modifies = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__downs = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="downs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__ups = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__fault_clears = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="fault-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__fault_detects = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="fault-detects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__protection_switches = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="protection-switches", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__protection_reverts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="protection-reverts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__restoration_failures = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__restoration_starts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-starts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__restoration_successes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-successes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__restoration_reversion_failures = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__restoration_reversion_starts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-starts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__restoration_reversion_successes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-successes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'statistics']

  def _get_discontinuity_time(self):
    """
    Getter method for discontinuity_time, mapped from YANG variable /networks/network/link/te/statistics/discontinuity_time (yang:date-and-time)

    YANG Description: The time of the most recent occasion at which any one or
more of this interface's counters suffered a
discontinuity.  If no such discontinuities have occurred
since the last re-initialization of the local management
subsystem, then this node contains the time the local
management subsystem re-initialized itself.
    """
    return self.__discontinuity_time
      
  def _set_discontinuity_time(self, v, load=False):
    """
    Setter method for discontinuity_time, mapped from YANG variable /networks/network/link/te/statistics/discontinuity_time (yang:date-and-time)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_discontinuity_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_discontinuity_time() directly.

    YANG Description: The time of the most recent occasion at which any one or
more of this interface's counters suffered a
discontinuity.  If no such discontinuities have occurred
since the last re-initialization of the local management
subsystem, then this node contains the time the local
management subsystem re-initialized itself.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """discontinuity_time must be of a type compatible with yang:date-and-time""",
          'defined-type': "yang:date-and-time",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)""",
        })

    self.__discontinuity_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_discontinuity_time(self):
    self.__discontinuity_time = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="discontinuity-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:date-and-time', is_config=False)


  def _get_disables(self):
    """
    Getter method for disables, mapped from YANG variable /networks/network/link/te/statistics/disables (yang:counter32)

    YANG Description: Number of times that a link was disabled.
    """
    return self.__disables
      
  def _set_disables(self, v, load=False):
    """
    Setter method for disables, mapped from YANG variable /networks/network/link/te/statistics/disables (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_disables is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_disables() directly.

    YANG Description: Number of times that a link was disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """disables must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__disables = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_disables(self):
    self.__disables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_enables(self):
    """
    Getter method for enables, mapped from YANG variable /networks/network/link/te/statistics/enables (yang:counter32)

    YANG Description: Number of times that a link was enabled.
    """
    return self.__enables
      
  def _set_enables(self, v, load=False):
    """
    Setter method for enables, mapped from YANG variable /networks/network/link/te/statistics/enables (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enables is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enables() directly.

    YANG Description: Number of times that a link was enabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enables must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__enables = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enables(self):
    self.__enables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_maintenance_clears(self):
    """
    Getter method for maintenance_clears, mapped from YANG variable /networks/network/link/te/statistics/maintenance_clears (yang:counter32)

    YANG Description: Number of times that a link was taken out of maintenance.
    """
    return self.__maintenance_clears
      
  def _set_maintenance_clears(self, v, load=False):
    """
    Setter method for maintenance_clears, mapped from YANG variable /networks/network/link/te/statistics/maintenance_clears (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_maintenance_clears is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_maintenance_clears() directly.

    YANG Description: Number of times that a link was taken out of maintenance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """maintenance_clears must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__maintenance_clears = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_maintenance_clears(self):
    self.__maintenance_clears = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_maintenance_sets(self):
    """
    Getter method for maintenance_sets, mapped from YANG variable /networks/network/link/te/statistics/maintenance_sets (yang:counter32)

    YANG Description: Number of times that a link was put in maintenance.
    """
    return self.__maintenance_sets
      
  def _set_maintenance_sets(self, v, load=False):
    """
    Setter method for maintenance_sets, mapped from YANG variable /networks/network/link/te/statistics/maintenance_sets (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_maintenance_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_maintenance_sets() directly.

    YANG Description: Number of times that a link was put in maintenance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """maintenance_sets must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__maintenance_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_maintenance_sets(self):
    self.__maintenance_sets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_modifies(self):
    """
    Getter method for modifies, mapped from YANG variable /networks/network/link/te/statistics/modifies (yang:counter32)

    YANG Description: Number of times that a link was modified.
    """
    return self.__modifies
      
  def _set_modifies(self, v, load=False):
    """
    Setter method for modifies, mapped from YANG variable /networks/network/link/te/statistics/modifies (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_modifies is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_modifies() directly.

    YANG Description: Number of times that a link was modified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """modifies must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__modifies = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_modifies(self):
    self.__modifies = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_downs(self):
    """
    Getter method for downs, mapped from YANG variable /networks/network/link/te/statistics/downs (yang:counter32)

    YANG Description: Number of times that a link was set to an operational state
of 'down'.
    """
    return self.__downs
      
  def _set_downs(self, v, load=False):
    """
    Setter method for downs, mapped from YANG variable /networks/network/link/te/statistics/downs (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_downs is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_downs() directly.

    YANG Description: Number of times that a link was set to an operational state
of 'down'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="downs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """downs must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="downs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__downs = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_downs(self):
    self.__downs = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="downs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_ups(self):
    """
    Getter method for ups, mapped from YANG variable /networks/network/link/te/statistics/ups (yang:counter32)

    YANG Description: Number of times that a link was set to an operational state
of 'up'.
    """
    return self.__ups
      
  def _set_ups(self, v, load=False):
    """
    Setter method for ups, mapped from YANG variable /networks/network/link/te/statistics/ups (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ups is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ups() directly.

    YANG Description: Number of times that a link was set to an operational state
of 'up'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ups must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__ups = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ups(self):
    self.__ups = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_fault_clears(self):
    """
    Getter method for fault_clears, mapped from YANG variable /networks/network/link/te/statistics/fault_clears (yang:counter32)

    YANG Description: Number of times that a link experienced a fault-clear
event.
    """
    return self.__fault_clears
      
  def _set_fault_clears(self, v, load=False):
    """
    Setter method for fault_clears, mapped from YANG variable /networks/network/link/te/statistics/fault_clears (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fault_clears is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fault_clears() directly.

    YANG Description: Number of times that a link experienced a fault-clear
event.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="fault-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fault_clears must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="fault-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__fault_clears = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fault_clears(self):
    self.__fault_clears = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="fault-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_fault_detects(self):
    """
    Getter method for fault_detects, mapped from YANG variable /networks/network/link/te/statistics/fault_detects (yang:counter32)

    YANG Description: Number of times that a link experienced fault detection.
    """
    return self.__fault_detects
      
  def _set_fault_detects(self, v, load=False):
    """
    Setter method for fault_detects, mapped from YANG variable /networks/network/link/te/statistics/fault_detects (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fault_detects is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fault_detects() directly.

    YANG Description: Number of times that a link experienced fault detection.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="fault-detects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fault_detects must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="fault-detects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__fault_detects = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fault_detects(self):
    self.__fault_detects = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="fault-detects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_protection_switches(self):
    """
    Getter method for protection_switches, mapped from YANG variable /networks/network/link/te/statistics/protection_switches (yang:counter32)

    YANG Description: Number of times that a link experienced protection
switchover.
    """
    return self.__protection_switches
      
  def _set_protection_switches(self, v, load=False):
    """
    Setter method for protection_switches, mapped from YANG variable /networks/network/link/te/statistics/protection_switches (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protection_switches is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protection_switches() directly.

    YANG Description: Number of times that a link experienced protection
switchover.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="protection-switches", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protection_switches must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="protection-switches", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__protection_switches = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protection_switches(self):
    self.__protection_switches = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="protection-switches", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_protection_reverts(self):
    """
    Getter method for protection_reverts, mapped from YANG variable /networks/network/link/te/statistics/protection_reverts (yang:counter32)

    YANG Description: Number of times that a link experienced protection
reversion.
    """
    return self.__protection_reverts
      
  def _set_protection_reverts(self, v, load=False):
    """
    Setter method for protection_reverts, mapped from YANG variable /networks/network/link/te/statistics/protection_reverts (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protection_reverts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protection_reverts() directly.

    YANG Description: Number of times that a link experienced protection
reversion.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="protection-reverts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protection_reverts must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="protection-reverts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__protection_reverts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protection_reverts(self):
    self.__protection_reverts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="protection-reverts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_restoration_failures(self):
    """
    Getter method for restoration_failures, mapped from YANG variable /networks/network/link/te/statistics/restoration_failures (yang:counter32)

    YANG Description: Number of times that a link experienced restoration
failure.
    """
    return self.__restoration_failures
      
  def _set_restoration_failures(self, v, load=False):
    """
    Setter method for restoration_failures, mapped from YANG variable /networks/network/link/te/statistics/restoration_failures (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_restoration_failures is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_restoration_failures() directly.

    YANG Description: Number of times that a link experienced restoration
failure.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """restoration_failures must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__restoration_failures = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_restoration_failures(self):
    self.__restoration_failures = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_restoration_starts(self):
    """
    Getter method for restoration_starts, mapped from YANG variable /networks/network/link/te/statistics/restoration_starts (yang:counter32)

    YANG Description: Number of times that a link experienced restoration
start.
    """
    return self.__restoration_starts
      
  def _set_restoration_starts(self, v, load=False):
    """
    Setter method for restoration_starts, mapped from YANG variable /networks/network/link/te/statistics/restoration_starts (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_restoration_starts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_restoration_starts() directly.

    YANG Description: Number of times that a link experienced restoration
start.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-starts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """restoration_starts must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-starts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__restoration_starts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_restoration_starts(self):
    self.__restoration_starts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-starts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_restoration_successes(self):
    """
    Getter method for restoration_successes, mapped from YANG variable /networks/network/link/te/statistics/restoration_successes (yang:counter32)

    YANG Description: Number of times that a link experienced restoration
success.
    """
    return self.__restoration_successes
      
  def _set_restoration_successes(self, v, load=False):
    """
    Setter method for restoration_successes, mapped from YANG variable /networks/network/link/te/statistics/restoration_successes (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_restoration_successes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_restoration_successes() directly.

    YANG Description: Number of times that a link experienced restoration
success.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-successes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """restoration_successes must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-successes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__restoration_successes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_restoration_successes(self):
    self.__restoration_successes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-successes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_restoration_reversion_failures(self):
    """
    Getter method for restoration_reversion_failures, mapped from YANG variable /networks/network/link/te/statistics/restoration_reversion_failures (yang:counter32)

    YANG Description: Number of times that a link experienced restoration
reversion failure.
    """
    return self.__restoration_reversion_failures
      
  def _set_restoration_reversion_failures(self, v, load=False):
    """
    Setter method for restoration_reversion_failures, mapped from YANG variable /networks/network/link/te/statistics/restoration_reversion_failures (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_restoration_reversion_failures is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_restoration_reversion_failures() directly.

    YANG Description: Number of times that a link experienced restoration
reversion failure.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """restoration_reversion_failures must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__restoration_reversion_failures = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_restoration_reversion_failures(self):
    self.__restoration_reversion_failures = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-failures", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_restoration_reversion_starts(self):
    """
    Getter method for restoration_reversion_starts, mapped from YANG variable /networks/network/link/te/statistics/restoration_reversion_starts (yang:counter32)

    YANG Description: Number of times that a link experienced restoration
reversion start.
    """
    return self.__restoration_reversion_starts
      
  def _set_restoration_reversion_starts(self, v, load=False):
    """
    Setter method for restoration_reversion_starts, mapped from YANG variable /networks/network/link/te/statistics/restoration_reversion_starts (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_restoration_reversion_starts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_restoration_reversion_starts() directly.

    YANG Description: Number of times that a link experienced restoration
reversion start.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-starts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """restoration_reversion_starts must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-starts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__restoration_reversion_starts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_restoration_reversion_starts(self):
    self.__restoration_reversion_starts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-starts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_restoration_reversion_successes(self):
    """
    Getter method for restoration_reversion_successes, mapped from YANG variable /networks/network/link/te/statistics/restoration_reversion_successes (yang:counter32)

    YANG Description: Number of times that a link experienced restoration
reversion success.
    """
    return self.__restoration_reversion_successes
      
  def _set_restoration_reversion_successes(self, v, load=False):
    """
    Setter method for restoration_reversion_successes, mapped from YANG variable /networks/network/link/te/statistics/restoration_reversion_successes (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_restoration_reversion_successes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_restoration_reversion_successes() directly.

    YANG Description: Number of times that a link experienced restoration
reversion success.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-successes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """restoration_reversion_successes must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-successes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__restoration_reversion_successes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_restoration_reversion_successes(self):
    self.__restoration_reversion_successes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="restoration-reversion-successes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)

  discontinuity_time = __builtin__.property(_get_discontinuity_time)
  disables = __builtin__.property(_get_disables)
  enables = __builtin__.property(_get_enables)
  maintenance_clears = __builtin__.property(_get_maintenance_clears)
  maintenance_sets = __builtin__.property(_get_maintenance_sets)
  modifies = __builtin__.property(_get_modifies)
  downs = __builtin__.property(_get_downs)
  ups = __builtin__.property(_get_ups)
  fault_clears = __builtin__.property(_get_fault_clears)
  fault_detects = __builtin__.property(_get_fault_detects)
  protection_switches = __builtin__.property(_get_protection_switches)
  protection_reverts = __builtin__.property(_get_protection_reverts)
  restoration_failures = __builtin__.property(_get_restoration_failures)
  restoration_starts = __builtin__.property(_get_restoration_starts)
  restoration_successes = __builtin__.property(_get_restoration_successes)
  restoration_reversion_failures = __builtin__.property(_get_restoration_reversion_failures)
  restoration_reversion_starts = __builtin__.property(_get_restoration_reversion_starts)
  restoration_reversion_successes = __builtin__.property(_get_restoration_reversion_successes)


  _pyangbind_elements = OrderedDict([('discontinuity_time', discontinuity_time), ('disables', disables), ('enables', enables), ('maintenance_clears', maintenance_clears), ('maintenance_sets', maintenance_sets), ('modifies', modifies), ('downs', downs), ('ups', ups), ('fault_clears', fault_clears), ('fault_detects', fault_detects), ('protection_switches', protection_switches), ('protection_reverts', protection_reverts), ('restoration_failures', restoration_failures), ('restoration_starts', restoration_starts), ('restoration_successes', restoration_successes), ('restoration_reversion_failures', restoration_reversion_failures), ('restoration_reversion_starts', restoration_reversion_starts), ('restoration_reversion_successes', restoration_reversion_successes), ])


