import os, sys, logging
from prometheus_client import start_http_server
from common.Settings import wait_for_environment_variables
from webui.service import create_app
from webui.Config import WEBUI_SERVICE_PORT, LOG_LEVEL, METRICS_PORT, HOST, SECRET_KEY, DEBUG

def main():
    service_port = os.environ.get('WEBUISERVICE_SERVICE_PORT', WEBUI_SERVICE_PORT)
    log_level    = os.environ.get('LOG_LEVEL',                 LOG_LEVEL         )
    metrics_port = os.environ.get('METRICS_PORT',              METRICS_PORT      )
    host         = os.environ.get('HOST',                      HOST              )
    debug        = os.environ.get('DEBUG',                     DEBUG             )

    logging.basicConfig(level=log_level)
    logger = logging.getLogger(__name__)

    wait_for_environment_variables([
        'CONTEXTSERVICE_SERVICE_HOST', 'CONTEXTSERVICE_SERVICE_PORT_GRPC',
        'DEVICESERVICE_SERVICE_HOST', 'DEVICESERVICE_SERVICE_PORT_GRPC'
    ])

    logger.info('Starting...')

    start_http_server(metrics_port)

    app = create_app(use_config={'SECRET_KEY': SECRET_KEY})
    app.run(host=host, port=service_port, debug=debug)

    logger.info('Bye')
    return 0

if __name__ == '__main__':
    sys.exit(main())
