from common.DeviceTypes import DeviceTypeEnum
from ..driver_api.FilterFields import FilterFieldEnum, ORM_DeviceDriverEnum
from .emulated.EmulatedDriver import EmulatedDriver
from .openconfig.OpenConfigDriver import OpenConfigDriver
from .transport_api.TransportApiDriver import TransportApiDriver
from .p4.p4_driver import P4Driver

DRIVERS = [
    (EmulatedDriver, [
        {
            FilterFieldEnum.DEVICE_TYPE: [
                DeviceTypeEnum.EMULATED_OPTICAL_LINE_SYSTEM,
                DeviceTypeEnum.EMULATED_PACKET_ROUTER,
            ],
            FilterFieldEnum.DRIVER     : [
                ORM_DeviceDriverEnum.UNDEFINED,
                ORM_DeviceDriverEnum.OPENCONFIG,
                ORM_DeviceDriverEnum.TRANSPORT_API
            ],
        }
    ]),
    (OpenConfigDriver, [
        {
            FilterFieldEnum.DEVICE_TYPE: DeviceTypeEnum.PACKET_ROUTER,
            FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.OPENCONFIG,
        }
    ]),
    (TransportApiDriver, [
        {
            FilterFieldEnum.DEVICE_TYPE: DeviceTypeEnum.OPTICAL_LINE_SYSTEM,
            FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.TRANSPORT_API,
        }
    ]),
    (P4Driver, [
        {
            FilterFieldEnum.DEVICE_TYPE: DeviceTypeEnum.P4_SWITCH,
            FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.P4,
        }
    ]),
]
