#!/usr/bin/env bash
set -eu

if (( $# != 1 )); then
  echo "Usage: set_version.sh <version>" >&2
  exit 1
fi

version="$1"

if [ "$(git status --untracked-files=no --porcelain)" ]; then
    printf "Uncommitted changes in tracked files.\nPlease commit first and then run the script!\n"
    exit 0;
fi

./mvnw versions:set versions:commit -DnewVersion="${version}"
git commit -am "release(automation): ${version}"
